/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.block.Block;
import org.kopi.galite.visual.ui.vaadin.common.VCaption;
import org.kopi.galite.visual.ui.vaadin.common.VTable;
import org.kopi.galite.visual.ui.vaadin.event.PositionPanelListener;
import org.kopi.galite.visual.ui.vaadin.form.BlockComponentData;
import org.kopi.galite.visual.ui.vaadin.form.DBlock;
import org.kopi.galite.visual.ui.vaadin.form.FormListener;
import org.kopi.galite.visual.ui.vaadin.form.Page;
import org.kopi.galite.visual.ui.vaadin.form.PositionPanel;

@CssImport(value="./styles/galite/form.css")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ&\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u001aJ\u000e\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020\u001fJ\u000e\u0010;\u001a\u0002032\u0006\u0010:\u001a\u00020\u0002J\u001a\u0010<\u001a\u0002032\b\u0010=\u001a\u0004\u0018\u0001052\b\b\u0002\u0010>\u001a\u00020\u001aJ\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0007H\u0004J\u0010\u0010B\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020\u0007H\u0002J\u0006\u0010C\u001a\u00020\u001aJ\u0006\u0010D\u001a\u000203J\b\u0010E\u001a\u000203H\u0004J\b\u0010F\u001a\u000203H\u0004J\b\u0010G\u001a\u000203H\u0004J\u0010\u0010H\u001a\u0002032\u0006\u0010I\u001a\u00020\u0004H\u0004J\b\u0010J\u001a\u000203H\u0004J\u0010\u0010K\u001a\u0002032\u0006\u00106\u001a\u00020\u0004H\u0004J\b\u0010L\u001a\u000203H\u0016J\b\u0010M\u001a\u000203H\u0016J\b\u0010N\u001a\u000203H\u0016J\u000e\u0010O\u001a\u0002032\u0006\u0010P\u001a\u00020\u0004J\u0010\u0010Q\u001a\u0002032\u0006\u0010I\u001a\u00020\u0004H\u0016J\b\u0010R\u001a\u000203H\u0016J\b\u0010S\u001a\u000203H\u0004J!\u0010S\u001a\u0002032\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010T\u001a\u0002032\u0006\u0010:\u001a\u00020\u001fJ\u000e\u0010U\u001a\u0002032\u0006\u0010:\u001a\u00020\u0002J\u0010\u0010V\u001a\u0002032\u0006\u00106\u001a\u00020\u0004H\u0002J\u001d\u0010W\u001a\u0002032\u0006\u00104\u001a\u00020X2\u0006\u00106\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bYJ!\u0010Z\u001a\u0002032\u0012\u0010[\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0006\"\u00020\rH\u0002\u00a2\u0006\u0002\u0010\\J#\u0010Z\u001a\u0002032\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\bJ-\u0010Z\u001a\u0002032\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010]\u001a\u0004\u0018\u00010\u0007H\u0004\u00a2\u0006\u0002\u0010^J\u0016\u0010\u0017\u001a\u0002032\u0006\u0010_\u001a\u00020\u00042\u0006\u0010`\u001a\u00020\u0004J\u0016\u0010a\u001a\u0002032\u0006\u0010b\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u0004J\u0016\u0010c\u001a\u0002032\u0006\u0010_\u001a\u00020\u00042\u0006\u0010`\u001a\u00020\u0004J\u0006\u0010d\u001a\u000203R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0016R\u001c\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010'0\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010.\u001a\u0004\b,\u0010-R\u001a\u0010/\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0016\"\u0004\b1\u0010\u0018\u00a8\u0006e"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/Form;", "Lcom/vaadin/flow/component/html/Div;", "Lorg/kopi/galite/visual/ui/vaadin/event/PositionPanelListener;", "pageCount", "", "titles", "", "", "(I[Ljava/lang/String;)V", "blockInfo", "Lorg/kopi/galite/visual/ui/vaadin/form/PositionPanel;", "blocksData", "", "Lcom/vaadin/flow/component/Component;", "Lorg/kopi/galite/visual/ui/vaadin/form/BlockComponentData;", "getBlocksData", "()Ljava/util/Map;", "setBlocksData", "(Ljava/util/Map;)V", "currentPage", "currentPosition", "getCurrentPosition", "()I", "setCurrentPosition", "(I)V", "fireSelectionEvent", "", "lastSelected", "Lcom/vaadin/flow/component/tabs/Tab;", "listeners", "", "Lorg/kopi/galite/visual/ui/vaadin/form/FormListener;", "locale", "getLocale", "()Ljava/lang/String;", "setLocale", "(Ljava/lang/String;)V", "getPageCount", "pages", "Lorg/kopi/galite/visual/ui/vaadin/form/Page;", "[Lorg/kopi/galite/visual/ui/vaadin/form/Page;", "tabPanel", "Lcom/vaadin/flow/component/tabs/Tabs;", "tabsToPages", "getTitles", "()[Ljava/lang/String;", "[Ljava/lang/String;", "totalPositions", "getTotalPositions", "setTotalPositions", "addBlock", "", "block", "Lorg/kopi/galite/visual/ui/vaadin/block/Block;", "page", "isFollow", "isChart", "addFormListener", "l", "addPositionPanelListener", "cleanDirtyValues", "active", "transferFocus", "createCaption", "Lorg/kopi/galite/visual/ui/vaadin/common/VCaption;", "title", "createTabLabel", "delegateCaptionHandling", "disableAllBlocksActors", "fireGotoFirstPosition", "fireGotoLastPosition", "fireGotoNextPosition", "fireGotoPosition", "posno", "fireGotoPrevPosition", "firePageSelected", "gotoFirstPosition", "gotoLastPosition", "gotoNextPosition", "gotoPage", "i", "gotoPosition", "gotoPrevPosition", "init", "removeFormListener", "removePositionPanelListener", "selectPage", "setBorder", "Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;", "setBorder$galite_core", "setContent", "components", "([Lcom/vaadin/flow/component/Component;)V", "separator", "(I[Ljava/lang/String;Ljava/lang/String;)V", "current", "total", "setEnabled", "enabled", "setPosition", "showBlockInfo", "galite-core"})
public final class Form
extends Div
implements PositionPanelListener {
    private final int pageCount;
    @NotNull
    private final String[] titles;
    @Nullable
    private String locale;
    private int currentPosition;
    private int totalPositions;
    @NotNull
    private Map<Component, BlockComponentData> blocksData;
    private int currentPage;
    @NotNull
    private Page<?>[] pages;
    @NotNull
    private final Map<Tab, Component> tabsToPages;
    @Nullable
    private Tabs tabPanel;
    @NotNull
    private List<FormListener> listeners;
    @Nullable
    private Tab lastSelected;
    private boolean fireSelectionEvent;
    @NotNull
    private PositionPanel blockInfo;

    public Form(int pageCount, @NotNull String[] titles) {
        Intrinsics.checkNotNullParameter((Object)titles, (String)"titles");
        this.pageCount = pageCount;
        this.titles = titles;
        boolean bl = false;
        this.blocksData = new LinkedHashMap();
        this.currentPage = -1;
        this.pages = new Page[this.pageCount == 0 ? 1 : this.pageCount];
        bl = false;
        this.tabsToPages = new LinkedHashMap();
        bl = false;
        this.listeners = new ArrayList();
        this.fireSelectionEvent = true;
        this.blockInfo = new PositionPanel();
        this.setClassName("k-form");
        this.init(this.pageCount, this.titles);
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    @NotNull
    public final String[] getTitles() {
        return this.titles;
    }

    @Nullable
    public final String getLocale() {
        return this.locale;
    }

    public final void setLocale(@Nullable String string) {
        this.locale = string;
    }

    public final int getCurrentPosition() {
        return this.currentPosition;
    }

    public final void setCurrentPosition(int n) {
        this.currentPosition = n;
    }

    public final int getTotalPositions() {
        return this.totalPositions;
    }

    public final void setTotalPositions(int n) {
        this.totalPositions = n;
    }

    @NotNull
    public final Map<Component, BlockComponentData> getBlocksData() {
        return this.blocksData;
    }

    public final void setBlocksData(@NotNull Map<Component, BlockComponentData> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.blocksData = map;
    }

    private final void setContent(int pageCount, String[] titles) {
        if (pageCount == 0) {
            Component[] componentArray = new Component[1];
            Page<?> page = this.pages[0];
            Intrinsics.checkNotNull(page);
            componentArray[0] = (Component)page;
            this.setContent(componentArray);
        } else {
            Tabs tabs = this.tabPanel = new Tabs();
            Intrinsics.checkNotNull((Object)tabs);
            tabs.setClassName("k-form-tab");
            int n = 0;
            int n2 = this.pages.length + -1;
            if (n <= n2) {
                do {
                    Page<?> page;
                    int i = n++;
                    Tab tab = this.createTabLabel(titles[i]);
                    Tab[] tabArray = this.tabsToPages;
                    Intrinsics.checkNotNull(this.pages[i]);
                    boolean bl = false;
                    tabArray.put((Tab)tab, page);
                    Tabs tabs2 = this.tabPanel;
                    Intrinsics.checkNotNull((Object)tabs2);
                    tabArray = new Tab[]{tab};
                    tabs2.add(tabArray);
                    tab.setEnabled(false);
                    tab.addClassName("tab");
                } while (n <= n2);
            }
            Tabs tabs3 = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs3);
            tabs3.addSelectedChangeListener(new ComponentEventListener(this){
                final /* synthetic */ Form this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void onComponentEvent(Tabs.SelectedChangeEvent it) {
                    if (it.isFromClient()) {
                        Form.access$setLastSelected$p(this.this$0, it.getPreviousTab());
                        Tabs tabs = Form.access$getTabPanel$p(this.this$0);
                        Intrinsics.checkNotNull((Object)tabs);
                        tabs.setSelectedTab(Form.access$getLastSelected$p(this.this$0));
                        this.this$0.firePageSelected(ArraysKt.indexOf((Object[])Form.access$getPages$p(this.this$0), Form.access$getTabsToPages$p(this.this$0).get(it.getSelectedTab())));
                    }
                }
            });
            Component[] componentArray = new Component[2];
            Tabs tabs4 = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs4);
            componentArray[0] = (Component)tabs4;
            Page<?>[] pageArray = this.pages;
            componentArray[1] = (Component)new Div((Component[])Arrays.copyOf(pageArray, pageArray.length));
            this.setContent(componentArray);
        }
    }

    private final void setContent(Component ... components) {
        this.removeAll();
        VTable table = new VTable(0, 0);
        Component[] $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        Component[] componentArray = $this$forEach$iv;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component element$iv;
            Component it = element$iv = componentArray[i];
            boolean bl = false;
            table.addInNewRow(it);
        }
        Component[] componentArray2 = new Component[]{table};
        this.add(componentArray2);
    }

    private final void selectPage(int page) {
        if (this.tabPanel != null) {
            Tabs tabs = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs);
            tabs.setSelectedIndex(page);
            Tabs tabs2 = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs2);
            Tab tab = this.lastSelected = tabs2.getSelectedTab();
            Intrinsics.checkNotNull((Object)tab);
            tab.setEnabled(true);
        }
    }

    private final Tab createTabLabel(String title) {
        String string;
        if (StringsKt.endsWith$default((String)title, (String)"<CENTER>", (boolean)false, (int)2, null)) {
            String string2 = title;
            int n = 0;
            int n2 = title.length() - 8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = title;
        }
        return new Tab(string);
    }

    public final void addBlock(@NotNull Block block, int page, boolean isFollow, boolean isChart) {
        FlexComponent.JustifyContentMode hAlign;
        Intrinsics.checkNotNullParameter((Object)((Object)block), (String)"block");
        Map<Component, BlockComponentData> map = this.blocksData;
        BlockComponentData blockComponentData = new BlockComponentData(isFollow, isChart, page);
        boolean bl = false;
        map.put((Component)block, blockComponentData);
        FlexComponent.JustifyContentMode justifyContentMode = hAlign = isChart ? FlexComponent.JustifyContentMode.CENTER : FlexComponent.JustifyContentMode.START;
        if (isFollow) {
            Page<?> page2 = this.pages[page];
            Intrinsics.checkNotNull(page2);
            page2.addFollow(block, hAlign);
        } else {
            Page<?> page3 = this.pages[page];
            Intrinsics.checkNotNull(page3);
            page3.add(block, hAlign);
        }
        block.layout();
        block.layoutAlignedComponents();
    }

    public final void setBorder$galite_core(@NotNull DBlock block, int page) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        block.setBorder$galite_core(block.getModel().getBorder(), block.getModel().getTitle(), this.pages[page]);
    }

    public final void gotoPage(int i) {
        this.currentPage = i;
        Tab tab = this.lastSelected;
        if (tab != null) {
            Tab tab2 = tab;
            boolean bl = false;
            boolean bl2 = false;
            Tab it = tab2;
            boolean bl3 = false;
            Component component = this.tabsToPages.get(it);
            Intrinsics.checkNotNull((Object)component);
            component.setVisible(false);
        }
        tab = this.lastSelected;
        if (tab != null) {
            tab.removeClassName("selected-tab");
        }
        Page<?> page = this.pages[i];
        Intrinsics.checkNotNull(page);
        page.setVisible(true);
        this.selectPage(i);
        if (this.tabPanel != null) {
            Tabs tabs = this.tabPanel;
            Intrinsics.checkNotNull((Object)tabs);
            tabs.getComponentAt(this.currentPage).getElement().getClassList().add((Object)"selected-tab");
        }
    }

    public final void setPosition(int current, int total) {
        this.currentPosition = current;
        this.totalPositions = total;
        if (this.blockInfo != null) {
            this.blockInfo.setPosition(current, total);
        }
    }

    public final void init(int pageCount, @NotNull String[] titles) {
        Intrinsics.checkNotNullParameter((Object)titles, (String)"titles");
        this.pages = new Page[pageCount == 0 ? 1 : pageCount];
        int n = 0;
        int n2 = this.pages.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                this.pages[i] = pageCount != 0 ? (StringsKt.endsWith$default((String)titles[i], (String)"<CENTER>", (boolean)false, (int)2, null) ? new Page<Component>((Component)new HorizontalLayout()) : new Page<Component>((Component)new VerticalLayout())) : new Page<Component>((Component)new VerticalLayout());
                Page<?> page = this.pages[i];
                Intrinsics.checkNotNull(page);
                page.setVisible(false);
                if (pageCount == 0) {
                    Page<?> page2 = this.pages[i];
                    Intrinsics.checkNotNull(page2);
                    page2.getStyle().set("max-height", "calc(100vh - 210px)");
                    continue;
                }
                Page<?> page3 = this.pages[i];
                Intrinsics.checkNotNull(page3);
                page3.getStyle().set("max-height", "calc(100vh - 260px)");
            } while (n <= n2);
        }
        this.setContent(pageCount, titles);
    }

    public final void showBlockInfo() {
        this.blockInfo.setVisible(false);
        this.blockInfo.show();
    }

    protected final void setContent(int pageCount, @NotNull String[] titles, @Nullable String separator) {
        Intrinsics.checkNotNullParameter((Object)titles, (String)"titles");
    }

    @NotNull
    protected final VCaption createCaption(@NotNull String title) {
        String string;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        VCaption vCaption = new VCaption(true);
        boolean bl = false;
        boolean bl2 = false;
        VCaption caption = vCaption;
        boolean bl3 = false;
        if (StringsKt.endsWith$default((String)title, (String)"<CENTER>", (boolean)false, (int)2, null)) {
            String string2 = title;
            int n = 0;
            int n2 = title.length() - 8;
            boolean bl4 = false;
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = title;
        }
        caption.setCaption(string);
        return vCaption;
    }

    public final void setEnabled(boolean enabled, int page) {
        Tab tab = (Tab)CollectionsKt.elementAtOrNull((Iterable)this.tabsToPages.keySet(), (int)page);
        if (tab != null) {
            tab.setEnabled(enabled);
        }
    }

    public final void addFormListener(@NotNull FormListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    public final void removeFormListener(@NotNull FormListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    public final void addPositionPanelListener(@NotNull PositionPanelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        if (this.blockInfo != null) {
            this.blockInfo.addPositionPanelListener(l);
        }
    }

    public final void removePositionPanelListener(@NotNull PositionPanelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        if (this.blockInfo != null) {
            this.blockInfo.removePositionPanelListener(l);
        }
    }

    protected final void firePageSelected(int page) {
        for (FormListener l : this.listeners) {
            l.onPageSelection(page);
        }
    }

    protected final void fireGotoNextPosition() {
        for (FormListener l : this.listeners) {
            l.gotoNextPosition();
        }
    }

    protected final void fireGotoPrevPosition() {
        for (FormListener l : this.listeners) {
            l.gotoPrevPosition();
        }
    }

    protected final void fireGotoLastPosition() {
        for (FormListener l : this.listeners) {
            l.gotoLastPosition();
        }
    }

    protected final void fireGotoFirstPosition() {
        for (FormListener l : this.listeners) {
            l.gotoFirstPosition();
        }
    }

    protected final void fireGotoPosition(int posno) {
        for (FormListener l : this.listeners) {
            l.gotoPosition(posno);
        }
    }

    protected final void init() {
        this.addPositionPanelListener(this);
    }

    public final boolean delegateCaptionHandling() {
        return false;
    }

    @Override
    public void gotoNextPosition() {
        this.fireGotoNextPosition();
    }

    @Override
    public void gotoPrevPosition() {
        this.fireGotoPrevPosition();
    }

    @Override
    public void gotoLastPosition() {
        this.fireGotoLastPosition();
    }

    @Override
    public void gotoFirstPosition() {
        this.fireGotoFirstPosition();
    }

    @Override
    public void gotoPosition(int posno) {
        this.fireGotoPosition(posno);
    }

    public final void setCurrentPosition(int current, int total) {
        this.setPosition(current, total);
    }

    public final void cleanDirtyValues(@Nullable Block active, boolean transferFocus2) {
        Block block = active;
        if (block != null) {
            block.cleanDirtyValues(active, transferFocus2);
        }
    }

    public static /* synthetic */ void cleanDirtyValues$default(Form form, Block block, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        form.cleanDirtyValues(block, bl);
    }

    public final void disableAllBlocksActors() {
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Component child = (Component)iterator.next();
            if (!(child instanceof Block)) continue;
            ((Block)child).setColumnViewsActorsEnabled(false);
        }
    }

    public static final /* synthetic */ void access$setLastSelected$p(Form $this, Tab tab) {
        $this.lastSelected = tab;
    }

    public static final /* synthetic */ Tabs access$getTabPanel$p(Form $this) {
        return $this.tabPanel;
    }

    public static final /* synthetic */ Tab access$getLastSelected$p(Form $this) {
        return $this.lastSelected;
    }

    public static final /* synthetic */ Page[] access$getPages$p(Form $this) {
        return $this.pages;
    }

    public static final /* synthetic */ Map access$getTabsToPages$p(Form $this) {
        return $this.tabsToPages;
    }
}

