/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.list;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.VListDialog;
import org.kopi.galite.visual.list.VListColumn;
import org.kopi.galite.visual.ui.vaadin.list.ListFilter;

@CssImport(value="./styles/galite/list.css")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\u00112\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/list/ListTable;", "Lcom/vaadin/flow/component/grid/Grid;", "", "", "model", "Lorg/kopi/galite/visual/form/VListDialog;", "(Lorg/kopi/galite/visual/form/VListDialog;)V", "headerComponents", "", "Lcom/vaadin/flow/component/Component;", "getHeaderComponents", "()Ljava/util/List;", "getModel", "()Lorg/kopi/galite/visual/form/VListDialog;", "selectedItem", "getSelectedItem", "buildColumns", "", "buildRows", "formatObject", "", "o", "col", "", "installFilters", "galite-core"})
public final class ListTable
extends Grid<List<? extends Object>> {
    @NotNull
    private final VListDialog model;
    @NotNull
    private final List<Component> headerComponents;

    public ListTable(@NotNull VListDialog model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
        boolean bl = false;
        this.headerComponents = new ArrayList();
        this.setColumnReorderingAllowed(true);
        this.buildRows();
        this.buildColumns();
        this.installFilters(this.model);
    }

    @NotNull
    public final VListDialog getModel() {
        return this.model;
    }

    @NotNull
    public final List<Component> getHeaderComponents() {
        return this.headerComponents;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRows() {
        List[] items = new List[this.model.getCount()];
        int n = 0;
        int n2 = this.model.getCount();
        if (n < n2) {
            do {
                Collection<void> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int row = n++;
                Object[] objectArray = (Object[])this.model.getData();
                int n3 = row;
                List[] listArray = items;
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Object[] objectArray2 = (Object[])item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void var19_19 = it[this.getModel().getTranslatedIdents()[row]];
                    collection.add(var19_19);
                }
                collection = (List)destination$iv$iv;
                listArray[n3] = collection;
            } while (n < n2);
        }
        this.setItems(Arrays.copyOf(items, items.length));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildColumns() {
        int n = 0;
        int n2 = this.model.getColumnCount();
        if (n < n2) {
            do {
                void it;
                int col = n++;
                Span span = new Span(this.model.getColumnName(col));
                boolean bl = false;
                boolean bl2 = false;
                Span span2 = span;
                Grid.Column column2 = this.addColumn(new ValueProvider(this, col){
                    final /* synthetic */ ListTable this$0;
                    final /* synthetic */ int $col;
                    {
                        this.this$0 = $receiver;
                        this.$col = $col;
                    }

                    public final Object apply(List<? extends Object> it) {
                        return this.this$0.formatObject(it.get(this.$col), this.$col);
                    }
                });
                boolean bl3 = false;
                this.getHeaderComponents().add((Component)it);
                Unit unit = Unit.INSTANCE;
                column2.setHeader((Component)span).setAutoWidth(true).setKey(String.valueOf(col));
            } while (n < n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void installFilters(@Nullable VListDialog model2) {
        HeaderRow filterRow;
        Object object = filterRow = this.appendHeaderRow();
        boolean bl = false;
        boolean bl2 = false;
        HeaderRow it = object;
        boolean bl3 = false;
        this.getElement().getClassList().add((Object)"list-filter");
        object = this.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.columns");
        Iterable $this$forEachIndexed$iv = (Iterable)object;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void column2;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Grid.Column column3 = (Grid.Column)item$iv;
            int index = n;
            boolean bl5 = false;
            HeaderRow.HeaderCell cell = (HeaderRow.HeaderCell)filterRow.getCell((Grid.Column)column2);
            TextField filter = new TextField();
            filter.setWidthFull();
            Icon search = new Icon(VaadinIcon.SEARCH);
            filter.setSuffixComponent((Component)search);
            filter.setClassName("filter-text");
            filter.addValueChangeListener(new HasValue.ValueChangeListener(this, index, filter){
                final /* synthetic */ ListTable this$0;
                final /* synthetic */ int $index;
                final /* synthetic */ TextField $filter;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                    this.$filter = $filter;
                }

                public final void valueChanged(AbstractField.ComponentValueChangeEvent<TextField, String> it) {
                    Object object = this.this$0.getDataProvider();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.data.provider.ListDataProvider<@[FlexibleNullability] kotlin.collections.List<kotlin.Any?>?>");
                    }
                    ListDataProvider listDataProvider = (ListDataProvider)object;
                    object = this.$filter.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"filter.value");
                    listDataProvider.setFilter((SerializablePredicate)new ListFilter(this.$index, (String)object, true, false));
                }
            });
            filter.setValueChangeMode(ValueChangeMode.EAGER);
            cell.setComponent((Component)filter);
        }
        this.getElement().getClassList().add((Object)"filtered");
    }

    @NotNull
    protected final String formatObject(@Nullable Object o, int col) {
        VListColumn vListColumn = this.model.getColumns()[col];
        Intrinsics.checkNotNull((Object)vListColumn);
        return String.valueOf(vListColumn.formatObject(o));
    }

    @NotNull
    public final List<Object> getSelectedItem() {
        Object object = this.asSingleSelect().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"asSingleSelect().value");
        return (List)object;
    }
}

