/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.visual;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.ui.vaadin.base.LocalizedProperties;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/visual/DownloaderDialog;", "Lcom/vaadin/flow/component/dialog/Dialog;", "file", "Ljava/io/File;", "name", "", "locale", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "closeButton", "Lcom/vaadin/flow/component/button/Button;", "downloadButton", "createFileInputStream", "Ljava/io/InputStream;", "path", "galite-core"})
public final class DownloaderDialog
extends Dialog {
    @NotNull
    private final Button downloadButton;
    @NotNull
    private final Button closeButton;

    public DownloaderDialog(@NotNull File file, @NotNull String name, @NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.downloadButton = new Button(LocalizedProperties.INSTANCE.getString(locale, "downloadLabel"), (Component)new Icon(VaadinIcon.DOWNLOAD_ALT));
        this.closeButton = new Button(LocalizedProperties.INSTANCE.getString(locale, "CLOSE"), (Component)new Icon(VaadinIcon.CLOSE_CIRCLE));
        StreamResource href2 = new StreamResource(name, new InputStreamFactory(this, file){
            final /* synthetic */ DownloaderDialog this$0;
            final /* synthetic */ File $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
            }

            public final InputStream createInputStream() {
                String string = this.$file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
                return DownloaderDialog.access$createFileInputStream(this.this$0, string);
            }
        });
        Anchor download = new Anchor((AbstractStreamResource)href2, "");
        Div buttons = new Div();
        Div title = new Div();
        title.setClassName("download-file-title");
        buttons.setClassName("download-file-buttons");
        download.getElement().setAttribute("download", true);
        this.downloadButton.setDisableOnClick(true);
        title.setText(LocalizedProperties.INSTANCE.getString(locale, "downloadText") + ": " + name);
        this.closeButton.addClickListener(new ComponentEventListener(){

            public final void onComponentEvent(ClickEvent<Button> it) {
                this.close();
            }
        });
        Component[] componentArray = new Component[]{(Component)this.downloadButton};
        download.add(componentArray);
        componentArray = new Component[]{(Component)download, (Component)this.closeButton};
        buttons.add(componentArray);
        componentArray = new Component[1];
        Component[] componentArray2 = new Component[]{(Component)title, (Component)buttons};
        componentArray[0] = (Component)new VerticalLayout(componentArray2);
        this.add(componentArray);
    }

    private final InputStream createFileInputStream(String path) {
        InputStream inputStream;
        try {
            inputStream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return inputStream;
    }

    public static final /* synthetic */ InputStream access$createFileInputStream(DownloaderDialog $this, String path) {
        return $this.createFileInputStream(path);
    }
}

