/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.window;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.actor.Actor;
import org.kopi.galite.visual.ui.vaadin.actor.VActorsNavigationPanel;
import org.kopi.galite.visual.ui.vaadin.base.Utils;
import org.kopi.galite.visual.ui.vaadin.base.VScrollablePanel;
import org.kopi.galite.visual.ui.vaadin.block.Block;
import org.kopi.galite.visual.ui.vaadin.form.Form;
import org.kopi.galite.visual.ui.vaadin.main.MainWindow;
import org.kopi.galite.visual.ui.vaadin.menu.VNavigationMenu;
import org.kopi.galite.visual.ui.vaadin.window.PopupWindow;
import org.kopi.galite.visual.ui.vaadin.window.VActorPanel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\tH\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u001eH\u0016J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/window/Window;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "Lcom/vaadin/flow/component/Focusable;", "()V", "actors", "Lorg/kopi/galite/visual/ui/vaadin/window/VActorPanel;", "getActors", "()Lorg/kopi/galite/visual/ui/vaadin/window/VActorPanel;", "content", "Lcom/vaadin/flow/component/Component;", "lasFocusedField", "getLasFocusedField", "()Lcom/vaadin/flow/component/Focusable;", "setLasFocusedField", "(Lcom/vaadin/flow/component/Focusable;)V", "navigationMenu", "Lorg/kopi/galite/visual/ui/vaadin/menu/VNavigationMenu;", "getNavigationMenu", "()Lorg/kopi/galite/visual/ui/vaadin/menu/VNavigationMenu;", "addActor", "", "actor", "Lorg/kopi/galite/visual/ui/vaadin/actor/Actor;", "addActorsNavigationPanel", "panel", "Lorg/kopi/galite/visual/ui/vaadin/actor/VActorsNavigationPanel;", "cleanDirtyValues", "active", "Lorg/kopi/galite/visual/ui/vaadin/block/Block;", "transferFocus", "", "focus", "getContent", "goBackToLastFocusedTextField", "hasLastFocusedTextField", "maybeSetMainWindowCaption", "caption", "", "maybeSetPopupWindowCaption", "setActorEnabled", "enabled", "setCaption", "setContent", "galite-core"})
public abstract class Window
extends VerticalLayout
implements Focusable<Window> {
    @NotNull
    private final VActorPanel actors = new VActorPanel();
    @Nullable
    private Component content;
    @Nullable
    private Focusable<?> lasFocusedField;

    public Window() {
        this.setClassName("k-window");
    }

    @NotNull
    protected final VActorPanel getActors() {
        return this.actors;
    }

    @Nullable
    public final Focusable<?> getLasFocusedField() {
        return this.lasFocusedField;
    }

    public final void setLasFocusedField(@Nullable Focusable<?> focusable) {
        this.lasFocusedField = focusable;
    }

    public void addActor(@NotNull Actor actor) {
        Intrinsics.checkNotNullParameter((Object)((Object)actor), (String)"actor");
        this.actors.addActor((Component)actor);
    }

    public void addActorsNavigationPanel(@NotNull VActorsNavigationPanel panel) {
        Intrinsics.checkNotNullParameter((Object)((Object)panel), (String)"panel");
        this.actors.addActorsNavigationPanel(panel);
    }

    @NotNull
    public final VNavigationMenu getNavigationMenu() {
        return this.actors.getNavigationMenu();
    }

    public void setContent(@NotNull Component content) {
        Component[] componentArray;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.content != null) {
            componentArray = new Component[]{this.content};
            this.remove(componentArray);
        }
        componentArray = new Component[]{content};
        this.content = (Component)new VScrollablePanel(componentArray);
        componentArray = new Component[]{this.content};
        this.add(componentArray);
    }

    @Nullable
    public Component getContent() {
        return this.content;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasLastFocusedTextField() {
        if (this.lasFocusedField == null) return false;
        Focusable<?> focusable = this.lasFocusedField;
        if (focusable == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.component.Component");
        }
        if (!((Component)focusable).isAttached()) return false;
        return true;
    }

    public void goBackToLastFocusedTextField() {
        if (this.lasFocusedField != null) {
            Focusable<?> focusable = this.lasFocusedField;
            Intrinsics.checkNotNull(focusable);
            focusable.focus();
        }
    }

    public void setCaption(@NotNull String caption) {
        Intrinsics.checkNotNullParameter((Object)caption, (String)"caption");
        boolean success = this.maybeSetMainWindowCaption(caption);
        if (!success) {
            this.maybeSetPopupWindowCaption(caption);
        }
    }

    private final boolean maybeSetMainWindowCaption(String caption) {
        MainWindow parent = Utils.INSTANCE.findMainWindow((Component)this);
        if (parent != null && parent.getWindowsList$galite_core().contains((Object)this)) {
            parent.updateWindowTitle((Component)this, caption);
            return true;
        }
        return false;
    }

    private final boolean maybeSetPopupWindowCaption(String caption) {
        Ref.ObjectRef parent = new Ref.ObjectRef();
        this.getParent().ifPresent(arg_0 -> Window.maybeSetPopupWindowCaption$lambda-0(parent, arg_0));
        if (parent.element != null) {
            Object object = parent.element;
            Intrinsics.checkNotNull((Object)object);
            ((PopupWindow)((Object)object)).setCaption(caption);
            return true;
        }
        return false;
    }

    public void cleanDirtyValues(@NotNull Block active) {
        Intrinsics.checkNotNullParameter((Object)((Object)active), (String)"active");
        this.cleanDirtyValues(active, true);
    }

    public void cleanDirtyValues(@Nullable Block active, boolean transferFocus2) {
        if (this.content instanceof Form) {
            Component component = this.content;
            if (component == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.form.Form");
            }
            ((Form)component).cleanDirtyValues(active, transferFocus2);
        }
    }

    public void setActorEnabled(@NotNull Component actor, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Component child = (Component)iterator.next();
            if (!(child instanceof Actor) || !Intrinsics.areEqual((Object)child, (Object)actor)) continue;
            ((Actor)child).setEnabled(enabled);
        }
    }

    public void focus() {
    }

    private static final void maybeSetPopupWindowCaption$lambda-0(Ref.ObjectRef $parent, Component popupContent) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)$parent, (String)"$parent");
        Intrinsics.checkNotNullParameter((Object)popupContent, (String)"popupContent");
        $parent.element = popupContent instanceof PopupWindow ? (PopupWindow)popupContent : ((t = popupContent.getParent().orElseGet(null)) instanceof PopupWindow ? (PopupWindow)((Object)t) : null);
    }
}

