/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.visual;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.l10n.LocalizationManager;
import org.kopi.galite.visual.util.base.InconsistencyException;
import org.kopi.galite.visual.visual.ApplicationContext;
import org.kopi.galite.visual.visual.Item;
import org.kopi.galite.visual.visual.ItemTreeManager;
import org.kopi.galite.visual.visual.Message;
import org.kopi.galite.visual.visual.RootItem;
import org.kopi.galite.visual.visual.UIFactory;
import org.kopi.galite.visual.visual.UItemTree;
import org.kopi.galite.visual.visual.UWindow;
import org.kopi.galite.visual.visual.VActor;
import org.kopi.galite.visual.visual.VWindow;
import org.kopi.galite.visual.visual.WindowBuilder;
import org.kopi.galite.visual.visual.WindowController;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 L2\u00020\u0001:\u0001LBe\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\b\u0012\u0006\u0010\u0011\u001a\u00020\b\u0012\u0006\u0010\u0012\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013J8\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\bH\u0002J\b\u00105\u001a\u00020.H\u0002J\u0010\u00106\u001a\u00020.2\u0006\u00103\u001a\u00020\bH\u0016J\u0010\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020\bH\u0016J\b\u00109\u001a\u00020:H\u0016J\u0013\u0010;\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010<J\u0006\u0010=\u001a\u00020\bJ\u0006\u0010>\u001a\u00020\u0006J\b\u0010?\u001a\u00020\bH\u0016J\b\u0010@\u001a\u00020.H\u0002J\u0006\u0010A\u001a\u00020\nJ\u0006\u0010B\u001a\u00020\nJ\u0006\u0010C\u001a\u00020\nJ\u0006\u0010D\u001a\u00020\nJ\u0010\u0010E\u001a\u00020.2\b\u0010F\u001a\u0004\u0018\u00010GJ\u0006\u0010H\u001a\u00020.J\u0018\u0010I\u001a\u00020.2\u0006\u0010J\u001a\u00020\b2\u0006\u0010K\u001a\u00020\nH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0012\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0018R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0018R\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0018R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\"\u0010%\u001a\u0004\u0018\u00010$2\b\u0010#\u001a\u0004\u0018\u00010$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010,\u00a8\u0006M"}, d2={"Lorg/kopi/galite/visual/visual/VItemTree;", "Lorg/kopi/galite/visual/visual/VWindow;", "rootName", "", "items", "", "Lorg/kopi/galite/visual/visual/Item;", "depth", "", "isInsertMode", "", "selectionType", "isLocalised", "itemTreeManager", "Lorg/kopi/galite/visual/visual/ItemTreeManager;", "isRemoveDescendantsAllowed", "nameLength", "localisedNameLength", "descriptionLength", "(Ljava/lang/String;[Lorg/kopi/galite/visual/visual/Item;IZIZLorg/kopi/galite/visual/visual/ItemTreeManager;ZIII)V", "getDepth", "()I", "getDescriptionLength", "isChanged", "()Z", "setChanged", "(Z)V", "[Lorg/kopi/galite/visual/visual/Item;", "getLocalisedNameLength", "maxId", "getNameLength", "removedItems", "", "getRemovedItems", "()Ljava/util/List;", "<set-?>", "Ljavax/swing/tree/TreeNode;", "root", "getRoot", "()Ljavax/swing/tree/TreeNode;", "rootItem", "Lorg/kopi/galite/visual/visual/RootItem;", "treeActors", "Lorg/kopi/galite/visual/visual/VActor;", "[Lorg/kopi/galite/visual/visual/VActor;", "createActor", "", "number", "menu", "item", "icon", "key", "modifier", "createTree", "executeVoidTrigger", "getActor", "at", "getDisplay", "Lorg/kopi/galite/visual/visual/UItemTree;", "getItems", "()[Lorg/kopi/galite/visual/visual/Item;", "getNextId", "getRootItem", "getType", "initMaxId", "isMultiSelection", "isMultiSelectionDefaultValue", "isNoEdit", "isSingleSelection", "localizeActors", "locale", "Ljava/util/Locale;", "refresh", "setActorEnabled", "actor", "enabled", "Companion", "galite-core"})
public final class VItemTree
extends VWindow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Item[] items;
    private final int depth;
    private final boolean isInsertMode;
    private final int selectionType;
    private final boolean isLocalised;
    @NotNull
    private final ItemTreeManager itemTreeManager;
    private final boolean isRemoveDescendantsAllowed;
    private final int nameLength;
    private final int localisedNameLength;
    private final int descriptionLength;
    @Nullable
    private TreeNode root;
    @Nullable
    private RootItem rootItem;
    @NotNull
    private final VActor[] treeActors;
    private int maxId;
    @NotNull
    private final String rootName;
    private boolean isChanged;
    @NotNull
    private final List<Item> removedItems;
    public static final int MAX_LENGTH = 32;
    public static final int NO_EDIT = 1;
    public static final int SINGLE_SELECTION = 2;
    public static final int MULTI_SELECTION = 3;
    public static final int MULTI_SELECTION_DEFAULT_VALUE = 4;
    public static final int CMD_QUIT = 0;
    public static final int CMD_SELECT = 1;
    public static final int CMD_DEFAULT = 2;
    public static final int CMD_FOLD = 3;
    public static final int CMD_UNFOLD = 4;
    public static final int CMD_SAVE = 5;
    public static final int CMD_LOCALISE = 6;
    public static final int CMD_EDIT = 7;
    public static final int CMD_ADD = 8;
    public static final int CMD_REMOVE = 9;
    @NotNull
    private static final String MENU_LOCALIZATION_RESOURCE = "org/kopi/galite/visual/Menu";

    public VItemTree(@Nullable String rootName, @NotNull Item[] items, int depth, boolean isInsertMode, int selectionType, boolean isLocalised, @NotNull ItemTreeManager itemTreeManager, boolean isRemoveDescendantsAllowed, int nameLength, int localisedNameLength, int descriptionLength) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)itemTreeManager, (String)"itemTreeManager");
        super(null, 1, null);
        this.items = items;
        this.depth = depth;
        this.isInsertMode = isInsertMode;
        this.selectionType = selectionType;
        this.isLocalised = isLocalised;
        this.itemTreeManager = itemTreeManager;
        this.isRemoveDescendantsAllowed = isRemoveDescendantsAllowed;
        this.nameLength = nameLength;
        this.localisedNameLength = localisedNameLength;
        this.descriptionLength = descriptionLength;
        this.treeActors = new VActor[10];
        String string = rootName;
        this.rootName = string == null ? "Items" : string;
        boolean bl = false;
        this.removedItems = new ArrayList();
        String string2 = rootName;
        if (string2 != null) {
            String string3 = string2;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string3;
            boolean bl4 = false;
            this.setTitle(it);
        }
        this.createActor(0, "File", "Close", "quit", 0, 0);
        this.createActor(1, "Edit", "Select", "done", 10, 0);
        this.createActor(8, "Edit", "AddItem", "insertline", 0, 0);
        this.createActor(9, "Edit", "RemoveItem", "deleteline", 0, 0);
        this.createActor(7, "Edit", "EditItem", "edit", 0, 0);
        this.createActor(3, "Edit", "Fold", "fold", 10, 0);
        this.createActor(4, "Edit", "Unfold", "unfold", 10, 0);
        this.createActor(2, "Edit", "Default", "top", 0, 0);
        this.createActor(6, "Edit", "Localise", "bold", 0, 0);
        this.createActor(5, "Edit", "Save", "save", 0, 0);
        this.addActors((VActor[])ArraysKt.requireNoNulls((Object[])this.treeActors));
        this.localizeActors(ApplicationContext.Companion.getDefaultLocale());
        this.createTree();
        if (this.isInsertMode) {
            this.initMaxId();
        }
    }

    public final int getDepth() {
        return this.depth;
    }

    public final boolean isInsertMode() {
        return this.isInsertMode;
    }

    public final boolean isLocalised() {
        return this.isLocalised;
    }

    public final boolean isRemoveDescendantsAllowed() {
        return this.isRemoveDescendantsAllowed;
    }

    public final int getNameLength() {
        return this.nameLength;
    }

    public final int getLocalisedNameLength() {
        return this.localisedNameLength;
    }

    public final int getDescriptionLength() {
        return this.descriptionLength;
    }

    public final void localizeActors(@Nullable Locale locale) {
        LocalizationManager manager = null;
        manager = new LocalizationManager(locale, Locale.getDefault());
        try {
            super.localizeActors(manager);
        }
        catch (InconsistencyException e) {
            ApplicationContext.Companion.reportTrouble("ItemTree Actor localization", "ItemTreeModel.localize", e.getMessage(), e);
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        manager = null;
    }

    @Override
    public void setActorEnabled(int actor, boolean enabled) {
        VActor vActor = this.treeActors[actor];
        Intrinsics.checkNotNull((Object)vActor);
        vActor.setHandler$galite_core(this);
        VActor vActor2 = this.treeActors[actor];
        Intrinsics.checkNotNull((Object)vActor2);
        vActor2.setEnabled(enabled);
    }

    @Override
    @NotNull
    public VActor getActor(int at) {
        VActor vActor = this.treeActors[at];
        Intrinsics.checkNotNull((Object)vActor);
        return vActor;
    }

    private final void createActor(int number, String menu, String item, String icon, int key, int modifier) {
        this.treeActors[number] = new VActor(menu, MENU_LOCALIZATION_RESOURCE, item, MENU_LOCALIZATION_RESOURCE, icon, key, modifier, false, 128, null);
        VActor vActor = this.treeActors[number];
        Intrinsics.checkNotNull((Object)vActor);
        vActor.setNumber(number);
    }

    @Override
    public void executeVoidTrigger(int key) {
        UItemTree currentDisplay = this.getDisplay();
        int n = key;
        switch (n) {
            case 0: {
                if (this.isChanged) {
                    if (!this.ask(Message.INSTANCE.getMessage("confirm_quit"), false)) break;
                    currentDisplay.closeWindow();
                    break;
                }
                currentDisplay.closeWindow();
                break;
            }
            case 1: {
                currentDisplay.setSelectedItem();
                break;
            }
            case 8: {
                currentDisplay.addItem();
                this.refresh();
                break;
            }
            case 9: {
                if (!this.ask(Message.INSTANCE.getMessage("confirm_delete"), false)) break;
                currentDisplay.removeSelectedItem();
                this.refresh();
                break;
            }
            case 7: {
                currentDisplay.editSelectedItem();
                this.refresh();
                break;
            }
            case 3: {
                currentDisplay.getTree().collapseRow(currentDisplay.getTree().getSelectionRow());
                break;
            }
            case 4: {
                currentDisplay.getTree().expandRow(currentDisplay.getTree().getSelectionRow());
                break;
            }
            case 2: {
                currentDisplay.setDefaultItem();
                break;
            }
            case 6: {
                currentDisplay.localiseSelectedItem();
                this.refresh();
                break;
            }
            case 5: {
                if (!this.isChanged || this.itemTreeManager == null) break;
                this.setWaitInfo("");
                this.itemTreeManager.save();
                this.unsetWaitInfo();
                this.isChanged = false;
                UItemTree uItemTree = currentDisplay;
                if (uItemTree == null) break;
                uItemTree.setTree();
                break;
            }
            default: {
                super.executeVoidTrigger(key);
            }
        }
    }

    public final void refresh() {
        this.isChanged = true;
        this.getDisplay().setTree();
    }

    private final void createTree() {
        RootItem rootItem = this.rootItem = new RootItem(-1, this.rootName);
        Intrinsics.checkNotNull((Object)rootItem);
        rootItem.createTree(this.items);
        RootItem rootItem2 = this.rootItem;
        Intrinsics.checkNotNull((Object)rootItem2);
        this.root = rootItem2.getRoot();
    }

    @Nullable
    public final Item[] getItems() {
        return this.getDisplay().getTree().getItems();
    }

    @NotNull
    public final Item getRootItem() {
        return this.getDisplay().getTree().getRootItem();
    }

    private final void initMaxId() {
        this.maxId = -1;
        int n = 0;
        int n2 = this.items.length + -1;
        if (n <= n2) {
            do {
                int i;
                if (this.maxId >= this.items[i = n++].getId()) continue;
                this.maxId = this.items[i].getId();
            } while (n <= n2);
        }
    }

    @Override
    public int getType() {
        return 60;
    }

    @Override
    @NotNull
    public UItemTree getDisplay() {
        UWindow uWindow = super.getDisplay();
        if (uWindow == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.visual.UItemTree");
        }
        return (UItemTree)uWindow;
    }

    public final boolean isNoEdit() {
        return this.selectionType == 1;
    }

    public final boolean isSingleSelection() {
        return this.selectionType == 2;
    }

    public final boolean isMultiSelection() {
        return this.selectionType == 3;
    }

    public final boolean isMultiSelectionDefaultValue() {
        return this.selectionType == 4;
    }

    public final int getNextId() {
        VItemTree vItemTree = this;
        int n = vItemTree.maxId;
        vItemTree.maxId = n + 1;
        return this.maxId;
    }

    @Nullable
    public final TreeNode getRoot() {
        return this.root;
    }

    public final boolean isChanged() {
        return this.isChanged;
    }

    public final void setChanged(boolean bl) {
        this.isChanged = bl;
    }

    @NotNull
    public final List<Item> getRemovedItems() {
        return this.removedItems;
    }

    static {
        WindowController.Companion.getWindowController().registerWindowBuilder(60, new WindowBuilder(){

            @NotNull
            public UWindow createWindow(@NotNull VWindow model2) {
                Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
                return (UItemTree)UIFactory.Companion.getUiFactory().createView(model2);
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kopi/galite/visual/visual/VItemTree$Companion;", "", "()V", "CMD_ADD", "", "CMD_DEFAULT", "CMD_EDIT", "CMD_FOLD", "CMD_LOCALISE", "CMD_QUIT", "CMD_REMOVE", "CMD_SAVE", "CMD_SELECT", "CMD_UNFOLD", "MAX_LENGTH", "MENU_LOCALIZATION_RESOURCE", "", "MULTI_SELECTION", "MULTI_SELECTION_DEFAULT_VALUE", "NO_EDIT", "SINGLE_SELECTION", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

