/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.Component;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.kopi.galite.visual.base.UComponent;
import org.kopi.galite.visual.form.Alignment;
import org.kopi.galite.visual.form.LayoutManager;
import org.kopi.galite.visual.form.UBlock;
import org.kopi.galite.visual.form.UForm;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldUI;
import org.kopi.galite.visual.form.ViewBlockAlignment;
import org.kopi.galite.visual.util.base.InconsistencyException;
import org.kopi.galite.visual.visual.VException;
import org.kopi.galite.visual.visual.VExecFailedException;
import org.kopi.vkopi.lib.ui.swing.base.KopiTitledBorder;
import org.kopi.vkopi.lib.ui.swing.form.DBlockDropTargetHandler;
import org.kopi.vkopi.lib.ui.swing.form.DFieldUI;
import org.kopi.vkopi.lib.ui.swing.form.DForm;
import org.kopi.vkopi.lib.ui.swing.form.KopiSimpleBlockLayout;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;

public class DBlock
extends JPanel
implements UBlock {
    private final SynchronRefresh synchronRefresh = new SynchronRefresh();
    private final DForm formView;
    protected final VBlock model;
    private VFieldUI[] columnViews;
    protected LayoutManager layout;
    protected final int maxRowPos;
    protected final int maxColumnPos;
    protected final int displayedFields;
    protected Border border;
    private int sortedToprec;
    private int[] sortedRecToDisplay;
    private int[] displayToSortedRec;
    private static final long serialVersionUID = -8665529498396399382L;

    public DBlock(DForm parent, VBlock model2) {
        SwingThreadHandler.verifyRunsInEventThread("DBlock <init>");
        this.setBorder(model2.getBorder(), model2.getTitle());
        this.setBorder(this.border);
        this.setFocusCycleRoot(true);
        this.setFocusable(false);
        model2.addBlockListener(this);
        this.maxRowPos = model2.getMaxRowPos();
        this.maxColumnPos = model2.getMaxColumnPos();
        this.displayedFields = model2.getDisplayedFields();
        this.model = model2;
        this.formView = parent;
        if (model2.isMulti()) {
            this.sortedRecToDisplay = new int[model2.getBufferSize()];
            this.displayToSortedRec = new int[model2.getDisplaySize()];
        } else {
            this.sortedRecToDisplay = new int[1];
            this.displayToSortedRec = new int[1];
        }
        this.layout = this.createLayoutManager();
        this.setLayout(this.layout);
        this.rebuildCachedInfos();
        this.createFields();
        if (model2.isDroppable()) {
            this.setDropTarget(new DropTarget(null, 1, new DBlockDropTargetHandler(model2)));
        }
    }

    protected void createFields() {
        VField[] fields = this.model.getFields();
        this.columnViews = new VFieldUI[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.columnViews[i] = this.createFieldDisplays(fields[i]);
        }
    }

    protected LayoutManager createLayoutManager() {
        return new KopiSimpleBlockLayout(2 * this.maxColumnPos, this.maxRowPos, this.model.getAlignment() == null ? null : new ViewBlockAlignment(this.formView, this.model.getAlignment()));
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 5, insets.left + 5, insets.bottom + 5, insets.right + 5);
    }

    @Override
    public VBlock getModel() {
        return this.model;
    }

    @Override
    public int getColumnPos(int x) {
        return this.layout.getColumnPos(x);
    }

    private void setBorder(int style, String title) {
        if (style == 0) {
            this.border = KopiTitledBorder.BRD_EMPTY;
        } else {
            switch (style) {
                case 1: {
                    this.border = KopiTitledBorder.BRD_LINE;
                    break;
                }
                case 2: {
                    this.border = KopiTitledBorder.BRD_RAISED;
                    break;
                }
                case 3: {
                    this.border = KopiTitledBorder.BRD_LOWERED;
                    break;
                }
                case 4: {
                    this.border = KopiTitledBorder.BRD_ETCHED;
                    break;
                }
                default: {
                    throw new InconsistencyException();
                }
            }
            if (title != null) {
                this.border = new KopiTitledBorder(this.border, title);
            }
        }
    }

    private VFieldUI createFieldDisplays(VField model2) {
        if (!model2.isInternal()) {
            DFieldUI ui = new DFieldUI(this, model2);
            return ui;
        }
        return null;
    }

    public void gotoNextRecord() throws VException {
        this.getModel().gotoNextRecord();
    }

    public void gotoPrevRecord() throws VException {
        this.getModel().gotoPrevRecord();
    }

    private void rebuildCachedInfos() {
        int i;
        int cnt = 0;
        for (i = 0; i < this.sortedToprec; ++i) {
            this.sortedRecToDisplay[i] = -1;
        }
        while (cnt < this.model.getDisplaySize() && i < this.model.getBufferSize()) {
            this.sortedRecToDisplay[i] = this.model.isSortedRecordDeleted(i) ? -1 : cnt++;
            ++i;
        }
        while (i < this.model.getBufferSize()) {
            this.sortedRecToDisplay[i] = -1;
            ++i;
        }
        cnt = this.sortedToprec;
        for (i = 0; i < this.model.getDisplaySize(); ++i) {
            while (cnt < this.model.getBufferSize() && this.model.isSortedRecordDeleted(cnt)) {
                ++cnt;
            }
            if (cnt >= this.model.getBufferSize()) continue;
            this.displayToSortedRec[i] = cnt++;
        }
    }

    @Override
    public void add(UComponent comp, Alignment constraints) {
        super.add((Component)((Object)comp), constraints);
    }

    protected void refresh(boolean force) {
        int i;
        SwingThreadHandler.verifyRunsInEventThread("DBlock refresh");
        boolean redisplay = false;
        if (!this.model.isMulti()) {
            return;
        }
        if (this.model.getActiveRecord() == -1) {
            this.rebuildCachedInfos();
            for (int i2 = 0; i2 < this.columnViews.length; ++i2) {
                if (this.columnViews[i2] == null) continue;
                this.columnViews[i2].scrollTo(this.sortedToprec);
            }
            return;
        }
        int recno = this.model.getSortedPosition(this.model.getActiveRecord());
        if (recno < this.sortedToprec) {
            this.sortedToprec = recno;
            int scrollMore = this.model.getDisplaySize() / 4;
            for (i = recno - 1; scrollMore > 0 && i > 0; --i) {
                if (this.model.isSortedRecordDeleted(i)) continue;
                --this.sortedToprec;
                --scrollMore;
            }
            redisplay = true;
        } else {
            int i3;
            int displine = 0;
            for (i3 = this.sortedToprec; i3 < recno; ++i3) {
                if (this.model.isSortedRecordDeleted(i3)) continue;
                ++displine;
            }
            if (displine < this.model.getDisplaySize()) {
                redisplay = force;
            } else {
                do {
                    if (!this.model.isSortedRecordDeleted(this.sortedToprec)) {
                        --displine;
                    }
                    ++this.sortedToprec;
                } while (displine >= this.model.getDisplaySize());
                int scrollMore = this.model.getDisplaySize() / 4;
                for (i3 = recno + 1; scrollMore > 0 && i3 < this.model.getBufferSize(); ++i3) {
                    if (this.model.isSortedRecordDeleted(i3)) continue;
                    ++this.sortedToprec;
                    --scrollMore;
                }
                redisplay = true;
            }
        }
        this.rebuildCachedInfos();
        if (redisplay) {
            for (i = 0; i < this.columnViews.length; ++i) {
                if (this.columnViews[i] == null) continue;
                this.columnViews[i].scrollTo(this.sortedToprec);
            }
        }
    }

    @Override
    public void orderChanged() {
        SwingThreadHandler.startAndWait(this.synchronRefresh);
    }

    @Override
    public int getDisplayLine() {
        return this.getDisplayLine(this.model.getActiveRecord());
    }

    @Override
    public int getDisplayLine(int recno) {
        if (recno < 0) {
            return -1;
        }
        int pos = this.model.getSortedPosition(recno);
        if (pos < 0) {
            return -1;
        }
        return this.sortedRecToDisplay[pos];
    }

    @Override
    public int getRecordFromDisplayLine(int line) {
        return this.model.getDataPosition(this.displayToSortedRec[line]);
    }

    public void setScrollPos(int val) throws VException {
        assert (val < this.model.getBufferSize());
        if (this.sortedToprec != val) {
            int recno = 0;
            while (val > 0) {
                if (!this.model.isSortedRecordDeleted(recno)) {
                    --val;
                }
                ++recno;
            }
            if (this.model.getActiveField() != null) {
                int lastVisibleRec = recno;
                int nbDisplay = this.model.getDisplaySize() - 1;
                int activeRecord = this.model.getActiveRecord();
                boolean inside = false;
                while (nbDisplay > 0) {
                    if (!this.model.isSortedRecordDeleted(lastVisibleRec)) {
                        --nbDisplay;
                    }
                    if (activeRecord == this.model.getDataPosition(lastVisibleRec)) {
                        inside = true;
                    }
                    ++lastVisibleRec;
                }
                this.sortedToprec = recno;
                if (inside) {
                    if (this.model.getActiveField() != null) {
                        this.model.getActiveField().updateText();
                    }
                    this.blockChanged();
                } else {
                    int nextRec = this.model.getSortedPosition(this.model.getActiveRecord()) < recno ? this.model.getDataPosition(recno) : this.model.getDataPosition(lastVisibleRec);
                    if (this.model.noMove() || !this.model.isRecordAccessible(nextRec)) {
                        throw new VExecFailedException();
                    }
                    this.model.changeActiveRecord(nextRec);
                }
            } else {
                if (this.model.noMove() || this.model.isRecordDeleted(this.model.getDataPosition(recno))) {
                    throw new VExecFailedException();
                }
                this.sortedToprec = recno;
                this.blockChanged();
                if (this.model != this.model.getForm().getActiveBlock()) {
                    this.model.setActiveRecord(-1);
                }
            }
        }
    }

    public void clear() {
        this.sortedToprec = 0;
        this.refresh(true);
    }

    @Override
    public UForm getFormView() {
        return this.formView;
    }

    @Override
    public void blockClosed() {
    }

    @Override
    public void blockCleared() {
        SwingThreadHandler.start(new Runnable(){

            @Override
            public void run() {
                DBlock.this.clear();
            }
        });
    }

    @Override
    public void blockAccessChanged(VBlock block, boolean newAccess) {
    }

    @Override
    public void blockViewModeEntered(VBlock block, VField field2) {
    }

    @Override
    public void blockViewModeLeaved(VBlock block, VField field2) {
    }

    @Override
    public void blockChanged() {
        SwingThreadHandler.startAndWait(this.synchronRefresh);
    }

    @Override
    public void validRecordNumberChanged() {
    }

    @Override
    public void recordInfoChanged(int rec, int info) {
    }

    @Override
    public UBlock getCurrentDisplay() {
        return this;
    }

    @Override
    public void filterHidden() {
    }

    @Override
    public void filterShown() {
    }

    @Override
    public boolean inDetailMode() {
        return false;
    }

    private class SynchronRefresh
    implements Runnable {
        private SynchronRefresh() {
        }

        @Override
        public void run() {
            DBlock.this.refresh(true);
        }
    }
}

