/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.kopi.galite.visual.type.Date;
import org.kopi.galite.visual.type.Month;
import org.kopi.galite.visual.visual.VlibProperties;
import org.kopi.vkopi.lib.ui.swing.base.Utils;
import org.kopi.vkopi.lib.ui.swing.form.CalendarPane;

public class DateChooser
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8823525349311235417L;
    private static final String[] MONTH_NAMES = new String[]{VlibProperties.getString("Jan"), VlibProperties.getString("Feb"), VlibProperties.getString("Mar"), VlibProperties.getString("Apr"), VlibProperties.getString("May"), VlibProperties.getString("Jun"), VlibProperties.getString("Jul"), VlibProperties.getString("Aug"), VlibProperties.getString("Sep"), VlibProperties.getString("Oct"), VlibProperties.getString("Nov"), VlibProperties.getString("Dec")};
    private Date selectedDate;
    private boolean okay;
    private JPopupMenu popup;
    private FocusListener rootPaneFocusListener;
    private Component lastFocused = null;
    private boolean focusTraversalKeysEnabled;
    private KeyListener listener;
    private JLabel yearLabel;
    private JLabel monthLabel;
    private JButton prevYearButton;
    private JButton nextYearButton;
    private JButton prevMonthButton;
    private JButton nextMonthButton;
    private JButton todayButton;
    private CalendarPane cal;
    private int firstDay;
    JRootPane invokerRootPane;

    public DateChooser(Date date) {
        this.selectedDate = date == null ? Date.Companion.now() : date;
        this.setLayout(new BorderLayout(5, 5));
        this.setOpaque(false);
        this.setFocusCycleRoot(true);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout(0, 0));
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        top.add((Component)p1, "West");
        this.prevMonthButton = new JButton(Utils.getImage("arrowleft.gif"));
        this.prevMonthButton.setRequestFocusEnabled(false);
        this.prevMonthButton.setMargin(emptyInsets);
        this.prevMonthButton.setFocusPainted(false);
        this.prevMonthButton.setOpaque(false);
        this.prevMonthButton.addActionListener(this);
        p1.add(this.prevMonthButton);
        this.nextMonthButton = new JButton(Utils.getImage("arrowright.gif"));
        this.nextMonthButton.setRequestFocusEnabled(false);
        this.nextMonthButton.setMargin(emptyInsets);
        this.nextMonthButton.setFocusPainted(false);
        this.nextMonthButton.setOpaque(false);
        this.nextMonthButton.addActionListener(this);
        p1.add(this.nextMonthButton);
        this.monthLabel = new JLabel();
        this.monthLabel.setForeground(Color.black);
        this.monthLabel.setOpaque(false);
        p1.add(this.monthLabel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        top.add((Component)p2, "East");
        this.yearLabel = new JLabel();
        this.yearLabel.setForeground(Color.black);
        this.yearLabel.setOpaque(false);
        p2.add(this.yearLabel);
        this.prevYearButton = new JButton(Utils.getImage("arrowleft.gif"));
        this.prevYearButton.setRequestFocusEnabled(false);
        this.prevYearButton.setMargin(emptyInsets);
        this.prevYearButton.setFocusPainted(false);
        this.prevYearButton.setOpaque(false);
        this.prevYearButton.addActionListener(this);
        p2.add(this.prevYearButton);
        this.nextYearButton = new JButton(Utils.getImage("arrowright.gif"));
        this.nextYearButton.setRequestFocusEnabled(false);
        this.nextYearButton.setMargin(emptyInsets);
        this.nextYearButton.setFocusPainted(false);
        this.nextYearButton.setOpaque(false);
        this.nextYearButton.addActionListener(this);
        p2.add(this.nextYearButton);
        this.add((Component)top, "North");
        this.cal = new CalendarPane(this);
        this.cal.setOpaque(false);
        this.add((Component)this.cal, "Center");
        JPanel end = new JPanel();
        end.setLayout(new BorderLayout(1, 2));
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout(1));
        end.add((Component)button, "North");
        this.todayButton = new JButton(VlibProperties.getString("today"));
        this.todayButton.setRequestFocusEnabled(false);
        this.todayButton.setMargin(emptyInsets);
        this.todayButton.setFocusPainted(false);
        this.todayButton.setOpaque(false);
        this.todayButton.addActionListener(this);
        button.add((Component)this.todayButton, "North");
        this.add((Component)end, "South");
        this.updateCalendar();
        this.refresh();
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), 1, f.getSize()));
        this.rootPaneFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent ev) {
                Component opposite = ev.getOppositeComponent();
                if (opposite != null) {
                    DateChooser.this.lastFocused = opposite;
                }
                ev.getComponent().removeFocusListener(this);
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o == this.todayButton) {
            this.selectedDate = Date.Companion.now();
            this.okay = true;
            this.dispose();
        } else {
            if (o == this.prevMonthButton) {
                this.incrementMonth(-1);
            } else if (o == this.nextMonthButton) {
                this.incrementMonth(1);
            } else if (o == this.prevYearButton) {
                this.incrementYear(-1);
            } else if (o == this.nextYearButton) {
                this.incrementYear(1);
            }
            this.updateCalendar();
            this.refresh();
        }
    }

    public int getFirstDay() {
        return this.firstDay;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(Date selectedDate) {
        this.selectedDate = selectedDate;
    }

    void setOkay(boolean okay) {
        this.okay = okay;
    }

    private void incrementDay(int count) {
        this.selectedDate = this.selectedDate.add(count);
    }

    private void incrementMonth(int count) {
        Month m = new Month(this.selectedDate).add(count);
        this.selectedDate = this.selectedDate.getDay() < m.getLastDay().getDay() ? new Date(m.getYear(), m.getMonth(), this.selectedDate.getDay()) : m.getLastDay();
    }

    private void incrementYear(int count) {
        this.incrementMonth(12 * count);
    }

    static int getDaysInMonth(Date d) {
        return new Month(d).getLastDay().getDay();
    }

    private void updateCalendar() {
        this.firstDay = new Date(this.selectedDate.getYear(), this.selectedDate.getMonth(), 1).getWeekday();
        this.yearLabel.setText(String.valueOf(this.selectedDate.getYear()));
        this.monthLabel.setText(MONTH_NAMES[this.selectedDate.getMonth() - 1]);
    }

    void refresh() {
        this.cal.repaint();
    }

    public static Date getDate(Container container, Component field2, Date date) {
        DateChooser chooser = new DateChooser(date);
        return chooser.doModal(container, field2, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date doModal(Container parent, Component field2, Date date) {
        this.popup = new JPopupMenu(){
            private static final long serialVersionUID = 3509735766988472178L;

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                return new Dimension(dim.width, dim.height);
            }
        };
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                DateChooser dateChooser = DateChooser.this;
                synchronized (dateChooser) {
                    DateChooser.this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                DateChooser dateChooser = DateChooser.this;
                synchronized (dateChooser) {
                    DateChooser.this.notify();
                }
            }
        });
        this.popup.insert(this, 0);
        this.addKeyListener(parent);
        this.popup.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension popupSize = this.popup.getPreferredSize();
        Point fieldPositionOnScreen = field2.getLocationOnScreen();
        Point offset = new Point(0, 0);
        if (fieldPositionOnScreen.x < 20) {
            offset.x = 20 - fieldPositionOnScreen.x;
        } else if (fieldPositionOnScreen.x + popupSize.width > screen.width - 20) {
            offset.x = screen.width - 20 - popupSize.width - fieldPositionOnScreen.x;
        }
        offset.y = fieldPositionOnScreen.y < 20 ? 20 - fieldPositionOnScreen.y : (fieldPositionOnScreen.y + popupSize.height > screen.height - 20 ? screen.height - 20 - popupSize.height - fieldPositionOnScreen.y : field2.getSize().height);
        this.show(field2, offset.x, offset.y);
        DateChooser dateChooser = this;
        synchronized (dateChooser) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.okay ? this.selectedDate : date;
    }

    private void show(final Component comp, final int x, final int y) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DateChooser.this.popup.show(comp, x, y);
            }
        });
    }

    private void addKeyListener(Component parent) {
        this.listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                int key = k.getKeyCode();
                if (key == 27) {
                    DateChooser.this.okay = false;
                    DateChooser.this.dispose();
                } else if (key == 32 || key == 10 && !k.isShiftDown()) {
                    DateChooser.this.okay = true;
                    DateChooser.this.dispose();
                } else {
                    if (key == 37 || key == 9 && k.isShiftDown()) {
                        DateChooser.this.incrementDay(-1);
                    } else if (key == 39 || key == 9) {
                        DateChooser.this.incrementDay(1);
                    } else if (key == 38) {
                        DateChooser.this.incrementDay(-7);
                    } else if (key == 40) {
                        DateChooser.this.incrementDay(7);
                    } else if (key == 33) {
                        DateChooser.this.incrementMonth(-1);
                    } else if (key == 34) {
                        DateChooser.this.incrementMonth(1);
                    }
                    DateChooser.this.updateCalendar();
                    DateChooser.this.refresh();
                }
            }
        };
        this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.invokerRootPane = SwingUtilities.getRootPane(parent);
        if (this.invokerRootPane != null) {
            this.invokerRootPane.addFocusListener(this.rootPaneFocusListener);
            this.invokerRootPane.requestFocus(true);
            this.invokerRootPane.addKeyListener(this.listener);
            this.focusTraversalKeysEnabled = this.invokerRootPane.getFocusTraversalKeysEnabled();
            this.invokerRootPane.setFocusTraversalKeysEnabled(false);
        }
    }

    private void removeKeyListener() {
        if (this.lastFocused != null) {
            this.lastFocused.requestFocus();
        }
        if (this.invokerRootPane != null) {
            this.invokerRootPane.removeKeyListener(this.listener);
            this.invokerRootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        this.popup.setVisible(false);
        this.removeKeyListener();
        DateChooser dateChooser = this;
        synchronized (dateChooser) {
            this.notify();
        }
    }
}

