/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.util.PrintJob;
import org.kopi.galite.visual.visual.Action;
import org.kopi.galite.visual.visual.PrinterManager;
import org.kopi.galite.visual.visual.VException;
import org.kopi.vkopi.lib.ui.swing.base.Stateful;
import org.kopi.vkopi.lib.ui.swing.form.DField;
import org.kopi.vkopi.lib.ui.swing.visual.Utils;

public class KeyNavigator
extends AbstractAction {
    protected final int keyCode;
    public static final int KEY_NEXT_FIELD = 0;
    public static final int KEY_PREV_FIELD = 1;
    public static final int KEY_REC_UP = 2;
    public static final int KEY_REC_DOWN = 3;
    public static final int KEY_REC_FIRST = 4;
    public static final int KEY_REC_LAST = 5;
    public static final int KEY_EMPTY_FIELD = 6;
    public static final int KEY_NEXT_BLOCK = 7;
    public static final int KEY_PREV_VAL = 8;
    public static final int KEY_NEXT_VAL = 9;
    public static final int KEY_DIAMETER = 10;
    public static final int KEY_ESCAPE = 11;
    public static final int KEY_PRINTFORM = 12;
    public static final KeyNavigator[] navigators = new KeyNavigator[]{new KeyNavigator(0), new KeyNavigator(1), new KeyNavigator(2), new KeyNavigator(3), new KeyNavigator(4), new KeyNavigator(5), new KeyNavigator(6), new KeyNavigator(7), new KeyNavigator(8), new KeyNavigator(9), new KeyNavigator(10), new KeyNavigator(11), new KeyNavigator(12)};

    protected KeyNavigator(int keyCode) {
        super("navigation-key");
        this.keyCode = keyCode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DField fieldView;
        Stateful sharedText;
        try {
            sharedText = (Stateful)((Object)((JTextComponent)e.getSource()).getDocument());
            fieldView = (DField)Utils.getRoot((JComponent)e.getSource(), DField.class);
        }
        catch (ClassCastException cce) {
            return;
        }
        if (sharedText == null) {
            return;
        }
        VField field2 = (VField)sharedText.getModel();
        if (field2 == null || field2.getForm() == null || field2.getForm().getActiveBlock() == null || field2.getForm().getActiveBlock().getActiveField() != field2 && this.keyCode != 7) {
            return;
        }
        this.processKeyCode(fieldView, field2, (JTextComponent)e.getSource());
    }

    protected final void processKeyCode(final DField fieldView, final VField field2, final JTextComponent sharedText) {
        Action action2;
        switch (this.keyCode) {
            case 0: {
                action2 = new Action("keyKEY_TAB"){

                    @Override
                    public void execute() {
                        field2.getBlock().getForm().getActiveBlock().gotoNextField();
                    }
                };
                break;
            }
            case 1: {
                action2 = new Action("keyKEY_STAB"){

                    @Override
                    public void execute() {
                        field2.getBlock().getForm().getActiveBlock().gotoPrevField();
                    }
                };
                break;
            }
            case 7: {
                action2 = new Action("keyKEY_BLOCK"){

                    @Override
                    public void execute() {
                        field2.getBlock().getForm().gotoNextBlock();
                    }
                };
                break;
            }
            case 2: {
                action2 = new Action("keyKEY_REC_UP"){

                    @Override
                    public void execute() {
                        fieldView.getBlockView().getModel().gotoPrevRecord();
                    }
                };
                break;
            }
            case 3: {
                action2 = new Action("keyKEY_REC_DOWN"){

                    @Override
                    public void execute() {
                        fieldView.getBlockView().getModel().gotoNextRecord();
                    }
                };
                break;
            }
            case 4: {
                action2 = new Action("keyKEY_REC_FIRST"){

                    @Override
                    public void execute() {
                        field2.getBlock().getForm().getActiveBlock().gotoFirstRecord();
                    }
                };
                break;
            }
            case 5: {
                action2 = new Action("keyKEY_REC_LAST"){

                    @Override
                    public void execute() {
                        field2.getBlock().getForm().getActiveBlock().gotoLastRecord();
                    }
                };
                break;
            }
            case 6: {
                action2 = new Action("keyKEY_ALTENTER"){

                    @Override
                    public void execute() {
                        field2.getBlock().getForm().getActiveBlock().gotoNextEmptyMustfill();
                    }
                };
                break;
            }
            case 10: {
                Action action3 = new Action("keyKEY_DIAMETER"){

                    @Override
                    public void execute() {
                        JTextComponent text = sharedText;
                        text.replaceSelection("\u00d8");
                        text.select(text.getSelectionStart() + 1, text.getSelectionStart() + 1);
                    }
                };
                fieldView.getBlockView().getFormView().performBasicAction(action3);
                return;
            }
            case 11: {
                fieldView.getBlockView().getFormView().closeWindow();
                action2 = null;
                break;
            }
            case 12: {
                action2 = new Action("keyKEY_ALTENTER"){

                    @Override
                    public void execute() {
                        PrintJob job = null;
                        try {
                            job = fieldView.getBlockView().getFormView().printForm();
                        }
                        catch (VException e) {
                            e.printStackTrace();
                        }
                        PrinterManager.Companion.getPrinterManager().getCurrentPrinter().print(job);
                    }
                };
                break;
            }
            default: {
                action2 = this.processSpecificKeyCode(fieldView, field2);
            }
        }
        if (action2 != null) {
            fieldView.getBlockView().getFormView().performAsyncAction(action2);
        }
    }

    protected Action processSpecificKeyCode(final DField fieldView, VField field2) {
        Action action2;
        switch (this.keyCode) {
            case 8: {
                action2 = new Action("keyKEY_LIST_UP"){

                    @Override
                    public void execute() {
                        fieldView.getRowController().previousEntry();
                    }
                };
                break;
            }
            case 9: {
                action2 = new Action("keyKEY_LIST_DOWN"){

                    @Override
                    public void execute() {
                        fieldView.getRowController().nextEntry();
                    }
                };
                break;
            }
            default: {
                action2 = null;
            }
        }
        return action2;
    }

    public static KeyNavigator getKeyNavigator(int code) {
        return navigators[code];
    }
}

