/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.type;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.type.Type;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 )2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u0011\b\u0016\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004J\u0011\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\u001a\u0010 \u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\b\b\u0002\u0010!\u001a\u00020\"H\u0007J\u0006\u0010#\u001a\u00020\nJ\b\u0010$\u001a\u00020\u0004H\u0016J\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\rH\u0016J\u0010\u0010(\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0012\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0015\"\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006*"}, d2={"Lorg/kopi/galite/visual/type/Time;", "Lorg/kopi/galite/visual/type/Type;", "Ljava/time/LocalTime;", "hours", "", "minutes", "seconds", "(III)V", "time", "(Ljava/time/LocalTime;)V", "Ljava/sql/Time;", "(Ljava/sql/Time;)V", "string", "", "(Ljava/lang/String;)V", "calendar", "Ljava/util/Calendar;", "(Ljava/util/Calendar;)V", "scalar", "(I)V", "getHours", "()I", "getMinutes", "getScalar$galite_core", "setScalar$galite_core", "getSeconds", "add", "compareTo", "other", "equals", "", "", "format", "locale", "Ljava/util/Locale;", "getSqlTime", "hashCode", "toCalendar", "Ljava/util/GregorianCalendar;", "toSql", "toString", "Companion", "galite-core"})
public class Time
extends Type<Time, LocalTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int scalar;
    @NotNull
    private static final GregorianCalendar calendar = new GregorianCalendar();
    @NotNull
    private static final Time DEFAULT = new Time(0, 0, 0);

    public final int getScalar$galite_core() {
        return this.scalar;
    }

    public final void setScalar$galite_core(int n) {
        this.scalar = n;
    }

    public Time(int hours, int minutes, int seconds) {
        this.scalar = (hours * 3600 + minutes * 60 + seconds) % 86400;
    }

    public /* synthetic */ Time(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3);
    }

    public Time(@NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(time.getHour(), time.getMinute(), time.getSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time(@NotNull java.sql.Time time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        GregorianCalendar gregorianCalendar = calendar;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (gregorianCalendar) {
            boolean bl3 = false;
            calendar.setTime(time);
            hours = calendar.get(11);
            minutes = calendar.get(12);
            seconds = calendar.get(13);
            Unit unit = Unit.INSTANCE;
        }
        this.scalar = (hours * 3600 + minutes * 60 + seconds) % 86400;
    }

    public Time(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        java.sql.Time time = java.sql.Time.valueOf(string);
        Intrinsics.checkNotNullExpressionValue((Object)time, (String)"valueOf(string)");
        this(time);
    }

    public Time(@Nullable Calendar calendar) {
        if (calendar != null) {
            int hours = calendar.get(11);
            int minutes = calendar.get(12);
            int seconds = calendar.get(13);
            this.scalar = (hours * 3600 + minutes * 60 + seconds) % 86400;
        }
    }

    @JvmOverloads
    @NotNull
    public final String format(@NotNull String format2, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, this.getHours());
        cal.set(12, this.getMinutes());
        cal.set(13, this.getSeconds());
        String string = new SimpleDateFormat(format2).format(cal.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(format).format(cal.time)");
        return string;
    }

    public static /* synthetic */ String format$default(Time time, String string, Locale locale, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: format");
        }
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return time.format(string, locale);
    }

    @NotNull
    public final GregorianCalendar toCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.set(11, this.getHours());
        calendar.set(12, this.getMinutes());
        calendar.set(13, this.getSeconds());
        return calendar;
    }

    public Time(int scalar) {
        this.scalar = scalar % 86400;
    }

    @NotNull
    public final Time add(int seconds) {
        return new Time(this.scalar + seconds);
    }

    @Override
    public int compareTo(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int v1 = this.scalar;
        int v2 = other.scalar;
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    public final int getHours() {
        return this.scalar / 3600;
    }

    public final int getMinutes() {
        return this.scalar / 60 % 60;
    }

    public final int getSeconds() {
        return this.scalar % 60;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final java.sql.Time getSqlTime() {
        GregorianCalendar gregorianCalendar = calendar;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (gregorianCalendar) {
            boolean bl3 = false;
            calendar.set(11, this.getScalar$galite_core() / 3600);
            calendar.set(12, this.getScalar$galite_core() / 60 % 60);
            calendar.set(13, this.getScalar$galite_core() % 60);
            java.sql.Time time = new java.sql.Time(calendar.getTime().getTime());
            return time;
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof Time && ((Time)other).scalar == this.scalar;
    }

    @Override
    @NotNull
    public String toString(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        int hours = this.scalar / 3600;
        int minutes = this.scalar / 60 % 60;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d2 = stringBuilder;
        boolean bl5 = false;
        $this$toString_u24lambda_u2d2.append(hours / 10);
        $this$toString_u24lambda_u2d2.append(hours % 10);
        $this$toString_u24lambda_u2d2.append(':');
        $this$toString_u24lambda_u2d2.append(minutes / 10);
        $this$toString_u24lambda_u2d2.append(minutes % 10);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String toSql() {
        int hours = this.scalar / 3600;
        int minutes = this.scalar / 60 % 60;
        int seconds = this.scalar % 60;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toSql_u24lambda_u2d3 = stringBuilder;
        boolean bl5 = false;
        $this$toSql_u24lambda_u2d3.append(hours / 10);
        $this$toSql_u24lambda_u2d3.append(hours % 10);
        $this$toSql_u24lambda_u2d3.append(':');
        $this$toSql_u24lambda_u2d3.append(minutes / 10);
        $this$toSql_u24lambda_u2d3.append(minutes % 10);
        $this$toSql_u24lambda_u2d3.append(':');
        $this$toSql_u24lambda_u2d3.append(seconds / 10);
        $this$toSql_u24lambda_u2d3.append(seconds % 10);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public int hashCode() {
        return this.scalar;
    }

    @JvmOverloads
    @NotNull
    public final String format(@NotNull String format2) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        return Time.format$default(this, format2, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kopi/galite/visual/type/Time$Companion;", "", "()V", "DEFAULT", "Lorg/kopi/galite/visual/type/Time;", "getDEFAULT", "()Lorg/kopi/galite/visual/type/Time;", "calendar", "Ljava/util/GregorianCalendar;", "now", "parse", "input", "", "format", "locale", "Ljava/util/Locale;", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Time now() {
            Calendar now = Calendar.getInstance();
            return new Time(now.get(11), now.get(12), now.get(13));
        }

        @NotNull
        public final Time parse(@NotNull String input, @NotNull String format2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            return this.parse(input, format2, locale);
        }

        @NotNull
        public final Time parse(@NotNull String input, @NotNull String format2, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            GregorianCalendar cal = new GregorianCalendar();
            try {
                cal.setTime(new SimpleDateFormat(format2, locale).parse(input));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException();
            }
            return new Time(cal.get(11), cal.get(12), cal.get(13));
        }

        @NotNull
        public final Time getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

