/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.calendar;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.fullcalendar.VFullCalendarBlock;
import org.kopi.galite.visual.fullcalendar.VFullCalendarEntry;
import org.kopi.galite.visual.type.Date;
import org.kopi.galite.visual.type.Timestamp;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.base.Utils;
import org.kopi.galite.visual.visual.Action;
import org.vaadin.stefan.fullcalendar.CalendarView;
import org.vaadin.stefan.fullcalendar.CalendarViewImpl;
import org.vaadin.stefan.fullcalendar.Entry;
import org.vaadin.stefan.fullcalendar.EntryClickedEvent;
import org.vaadin.stefan.fullcalendar.EntryDroppedEvent;
import org.vaadin.stefan.fullcalendar.EntryResizedEvent;
import org.vaadin.stefan.fullcalendar.FullCalendar;
import org.vaadin.stefan.fullcalendar.FullCalendarBuilder;
import org.vaadin.stefan.fullcalendar.TimeslotsSelectedEvent;

@CssImport(value="./styles/galite/fullcalendar.css")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001*B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020 J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0014J\u0006\u0010&\u001a\u00020\u001cJ\b\u0010'\u001a\u00020\u001cH\u0002J\b\u0010(\u001a\u00020\u001cH\u0002J\b\u0010)\u001a\u00020\u001cH\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/calendar/DAbstractFullCalendar;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "model", "Lorg/kopi/galite/visual/fullcalendar/VFullCalendarBlock;", "type", "Lorg/vaadin/stefan/fullcalendar/CalendarViewImpl;", "(Lorg/kopi/galite/visual/fullcalendar/VFullCalendarBlock;Lorg/vaadin/stefan/fullcalendar/CalendarViewImpl;)V", "calendar", "Lorg/vaadin/stefan/fullcalendar/FullCalendar;", "getCalendar", "()Lorg/vaadin/stefan/fullcalendar/FullCalendar;", "currentUI", "Lcom/vaadin/flow/component/UI;", "getCurrentUI", "()Lcom/vaadin/flow/component/UI;", "setCurrentUI", "(Lcom/vaadin/flow/component/UI;)V", "datePicker", "Lcom/vaadin/flow/component/datepicker/DatePicker;", "getDatePicker", "()Lcom/vaadin/flow/component/datepicker/DatePicker;", "header", "Lcom/vaadin/flow/component/orderedlayout/HorizontalLayout;", "getHeader", "()Lcom/vaadin/flow/component/orderedlayout/HorizontalLayout;", "getModel", "()Lorg/kopi/galite/visual/fullcalendar/VFullCalendarBlock;", "addAllEntries", "", "addEntryListeners", "enter", "getSelectedDate", "Lorg/kopi/galite/visual/type/Date;", "goToDate", "date", "onAttach", "attachEvent", "Lcom/vaadin/flow/component/AttachEvent;", "refreshEntries", "removeAllEntries", "setDatePickerListeners", "setHeader", "FullCalendarEntry", "galite-core"})
public class DAbstractFullCalendar
extends VerticalLayout {
    @NotNull
    private final VFullCalendarBlock model;
    @NotNull
    private final CalendarViewImpl type;
    @NotNull
    private final FullCalendar calendar;
    @NotNull
    private final DatePicker datePicker;
    @NotNull
    private final HorizontalLayout header;
    @Nullable
    private UI currentUI;

    protected DAbstractFullCalendar(@NotNull VFullCalendarBlock model2, @NotNull CalendarViewImpl type2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.model = model2;
        this.type = type2;
        Component[] componentArray = FullCalendarBuilder.create().build();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"create().build()");
        this.calendar = componentArray;
        this.datePicker = new DatePicker(LocalDate.now());
        this.header = new HorizontalLayout();
        this.setWidth("150vh");
        this.setHeight("70vh");
        this.calendar.setSizeFull();
        this.calendar.changeView((CalendarView)this.type);
        this.addAllEntries();
        this.setHeader();
        componentArray = new Component[]{(Component)this.calendar};
        this.add(componentArray);
        this.setDatePickerListeners();
        this.addEntryListeners();
    }

    @NotNull
    protected final VFullCalendarBlock getModel() {
        return this.model;
    }

    @NotNull
    protected final FullCalendar getCalendar() {
        return this.calendar;
    }

    @NotNull
    protected final DatePicker getDatePicker() {
        return this.datePicker;
    }

    @NotNull
    protected final HorizontalLayout getHeader() {
        return this.header;
    }

    @Nullable
    protected final UI getCurrentUI() {
        return this.currentUI;
    }

    protected final void setCurrentUI(@Nullable UI uI) {
        this.currentUI = uI;
    }

    public final void refreshEntries() {
        this.removeAllEntries();
        this.addAllEntries();
    }

    @NotNull
    public final Date getSelectedDate() {
        Object object = this.datePicker.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"datePicker.value");
        return new Date((LocalDate)object);
    }

    public final void goToDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        BackgroundThreadHandler.INSTANCE.access(this.currentUI, (Function0<Unit>)((Function0)new Function0<Unit>(this, date){
            final /* synthetic */ DAbstractFullCalendar this$0;
            final /* synthetic */ Date $date;
            {
                this.this$0 = $receiver;
                this.$date = $date;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCalendar().gotoDate(LocalDate.of(this.$date.getYear(), this.$date.getMonth(), this.$date.getDay()));
            }
        }));
    }

    public final void enter() {
        BackgroundThreadHandler.INSTANCE.access(this.currentUI, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getDatePicker().focus();
            }
        }));
    }

    private final void addAllEntries() {
        this.model.getForm().performAsyncAction(new Action(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
                super("Fetch entries");
            }

            /*
             * WARNING - void declaration
             */
            public void execute() {
                List list;
                List<VFullCalendarEntry> queryList;
                VFullCalendarBlock vFullCalendarBlock = this.this$0.getModel();
                Object object = this.this$0.getDatePicker().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"datePicker.value");
                List<VFullCalendarEntry> list2 = queryList = vFullCalendarBlock.fetchEntries(new Date((LocalDate)object));
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = list2;
                    DAbstractFullCalendar dAbstractFullCalendar = this.this$0;
                    boolean $i$f$map = false;
                    void var7_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void e;
                        VFullCalendarEntry vFullCalendarEntry = (VFullCalendarEntry)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Object object2 = e.getValues().get(dAbstractFullCalendar.getModel().getIdField());
                        if (object2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        int record = (Integer)object2;
                        FullCalendarEntry entry = new FullCalendarEntry(record);
                        LocalDateTime start = e.getStart().getSqlTimestamp().toLocalDateTime();
                        LocalDateTime end = e.getEnd().getSqlTimestamp().toLocalDateTime();
                        entry.setTitle(e.getDescription());
                        entry.setStart(start, dAbstractFullCalendar.getCalendar().getTimezone());
                        entry.setEnd(end, dAbstractFullCalendar.getCalendar().getTimezone());
                        entry.setColor(Utils.INSTANCE.toString(e.getColor(record)));
                        FullCalendarEntry fullCalendarEntry = entry;
                        collection.add(fullCalendarEntry);
                    }
                    list = (List)destination$iv$iv;
                }
                List entries = list;
                if (entries != null) {
                    BackgroundThreadHandler.INSTANCE.access(this.this$0.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, entries){
                        final /* synthetic */ DAbstractFullCalendar this$0;
                        final /* synthetic */ List<FullCalendarEntry> $entries;
                        {
                            this.this$0 = $receiver;
                            this.$entries = $entries;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.getCalendar().addEntries((Iterable)this.$entries);
                        }
                    }));
                }
            }
        });
    }

    private final void setHeader() {
        this.header.setId("fullCalendar-header");
        this.datePicker.setId("fullCalendar-date-picker");
        Component[] componentArray = new Component[]{(Component)this.datePicker};
        this.header.add(componentArray);
        componentArray = new Component[]{(Component)this.header};
        super.add(componentArray);
    }

    private final void setDatePickerListeners() {
        this.datePicker.addValueChangeListener(new HasValue.ValueChangeListener(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
            }

            public final void valueChanged(AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate> event) {
                if (event.isFromClient()) {
                    this.this$0.getModel().getForm().performAsyncAction(new Action(this.this$0, event){
                        final /* synthetic */ DAbstractFullCalendar this$0;
                        final /* synthetic */ AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate> $event;
                        {
                            this.this$0 = $receiver;
                            this.$event = $event;
                            super("Selected date changed");
                        }

                        public void execute() {
                            VFullCalendarBlock vFullCalendarBlock = this.this$0.getModel();
                            Object object = this.$event.getOldValue();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.oldValue");
                            Date date = new Date((LocalDate)object);
                            object = this.$event.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.value");
                            vFullCalendarBlock.dateChanged$galite_core(date, new Date((LocalDate)object));
                        }
                    });
                }
            }
        });
    }

    private final void addEntryListeners() {
        this.calendar.addEntryClickedListener(new ComponentEventListener(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
            }

            public final void onComponentEvent(EntryClickedEvent it) {
                this.this$0.getModel().getForm().performAsyncAction(new Action(this.this$0, it){
                    final /* synthetic */ DAbstractFullCalendar this$0;
                    final /* synthetic */ EntryClickedEvent $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super("entry clicked");
                    }

                    public void execute() {
                        Entry entry = this.$it.getEntry();
                        if (entry == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.calendar.DAbstractFullCalendar.FullCalendarEntry");
                        }
                        this.this$0.getModel().openForEdit$galite_core(((FullCalendarEntry)entry).getRecord());
                    }
                });
            }
        });
        this.calendar.addEntryResizedListener(new ComponentEventListener(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
            }

            public final void onComponentEvent(EntryResizedEvent it) {
                this.this$0.getModel().getForm().performAsyncAction(new Action(it, this.this$0){
                    final /* synthetic */ EntryResizedEvent $it;
                    final /* synthetic */ DAbstractFullCalendar this$0;
                    {
                        this.$it = $it;
                        this.this$0 = $receiver;
                        super("entry time edited");
                    }

                    public void execute() {
                        Entry newEntry = this.$it.applyChangesOnEntry();
                        LocalDateTime localDateTime = newEntry.getStart();
                        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"newEntry.start");
                        Timestamp newStart = Timestamp.Companion.from(localDateTime);
                        LocalDateTime localDateTime2 = newEntry.getEnd();
                        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"newEntry.end");
                        Timestamp newEnd = Timestamp.Companion.from(localDateTime2);
                        localDateTime2 = this.$it.getEntry();
                        if (localDateTime2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.calendar.DAbstractFullCalendar.FullCalendarEntry");
                        }
                        this.this$0.getModel().openForEdit$galite_core(((FullCalendarEntry)((Object)localDateTime2)).getRecord(), newStart, newEnd);
                    }
                });
            }
        });
        this.calendar.addEntryDroppedListener(new ComponentEventListener(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
            }

            public final void onComponentEvent(EntryDroppedEvent it) {
                this.this$0.getModel().getForm().performAsyncAction(new Action(it, this.this$0){
                    final /* synthetic */ EntryDroppedEvent $it;
                    final /* synthetic */ DAbstractFullCalendar this$0;
                    {
                        this.$it = $it;
                        this.this$0 = $receiver;
                        super("entry time edited");
                    }

                    public void execute() {
                        Entry newEntry = this.$it.applyChangesOnEntry();
                        LocalDateTime localDateTime = newEntry.getStart();
                        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"newEntry.start");
                        Timestamp newStart = Timestamp.Companion.from(localDateTime);
                        LocalDateTime localDateTime2 = newEntry.getEnd();
                        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"newEntry.end");
                        Timestamp newEnd = Timestamp.Companion.from(localDateTime2);
                        localDateTime2 = this.$it.getEntry();
                        if (localDateTime2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.calendar.DAbstractFullCalendar.FullCalendarEntry");
                        }
                        this.this$0.getModel().openForEdit$galite_core(((FullCalendarEntry)((Object)localDateTime2)).getRecord(), newStart, newEnd);
                    }
                });
            }
        });
        this.calendar.addTimeslotsSelectedListener(new ComponentEventListener(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
            }

            public final void onComponentEvent(TimeslotsSelectedEvent it) {
                this.this$0.getModel().getForm().performAsyncAction(new Action(this.this$0, it){
                    final /* synthetic */ DAbstractFullCalendar this$0;
                    final /* synthetic */ TimeslotsSelectedEvent $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super("new entry");
                    }

                    public void execute() {
                        VFullCalendarBlock vFullCalendarBlock = this.this$0.getModel();
                        LocalDateTime localDateTime = this.$it.getStartDateTime();
                        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"it.startDateTime");
                        Timestamp timestamp = Timestamp.Companion.from(localDateTime);
                        localDateTime = this.$it.getEndDateTime();
                        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"it.endDateTime");
                        vFullCalendarBlock.openForEdit(timestamp, Timestamp.Companion.from(localDateTime));
                    }
                });
            }
        });
    }

    private final void removeAllEntries() {
        BackgroundThreadHandler.INSTANCE.access(this.currentUI, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DAbstractFullCalendar this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCalendar().removeAllEntries();
            }
        }));
    }

    protected void onAttach(@NotNull AttachEvent attachEvent) {
        Intrinsics.checkNotNullParameter((Object)attachEvent, (String)"attachEvent");
        this.currentUI = attachEvent.getUI();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/calendar/DAbstractFullCalendar$FullCalendarEntry;", "Lorg/vaadin/stefan/fullcalendar/Entry;", "record", "", "(I)V", "getRecord", "()I", "galite-core"})
    public static final class FullCalendarEntry
    extends Entry {
        private final int record;

        public FullCalendarEntry(int record) {
            this.record = record;
        }

        public final int getRecord() {
            return this.record;
        }
    }
}

