/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.event.PositionPanelListener;
import org.kopi.galite.visual.ui.vaadin.label.Label;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rJ\b\u0010\u0018\u001a\u00020\u0016H\u0004J\b\u0010\u0019\u001a\u00020\u0016H\u0004J\b\u0010\u001a\u001a\u00020\u0016H\u0004J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0004H\u0004J\b\u0010\u001d\u001a\u00020\u0016H\u0004J\u0006\u0010\u001e\u001a\u00020\u0016J\u0014\u0010\u001f\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rJ\u0018\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0004J\u0006\u0010'\u001a\u00020\u0016J\u000e\u0010(\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010)\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010*\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0006J\u0006\u0010+\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/PositionPanel;", "Lcom/vaadin/flow/component/orderedlayout/HorizontalLayout;", "()V", "current", "", "first", "Lcom/vaadin/flow/component/button/Button;", "info", "Lcom/vaadin/flow/component/textfield/TextField;", "last", "left", "listeners", "", "Lorg/kopi/galite/visual/ui/vaadin/event/PositionPanelListener;", "popup", "Lcom/vaadin/flow/component/dialog/Dialog;", "right", "slash", "Lorg/kopi/galite/visual/ui/vaadin/label/Label;", "total", "totalInfo", "addPositionPanelListener", "", "l", "fireGotoFirstPosition", "fireGotoLastPosition", "fireGotoNextPosition", "fireGotoPosition", "posno", "fireGotoPrevPosition", "hide", "onClick", "event", "Lcom/vaadin/flow/component/ClickEvent;", "removePositionPanelListener", "setButtonIcon", "button", "icon", "Lcom/vaadin/flow/component/icon/VaadinIcon;", "setButtonsStyleName", "setCurrent", "setPosition", "setStyleName", "show", "galite-core"})
public final class PositionPanel
extends HorizontalLayout {
    @NotNull
    private final Dialog popup = new Dialog();
    @Nullable
    private List<PositionPanelListener> listeners;
    @NotNull
    private final Button first;
    @NotNull
    private final Button last;
    @NotNull
    private final Button left;
    @NotNull
    private final Button right;
    @NotNull
    private final TextField info;
    @NotNull
    private final Label totalInfo;
    @NotNull
    private final Label slash;
    private int current;
    private int total;

    public PositionPanel() {
        this.setSpacing(true);
        this.listeners = new ArrayList();
        this.first = new Button();
        this.last = new Button();
        this.left = new Button();
        this.right = new Button();
        this.info = new TextField();
        this.totalInfo = new Label();
        this.slash = new Label();
        this.totalInfo.setClassName("records-totalInfo");
        this.info.setClassName("records-info");
        this.slash.setClassName("slash");
        Component[] componentArray = new Component[]{(Component)this.first};
        this.add(componentArray);
        componentArray = new Component[]{(Component)this.left};
        this.add(componentArray);
        componentArray = new Component[]{(Component)this.info};
        this.add(componentArray);
        componentArray = new Component[]{(Component)this.slash};
        this.add(componentArray);
        componentArray = new Component[]{(Component)this.totalInfo};
        this.add(componentArray);
        componentArray = new Component[]{(Component)this.right};
        this.add(componentArray);
        componentArray = new Component[]{(Component)this.last};
        this.add(componentArray);
    }

    public final void setPosition(int current, int total) {
        this.current = current;
        this.total = total;
        this.setCurrent(current);
        this.totalInfo.setText(Intrinsics.stringPlus((String)"", (Object)total));
        this.slash.setText("/");
        this.setButtonIcon(this.left, VaadinIcon.ANGLE_LEFT);
        this.setButtonIcon(this.first, VaadinIcon.ANGLE_DOUBLE_LEFT);
        this.setButtonIcon(this.right, VaadinIcon.ANGLE_RIGHT);
        this.setButtonIcon(this.last, VaadinIcon.ANGLE_DOUBLE_RIGHT);
        this.left.setEnabled(current > 1);
        this.first.setEnabled(current > 1);
        this.right.setEnabled(current < total);
        this.last.setEnabled(current < total);
    }

    public final void setStyleName(@NotNull Button button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        if (!button.isEnabled()) {
            button.getClassNames().remove((Object)"v-enabled-button");
            button.getClassNames().add((Object)"v-disabled-button");
        } else {
            button.getClassNames().remove((Object)"v-disabled-button");
            button.getClassNames().add((Object)"v-enabled-button");
        }
    }

    public final void setButtonsStyleName() {
        this.setStyleName(this.first);
        this.setStyleName(this.last);
        this.setStyleName(this.left);
        this.setStyleName(this.right);
    }

    public final void setCurrent(int current) {
        this.current = current;
        this.info.setValue(String.valueOf(current));
    }

    protected final void setButtonIcon(@NotNull Button button, @NotNull VaadinIcon icon) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        button.setIcon((Component)new Icon(icon));
        button.setClassName("button");
        this.setButtonsStyleName();
    }

    public final void addPositionPanelListener(@NotNull PositionPanelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        List<PositionPanelListener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        list.add(l);
    }

    public final void removePositionPanelListener(@NotNull PositionPanelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        List<PositionPanelListener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        list.remove(l);
    }

    protected final void fireGotoNextPosition() {
        List<PositionPanelListener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        for (PositionPanelListener l : list) {
            if (l == null) continue;
            l.gotoNextPosition();
        }
    }

    protected final void fireGotoPrevPosition() {
        List<PositionPanelListener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        for (PositionPanelListener l : list) {
            if (l == null) continue;
            l.gotoPrevPosition();
        }
    }

    protected final void fireGotoLastPosition() {
        List<PositionPanelListener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        for (PositionPanelListener l : list) {
            if (l == null) continue;
            l.gotoLastPosition();
        }
    }

    protected final void fireGotoFirstPosition() {
        List<PositionPanelListener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        for (PositionPanelListener l : list) {
            if (l == null) continue;
            l.gotoFirstPosition();
        }
    }

    protected final void fireGotoPosition(int posno) {
        List<PositionPanelListener> list = this.listeners;
        Intrinsics.checkNotNull(list);
        for (PositionPanelListener l : list) {
            if (l == null) continue;
            l.gotoPosition(posno);
        }
    }

    public final void onClick(@NotNull ClickEvent<HorizontalLayout> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (event.getSource() == this.first) {
            this.fireGotoFirstPosition();
            this.setButtonsStyleName();
        } else if (Intrinsics.areEqual((Object)event.getSource(), (Object)this.last)) {
            this.fireGotoLastPosition();
            this.setButtonsStyleName();
        } else if (Intrinsics.areEqual((Object)event.getSource(), (Object)this.left)) {
            this.fireGotoPrevPosition();
            this.setButtonsStyleName();
        } else if (Intrinsics.areEqual((Object)event.getSource(), (Object)this.right)) {
            this.fireGotoNextPosition();
            this.setButtonsStyleName();
        }
    }

    public final void show() {
        this.setButtonsStyleName();
        this.setVisible(true);
        Component[] componentArray = new Component[]{(Component)this};
        this.popup.add(componentArray);
        this.popup.open();
    }

    public final void hide() {
        this.popup.close();
    }
}

