/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.list;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.form.VListDialog;
import org.kopi.galite.visual.list.VListColumn;
import org.kopi.galite.visual.ui.vaadin.list.ListFilter;

@CssImport(value="./styles/galite/list.css")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005J\u0015\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/list/ListTable;", "Lcom/vaadin/flow/component/grid/Grid;", "", "", "model", "Lorg/kopi/galite/visual/form/VListDialog;", "(Lorg/kopi/galite/visual/form/VListDialog;)V", "getModel", "()Lorg/kopi/galite/visual/form/VListDialog;", "selectedItem", "getSelectedItem", "()Ljava/util/List;", "widthStyler", "Lcom/vaadin/flow/component/html/Div;", "getWidthStyler$galite_core", "()Lcom/vaadin/flow/component/html/Div;", "setWidthStyler$galite_core", "(Lcom/vaadin/flow/component/html/Div;)V", "buildColumns", "", "buildRows", "formatObject", "", "o", "col", "", "getColumnWidth", "installFilters", "setTableWidth", "setTableWidth$galite_core", "galite-core"})
public final class ListTable
extends Grid<List<? extends Object>> {
    @NotNull
    private final VListDialog model;
    @NotNull
    private Div widthStyler;

    public ListTable(@NotNull VListDialog model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
        this.widthStyler = new Div();
        this.setColumnReorderingAllowed(true);
        this.buildRows();
        this.buildColumns();
        this.setTableWidth$galite_core(this.model);
        this.installFilters(this.model);
    }

    @NotNull
    public final VListDialog getModel() {
        return this.model;
    }

    @NotNull
    public final Div getWidthStyler$galite_core() {
        return this.widthStyler;
    }

    public final void setWidthStyler$galite_core(@NotNull Div div) {
        Intrinsics.checkNotNullParameter((Object)div, (String)"<set-?>");
        this.widthStyler = div;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRows() {
        List[] items = new List[this.model.getCount()];
        int n = 0;
        int n2 = this.model.getCount();
        if (n < n2) {
            do {
                Collection<void> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int row = n++;
                Object[] objectArray = (Object[])this.model.getData();
                int n3 = row;
                List[] listArray = items;
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Object[] objectArray2 = (Object[])item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void var19_19 = it[this.getModel().getTranslatedIdents()[row]];
                    collection.add(var19_19);
                }
                collection = (List)destination$iv$iv;
                listArray[n3] = collection;
            } while (n < n2);
        }
        this.setItems(Arrays.copyOf(items, items.length));
    }

    private final void buildColumns() {
        int n = 0;
        int n2 = this.model.getColumnCount();
        if (n < n2) {
            do {
                int col = n++;
                this.addColumn(new ValueProvider(this, col){
                    final /* synthetic */ ListTable this$0;
                    final /* synthetic */ int $col;
                    {
                        this.this$0 = $receiver;
                        this.$col = $col;
                    }

                    public final Object apply(List<? extends Object> it) {
                        return ListTable.access$formatObject(this.this$0, it.get(this.$col), this.$col);
                    }
                }).setHeader((Component)new Span(this.model.getColumnName(col))).setKey(String.valueOf(col));
            } while (n < n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void installFilters(@NotNull VListDialog model2) {
        void $this$mapIndexedTo$iv$iv;
        HeaderRow filterRow;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        HeaderRow headerRow = filterRow = this.appendHeaderRow();
        boolean bl = false;
        boolean bl2 = false;
        Object it = headerRow;
        boolean bl3 = false;
        this.getElement().getClassList().add((Object)"list-filter");
        List list = this.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.columns");
        Iterable $this$mapIndexed$iv = list;
        boolean $i$f$mapIndexed = false;
        it = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void column2;
            int n = index$iv$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Grid.Column column3 = (Grid.Column)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            HeaderRow.HeaderCell cell = (HeaderRow.HeaderCell)filterRow.getCell((Grid.Column)column2);
            TextField filterField = new TextField();
            Icon search = new Icon(VaadinIcon.SEARCH);
            filterField.setWidthFull();
            filterField.setSuffixComponent((Component)search);
            filterField.setClassName("filter-text");
            filterField.addValueChangeListener(new HasValue.ValueChangeListener(this){
                final /* synthetic */ ListTable this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void valueChanged(AbstractField.ComponentValueChangeEvent<TextField, String> it) {
                    DataProvider dataProvider = this.this$0.getDataProvider();
                    if (dataProvider == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.data.provider.ListDataProvider<@[FlexibleNullability] kotlin.collections.List<kotlin.Any?>?>");
                    }
                    ((ListDataProvider)dataProvider).refreshAll();
                }
            });
            filterField.setValueChangeMode(ValueChangeMode.EAGER);
            cell.setComponent((Component)filterField);
            TextField textField = filterField;
            collection.add(textField);
        }
        List filterFields2 = (List)destination$iv$iv;
        list = this.getDataProvider();
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.data.provider.ListDataProvider<@[FlexibleNullability] kotlin.collections.List<kotlin.Any?>?>");
        }
        ((ListDataProvider)list).setFilter((SerializablePredicate)new ListFilter(filterFields2, model2, true, false));
        this.getElement().getClassList().add((Object)"filtered");
    }

    private final String formatObject(Object o, int col) {
        VListColumn vListColumn = this.model.getColumns()[col];
        Intrinsics.checkNotNull((Object)vListColumn);
        return String.valueOf(vListColumn.formatObject(o));
    }

    public final void setTableWidth$galite_core(@NotNull VListDialog model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        int width = 0;
        int n = 0;
        int n2 = model2.getColumnCount();
        if (n < n2) {
            do {
                int col = n++;
                int columnWidth = this.getColumnWidth(model2, col) + 36;
                this.getColumnByKey(String.valueOf(col)).setWidth(columnWidth + "px");
                width += columnWidth;
            } while (n < n2);
        }
        this.widthStyler.setWidth((float)width + 20.0f, Unit.PIXELS);
        this.widthStyler.setMinWidth((float)width + 20.0f, Unit.PIXELS);
    }

    private final int getColumnWidth(VListDialog model2, int col) {
        int width = 0;
        width = 0;
        int n = 0;
        int n2 = model2.getCount();
        if (n < n2) {
            do {
                int row = n++;
                VListColumn vListColumn = model2.getColumns()[col];
                Intrinsics.checkNotNull((Object)vListColumn);
                String value = String.valueOf(vListColumn.formatObject(model2.getValueAt(row, col)));
                int n3 = value.length();
                String string = model2.getTitles()[col];
                Intrinsics.checkNotNull((Object)string);
                width = RangesKt.coerceAtLeast((int)width, (int)RangesKt.coerceAtLeast((int)n3, (int)string.length()));
            } while (n < n2);
        }
        return 8 * width;
    }

    @NotNull
    public final List<Object> getSelectedItem() {
        Object object = this.asSingleSelect().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"asSingleSelect().value");
        return (List)object;
    }

    public static final /* synthetic */ String access$formatObject(ListTable $this, Object o, int col) {
        return $this.formatObject(o, col);
    }
}

