/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.menu;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.actor.VActorsNavigationPanel;
import org.kopi.galite.visual.ui.vaadin.menu.VNavigationMenu;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u000eR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/menu/VActorsRootNavigationItem;", "Lcom/vaadin/flow/component/button/Button;", "()V", "menu", "Lorg/kopi/galite/visual/ui/vaadin/menu/VNavigationMenu;", "getMenu", "()Lorg/kopi/galite/visual/ui/vaadin/menu/VNavigationMenu;", "setMenu", "(Lorg/kopi/galite/visual/ui/vaadin/menu/VNavigationMenu;)V", "rootIcon", "Lcom/vaadin/flow/component/icon/Icon;", "getRootIcon", "()Lcom/vaadin/flow/component/icon/Icon;", "getCaption", "", "getIconElement", "Lcom/vaadin/flow/dom/Element;", "onClick", "", "setActorsNavigationPanel", "panel", "Lorg/kopi/galite/visual/ui/vaadin/actor/VActorsNavigationPanel;", "setCaption", "text", "galite-core"})
public final class VActorsRootNavigationItem
extends Button {
    @NotNull
    private VNavigationMenu menu = new VNavigationMenu(this);
    @NotNull
    private final Icon rootIcon = new Icon(VaadinIcon.ALIGN_JUSTIFY);

    public VActorsRootNavigationItem() {
        this.setClassName("actors-rootNavigationItem");
        this.getElement().setAttribute("part", "rootNavigation");
        this.setIcon((Component)this.rootIcon);
        this.menu.setClassName("actors-navigationMenu");
        this.addClickListener(new ComponentEventListener(){

            public final void onComponentEvent(ClickEvent<Button> it) {
                this.onClick();
            }
        });
        this.menu.addDialogCloseActionListener(new ComponentEventListener(){

            public final void onComponentEvent(Dialog.DialogCloseActionEvent it) {
                this.getMenu().close();
                this.getElement().removeAttribute("part");
                this.getElement().setAttribute("part", "rootNavigation");
            }
        });
    }

    @NotNull
    public final VNavigationMenu getMenu() {
        return this.menu;
    }

    public final void setMenu(@NotNull VNavigationMenu vNavigationMenu) {
        Intrinsics.checkNotNullParameter((Object)((Object)vNavigationMenu), (String)"<set-?>");
        this.menu = vNavigationMenu;
    }

    @NotNull
    public final Icon getRootIcon() {
        return this.rootIcon;
    }

    public final void onClick() {
        if (this.menu.isOpened()) {
            this.menu.close();
        } else {
            this.menu.open();
            this.getElement().setAttribute("part", "rootNavigation-open");
        }
    }

    public final void setCaption(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.setText(text);
    }

    @Nullable
    public final String getCaption() {
        return this.getElement().getText();
    }

    public final void setActorsNavigationPanel(@NotNull VActorsNavigationPanel panel) {
        Intrinsics.checkNotNullParameter((Object)((Object)panel), (String)"panel");
        this.menu.setNavigationPanel(panel);
    }

    @Nullable
    public final Element getIconElement() {
        return this.getIcon().getElement();
    }
}

