/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util.ipp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.util.ipp.IPPConstants;
import org.kopi.galite.visual.util.ipp.IPPInputStream;
import org.kopi.galite.visual.util.ipp.IPPOutputStream;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0010J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/kopi/galite/visual/util/ipp/IPPHeader;", "", "inputStream", "Lorg/kopi/galite/visual/util/ipp/IPPInputStream;", "(Lorg/kopi/galite/visual/util/ipp/IPPInputStream;)V", "()V", "majorVersion", "", "minorVersion", "operationID", "", "getOperationID", "()S", "setOperationID", "(S)V", "requestID", "", "getRequestID", "()I", "setRequestID", "(I)V", "dump", "", "getSize", "getStatus", "", "isAnError", "", "setVersion", "major", "minor", "write", "os", "Lorg/kopi/galite/visual/util/ipp/IPPOutputStream;", "galite-core"})
public final class IPPHeader {
    private byte majorVersion;
    private byte minorVersion;
    private short operationID;
    private int requestID;

    public IPPHeader() {
        this.majorVersion = 1;
        this.minorVersion = 1;
    }

    public final short getOperationID() {
        return this.operationID;
    }

    public final void setOperationID(short s) {
        this.operationID = s;
    }

    public final int getRequestID() {
        return this.requestID;
    }

    public final void setRequestID(int n) {
        this.requestID = n;
    }

    public IPPHeader(@NotNull IPPInputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this();
        this.majorVersion = inputStream.readByte();
        this.minorVersion = inputStream.readByte();
        this.operationID = inputStream.readShort();
        this.requestID = inputStream.readInteger();
    }

    public final void setVersion(byte major, byte minor) {
        this.majorVersion = major;
        this.minorVersion = minor;
    }

    public final void write(@NotNull IPPOutputStream os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        os.writeByte(this.majorVersion);
        os.writeByte(this.minorVersion);
        os.writeShort(this.operationID);
        os.writeInteger(this.requestID);
    }

    public final int getSize() {
        return 8;
    }

    public final void dump() {
        String string = Intrinsics.stringPlus((String)"Major version : ", (Object)this.majorVersion);
        boolean bl = false;
        System.out.println((Object)string);
        string = Intrinsics.stringPlus((String)"Minor version : ", (Object)this.minorVersion);
        bl = false;
        System.out.println((Object)string);
        string = Intrinsics.stringPlus((String)"Operation ID : ", (Object)this.operationID);
        bl = false;
        System.out.println((Object)string);
        string = Intrinsics.stringPlus((String)"Request ID : ", (Object)this.requestID);
        bl = false;
        System.out.println((Object)string);
    }

    public final boolean isAnError() {
        return this.operationID >= 1024;
    }

    @Nullable
    public final String getStatus() {
        int units = 0;
        if (this.operationID < 1024) {
            units = this.operationID;
            if (units < IPPConstants.INSTANCE.getERR_SUCCESSFUL().length) {
                return IPPConstants.INSTANCE.getERR_SUCCESSFUL()[units];
            }
        } else if (this.operationID < 1280) {
            units = this.operationID - 1024;
            if (units < IPPConstants.INSTANCE.getERR_CLIENT_ERROR().length) {
                return IPPConstants.INSTANCE.getERR_CLIENT_ERROR()[units];
            }
        } else {
            units = this.operationID - 1024;
            if (units < IPPConstants.INSTANCE.getERR_SERVER_ERROR().length) {
                return IPPConstants.INSTANCE.getERR_SERVER_ERROR()[units];
            }
        }
        return null;
    }
}

