/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.kopi.galite.visual.util.base.Utils;
import org.kopi.galite.visual.visual.Action;
import org.kopi.galite.visual.visual.Item;
import org.kopi.galite.visual.visual.MessageCode;
import org.kopi.galite.visual.visual.UItemTree;
import org.kopi.galite.visual.visual.VException;
import org.kopi.galite.visual.visual.VExecFailedException;
import org.kopi.galite.visual.visual.VItemTree;
import org.kopi.galite.visual.visual.VlibProperties;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;
import org.kopi.vkopi.lib.ui.swing.visual.ItemRenderer;

public class DItemTree
extends DWindow
implements UItemTree {
    private Tree tree;
    private static final long serialVersionUID = 8814499549529628999L;

    public DItemTree(VItemTree model2) {
        super(model2);
        this.tree = new Tree(model2.getRoot());
        this.tree.addMouseListener(new MouseAdapter(){
            private long lastClick;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && DItemTree.this.getModel().isNoEdit()) {
                    DItemTree.this.changeSelectionState();
                } else if (e.getWhen() - this.lastClick < 400L) {
                    DItemTree.this.changeSelectionState();
                }
                this.lastClick = e.getWhen();
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 || e.getKeyCode() == 10 && DItemTree.this.getSelectedNode().isLeaf()) {
                    e.consume();
                    DItemTree.this.changeSelectionState();
                }
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DItemTree.this.setTree();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                DItemTree.this.setTree();
            }
        });
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DItemTree.this.setTree();
            }
        });
        this.tree.setCellRenderer(new ItemRenderer(this.getModel().isNoEdit(), this.getModel().isSingleSelection(), this.getModel().isLocalised()));
        this.tree.putClientProperty("JTree.lineStyle", "None");
        this.tree.setRowHeight(-1);
        this.tree.setBackground(UIManager.getColor("menu.background"));
        JScrollPane sp = new JScrollPane();
        sp.setBorder(null);
        sp.getViewport().add(this.tree);
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)sp, "Center");
        if (this.tree.getRowCount() > 0) {
            this.tree.setSelectionInterval(0, 0);
        }
        this.setTree();
        this.tree.requestFocusInWindow();
    }

    @Override
    public void setTree() {
        if (this.getModel() != null) {
            DefaultMutableTreeNode node = this.getSelectedNode();
            this.getModel().setActorEnabled(0, true);
            if (node != null) {
                boolean rootItem = ((Item)node.getUserObject()).getId() == -1;
                this.getModel().setActorEnabled(8, this.getModel().isInsertMode());
                this.getModel().setActorEnabled(9, this.getModel().isInsertMode() && !rootItem);
                this.getModel().setActorEnabled(7, this.getModel().isInsertMode() && !rootItem);
                this.getModel().setActorEnabled(6, this.getModel().isLocalised() && this.getModel().isInsertMode() && !rootItem);
                this.getModel().setActorEnabled(1, !this.getModel().isNoEdit() && !rootItem);
                this.getModel().setActorEnabled(2, this.getModel().isMultiSelectionDefaultValue() && !rootItem);
                if (node.isLeaf()) {
                    this.getModel().setActorEnabled(3, false);
                    this.getModel().setActorEnabled(4, false);
                } else if (this.tree.isExpanded(this.tree.getSelectionPath())) {
                    this.getModel().setActorEnabled(3, true);
                    this.getModel().setActorEnabled(4, false);
                } else {
                    this.getModel().setActorEnabled(3, false);
                    this.getModel().setActorEnabled(4, true);
                }
            } else {
                this.getModel().setActorEnabled(3, false);
                this.getModel().setActorEnabled(4, false);
                this.getModel().setActorEnabled(8, false);
                this.getModel().setActorEnabled(9, false);
                this.getModel().setActorEnabled(7, false);
                this.getModel().setActorEnabled(6, false);
                this.getModel().setActorEnabled(1, false);
                this.getModel().setActorEnabled(2, false);
            }
            this.getModel().setActorEnabled(5, this.getModel().isChanged());
        }
    }

    @Override
    public void run() throws VException {
        this.setVisible(true);
    }

    protected DefaultMutableTreeNode getSelectedNode() {
        TreePath selPath = this.tree.getSelectionPath();
        if (selPath != null) {
            return (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    @Override
    public void setSelectedItem() {
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            Item selectedItem = (Item)selectedNode.getUserObject();
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            if (this.getModel().isSingleSelection()) {
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
                if (!selectedItem.isSelected()) {
                    this.unselectAll(treeModel, rootNode);
                }
            }
            selectedItem.setSelected(!selectedItem.isSelected());
            treeModel.nodeChanged(selectedNode);
            this.getModel().refresh();
        }
    }

    @Override
    public void setDefaultItem() {
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
            Item selectedItem = (Item)selectedNode.getUserObject();
            if (!selectedItem.isDefaultItem()) {
                this.setDefault(treeModel, rootNode);
            }
            selectedItem.setDefaultItem(!selectedItem.isDefaultItem());
            selectedItem.setSelected(true);
            treeModel.nodeChanged(selectedNode);
            this.getModel().refresh();
        }
    }

    private void setDefault(DefaultTreeModel treeModel, DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            Item item = (Item)child.getUserObject();
            if (item.isDefaultItem()) {
                item.setDefaultItem(false);
                treeModel.nodeChanged(child);
            }
            if (child.getChildCount() <= 0) continue;
            this.setDefault(treeModel, child);
        }
    }

    private void unselectAll(DefaultTreeModel treeModel, DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            Item item = (Item)child.getUserObject();
            if (item.isSelected()) {
                item.setSelected(false);
                treeModel.nodeChanged(child);
            }
            if (child.getChildCount() <= 0) continue;
            this.unselectAll(treeModel, child);
        }
    }

    private void changeSelectionState() {
        this.getModel().performAsyncAction(new Action("change_selection_state"){

            @Override
            public void execute() {
                if (!DItemTree.this.getModel().isNoEdit()) {
                    DItemTree.this.setSelectedItem();
                }
            }
        });
    }

    @Override
    public void addItem() throws VException {
        this.getModel();
        int maxLength = Math.min(32, this.getModel().getNameLength());
        int selectedRow = this.tree.getSelectionRow();
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            String newItem;
            Item parent = (Item)selectedNode.getUserObject();
            if (this.getModel().getDepth() > 0 && parent.getLevel() + 1 > this.getModel().getDepth()) {
                throw new VExecFailedException(MessageCode.INSTANCE.getMessage("VIS-00069", this.getModel().getDepth()));
            }
            while ((newItem = JOptionPane.showInputDialog(this, MessageCode.INSTANCE.getMessage("VIS-00068", maxLength), VlibProperties.getString("New_item"), -1)) != null && newItem.length() > maxLength) {
            }
            if (newItem != null && newItem.trim().length() != 0) {
                newItem = newItem.trim();
                DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
                Item item = new Item(this.getModel().getNextId(), ((Item)selectedNode.getUserObject()).getId(), newItem, null, null, false, false, null, newItem);
                item.setLevel(parent.getLevel() + 1);
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(item);
                selectedNode.add(newNode);
                if (selectedNode.getChildCount() > 0) {
                    treeModel.reload(selectedNode);
                } else {
                    treeModel.nodeChanged(selectedNode);
                }
                if (selectedRow > 0) {
                    this.tree.expandRow(selectedRow);
                }
            }
        }
    }

    @Override
    public void removeSelectedItem() {
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        if (selectedNode != null) {
            treeModel = (DefaultTreeModel)this.tree.getModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
            if (!this.getModel().isRemoveDescendantsAllowed()) {
                this.attacheToParent(treeModel, selectedNode, (DefaultMutableTreeNode)selectedNode.getParent());
            }
            this.removeItem(treeModel, rootNode, (Item)selectedNode.getUserObject());
        }
    }

    public void attacheToParent(DefaultTreeModel treeModel, DefaultMutableTreeNode node, DefaultMutableTreeNode parent) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            Item childItem = (Item)child.getUserObject();
            childItem.setParent(((Item)parent.getUserObject()).getId());
            parent.add(child);
            if (parent.getChildCount() > 0) {
                treeModel.reload(parent);
            } else {
                treeModel.nodeChanged(parent);
            }
            this.setLevel(treeModel, child);
        }
    }

    public void setLevel(DefaultTreeModel treeModel, DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.getChildCount() <= 0) continue;
            this.setLevel(treeModel, child);
        }
        ((Item)node.getUserObject()).decrementLevel();
    }

    private void removeItem(DefaultTreeModel treeModel, DefaultMutableTreeNode node, Item itemToRemove) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            Item childItem = (Item)child.getUserObject();
            if (childItem.getId() == itemToRemove.getId()) {
                this.getModel().getRemovedItems().add(itemToRemove);
                node.remove(i);
                treeModel.reload(node);
                return;
            }
            if (child.getChildCount() <= 0) continue;
            this.removeItem(treeModel, child, itemToRemove);
        }
    }

    @Override
    public void editSelectedItem() {
        this.getModel();
        int maxLength = Math.min(32, this.getModel().getNameLength());
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            String newName;
            Item selectedItem = (Item)selectedNode.getUserObject();
            while ((newName = (String)JOptionPane.showInputDialog(this, MessageCode.INSTANCE.getMessage("VIS-00068", maxLength), VlibProperties.getString("OpenLine"), -1, null, null, selectedItem.getName())) != null && newName.length() > maxLength) {
            }
            if (newName != null && newName.trim().length() != 0) {
                DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
                selectedItem.setName(newName);
                treeModel.nodeChanged(selectedNode);
            }
        }
    }

    @Override
    public void localiseSelectedItem() {
        this.getModel();
        int maxLength = Math.min(32, this.getModel().getLocalisedNameLength());
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            String localisedName;
            Item selectedItem = (Item)selectedNode.getUserObject();
            while ((localisedName = (String)JOptionPane.showInputDialog(this, MessageCode.INSTANCE.getMessage("VIS-00068", maxLength), VlibProperties.getString("OpenLine"), -1, null, null, selectedItem.getLocalisedName())) != null && localisedName.length() > maxLength) {
            }
            if (localisedName != null && localisedName.trim().length() != 0) {
                DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
                selectedItem.setLocalisedName(localisedName);
                treeModel.nodeChanged(selectedNode);
            }
        }
    }

    @Override
    public UItemTree.UTreeComponent getTree() {
        return this.tree;
    }

    @Override
    public VItemTree getModel() {
        return (VItemTree)super.getModel();
    }

    public class Tree
    extends JTree
    implements UItemTree.UTreeComponent {
        TreeNode root;
        private static final long serialVersionUID = -3954942255139034033L;

        public Tree(TreeNode root) {
            super(root);
            this.root = root;
        }

        @Override
        public boolean isExpanded(Object path) {
            return super.isExpanded((TreePath)path);
        }

        @Override
        public boolean isCollapsed(Object path) {
            return super.isCollapsed((TreePath)path);
        }

        @Override
        public int getSelectionRow() {
            return super.getSelectionRows()[0];
        }

        @Override
        public Item[] getItems() {
            List<Item> itemsList = this.getItems(this.root);
            if (itemsList != null && itemsList.size() > 0) {
                return (Item[])Utils.Companion.toArray(itemsList);
            }
            return null;
        }

        public List<Item> getItems(TreeNode node) {
            ArrayList<Item> items = new ArrayList<Item>();
            Item item = (Item)((DefaultMutableTreeNode)node).getUserObject();
            item.setChildCount(node.getChildCount());
            if (item.getId() >= 0) {
                items.add(item);
            }
            if (node.getChildCount() > 0) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    items.addAll(this.getItems(node.getChildAt(i)));
                }
            }
            return items;
        }

        @Override
        public Item getRootItem() {
            return this.getRootItem(this.root);
        }

        public Item getRootItem(TreeNode node) {
            Item item = (Item)((DefaultMutableTreeNode)node).getUserObject();
            item.setChildCount(node.getChildCount());
            if (node.getChildCount() > 0) {
                Item[] children = new Item[node.getChildCount()];
                for (int i = 0; i < node.getChildCount(); ++i) {
                    children[i] = this.getRootItem(node.getChildAt(i));
                }
                item.setChildren(children);
            }
            return item;
        }

        @Override
        public boolean isUnique(String name) {
            return true;
        }

        @Override
        public void expandTree() {
        }
    }
}

