/*
 * Copyright (c) 2013-2021 kopiLeft Services SARL, Tunis TN
 * Copyright (c) 1990-2021 kopiRight Managed Solutions GmbH, Wien AT
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package org.kopi.galite.visual.l10n

import org.jdom2.Document
import org.jdom2.Element
import org.kopi.galite.visual.util.base.InconsistencyException

/**
 * Implements a report localizer.
 *
 * @param             manager         the manager to use for localization
 * @param             document        the document containing the report localization
 */
class ReportLocalizer(manager: LocalizationManager, document: Document) : Localizer(manager) {

  // ----------------------------------------------------------------------
  // DATA MEMBERS
  // ----------------------------------------------------------------------
  private val root: Element = document.rootElement

  // ----------------------------------------------------------------------
  // CONSTRUCTOR
  // ----------------------------------------------------------------------
  init {
    if (root.name != "report") {
      throw InconsistencyException("bad root element $root")
    }
  }

  /**
   * Returns the value of the title attribute.
   */
  fun getTitle(): String = root.getAttributeValue("title")

  /**
   * Returns the value of the help attribute.
   */
  fun getHelp(): String? = root.getAttributeValue("help")

  /**
   * Constructs a field localizer for the given field.
   *
   * @param             ident           the identifier of the field
   */
  fun getFieldLocalizer(ident: String): FieldLocalizer {
    return FieldLocalizer(manager,
                          Utils.lookupChild(root, "field", "ident", ident))
  }
}
