/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.dsl.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.AutoIncColumnType;
import org.jetbrains.exposed.sql.BooleanColumnType;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.IntegerColumnType;
import org.jetbrains.exposed.sql.LongColumnType;
import org.jetbrains.exposed.sql.StringColumnType;
import org.kopi.galite.visual.domain.ListDomain;
import org.kopi.galite.visual.dsl.common.LocalizationWriter;
import org.kopi.galite.visual.list.VBooleanColumn;
import org.kopi.galite.visual.list.VDateColumn;
import org.kopi.galite.visual.list.VIntegerColumn;
import org.kopi.galite.visual.list.VListColumn;
import org.kopi.galite.visual.list.VStringColumn;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/kopi/galite/visual/dsl/common/ListDescription;", "", "title", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "domain", "Lorg/kopi/galite/visual/domain/ListDomain;", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/Column;Lorg/kopi/galite/visual/domain/ListDomain;)V", "getColumn", "()Lorg/jetbrains/exposed/sql/Column;", "getDomain", "()Lorg/kopi/galite/visual/domain/ListDomain;", "getTitle", "()Ljava/lang/String;", "buildModel", "Lorg/kopi/galite/visual/list/VListColumn;", "genLocalization", "", "writer", "Lorg/kopi/galite/visual/dsl/common/LocalizationWriter;", "galite-core"})
public final class ListDescription {
    @NotNull
    private final String title;
    @NotNull
    private final Column<?> column;
    @NotNull
    private final ListDomain<?> domain;

    public ListDescription(@NotNull String title, @NotNull Column<?> column2, @NotNull ListDomain<?> domain) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        this.title = title;
        this.column = column2;
        this.domain = domain;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Column<?> getColumn() {
        return this.column;
    }

    @NotNull
    public final ListDomain<?> getDomain() {
        return this.domain;
    }

    @NotNull
    public final VListColumn buildModel() {
        VListColumn vListColumn;
        IColumnType type2 = this.column.getColumnType() instanceof AutoIncColumnType ? (IColumnType)((AutoIncColumnType)this.column.getColumnType()).getDelegate() : this.column.getColumnType();
        IColumnType iColumnType = type2;
        if (iColumnType instanceof IntegerColumnType ? true : iColumnType instanceof LongColumnType) {
            ColumnSet columnSet = this.domain.getTable();
            int n = this.domain.getDefaultAlignment();
            Integer n2 = this.domain.getWidth();
            Intrinsics.checkNotNull((Object)n2);
            vListColumn = new VIntegerColumn(this.title, this.column, columnSet, n, n2, true);
        } else if (iColumnType instanceof StringColumnType) {
            ColumnSet columnSet = this.domain.getTable();
            int n = this.domain.getDefaultAlignment();
            Integer n3 = this.domain.getWidth();
            Intrinsics.checkNotNull((Object)n3);
            vListColumn = new VStringColumn(this.title, this.column, columnSet, n, n3, true);
        } else if (iColumnType instanceof BooleanColumnType) {
            vListColumn = new VBooleanColumn(this.title, this.column, this.domain.getTable(), true);
        } else if (iColumnType instanceof IDateColumnType) {
            vListColumn = new VDateColumn(this.title, this.column, this.domain.getTable(), true);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Type ");
            KClass<?> kClass = this.domain.getKClass();
            Intrinsics.checkNotNull(kClass);
            throw new RuntimeException(stringBuilder.append((Object)kClass.getQualifiedName()).append(" is not supported").toString());
        }
        return vListColumn;
    }

    public final void genLocalization(@NotNull LocalizationWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.genListDesc(this.column, this.title);
    }
}

