/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.report;

import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.report.PExport2Excel;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u00060\u0005R\u00020\u0000\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kopi/galite/visual/report/CellStyleCacheManager;", "Ljava/io/Serializable;", "()V", "stylesCache", "", "Lorg/kopi/galite/visual/report/CellStyleCacheManager$StyleKey;", "Lorg/apache/poi/ss/usermodel/CellStyle;", "getStyle", "exporter", "Lorg/kopi/galite/visual/report/PExport2Excel;", "wb", "Lorg/apache/poi/ss/usermodel/Workbook;", "alignment", "", "dataFormat", "color", "Ljava/awt/Color;", "StyleKey", "galite-core"})
public final class CellStyleCacheManager
implements Serializable {
    @NotNull
    private final Map<StyleKey, CellStyle> stylesCache = new HashMap();

    @NotNull
    public final CellStyle getStyle(@NotNull PExport2Excel exporter, @NotNull Workbook wb, short alignment, short dataFormat, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)exporter, (String)"exporter");
        Intrinsics.checkNotNullParameter((Object)wb, (String)"wb");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        StyleKey key = new StyleKey(alignment, dataFormat, color);
        if (!this.stylesCache.containsKey(key)) {
            Object object = wb.createCellStyle();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wb.createCellStyle()");
            CellStyle style = object;
            style.setVerticalAlignment(VerticalAlignment.TOP);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            style.setBorderLeft(BorderStyle.THIN);
            style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            style.setBorderRight(BorderStyle.THIN);
            style.setRightBorderColor(IndexedColors.BLACK.getIndex());
            style.setBorderTop(BorderStyle.THIN);
            style.setTopBorderColor(IndexedColors.BLACK.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setWrapText(true);
            style.setAlignment(HorizontalAlignment.forInt((int)alignment));
            if (dataFormat != -1) {
                style.setDataFormat(dataFormat);
            }
            if (style instanceof XSSFCellStyle) {
                object = exporter.createFillForegroundColor(color);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.apache.poi.xssf.usermodel.XSSFColor");
                }
                ((XSSFCellStyle)style).setFillForegroundColor((XSSFColor)object);
            } else {
                object = exporter.createFillForegroundColor(color);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.apache.poi.hssf.util.HSSFColor");
                }
                style.setFillForegroundColor(((HSSFColor)object).getIndex());
            }
            object = this.stylesCache;
            boolean bl = false;
            object.put(key, style);
        }
        CellStyle cellStyle = this.stylesCache.get(key);
        Intrinsics.checkNotNull((Object)cellStyle);
        return cellStyle;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kopi/galite/visual/report/CellStyleCacheManager$StyleKey;", "", "alignment", "", "dataFormat", "color", "Ljava/awt/Color;", "(Lorg/kopi/galite/visual/report/CellStyleCacheManager;SSLjava/awt/Color;)V", "equals", "", "other", "hashCode", "", "galite-core"})
    public final class StyleKey {
        private final short alignment;
        private final short dataFormat;
        @NotNull
        private final Color color;

        public StyleKey(short alignment, @NotNull short dataFormat, Color color) {
            Intrinsics.checkNotNullParameter((Object)CellStyleCacheManager.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.alignment = alignment;
            this.dataFormat = dataFormat;
            this.color = color;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof StyleKey ? this.alignment == ((StyleKey)other).alignment && this.dataFormat == ((StyleKey)other).dataFormat && Intrinsics.areEqual((Object)this.color, (Object)((StyleKey)other).color) : super.equals(other);
        }

        public int hashCode() {
            return this.alignment + this.dataFormat + this.color.hashCode();
        }
    }
}

