/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import java.text.SimpleDateFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.type.Date;
import org.kopi.galite.visual.type.Time;
import org.kopi.galite.visual.type.Timestamp;
import org.kopi.galite.visual.ui.vaadin.field.AllowAllValidator;
import org.kopi.galite.visual.ui.vaadin.field.DateValidator;
import org.kopi.galite.visual.ui.vaadin.field.InputTextField;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/TimestampValidator;", "Lorg/kopi/galite/visual/ui/vaadin/field/AllowAllValidator;", "maxLength", "", "(I)V", "checkType", "", "field", "Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "text", "", "toTimestamp", "date", "Ljava/util/Date;", "Companion", "galite-core"})
public final class TimestampValidator
extends AllowAllValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TimestampValidator(int maxLength) {
        super(maxLength);
    }

    @Override
    public void checkType(@NotNull InputTextField<?> field, @NotNull String text) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)"", (Object)text)) {
            field.setValue(null);
        } else {
            field.setValue(String.valueOf(Companion.parseTimestamp(text)));
        }
    }

    private final String toTimestamp(java.util.Date date) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toTimestamp_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        int nanos = (int)(date.getTime() % (long)1000 * (long)1000000);
        if (nanos < 0) {
            nanos += 1000000000;
            date.setTime((date.getTime() / (long)1000 - 1L) * (long)1000);
        }
        $this$toTimestamp_u24lambda_u2d0.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
        if (nanos >= 100) {
            $this$toTimestamp_u24lambda_u2d0.append(nanos);
        } else if (nanos >= 10) {
            $this$toTimestamp_u24lambda_u2d0.append(Intrinsics.stringPlus((String)"0", (Object)nanos));
        } else {
            $this$toTimestamp_u24lambda_u2d0.append(Intrinsics.stringPlus((String)"00", (Object)nanos));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/TimestampValidator$Companion;", "", "()V", "parseDate", "Lorg/kopi/galite/visual/type/Date;", "date", "", "parseTime", "Lorg/kopi/galite/visual/type/Time;", "time", "parseTimestamp", "Lorg/kopi/galite/visual/type/Timestamp;", "text", "retryParseDate", "tokens", "", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Timestamp parseTimestamp(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            CharSequence charSequence = text;
            Object object = "[ T]";
            int n = 0;
            object = new Regex((String)object);
            n = 2;
            boolean bl = false;
            List timestamp = object.split(charSequence, n);
            object = this.parseDate((String)timestamp.get(0));
            if (object == null) {
                return null;
            }
            Object date = object;
            Time time = this.parseTime((String)timestamp.get(1));
            if (time == null) {
                return null;
            }
            Time time2 = time;
            return Timestamp.Companion.from((Date)date, time2);
        }

        @Nullable
        public final Date parseDate(@NotNull String date) {
            java.util.Date now;
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            int month = 0;
            int year = -2;
            CharSequence charSequence = date;
            String string = "[#./-]";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            List tokens = string.split(charSequence, n);
            if (tokens.isEmpty()) {
                return null;
            }
            int day = DateValidator.Companion.stringToInt$galite_core((String)tokens.get(0));
            if (tokens.size() >= 2) {
                month = DateValidator.Companion.stringToInt$galite_core((String)tokens.get(1));
            }
            if (tokens.size() >= 3) {
                year = DateValidator.Companion.stringToInt$galite_core((String)tokens.get(2));
            }
            if (tokens.size() > 3 || day == -1 || month == -1 || year == -1) {
                return null;
            }
            if (month == 0) {
                now = new java.util.Date();
                month = now.getMonth() + 1;
                year = now.getYear() + 1900;
            } else if (year == -2) {
                now = new java.util.Date();
                year = now.getYear() + 1900;
            } else if (year < 50) {
                year += 2000;
            } else if (year < 100) {
                year += 1900;
            } else if (year < 1000) {
                return null;
            }
            if (!DateValidator.Companion.isDate$galite_core(day, month, year)) {
                return this.retryParseDate(tokens);
            }
            return new Date(year, month, day);
        }

        private final Date retryParseDate(List<String> tokens) {
            int day = 0;
            int month = 0;
            int year = DateValidator.Companion.stringToInt$galite_core(tokens.get(0));
            if (tokens.size() >= 2) {
                month = DateValidator.Companion.stringToInt$galite_core(tokens.get(1));
            }
            if (tokens.size() >= 3) {
                day = DateValidator.Companion.stringToInt$galite_core(tokens.get(2));
            }
            if (tokens.size() > 3 || day == -1 || month == -1 || year == -1) {
                return null;
            }
            if (month == 0) {
                java.util.Date now = new java.util.Date();
                month = now.getMonth() + 1;
                year = now.getYear() + 1900;
            } else if (year == -2) {
                java.util.Date now = new java.util.Date();
                year = now.getYear() + 1900;
            } else if (year < 50) {
                year += 2000;
            } else if (year < 100) {
                year += 1900;
            } else if (year < 1000) {
                return null;
            }
            if (!DateValidator.Companion.isDate$galite_core(day, month, year)) {
                return null;
            }
            return new Date(year, month, day);
        }

        private final Time parseTime(String time) {
            int hours = -1;
            int minutes = 0;
            int seconds = 0;
            String buffer = Intrinsics.stringPlus((String)time, (Object)"\u0000");
            int bp = 0;
            int state = 1;
            while (state > 0) {
                int n = state;
                switch (n) {
                    case 1: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            hours = buffer.charAt(bp) - 48;
                            state = 2;
                            break;
                        }
                        if (buffer.charAt(bp) == '\u0000') {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 2: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            hours = 10 * hours + (buffer.charAt(bp) - 48);
                            state = 3;
                            break;
                        }
                        if (buffer.charAt(bp) == ':') {
                            state = 4;
                            break;
                        }
                        if (buffer.charAt(bp) == '\u0000') {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 3: {
                        state = buffer.charAt(bp) == ':' ? 4 : (buffer.charAt(bp) == '\u0000' ? 0 : -1);
                        break;
                    }
                    case 4: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            minutes = buffer.charAt(bp) - 48;
                            state = 5;
                            break;
                        }
                        if (buffer.charAt(bp) == '\u0000') {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 5: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            minutes = 10 * minutes + (buffer.charAt(bp) - 48);
                            state = 6;
                            break;
                        }
                        if (buffer.charAt(bp) == ':') {
                            state = 7;
                            break;
                        }
                        if (buffer.charAt(bp) == '\u0000') {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 6: {
                        state = buffer.charAt(bp) == ':' ? 7 : (buffer.charAt(bp) == '\u0000' ? 0 : -1);
                        break;
                    }
                    case 7: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            seconds = buffer.charAt(bp) - 48;
                            state = 8;
                            break;
                        }
                        if (buffer.charAt(bp) == '\u0000') {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 8: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            seconds = 10 * seconds + (buffer.charAt(bp) - 48);
                            state = 9;
                            break;
                        }
                        if (buffer.charAt(bp) == '\u0000') {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 9: {
                        state = buffer.charAt(bp) == '\u0000' ? 0 : -1;
                    }
                }
                ++bp;
            }
            if (state == -1) {
                return null;
            }
            return hours == -1 ? (Time)null : new Time(hours, minutes, seconds);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

