/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.visual;

import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.base.Image;
import org.kopi.galite.visual.db.DBContext;
import org.kopi.galite.visual.dsl.common.Window;
import org.kopi.galite.visual.l10n.LocalizationManager;
import org.kopi.galite.visual.l10n.ModuleLocalizer;
import org.kopi.galite.visual.util.base.InconsistencyException;
import org.kopi.galite.visual.visual.ApplicationConfiguration;
import org.kopi.galite.visual.visual.ApplicationContext;
import org.kopi.galite.visual.visual.Executable;
import org.kopi.galite.visual.visual.ImageHandler;
import org.kopi.galite.visual.visual.MessageCode;
import org.kopi.galite.visual.visual.VException;
import org.kopi.galite.visual.visual.VMenuTree;
import org.kopi.galite.visual.visual.VRuntimeException;
import org.kopi.galite.visual.visual.VWindow;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001)BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0000H\u0096\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u0006H\u0016R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\"\u0010\u000b\u001a\u0004\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\"\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000eR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\u0004\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/kopi/galite/visual/visual/Module;", "", "id", "", "parent", "shortname", "", "source", "objectName", "accessibility", "priority", "icon", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;)V", "getAccessibility", "()I", "setAccessibility", "(I)V", "<set-?>", "description", "getDescription", "()Ljava/lang/String;", "help", "getHelp", "Lorg/kopi/galite/visual/base/Image;", "getIcon", "()Lorg/kopi/galite/visual/base/Image;", "getId", "getObjectName", "getParent", "smallIcon", "getSmallIcon", "compareTo", "other", "localize", "", "manager", "Lorg/kopi/galite/visual/l10n/LocalizationManager;", "run", "context", "Lorg/kopi/galite/visual/db/DBContext;", "toString", "Companion", "galite-core"})
public final class Module
implements Comparable<Module> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final int parent;
    @NotNull
    private final String shortname;
    @NotNull
    private final String source;
    private int accessibility;
    private int priority;
    @Nullable
    private Image icon;
    @Nullable
    private String objectName;
    @NotNull
    private String description;
    @Nullable
    private String help;
    @Nullable
    private Image smallIcon;
    public static final int ACS_PARENT = 0;
    public static final int ACS_TRUE = 1;
    public static final int ACS_FALSE = 2;

    public Module(int id, int parent, @NotNull String shortname, @NotNull String source, @Nullable String objectName, int accessibility, int priority, @Nullable String icon) {
        Intrinsics.checkNotNullParameter((Object)shortname, (String)"shortname");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.id = id;
        this.parent = parent;
        this.shortname = shortname;
        this.source = source;
        this.accessibility = accessibility;
        this.priority = priority;
        this.objectName = objectName;
        this.description = "";
        if (icon != null) {
            this.icon = ImageHandler.Companion.getImageHandler().getImage(icon);
            this.smallIcon = ImageHandler.Companion.getImageHandler().getImage(icon);
            if (this.smallIcon == null) {
                Image image = this.smallIcon;
                Intrinsics.checkNotNull((Object)image);
                this.smallIcon = image.getScaledInstance(16, 16, 4);
            }
        }
    }

    public final int getId() {
        return this.id;
    }

    public final int getParent() {
        return this.parent;
    }

    public final int getAccessibility() {
        return this.accessibility;
    }

    public final void setAccessibility(int n) {
        this.accessibility = n;
    }

    @Nullable
    public final Image getIcon() {
        return this.icon;
    }

    @Nullable
    public final String getObjectName() {
        return this.objectName;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final String getHelp() {
        return this.help;
    }

    @Nullable
    public final Image getSmallIcon() {
        return this.smallIcon;
    }

    public final void run(@NotNull DBContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Companion.startForm(context, this.objectName, this.description, this.smallIcon);
    }

    @NotNull
    public String toString() {
        return this.shortname;
    }

    public final void localize(@NotNull LocalizationManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        ModuleLocalizer loc = null;
        try {
            loc = manager.getModuleLocalizer(this.source, this.shortname);
            String string = loc.getLabel();
            Intrinsics.checkNotNull((Object)string);
            this.description = string;
            this.help = loc.getHelp();
        }
        catch (InconsistencyException e) {
            ApplicationContext.Companion.reportTrouble(this.shortname, this.source, "Module '" + this.shortname + "' was not found in '" + this.source + '\'', e);
            this.help = this.description = "!!! " + this.shortname + " !!!";
        }
    }

    @Override
    public int compareTo(@NotNull Module other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.priority == other.priority ? this.description.compareTo(other.description) : Intrinsics.compare((int)this.priority, (int)other.priority);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ0\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kopi/galite/visual/visual/Module$Companion;", "", "()V", "ACS_FALSE", "", "ACS_PARENT", "ACS_TRUE", "getExecutable", "Lorg/kopi/galite/visual/visual/Executable;", "objectName", "", "startForm", "ctxt", "Lorg/kopi/galite/visual/db/DBContext;", "description", "icon", "Lorg/kopi/galite/visual/base/Image;", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Executable getExecutable(@Nullable String objectName) {
            try {
                Executable executable;
                Object instance;
                Class<?> clazz = Class.forName(objectName);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(objectName)");
                Object object = JvmClassMappingKt.getKotlinClass(clazz).getObjectInstance();
                Object object2 = instance = object == null ? Class.forName(objectName).newInstance() : object;
                if (instance instanceof Window) {
                    executable = ((Window)instance).getModel();
                } else {
                    if (instance == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.visual.Executable");
                    }
                    executable = (Executable)instance;
                }
                return executable;
            }
            catch (IllegalAccessException iae) {
                throw new VRuntimeException(iae);
            }
            catch (InstantiationException ie) {
                throw new VRuntimeException(ie);
            }
            catch (ClassNotFoundException cnfe) {
                throw new VRuntimeException(cnfe);
            }
        }

        @JvmOverloads
        @Nullable
        public final Executable startForm(@NotNull DBContext ctxt, @Nullable String objectName, @NotNull String description, @Nullable Image icon) throws VException {
            Executable executable;
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            try {
                Executable form;
                ApplicationConfiguration applicationConfiguration = ApplicationContext.Companion.getDefaults();
                Intrinsics.checkNotNull((Object)applicationConfiguration);
                if (applicationConfiguration.isDebugModeEnabled()) {
                    System.gc();
                    Thread.yield();
                }
                if ((form = this.getExecutable(objectName)) instanceof VWindow) {
                    ((VWindow)form).setSmallIcon(icon);
                }
                form.setDBContext(ctxt);
                form.doNotModal();
                executable = form;
            }
            catch (VException v) {
                v.printStackTrace();
                throw v;
            }
            catch (Throwable t) {
                ApplicationContext.Companion.reportTrouble("Form loading", "Module.startForm(DBContext ctxt, String object, String description, ImageIcon icon)", t.getMessage(), t);
                VMenuTree vMenuTree = ApplicationContext.Companion.getMenu();
                Intrinsics.checkNotNull((Object)vMenuTree);
                ApplicationContext.Companion.displayError(vMenuTree.getDisplay(), MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00041", null, false, 6, null));
                executable = null;
            }
            return executable;
        }

        public static /* synthetic */ Executable startForm$default(Companion companion, DBContext dBContext, String string, String string2, Image image, int n, Object object) throws VException {
            if ((n & 8) != 0) {
                image = null;
            }
            return companion.startForm(dBContext, string, string2, image);
        }

        @JvmOverloads
        @Nullable
        public final Executable startForm(@NotNull DBContext ctxt, @Nullable String objectName, @NotNull String description) throws VException {
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return org.kopi.galite.visual.visual.Module$Companion.startForm$default(this, ctxt, objectName, description, null, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

