/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.kopi.vkopi.lib.ui.swing.base.JFieldLabel;
import org.kopi.vkopi.lib.ui.swing.plaf.KopiLabelUI;

public class KopiFieldLabelUI
extends KopiLabelUI {
    protected static KopiFieldLabelUI kopiFieldLabelUI = new KopiFieldLabelUI();
    protected static final Color color_focused = UIManager.getColor("KopiLabel.focused.color");
    protected static final Color color_skipped = UIManager.getColor("KopiLabel.skipped.color");
    protected static final Color color_mustfill = UIManager.getColor("KopiLabel.mustfill.color");
    protected static final Color color_visit = UIManager.getColor("KopiLabel.visit.color");
    protected static final Color color_underline = UIManager.getColor("KopiLabel.ul.color");
    protected static final Color color_underline_mustfill;
    protected static final Color color_underline_visit;
    protected static final Color color_underline_skipped;
    protected static final Color color_info;
    protected static final int underline_width;
    private static final Font font;

    public static ComponentUI createUI(JComponent x) {
        return kopiFieldLabelUI;
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        if (l instanceof JFieldLabel) {
            JFieldLabel fl = (JFieldLabel)l;
            int mnemIndex = l.getDisplayedMnemonicIndex();
            if ((fl.getState() & 8) != 0) {
                g.setColor(color_focused);
            } else {
                switch (fl.getState() & 7) {
                    case 2: {
                        g.setColor(color_skipped);
                        break;
                    }
                    case 4: {
                        g.setColor(color_mustfill);
                        break;
                    }
                    case 3: {
                        g.setColor(color_visit);
                        break;
                    }
                    default: {
                        g.setColor(Color.BLACK);
                    }
                }
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, mnemIndex, 0, textY + 2);
            if (fl.getInfoText() != null) {
                g.setFont(font);
                FontMetrics fm = g.getFontMetrics();
                int width = (int)fm.getStringBounds(fl.getInfoText(), g).getWidth();
                int height = (int)fm.getStringBounds(fl.getInfoText(), g).getHeight();
                g.setColor(color_info);
                g.drawString(fl.getInfoText(), l.getWidth() - width - 1, height - 3);
            }
        } else {
            super.paintEnabledText(l, g, s, 0, textY + 2);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (c instanceof JFieldLabel) {
            JFieldLabel fl = (JFieldLabel)c;
            Rectangle clipRect = new Rectangle(0, 0, c.getWidth(), c.getHeight());
            if (clipRect.height - underline_width <= 0 || fl.getText() == null || fl.getText().length() == 0) {
                return;
            }
            if ((fl.getState() & 0x10) == 0 || fl.isInDetailMode()) {
                switch (fl.getState() & 7) {
                    case 2: {
                        g.setColor(color_underline_skipped);
                        break;
                    }
                    case 4: {
                        g.setColor(color_underline_mustfill);
                        break;
                    }
                    case 3: {
                        g.setColor(color_underline_visit);
                        break;
                    }
                    default: {
                        g.setColor(color_underline);
                    }
                }
                g.fillRect(clipRect.x, clipRect.y, clipRect.width, underline_width);
            }
        }
    }

    static {
        color_underline_visit = UIManager.getColor("KopiLabel.ul.visit.color");
        color_underline_skipped = UIManager.getColor("KopiLabel.ul.skipped.color");
        color_underline_mustfill = UIManager.getColor("KopiLabel.ul.mustfill.color");
        color_info = UIManager.getColor("KopiLabel.info.color");
        font = UIManager.getFont("KopiLabel.info.font");
        underline_width = UIManager.getInt("KopiLabel.ul.width");
    }
}

