/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.report;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fR\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/kopi/galite/visual/report/Parameters;", "Ljava/io/Serializable;", "color", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "bgcolors", "", "[Ljava/awt/Color;", "fgcolors", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "getBackground", "level", "", "getForeground", "galite-core"})
public final class Parameters
implements Serializable {
    @NotNull
    private final Font font;
    @NotNull
    private final Color[] bgcolors;
    @NotNull
    private final Color[] fgcolors;

    public Parameters(@NotNull Color color) {
        int n;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.font = new Font("dialoginput", 0, 12);
        this.bgcolors = new Color[10];
        int n2 = 0;
        Color[] colorArray = new Color[10];
        Parameters parameters = this;
        while (n2 < 10) {
            n = n2++;
            colorArray[n] = new Color(0, 0, 0);
        }
        parameters.fgcolors = colorArray;
        Color reverseColor = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        int n3 = 0;
        n = this.bgcolors.length + -1;
        if (n3 <= n) {
            do {
                int i = n3++;
                this.bgcolors[i] = new Color(255 - i * reverseColor.getRed() / 17, 255 - i * reverseColor.getGreen() / 17, 255 - i * reverseColor.getBlue() / 17);
            } while (n3 <= n);
        }
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    @NotNull
    public final Color getBackground(int level) {
        Color color;
        if (level >= this.bgcolors.length) {
            Color color2 = Color.white;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"white");
            color = color2;
        } else {
            Color color3 = this.bgcolors[level];
            color = color3;
            Intrinsics.checkNotNull((Object)color3);
        }
        return color;
    }

    @NotNull
    public final Color getForeground(int level) {
        Color color;
        if (level >= this.fgcolors.length) {
            Color color2 = Color.black;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"black");
            color = color2;
        } else {
            color = this.fgcolors[level];
        }
        return color;
    }
}

