/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.report;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.dsl.report.ReportField;
import org.kopi.galite.visual.report.VBaseRow;
import org.kopi.galite.visual.report.VCCDepthFirstCircuitN;
import org.kopi.galite.visual.report.VCalculateColumn;
import org.kopi.galite.visual.report.VGroupRow;
import org.kopi.galite.visual.report.VReportRow;
import org.kopi.galite.visual.type.Decimal;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J(\u0010\b\u001a\u00020\u0004\"\u0012\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n*\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006J\u0014\u0010\f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\u0012\u0010\u000e\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J(\u0010\u000f\u001a\u00020\u0004\"\u0012\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n*\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006J\u0014\u0010\u0010\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\u0011\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\u0014\u0010\u0012\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J(\u0010\u0013\u001a\u00020\u0004\"\u0012\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n*\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006\u00a8\u0006\u0014"}, d2={"Lorg/kopi/galite/visual/report/Triggers;", "", "()V", "avgDecimal", "Lorg/kopi/galite/visual/report/VCalculateColumn;", "c", "Lorg/kopi/galite/visual/dsl/report/ReportField;", "Lorg/kopi/galite/visual/type/Decimal;", "avgInteger", "T", "", "", "countInteger", "", "reportIdenticalValue", "serialInteger", "sumDecimal", "sumInteger", "sumNullDecimal", "sumNullInteger", "galite-core"})
public final class Triggers {
    @NotNull
    public static final Triggers INSTANCE = new Triggers();

    private Triggers() {
    }

    @NotNull
    public final VCalculateColumn sumInteger(@NotNull ReportField<Integer> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                int result = 0;
                int n = 0;
                if (n < childCount) {
                    do {
                        int i;
                        TreeNode treeNode;
                        if ((treeNode = row.getChildAt(i = n++)) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                        }
                        VReportRow child = (VReportRow)treeNode;
                        Integer value = (Integer)child.getValueAt(column2);
                        if (value == null) continue;
                        result += value.intValue();
                    } while (n < childCount);
                }
                return result;
            }
        };
    }

    @NotNull
    public final VCalculateColumn countInteger(@NotNull ReportField<Integer> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                int n;
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                if (row.getLevel() > 1) {
                    int result = 0;
                    int n2 = 0;
                    if (n2 < childCount) {
                        do {
                            int i;
                            TreeNode treeNode;
                            if ((treeNode = row.getChildAt(i = n2++)) == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                            }
                            VReportRow child = (VReportRow)treeNode;
                            Integer value = (Integer)child.getValueAt(column2);
                            if (value == null) continue;
                            result += value.intValue();
                        } while (n2 < childCount);
                    }
                    n = result;
                } else {
                    n = childCount;
                }
                return n;
            }
        };
    }

    @NotNull
    public final VCalculateColumn sumDecimal(@NotNull ReportField<Decimal> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                Decimal result = new Decimal(0L, 2);
                int n = 0;
                if (n < childCount) {
                    do {
                        Decimal value;
                        int i;
                        TreeNode treeNode;
                        if ((treeNode = row.getChildAt(i = n++)) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                        }
                        VReportRow child = (VReportRow)treeNode;
                        Object object = child.getValueAt(column2);
                        Decimal decimal = value = object instanceof Decimal ? (Decimal)object : null;
                        if (value == null) continue;
                        result = result.plus(value);
                    } while (n < childCount);
                }
                return result;
            }
        };
    }

    @NotNull
    public final <T extends Number> VCalculateColumn sumNullInteger(@NotNull ReportField<T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new VCCDepthFirstCircuitN(){

            @Nullable
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                int result = 0;
                boolean valueFound = false;
                int n = 0;
                if (n < childCount) {
                    do {
                        int i;
                        TreeNode treeNode;
                        if ((treeNode = row.getChildAt(i = n++)) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                        }
                        VReportRow child = (VReportRow)treeNode;
                        Integer value = (Integer)child.getValueAt(column2);
                        if (value == null) continue;
                        valueFound = true;
                        result += value.intValue();
                    } while (n < childCount);
                }
                return valueFound ? Integer.valueOf(result) : null;
            }
        };
    }

    @NotNull
    public final VCalculateColumn sumNullDecimal(@NotNull ReportField<Decimal> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new VCCDepthFirstCircuitN(){

            @Nullable
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                boolean valueFound = false;
                Decimal result = new Decimal(0L, 2);
                int n = 0;
                if (n < childCount) {
                    do {
                        Decimal value;
                        int i;
                        TreeNode treeNode;
                        if ((treeNode = row.getChildAt(i = n++)) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                        }
                        VReportRow child = (VReportRow)treeNode;
                        Object object = child.getValueAt(column2);
                        Decimal decimal = value = object instanceof Decimal ? (Decimal)object : null;
                        if (value == null) continue;
                        valueFound = true;
                        result = result.plus(value);
                    } while (n < childCount);
                }
                return valueFound ? result : null;
            }
        };
    }

    @NotNull
    public final VCalculateColumn reportIdenticalValue(@NotNull ReportField<?> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new VCCDepthFirstCircuitN(){

            @Nullable
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                TreeNode treeNode = row.getChildAt(0);
                if (treeNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                }
                Object value = ((VReportRow)treeNode).getValueAt(column2);
                if (value == null) {
                    object = null;
                } else {
                    int n = 1;
                    if (n < childCount) {
                        do {
                            int i;
                            TreeNode treeNode2;
                            if ((treeNode2 = row.getChildAt(i = n++)) == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                            }
                            VReportRow child = (VReportRow)treeNode2;
                            if (Intrinsics.areEqual((Object)value, (Object)child.getValueAt(column2))) continue;
                            return null;
                        } while (n < childCount);
                    }
                    object = value;
                }
                return object;
            }
        };
    }

    @NotNull
    public final <T extends Number> VCalculateColumn avgInteger(@NotNull ReportField<T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                int result = 0;
                int n = 0;
                if (n < childCount) {
                    do {
                        int i;
                        TreeNode treeNode;
                        if ((treeNode = row.getChildAt(i = n++)) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                        }
                        VReportRow child = (VReportRow)treeNode;
                        Integer value = (Integer)child.getValueAt(column2);
                        if (value == null) continue;
                        result += value.intValue();
                    } while (n < childCount);
                }
                return result / childCount;
            }
        };
    }

    @NotNull
    public final <T extends Number> VCalculateColumn serialInteger(@NotNull ReportField<T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                int n;
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                if (row.getLevel() > 1) {
                    int result = 0;
                    int n2 = 0;
                    if (n2 < childCount) {
                        do {
                            int i;
                            TreeNode treeNode;
                            if ((treeNode = row.getChildAt(i = n2++)) == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                            }
                            VReportRow child = (VReportRow)treeNode;
                            Integer value = (Integer)child.getValueAt(column2);
                            if (value == null) continue;
                            result += value.intValue();
                        } while (n2 < childCount);
                    }
                    n = result;
                } else {
                    n = childCount;
                }
                return n;
            }

            public void calculate(@NotNull VGroupRow tree, int column2) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                if (tree.getLevel() > 1) {
                    int n = 0;
                    int childCount = tree.getChildCount();
                    if (n < childCount) {
                        do {
                            int i;
                            TreeNode treeNode;
                            if ((treeNode = tree.getChildAt(i = n++)) == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VGroupRow");
                            }
                            this.calculate((VGroupRow)treeNode, column2);
                        } while (n < childCount);
                    }
                } else {
                    int n = 0;
                    int childCount = tree.getChildCount();
                    if (n < childCount) {
                        do {
                            int i;
                            TreeNode treeNode;
                            if ((treeNode = tree.getChildAt(i = n++)) == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VBaseRow");
                            }
                            ((VBaseRow)treeNode).setValueAt(column2, i + 1);
                        } while (n < childCount);
                    }
                }
                tree.setValueAt(column2, this.evalNode(tree, column2));
            }
        };
    }

    @NotNull
    public final VCalculateColumn avgDecimal(@NotNull ReportField<Decimal> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int leafCount = row.getLeafCount();
                double notNullLeafCount = 0.0;
                Decimal result = new Decimal(0L, 2);
                DefaultMutableTreeNode defaultMutableTreeNode = row.getFirstLeaf();
                VReportRow leaf = defaultMutableTreeNode instanceof VReportRow ? (VReportRow)defaultMutableTreeNode : null;
                int n = 0;
                if (n < leafCount) {
                    do {
                        Decimal value;
                        int i = n++;
                        VReportRow vReportRow = leaf;
                        Intrinsics.checkNotNull((Object)vReportRow);
                        Object object = vReportRow.getValueAt(column2);
                        Decimal decimal = value = object instanceof Decimal ? (Decimal)object : null;
                        if (value != null) {
                            result = result.plus(value);
                            double d = notNullLeafCount;
                            notNullLeafCount = d + 1.0;
                        }
                        VReportRow vReportRow2 = leaf = (object = leaf.getNextLeaf()) instanceof VReportRow ? (VReportRow)object : null;
                    } while (n < leafCount);
                }
                return !(notNullLeafCount == 0.0) ? result.div(new Decimal(notNullLeafCount)).setScale(2) : new Decimal(0L, 2);
            }
        };
    }
}

