/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.type;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.type.Date;
import org.kopi.galite.visual.type.Time;
import org.kopi.galite.visual.type.Type;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0015H\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/kopi/galite/visual/type/Timestamp;", "Lorg/kopi/galite/visual/type/Type;", "Ljava/time/Instant;", "string", "", "(Ljava/lang/String;)V", "millis", "", "(J)V", "instant", "(Ljava/time/Instant;)V", "calendar", "Ljava/util/Calendar;", "(Ljava/util/Calendar;)V", "sqlTimestamp", "Ljava/sql/Timestamp;", "(Ljava/sql/Timestamp;)V", "getSqlTimestamp", "()Ljava/sql/Timestamp;", "add", "compareTo", "", "other", "equals", "", "", "format", "locale", "Ljava/util/Locale;", "hashCode", "toCalendar", "Ljava/util/GregorianCalendar;", "toSql", "toString", "Companion", "galite-core"})
public final class Timestamp
extends Type<Timestamp, Instant> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.sql.Timestamp sqlTimestamp;
    @NotNull
    private static final Timestamp DEFAULT = new Timestamp(0L);
    @NotNull
    private static final SimpleDateFormat normal = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public Timestamp(@NotNull java.sql.Timestamp sqlTimestamp) {
        Intrinsics.checkNotNullParameter((Object)sqlTimestamp, (String)"sqlTimestamp");
        this.sqlTimestamp = sqlTimestamp;
    }

    @NotNull
    public final java.sql.Timestamp getSqlTimestamp() {
        return this.sqlTimestamp;
    }

    public Timestamp(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        java.sql.Timestamp timestamp = java.sql.Timestamp.valueOf(string);
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"valueOf(string)");
        this(timestamp);
    }

    public Timestamp(long millis) {
        this(new java.sql.Timestamp(millis));
    }

    public Timestamp(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        java.sql.Timestamp timestamp = java.sql.Timestamp.from(instant);
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"from(instant)");
        this(timestamp);
    }

    public Timestamp(@NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        this(new java.sql.Timestamp(calendar.getTimeInMillis()));
    }

    @NotNull
    public final String format(@NotNull String format2, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = new SimpleDateFormat(format2, locale).format(this.sqlTimestamp);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(format,\u2026ale).format(sqlTimestamp)");
        return string;
    }

    public static /* synthetic */ String format$default(Timestamp timestamp, String string, Locale locale, int n, Object object) {
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return timestamp.format(string, locale);
    }

    @NotNull
    public final GregorianCalendar toCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.setTimeInMillis(this.sqlTimestamp.getTime());
        return calendar;
    }

    @NotNull
    public final Timestamp add(long millis) {
        return new Timestamp(this.sqlTimestamp.getTime() + millis);
    }

    @Override
    public int compareTo(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.sqlTimestamp.compareTo(other.sqlTimestamp);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof Timestamp && ((Timestamp)other).sqlTimestamp.equals(this.sqlTimestamp);
    }

    @Override
    @NotNull
    public String toString(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        StringBuffer tmp = new StringBuffer(normal.format(this.sqlTimestamp));
        int nanos = this.sqlTimestamp.getNanos();
        if (nanos >= 100) {
            tmp.append(nanos);
        } else if (nanos >= 10) {
            tmp.append(Intrinsics.stringPlus((String)"0", (Object)nanos));
        } else {
            tmp.append(Intrinsics.stringPlus((String)"00", (Object)nanos));
        }
        String string = tmp.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tmp.toString()");
        return string;
    }

    @Override
    @NotNull
    public Instant toSql() {
        Instant instant = this.sqlTimestamp.toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sqlTimestamp.toInstant()");
        return instant;
    }

    public int hashCode() {
        return this.sqlTimestamp.hashCode();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u001e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J6\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/kopi/galite/visual/type/Timestamp$Companion;", "", "()V", "DEFAULT", "Lorg/kopi/galite/visual/type/Timestamp;", "getDEFAULT", "()Lorg/kopi/galite/visual/type/Timestamp;", "normal", "Ljava/text/SimpleDateFormat;", "from", "localDateTime", "Ljava/time/LocalDateTime;", "date", "Lorg/kopi/galite/visual/type/Date;", "time", "Lorg/kopi/galite/visual/type/Time;", "now", "parse", "input", "", "format", "locale", "Ljava/util/Locale;", "toCalendar", "Ljava/util/GregorianCalendar;", "year", "", "month", "day", "hours", "minutes", "seconds", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Timestamp now() {
            return new Timestamp(System.currentTimeMillis());
        }

        @NotNull
        public final Timestamp parse(@NotNull String input, @NotNull String format2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            return this.parse(input, format2, locale);
        }

        @NotNull
        public final Timestamp parse(@NotNull String input, @NotNull String format2, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            GregorianCalendar cal = new GregorianCalendar();
            try {
                cal.setTime(new SimpleDateFormat(format2, locale).parse(input));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage());
            }
            return new Timestamp(cal.getTimeInMillis());
        }

        @NotNull
        public final Timestamp from(@NotNull LocalDateTime localDateTime) {
            Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"localDateTime");
            return new Timestamp(this.toCalendar(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond()));
        }

        @NotNull
        public final Timestamp from(@NotNull Date date, @NotNull Time time) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            return new Timestamp(this.toCalendar(date.getYear(), date.getMonth(), date.getDay(), time.getHours(), time.getMinutes(), time.getSeconds()));
        }

        @NotNull
        public final GregorianCalendar toCalendar(int year, int month, int day, int hours, int minutes, int seconds) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.clear();
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hours);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            return calendar;
        }

        @NotNull
        public final Timestamp getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

