/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.Component;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.BlockListener;
import org.kopi.galite.visual.form.BlockRecordListener;
import org.kopi.galite.visual.form.UBlock;
import org.kopi.galite.visual.form.UForm;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldException;
import org.kopi.galite.visual.form.VForm;
import org.kopi.galite.visual.fullcalendar.VFullCalendarBlock;
import org.kopi.galite.visual.type.Date;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.form.DBlock;
import org.kopi.galite.visual.ui.vaadin.form.DFullCalendarBlock;
import org.kopi.galite.visual.ui.vaadin.form.DGridBlock;
import org.kopi.galite.visual.ui.vaadin.form.DGridMultiBlock;
import org.kopi.galite.visual.ui.vaadin.form.Form;
import org.kopi.galite.visual.ui.vaadin.form.FormListener;
import org.kopi.galite.visual.ui.vaadin.visual.DWindow;
import org.kopi.galite.visual.util.PrintJob;
import org.kopi.galite.visual.util.base.InconsistencyException;
import org.kopi.galite.visual.visual.Action;
import org.kopi.galite.visual.visual.VRuntimeException;
import org.kopi.galite.visual.visual.VWindow;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0002JKB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0004J\u001c\u0010*\u001a\u00020$2\b\u0010+\u001a\u0004\u0018\u00010)2\b\u0010,\u001a\u0004\u0018\u00010)H\u0016J\u000e\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/J\u0014\u00100\u001a\u0004\u0018\u0001012\b\u0010%\u001a\u0004\u0018\u00010)H\u0016J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0014J\b\u00105\u001a\u00020$H\u0016J\b\u00106\u001a\u00020$H\u0016J\b\u00107\u001a\u00020$H\u0016J\u000e\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020\u0014J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\u0014H\u0016J\b\u0010<\u001a\u00020$H\u0016J\u0010\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u000203H\u0016J\u0010\u0010?\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0014H\u0016J\n\u0010@\u001a\u0004\u0018\u00010AH\u0016J\b\u0010B\u001a\u00020$H\u0016J\b\u0010C\u001a\u00020$H\u0016J\u0010\u0010D\u001a\u00020$2\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020$H\u0016J\u0010\u0010H\u001a\u00020$2\u0006\u0010I\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006L"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DForm;", "Lorg/kopi/galite/visual/ui/vaadin/visual/DWindow;", "Lorg/kopi/galite/visual/form/UForm;", "Lorg/kopi/galite/visual/ui/vaadin/form/FormListener;", "model", "Lorg/kopi/galite/visual/form/VForm;", "(Lorg/kopi/galite/visual/form/VForm;)V", "blockListener", "Lorg/kopi/galite/visual/form/BlockListener;", "blockRecordHandler", "Lorg/kopi/galite/visual/ui/vaadin/form/DForm$BlockRecordHandler;", "blockViews", "", "Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;", "[Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;", "content", "Lorg/kopi/galite/visual/ui/vaadin/form/Form;", "getContent", "()Lorg/kopi/galite/visual/ui/vaadin/form/Form;", "currentPage", "", "getCurrentPage", "()I", "setCurrentPage", "(I)V", "pageCount", "getPageCount", "<set-?>", "", "runtimeDebugInfo", "getRuntimeDebugInfo", "()Ljava/lang/Throwable;", "vForm", "getVForm", "()Lorg/kopi/galite/visual/form/VForm;", "addBlock", "", "block", "page", "createViewForBlock", "blockModel", "Lorg/kopi/galite/visual/form/VBlock;", "currentBlockChanged", "oldBlock", "newBlock", "displayFieldError", "fe", "Lorg/kopi/galite/visual/form/VFieldException;", "getBlockView", "Lorg/kopi/galite/visual/form/UBlock;", "getPageTitle", "", "index", "gotoFirstPosition", "gotoLastPosition", "gotoNextPosition", "gotoPage", "i", "gotoPosition", "posno", "gotoPrevPosition", "launchDocumentPreview", "file", "onPageSelection", "printForm", "Lorg/kopi/galite/visual/util/PrintJob;", "printSnapshot", "release", "reportError", "e", "Lorg/kopi/galite/visual/visual/VRuntimeException;", "run", "setFieldSearchOperator", "op", "BlockAccessHandler", "BlockRecordHandler", "galite-core"})
public final class DForm
extends DWindow
implements UForm,
FormListener {
    private int currentPage;
    @NotNull
    private final Form content;
    @NotNull
    private final BlockListener blockListener;
    @NotNull
    private final DBlock[] blockViews;
    @NotNull
    private final BlockRecordHandler blockRecordHandler;
    @Nullable
    private Throwable runtimeDebugInfo;

    public DForm(@NotNull VForm model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(model2);
        this.currentPage = -1;
        this.content = new Form(this.getPageCount(), model2.getPages$galite_core());
        this.blockListener = new BlockAccessHandler();
        this.blockRecordHandler = new BlockRecordHandler();
        model2.addFormListener(this);
        this.content.addFormListener(this);
        VWindow vWindow = this.getModel();
        Intrinsics.checkNotNull((Object)vWindow);
        vWindow.setDisplay(this);
        VForm vForm = this.getVForm();
        Intrinsics.checkNotNull((Object)vForm);
        int blockCount = vForm.getBlockCount();
        this.blockViews = new DBlock[blockCount];
        int n = 0;
        if (n < blockCount) {
            do {
                int i = n++;
                VForm vForm2 = this.getVForm();
                Intrinsics.checkNotNull((Object)vForm2);
                VBlock blockModel = vForm2.getBlock(i);
                if (!blockModel.isInternal()) {
                    DBlock blockView;
                    this.blockViews[i] = blockView = this.createViewForBlock(blockModel);
                    this.addBlock(blockView, blockModel.getPageNumber());
                }
                blockModel.addBlockListener(this.blockListener);
            } while (n < blockCount);
        }
        this.setContent((Component)this.content);
        VWindow vWindow2 = this.getModel();
        Intrinsics.checkNotNull((Object)vWindow2);
        vWindow2.enableCommands();
    }

    public final int getCurrentPage() {
        return this.currentPage;
    }

    public final void setCurrentPage(int n) {
        this.currentPage = n;
    }

    @NotNull
    public final Form getContent() {
        return this.content;
    }

    @NotNull
    protected final DBlock createViewForBlock(@NotNull VBlock blockModel) {
        Intrinsics.checkNotNullParameter((Object)blockModel, (String)"blockModel");
        DBlock blockView = null;
        if (blockModel instanceof VFullCalendarBlock) {
            blockView = new DFullCalendarBlock(this, (VFullCalendarBlock)blockModel);
        } else if (!blockModel.isMulti()) {
            blockView = new DBlock(this, blockModel);
        } else {
            if (blockModel.noChart() && blockModel.noDetail()) {
                throw new InconsistencyException("Block " + blockModel.getName() + " is \"NO DEATIL\" and \"NO CHART\" at the same time");
            }
            blockView = blockModel.noChart() ? new DBlock(this, blockModel) : (blockModel.noDetail() ? (DBlock)new DGridBlock(this, blockModel) : (DBlock)new DGridMultiBlock(this, blockModel));
        }
        return blockView;
    }

    public final int getPageCount() {
        VForm vForm = this.getVForm();
        Intrinsics.checkNotNull((Object)vForm);
        return vForm.getPages$galite_core().length;
    }

    @NotNull
    public final String getPageTitle(int index) {
        VForm vForm = this.getVForm();
        Intrinsics.checkNotNull((Object)vForm);
        return vForm.getPages$galite_core()[index];
    }

    @Override
    public void reportError(@NotNull VRuntimeException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getCause() instanceof VFieldException && e.getMessage() != null) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.form.VFieldException");
            }
            this.displayFieldError((VFieldException)throwable);
        } else {
            super.reportError(e);
        }
    }

    public final void displayFieldError(@NotNull VFieldException fe) {
        Intrinsics.checkNotNullParameter((Object)fe, (String)"fe");
        VField field = fe.getField();
        field.displayFieldError(fe.getMessage());
    }

    public final void gotoPage(int i) {
        this.currentPage = i;
        BackgroundThreadHandler.INSTANCE.access(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this, i){
            final /* synthetic */ DForm this$0;
            final /* synthetic */ int $i;
            {
                this.this$0 = $receiver;
                this.$i = $i;
                super(0);
            }

            public final void invoke() {
                this.this$0.getContent().gotoPage(this.$i);
            }
        }));
    }

    @Override
    public void release() {
        if (this.getVForm() != null) {
            VForm vForm = this.getVForm();
            Intrinsics.checkNotNull((Object)vForm);
            vForm.removeFormListener(this);
            int n = 0;
            int n2 = this.blockViews.length + -1;
            if (n <= n2) {
                do {
                    DBlock dBlock;
                    int i = n++;
                    VForm vForm2 = this.getVForm();
                    Intrinsics.checkNotNull((Object)vForm2);
                    VBlock block = vForm2.getBlock(i);
                    block.removeBlockListener(this.blockListener);
                    UBlock uBlock = block.getDisplay$galite_core();
                    DBlock dBlock2 = dBlock = uBlock instanceof DBlock ? (DBlock)uBlock : null;
                    if (dBlock == null) continue;
                    dBlock.release();
                } while (n <= n2);
            }
        }
        super.release();
    }

    private final void addBlock(DBlock block, int page) {
        if (!block.getModel().isInternal()) {
            this.content.addBlock(block, page, block.getModel().isFollow(), block.getModel().noDetail());
        }
        this.content.setBorder$galite_core(block, page);
    }

    @Nullable
    public final VForm getVForm() {
        VWindow vWindow = this.getModel();
        return vWindow instanceof VForm ? (VForm)vWindow : null;
    }

    @Override
    public void run() {
        VForm vForm = this.getVForm();
        Intrinsics.checkNotNull((Object)vForm);
        vForm.prepareForm();
        VForm vForm2 = this.getVForm();
        Intrinsics.checkNotNull((Object)vForm2);
        int blockcount = vForm2.getBlockCount();
        int n = 0;
        if (n < blockcount) {
            do {
                int i = n++;
                VForm vForm3 = this.getVForm();
                Intrinsics.checkNotNull((Object)vForm3);
                vForm3.getBlock(i).updateBlockAccess();
            } while (n < blockcount);
        }
        VForm vForm4 = this.getVForm();
        Intrinsics.checkNotNull((Object)vForm4);
        vForm4.executeAfterStart();
    }

    @Override
    public void onPageSelection(int page) {
        if (this.currentPage != page) {
            this.performAsyncAction(new Action(this, page){
                final /* synthetic */ DForm this$0;
                final /* synthetic */ int $page;
                {
                    this.this$0 = $receiver;
                    this.$page = $page;
                    super("setSelectedIndex");
                }

                public void execute() {
                    VForm vForm = this.this$0.getVForm();
                    Intrinsics.checkNotNull((Object)vForm);
                    vForm.gotoPage(this.$page);
                }
            });
        }
    }

    @Override
    public void gotoNextPosition() {
        this.performAsyncAction(new Action(this){
            final /* synthetic */ DForm this$0;
            {
                this.this$0 = $receiver;
                super("gotoNextPosition");
            }

            public void execute() {
                VForm vForm = this.this$0.getVForm();
                Intrinsics.checkNotNull((Object)vForm);
                VBlock vBlock = vForm.getActiveBlock();
                Intrinsics.checkNotNull((Object)vBlock);
                vBlock.gotoNextRecord();
            }
        });
    }

    @Override
    public void gotoPrevPosition() {
        this.performAsyncAction(new Action(this){
            final /* synthetic */ DForm this$0;
            {
                this.this$0 = $receiver;
                super("gotoPrevPosition");
            }

            public void execute() {
                VForm vForm = this.this$0.getVForm();
                Intrinsics.checkNotNull((Object)vForm);
                VBlock vBlock = vForm.getActiveBlock();
                Intrinsics.checkNotNull((Object)vBlock);
                vBlock.gotoPrevRecord();
            }
        });
    }

    @Override
    public void gotoLastPosition() {
        this.performAsyncAction(new Action(this){
            final /* synthetic */ DForm this$0;
            {
                this.this$0 = $receiver;
                super("gotoLastPosition");
            }

            public void execute() {
                VForm vForm = this.this$0.getVForm();
                Intrinsics.checkNotNull((Object)vForm);
                VBlock vBlock = vForm.getActiveBlock();
                Intrinsics.checkNotNull((Object)vBlock);
                vBlock.gotoLastRecord();
            }
        });
    }

    @Override
    public void gotoFirstPosition() {
        this.performAsyncAction(new Action(this){
            final /* synthetic */ DForm this$0;
            {
                this.this$0 = $receiver;
                super("gotoFirstPosition");
            }

            public void execute() {
                VForm vForm = this.this$0.getVForm();
                Intrinsics.checkNotNull((Object)vForm);
                VBlock vBlock = vForm.getActiveBlock();
                Intrinsics.checkNotNull((Object)vBlock);
                vBlock.gotoFirstRecord();
            }
        });
    }

    @Override
    public void gotoPosition(int posno) {
        this.performAsyncAction(new Action(this, posno){
            final /* synthetic */ DForm this$0;
            final /* synthetic */ int $posno;
            {
                this.this$0 = $receiver;
                this.$posno = $posno;
                super("gotoPosition");
            }

            public void execute() {
                VForm vForm = this.this$0.getVForm();
                Intrinsics.checkNotNull((Object)vForm);
                VBlock vBlock = vForm.getActiveBlock();
                Intrinsics.checkNotNull((Object)vBlock);
                vBlock.gotoRecord(this.$posno - 1);
            }
        });
    }

    @Override
    public void currentBlockChanged(@Nullable VBlock oldBlock, @Nullable VBlock newBlock) {
        if (oldBlock != null) {
            oldBlock.removeBlockRecordListener(this.blockRecordHandler);
            if (this.getBlockView(oldBlock) instanceof DGridBlock) {
                DGridBlock dGridBlock = (DGridBlock)this.getBlockView(oldBlock);
                Intrinsics.checkNotNull((Object)dGridBlock);
                dGridBlock.clear();
            }
        }
        if (newBlock != null) {
            newBlock.addBlockRecordListener(this.blockRecordHandler);
            this.blockRecordHandler.blockRecordChanged(newBlock.getSortedPosition(newBlock.getRecord()), newBlock.getRecordCount());
        }
        if (newBlock != null && newBlock.getPageNumber() != this.currentPage) {
            this.gotoPage(newBlock.getPageNumber());
            if (this.getBlockView(oldBlock) instanceof DGridBlock) {
                DGridBlock dGridBlock = (DGridBlock)this.getBlockView(oldBlock);
                Intrinsics.checkNotNull((Object)dGridBlock);
                dGridBlock.scrollToStart$galite_core();
            }
        }
    }

    @Override
    public void setFieldSearchOperator(int op) {
    }

    @Override
    @Nullable
    public UBlock getBlockView(@Nullable VBlock block) {
        VForm vForm = this.getVForm();
        Intrinsics.checkNotNull((Object)vForm);
        VBlock[] blocks = vForm.getBlocks();
        int n = 0;
        int n2 = blocks.length + -1;
        if (n <= n2) {
            do {
                int i;
                if (!Intrinsics.areEqual((Object)block, (Object)blocks[i = n++])) continue;
                return this.blockViews[i];
            } while (n <= n2);
        }
        return null;
    }

    @Override
    @Nullable
    public PrintJob printForm() {
        return null;
    }

    @Override
    public void printSnapshot() {
    }

    @Override
    @Nullable
    public Throwable getRuntimeDebugInfo() {
        return this.runtimeDebugInfo;
    }

    @Override
    public void launchDocumentPreview(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File f = new File(file);
        String string = f.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.name");
        this.fileProduced(f, string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016\u00a8\u0006 "}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DForm$BlockAccessHandler;", "Lorg/kopi/galite/visual/form/BlockListener;", "(Lorg/kopi/galite/visual/ui/vaadin/form/DForm;)V", "blockAccessChanged", "", "block", "Lorg/kopi/galite/visual/form/VBlock;", "newAccess", "", "blockChanged", "blockCleared", "blockClosed", "blockViewModeEntered", "actviceField", "Lorg/kopi/galite/visual/form/VField;", "blockViewModeLeaved", "enter", "filterHidden", "filterShown", "getCurrentDisplay", "Lorg/kopi/galite/visual/form/UBlock;", "getSelectedDate", "Lorg/kopi/galite/visual/type/Date;", "goToDate", "date", "orderChanged", "recordInfoChanged", "rec", "", "info", "refreshEntries", "validRecordNumberChanged", "galite-core"})
    private final class BlockAccessHandler
    implements BlockListener {
        public BlockAccessHandler() {
            Intrinsics.checkNotNullParameter((Object)DForm.this, (String)"this$0");
        }

        @Override
        public void blockClosed() {
        }

        @Override
        public void blockChanged() {
        }

        @Override
        public void blockCleared() {
        }

        @Override
        public void refreshEntries() {
        }

        @Override
        @Nullable
        public Date getSelectedDate() {
            return null;
        }

        @Override
        public void goToDate(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        }

        @Override
        public void enter() {
        }

        @Override
        public void blockAccessChanged(@NotNull VBlock block, boolean newAccess) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            BackgroundThreadHandler.INSTANCE.access(DForm.this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(DForm.this, block, newAccess){
                final /* synthetic */ DForm this$0;
                final /* synthetic */ VBlock $block;
                final /* synthetic */ boolean $newAccess;
                {
                    this.this$0 = $receiver;
                    this.$block = $block;
                    this.$newAccess = $newAccess;
                    super(0);
                }

                public final void invoke() {
                    if (this.this$0.getPageCount() == 1) {
                        return;
                    }
                    int pageNumber = this.$block.getPageNumber();
                    VForm vForm = this.this$0.getVForm();
                    Intrinsics.checkNotNull((Object)vForm);
                    VBlock[] blocks = vForm.getBlocks();
                    if (this.$newAccess) {
                        this.this$0.getContent().setEnabled(true, pageNumber);
                    } else {
                        int n = 0;
                        int n2 = blocks.length + -1;
                        if (n <= n2) {
                            do {
                                int i;
                                if (pageNumber != blocks[i = n++].getPageNumber() || !blocks[i].isAccessible()) continue;
                                return;
                            } while (n <= n2);
                        }
                        this.this$0.getContent().setEnabled(false, pageNumber);
                    }
                }
            }));
        }

        @Override
        public void blockViewModeLeaved(@NotNull VBlock block, @Nullable VField actviceField) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        }

        @Override
        public void blockViewModeEntered(@NotNull VBlock block, @Nullable VField actviceField) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        }

        @Override
        public void validRecordNumberChanged() {
        }

        @Override
        public void recordInfoChanged(int rec, int info) {
        }

        @Override
        public void orderChanged() {
        }

        @Override
        public void filterHidden() {
        }

        @Override
        public void filterShown() {
        }

        @Override
        @Nullable
        public UBlock getCurrentDisplay() {
            return null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DForm$BlockRecordHandler;", "Lorg/kopi/galite/visual/form/BlockRecordListener;", "(Lorg/kopi/galite/visual/ui/vaadin/form/DForm;)V", "blockRecordChanged", "", "current", "", "count", "galite-core"})
    private final class BlockRecordHandler
    implements BlockRecordListener {
        public BlockRecordHandler() {
            Intrinsics.checkNotNullParameter((Object)DForm.this, (String)"this$0");
        }

        @Override
        public void blockRecordChanged(int current, int count) {
            BackgroundThreadHandler.INSTANCE.access(DForm.this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(DForm.this, current, count){
                final /* synthetic */ DForm this$0;
                final /* synthetic */ int $current;
                final /* synthetic */ int $count;
                {
                    this.this$0 = $receiver;
                    this.$current = $current;
                    this.$count = $count;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getContent().setPosition(this.$current, this.$count);
                }
            }));
        }
    }
}

