/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.grid;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorTextField;
import org.kopi.galite.visual.ui.vaadin.grid.InvalidEditorFieldException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u0003H\u0004J\b\u0010\u000f\u001a\u00020\u000bH\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorIntegerField;", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorTextField;", "width", "", "minValue", "maxValue", "(III)V", "getMaxValue", "()I", "getMinValue", "check", "", "text", "", "intValue", "isNumeric", "validate", "", "galite-core"})
public final class GridEditorIntegerField
extends GridEditorTextField {
    private final int minValue;
    private final int maxValue;

    public GridEditorIntegerField(int width, int minValue, int maxValue) {
        super(width);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.getWrappedField$galite_core().setPattern("[0-9-]*");
        this.getWrappedField$galite_core().setPreventInvalidInput(true);
        this.getWrappedField$galite_core().getElement().setProperty("min", (double)this.minValue);
        this.getWrappedField$galite_core().getElement().setProperty("max", (double)this.maxValue);
    }

    public final int getMinValue() {
        return this.minValue;
    }

    public final int getMaxValue() {
        return this.maxValue;
    }

    @Override
    protected boolean check(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = text;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char element = string.charAt(i);
            char c = element;
            if (Character.isDigit(c) || c == '.' || c == '-') continue;
            return false;
        }
        return true;
    }

    @Override
    public void validate() {
        int value = this.intValue();
        if (value < this.minValue) {
            Object[] objectArray = new Object[]{this.minValue};
            throw new InvalidEditorFieldException(this, "00012", objectArray);
        }
        if (value > this.maxValue) {
            Object[] objectArray = new Object[]{this.maxValue};
            throw new InvalidEditorFieldException(this, "00009", objectArray);
        }
    }

    protected final boolean isNumeric() {
        return true;
    }

    protected final int intValue() {
        int n;
        try {
            String string = this.getValue();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException e) {
            throw new InvalidEditorFieldException(this, "00006", new Object[0]);
        }
        return n;
    }
}

