/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util.ipp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.util.base.InconsistencyException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kopi/galite/visual/util/ipp/IPPInputStream;", "", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "peekByte", "", "peekShortAfterFirstByte", "", "read", "", "readArray", "", "readByte", "readInteger", "readLine", "", "readShort", "readString", "length", "verify", "", "galite-core"})
public final class IPPInputStream {
    @NotNull
    private final InputStream inputStream;

    public IPPInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.inputStream = inputStream;
    }

    public final byte peekByte() {
        this.verify();
        this.inputStream.mark(1);
        int read = this.read();
        this.inputStream.reset();
        return (byte)read;
    }

    public final short peekShortAfterFirstByte() {
        int i = 0;
        this.verify();
        this.inputStream.mark(3);
        this.read();
        i |= this.read() << 8;
        this.inputStream.reset();
        return (short)(i |= this.read());
    }

    public final byte readByte() {
        return (byte)this.read();
    }

    public final short readShort() {
        short i;
        short s = i = 0;
        short s2 = (short)(this.read() << 8);
        boolean bl = false;
        s = i = (short)(s | s2);
        s2 = (short)this.read();
        bl = false;
        i = (short)(s | s2);
        return i;
    }

    public final int readInteger() {
        int i = 0;
        i |= this.read() << 24;
        i |= this.read() << 16;
        i |= this.read() << 8;
        return i |= this.read();
    }

    @NotNull
    public final String readString(int length) {
        byte[] buf = new byte[length];
        int nread = this.inputStream.read(buf, 0, length);
        if (nread != length) {
            throw new IOException("Error reading socket: unexpected end of transmission");
        }
        boolean bl = false;
        return new String(buf, Charsets.UTF_8);
    }

    @Nullable
    public final String readLine() {
        StringBuffer sb = new StringBuffer();
        int c = 0;
        boolean end = false;
        while (!end) {
            c = this.read();
            if (c == -1 || c == 10) {
                end = true;
                continue;
            }
            if (c == 13) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    @NotNull
    public final byte[] readArray() {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int nread = 0;
        while (true) {
            int n = this.inputStream.read(buf);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            nread = it;
            if (n <= 0) break;
            outputStream.write(buf, 0, nread);
        }
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }

    private final int read() {
        int c = this.inputStream.read();
        if (c == -1) {
            throw new IOException("Error reading socket: unexpected end of transmission");
        }
        return c;
    }

    private final void verify() {
        if (!this.inputStream.markSupported()) {
            throw new InconsistencyException("Mark is not supported");
        }
    }
}

