/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.db;

import java.sql.SQLException;
import java.util.NoSuchElementException;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.DatabaseConfig;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.kopi.galite.visual.db.ConnectionKt;
import org.kopi.galite.visual.db.Users;
import org.kopi.galite.visual.util.base.InconsistencyException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB=\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000eB%\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\"\u001a\u00020\u001cJ\b\u0010#\u001a\u00020$H\u0002R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0013\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019\u00a8\u0006&"}, d2={"Lorg/kopi/galite/visual/db/Connection;", "", "connection", "Ljava/sql/Connection;", "lookupUserId", "", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "(Ljava/sql/Connection;ZLorg/jetbrains/exposed/sql/Schema;)V", "url", "", "driver", "userName", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/exposed/sql/Schema;)V", "dataSource", "Ljavax/sql/DataSource;", "(Ljavax/sql/DataSource;ZLorg/jetbrains/exposed/sql/Schema;)V", "dbConnection", "Lorg/jetbrains/exposed/sql/Database;", "getDbConnection", "()Lorg/jetbrains/exposed/sql/Database;", "setDbConnection", "(Lorg/jetbrains/exposed/sql/Database;)V", "getPassword", "()Ljava/lang/String;", "getUrl", "user", "", "getUser", "()I", "setUser", "(I)V", "getUserName", "getUserID", "setUserID", "", "Companion", "galite-core"})
public final class Connection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final String userName;
    @Nullable
    private final String password;
    @NotNull
    private Database dbConnection;
    private int user;
    private static final int USERID_TO_DETERMINE = -1;
    private static final int USERID_NO_LOOKUP = -2;

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getUserName() {
        return this.userName;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    @NotNull
    public final Database getDbConnection() {
        return this.dbConnection;
    }

    public final void setDbConnection(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"<set-?>");
        this.dbConnection = database;
    }

    public final int getUser() {
        return this.user;
    }

    public final void setUser(int n) {
        this.user = n;
    }

    public Connection(final @NotNull java.sql.Connection connection, boolean lookupUserId, @Nullable Schema schema) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        DatabaseConfig configuration = ConnectionKt.databaseConfig(schema);
        this.dbConnection = Database.Companion.connect$default((Database.Companion)Database.Companion, (Function0)((Function0)new Function0<java.sql.Connection>(){

            @NotNull
            public final java.sql.Connection invoke() {
                return connection;
            }
        }), (DatabaseConfig)configuration, null, (int)4, null);
        this.url = this.dbConnection.getUrl();
        String string = connection.getMetaData().getUserName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.metaData.userName");
        this.userName = string;
        this.password = null;
        this.user = !lookupUserId ? -2 : -1;
        this.setUserID();
    }

    public /* synthetic */ Connection(java.sql.Connection connection, boolean bl, Schema schema, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            schema = null;
        }
        this(connection, bl, schema);
    }

    public Connection(@NotNull String url, @NotNull String driver, @NotNull String userName, @NotNull String password, boolean lookupUserId, @Nullable Schema schema) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        DatabaseConfig configuration = ConnectionKt.databaseConfig(schema);
        this.dbConnection = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)url, (String)driver, (String)userName, (String)password, null, (DatabaseConfig)configuration, null, (int)80, null);
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.user = !lookupUserId ? -2 : -1;
        this.setUserID();
    }

    public /* synthetic */ Connection(String string, String string2, String string3, String string4, boolean bl, Schema schema, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            schema = null;
        }
        this(string, string2, string3, string4, bl, schema);
    }

    public Connection(@NotNull DataSource dataSource, boolean lookupUserId, @Nullable Schema schema) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        DatabaseConfig configuration = ConnectionKt.databaseConfig(schema);
        this.dbConnection = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)dataSource, null, (DatabaseConfig)configuration, null, (int)10, null);
        this.url = this.dbConnection.getUrl();
        String string = dataSource.getConnection().getMetaData().getUserName();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        this.userName = string2;
        this.user = !lookupUserId ? -2 : -1;
        this.password = null;
    }

    public /* synthetic */ Connection(DataSource dataSource, boolean bl, Schema schema, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            schema = null;
        }
        this(dataSource, bl, schema);
    }

    public final int getUserID() {
        int n = this.user;
        switch (n) {
            case -2: {
                throw new InconsistencyException("user id must not be queried");
            }
            case -1: {
                throw new InconsistencyException("user id not yet determined");
            }
        }
        return this.user;
    }

    private final void setUserID() {
        if (this.user != -2) {
            if (Intrinsics.areEqual((Object)this.userName, (Object)"root") || Intrinsics.areEqual((Object)this.userName, (Object)"lgvplus") || Intrinsics.areEqual((Object)this.userName, (Object)"tbadmin") || Intrinsics.areEqual((Object)this.userName, (Object)"dba")) {
                this.user = -2;
            } else {
                try {
                    ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new Function1<Transaction, Unit>(this){
                        final /* synthetic */ Connection this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull Transaction $this$transaction) {
                            void $this$invoke_u24lambda_u2d0;
                            void $this$select$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                            FieldSet fieldSet = Users.INSTANCE.slice((Expression)Users.INSTANCE.getId(), new Expression[0]);
                            Connection connection = this.this$0;
                            boolean $i$f$select = false;
                            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
                            void var8_6 = $this$select$iv;
                            Connection connection2 = this.this$0;
                            boolean bl = false;
                            Op op = $this$invoke_u24lambda_u2d0.eq((ExpressionWithColumnType)Users.INSTANCE.getShortName(), (Object)connection.getUserName());
                            connection2.setUser(((Number)((ResultRow)CollectionsKt.single((Iterable)((Iterable)QueriesKt.select((FieldSet)var8_6, (Op)op)))).get((Expression)Users.INSTANCE.getId())).intValue());
                        }
                    }), (int)1, null);
                }
                catch (NoSuchElementException e) {
                    throw new SQLException("user unknown");
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException("different users with same name");
                }
                catch (SQLException e) {
                    String string = e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    throw new InconsistencyException(string);
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kopi/galite/visual/db/Connection$Companion;", "", "()V", "USERID_NO_LOOKUP", "", "USERID_TO_DETERMINE", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

