/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.report;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.report.MReport;
import org.kopi.galite.visual.report.PConfig;
import org.kopi.galite.visual.report.Parameters;
import org.kopi.galite.visual.report.UReport;
import org.kopi.galite.visual.report.VGroupRow;
import org.kopi.galite.visual.report.VReportColumn;
import org.kopi.galite.visual.report.VReportRow;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*J\u0010\u0010(\u001a\u00020%2\u0006\u0010+\u001a\u00020,H$J\b\u0010-\u001a\u00020%H\u0004J\b\u0010.\u001a\u00020%H\u0004J\u001d\u0010.\u001a\u00020%2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t00H$\u00a2\u0006\u0002\u00101J=\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u000e2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t002\u000e\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u000105002\u0006\u00106\u001a\u000207H$\u00a2\u0006\u0002\u00108J\u0018\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u00109\u001a\u00020\u000bH\u0014J \u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u000bH\u0004J\u001d\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b?J\u0006\u0010@\u001a\u00020%J\u001d\u0010A\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\bBJ\u001d\u0010C\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\bDJ\u001d\u0010E\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\bFJ\u001d\u0010G\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\bHJ\u001d\u0010I\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\bJJ\u001d\u0010K\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\bLJ\u001d\u0010M\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\bNJ\u001d\u0010O\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\bPJ\u000e\u0010Q\u001a\u00020R2\u0006\u00103\u001a\u00020\u000eJ\u000e\u0010S\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u000eJ\u0010\u0010T\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010U\u001a\u00020%2\b\u0010V\u001a\u0004\u0018\u00010\tH$J\u0006\u0010\n\u001a\u00020\u000bR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006W"}, d2={"Lorg/kopi/galite/visual/report/PExport;", "Ljava/io/Serializable;", "table", "Lorg/kopi/galite/visual/report/UReport$UTable;", "model", "Lorg/kopi/galite/visual/report/MReport;", "printConfig", "Lorg/kopi/galite/visual/report/PConfig;", "title", "", "tonerSaveMode", "", "(Lorg/kopi/galite/visual/report/UReport$UTable;Lorg/kopi/galite/visual/report/MReport;Lorg/kopi/galite/visual/report/PConfig;Ljava/lang/String;Z)V", "<set-?>", "", "columnCount", "getColumnCount", "()I", "firstVisibleColumn", "maxLevel", "getMaxLevel", "minLevel", "getModel", "()Lorg/kopi/galite/visual/report/MReport;", "parameters", "Lorg/kopi/galite/visual/report/Parameters;", "getPrintConfig", "()Lorg/kopi/galite/visual/report/PConfig;", "getTable", "()Lorg/kopi/galite/visual/report/UReport$UTable;", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "getTonerSaveMode", "()Z", "addTree", "", "row", "Lorg/kopi/galite/visual/report/VReportRow;", "export", "file", "Ljava/io/File;", "stream", "Ljava/io/OutputStream;", "exportData", "exportHeader", "data", "", "([Ljava/lang/String;)V", "exportRow", "level", "orig", "", "alignments", "", "(I[Ljava/lang/String;[Ljava/lang/Object;[I)V", "tail", "lineBreak", "formatBooleanColumn", "column", "Lorg/kopi/galite/visual/report/VReportColumn;", "index", "formatBooleanColumn$galite_core", "formatColumns", "formatDateColumn", "formatDateColumn$galite_core", "formatDecimalColumn", "formatDecimalColumn$galite_core", "formatIntegerColumn", "formatIntegerColumn$galite_core", "formatMonthColumn", "formatMonthColumn$galite_core", "formatStringColumn", "formatStringColumn$galite_core", "formatTimeColumn", "formatTimeColumn$galite_core", "formatTimestampColumn", "formatTimestampColumn$galite_core", "formatWeekColumn", "formatWeekColumn$galite_core", "getBackgroundForLevel", "Ljava/awt/Color;", "getColumnLabel", "getMinLevel", "startGroup", "subTitle", "galite-core"})
public abstract class PExport
implements Serializable {
    @NotNull
    private final UReport.UTable table;
    @NotNull
    private final MReport model;
    @NotNull
    private final PConfig printConfig;
    @NotNull
    private String title;
    private final boolean tonerSaveMode;
    private int columnCount;
    private int firstVisibleColumn;
    private int maxLevel;
    private int minLevel;
    @NotNull
    private final Parameters parameters;

    public PExport(@NotNull UReport.UTable table, @NotNull MReport model2, @NotNull PConfig printConfig, @NotNull String title, boolean tonerSaveMode) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)printConfig, (String)"printConfig");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.table = table;
        this.model = model2;
        this.printConfig = printConfig;
        this.title = title;
        this.tonerSaveMode = tonerSaveMode;
        this.firstVisibleColumn = -1;
        Color color = Color.blue;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"blue");
        this.parameters = new Parameters(color);
        int n = 0;
        int n2 = this.model.getAccessibleColumnCount();
        if (n < n2) {
            do {
                VReportColumn column2;
                int j = n++;
                int visibleColumn = this.table.convertColumnIndexToModel(j);
                VReportColumn vReportColumn = column2 = this.model.getAccessibleColumn(visibleColumn);
                Intrinsics.checkNotNull((Object)vReportColumn);
                if (!vReportColumn.isVisible() || column2.isFolded()) continue;
                if (this.firstVisibleColumn == -1) {
                    this.firstVisibleColumn = j;
                }
                PExport pExport = this;
                ++pExport.columnCount;
            } while (n < n2);
        }
        if (this.printConfig.getGroupFormfeed()) {
            PExport pExport = this;
            --pExport.columnCount;
        }
        VGroupRow vGroupRow = this.model.getTree();
        Intrinsics.checkNotNull((Object)vGroupRow);
        this.maxLevel = vGroupRow.getLevel();
    }

    public /* synthetic */ PExport(UReport.UTable uTable, MReport mReport, PConfig pConfig, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(uTable, mReport, pConfig, string, bl);
    }

    @NotNull
    public final UReport.UTable getTable() {
        return this.table;
    }

    @NotNull
    public final MReport getModel() {
        return this.model;
    }

    @NotNull
    public final PConfig getPrintConfig() {
        return this.printConfig;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.title = string;
    }

    public final boolean getTonerSaveMode() {
        return this.tonerSaveMode;
    }

    public final int getColumnCount() {
        return this.columnCount;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    public final void formatColumns() {
        int index = 0;
        int n = 0;
        int n2 = this.model.getAccessibleColumnCount();
        if (n < n2) {
            do {
                VReportColumn column2;
                int j = n++;
                int visibleColumn = this.table.convertColumnIndexToModel(j);
                VReportColumn vReportColumn = column2 = this.model.getAccessibleColumn(visibleColumn);
                Intrinsics.checkNotNull((Object)vReportColumn);
                if (!vReportColumn.isVisible() || column2.isFolded() || this.printConfig.getGroupFormfeed() && j == this.firstVisibleColumn) continue;
                column2.formatColumn(this, index);
                ++index;
            } while (n < n2);
        }
    }

    protected final void exportHeader() {
        String[] data = new String[this.columnCount];
        int index = 0;
        int n = 0;
        int n2 = this.model.getAccessibleColumnCount();
        if (n < n2) {
            do {
                VReportColumn column2;
                int j = n++;
                int visibleColumn = this.table.convertColumnIndexToModel(j);
                VReportColumn vReportColumn = column2 = this.model.getAccessibleColumn(visibleColumn);
                Intrinsics.checkNotNull((Object)vReportColumn);
                if (!vReportColumn.isVisible() || column2.isFolded() || this.printConfig.getGroupFormfeed() && j == this.firstVisibleColumn) continue;
                data[index] = column2.getLabel();
                ++index;
            } while (n < n2);
        }
        this.exportHeader(data);
    }

    protected final void exportData() {
        VGroupRow group = this.model.getTree();
        if (!this.printConfig.getGroupFormfeed()) {
            this.startGroup(null);
            this.exportHeader();
        }
        VGroupRow vGroupRow = group;
        Intrinsics.checkNotNull((Object)vGroupRow);
        this.minLevel = this.getMinLevel(vGroupRow);
        this.addTree(group);
    }

    /*
     * WARNING - void declaration
     */
    private final int getMinLevel(VReportRow row) {
        int n;
        if (row.getVisible() || !this.printConfig.getVisibleRows()) {
            void var2_2;
            int curr = row.getLevel();
            int n2 = 0;
            int n3 = row.getChildCount();
            if (n2 < n3) {
                do {
                    int i;
                    TreeNode treeNode;
                    if ((treeNode = row.getChildAt(i = n2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                    }
                    int childMinLevel = this.getMinLevel((VReportRow)treeNode);
                    if (childMinLevel >= curr) continue;
                    curr = childMinLevel;
                } while (n2 < n3);
            }
            n = var2_2;
        } else {
            n = this.maxLevel;
        }
        return n;
    }

    private final void addTree(VReportRow row) {
        boolean restrictedRow = this.printConfig.getVisibleRows();
        if (row.getVisible() || !restrictedRow) {
            int n;
            int n2;
            if (this.printConfig.getGroupFormfeed() && row.getLevel() == this.maxLevel - 1) {
                VReportColumn column2;
                VReportColumn vReportColumn = column2 = this.model.getAccessibleColumn(this.firstVisibleColumn);
                Intrinsics.checkNotNull((Object)vReportColumn);
                this.startGroup(vReportColumn.format(row.getValueAt(this.table.convertColumnIndexToModel(this.firstVisibleColumn))));
                this.exportHeader();
            }
            if (this.printConfig.getOrder() != 2) {
                this.exportRow(row, false);
            }
            if ((n2 = 0) < (n = row.getChildCount())) {
                do {
                    int i;
                    TreeNode treeNode;
                    if ((treeNode = row.getChildAt(i = n2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                    }
                    this.addTree((VReportRow)treeNode);
                } while (n2 < n);
            }
            if (this.printConfig.getOrder() == 2) {
                this.exportRow(row, true);
            }
        }
    }

    protected void exportRow(@NotNull VReportRow row, boolean tail) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        this.exportRow(row, tail, false);
    }

    protected final void exportRow(@NotNull VReportRow row, boolean tail, boolean lineBreak) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        int index = 0;
        String[] newRow = new String[this.columnCount];
        Object[] newRowOrig = new Object[this.columnCount];
        int[] alignments = new int[this.columnCount];
        int n = 0;
        int n2 = this.model.getAccessibleColumnCount();
        if (n < n2) {
            do {
                VReportColumn column2;
                int i = n++;
                int visibleColumn = this.table.convertColumnIndexToModel(i);
                VReportColumn vReportColumn = column2 = this.model.getAccessibleColumn(visibleColumn);
                Intrinsics.checkNotNull((Object)vReportColumn);
                if (vReportColumn.isFolded() || !column2.isVisible() || this.printConfig.getGroupFormfeed() && i == this.firstVisibleColumn) continue;
                if (row.getLevel() < this.model.getDisplayLevels(this.model.getReverseOrder(visibleColumn))) {
                    newRow[index] = null;
                    newRowOrig[index] = null;
                } else {
                    newRow[index] = lineBreak ? column2.formatWithLineBreaker(row.getValueAt(visibleColumn)) : column2.format(row.getValueAt(visibleColumn));
                    newRowOrig[index] = row.getValueAt(visibleColumn);
                }
                alignments[index] = column2.getAlign();
                ++index;
            } while (n < n2);
        }
        if (tail && row.getParent() != null) {
            TreeNode treeNode = row.getParent();
            if (treeNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
            }
            if (((VReportRow)treeNode).getFirstChild() == row && row.getChildCount() == 0) {
                VReportRow parent;
                VReportRow child = row;
                TreeNode treeNode2 = row.getParent();
                VReportRow vReportRow = parent = treeNode2 instanceof VReportRow ? (VReportRow)treeNode2 : null;
                while (parent != null && parent.getFirstChild() == child) {
                    index = 0;
                    int n3 = 0;
                    int n4 = this.model.getAccessibleColumnCount();
                    if (n3 < n4) {
                        do {
                            VReportColumn column3;
                            int i = n3++;
                            int visibleColumn = this.table.convertColumnIndexToModel(i);
                            VReportColumn vReportColumn = column3 = this.model.getAccessibleColumn(visibleColumn);
                            Intrinsics.checkNotNull((Object)vReportColumn);
                            if (vReportColumn.isFolded() || !column3.isVisible() || this.printConfig.getGroupFormfeed() && i == this.firstVisibleColumn) continue;
                            if (row.getLevel() < this.model.getDisplayLevels(this.model.getReverseOrder(visibleColumn)) && parent.getLevel() >= this.model.getDisplayLevels(this.model.getReverseOrder(visibleColumn))) {
                                newRow[index] = lineBreak ? column3.formatWithLineBreaker(row.getValueAt(visibleColumn)) : column3.format(row.getValueAt(visibleColumn));
                                newRowOrig[index] = row.getValueAt(visibleColumn);
                            }
                            ++index;
                        } while (n3 < n4);
                    }
                    child = parent;
                    treeNode2 = parent.getParent();
                    parent = treeNode2 instanceof VReportRow ? (VReportRow)treeNode2 : null;
                }
            }
        }
        this.exportRow(row.getLevel() - this.minLevel, newRow, newRowOrig, alignments);
    }

    public final void export(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            this.export(new FileOutputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void startGroup(@Nullable String var1);

    protected abstract void exportRow(int var1, @NotNull String[] var2, @NotNull Object[] var3, @NotNull int[] var4);

    protected abstract void exportHeader(@NotNull String[] var1);

    protected abstract void export(@NotNull OutputStream var1);

    public void formatStringColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
    }

    public void formatDateColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
    }

    public void formatMonthColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
    }

    public void formatWeekColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
    }

    public void formatDecimalColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
    }

    public void formatIntegerColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
    }

    public void formatBooleanColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
    }

    public void formatTimeColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
    }

    public void formatTimestampColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
    }

    @NotNull
    public final String getColumnLabel(int column2) {
        VReportColumn vReportColumn = this.model.getAccessibleColumn(this.table.convertColumnIndexToModel(column2));
        Intrinsics.checkNotNull((Object)vReportColumn);
        return vReportColumn.getLabel();
    }

    @NotNull
    public final Color getBackgroundForLevel(int level) {
        return this.parameters.getBackground(level);
    }

    public final boolean tonerSaveMode() {
        return this.tonerSaveMode;
    }
}

