/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.type;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.type.Date;
import org.kopi.galite.visual.type.Type;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 %2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002J\u0011\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0013\u001a\u00020\u0000J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0007H\u0017J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0002H\u0016J\b\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010 \u001a\u00020\u0002H\u0016J\u000e\u0010!\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0000J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/kopi/galite/visual/type/Month;", "Lorg/kopi/galite/visual/type/Type;", "", "year", "month", "(II)V", "date", "Lorg/kopi/galite/visual/type/Date;", "(Lorg/kopi/galite/visual/type/Date;)V", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;)V", "scalar", "(I)V", "add", "months", "addTo", "", "compareTo", "other", "copy", "equals", "", "", "format", "", "locale", "Ljava/util/Locale;", "getDate", "getFirstDay", "getLastDay", "getMonth", "getYear", "hashCode", "subtract", "toSql", "Ljava/sql/Date;", "toString", "Companion", "galite-core"})
public class Month
extends Type<Month, Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int scalar;
    @NotNull
    private static final Month DEFAULT = new Month(1900, 1);

    public Month(int scalar) {
        this.scalar = scalar;
    }

    public Month(int year, int month) {
        this(year * 12 + month - 1);
    }

    public Month(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this(date.getYear(), date.getMonth());
    }

    public Month(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this(date.getYear(), date.getMonthValue());
    }

    @NotNull
    public final String format(@NotNull String format2, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, this.getYear());
        cal.set(2, this.getMonth() - 1);
        cal.set(5, 1);
        String string = new SimpleDateFormat(format2, locale).format(cal.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(format, locale).format(cal.time)");
        return string;
    }

    public static /* synthetic */ String format$default(Month month, String string, Locale locale, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: format");
        }
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return month.format(string, locale);
    }

    @NotNull
    public final Month copy() {
        return new Month(this.scalar / 12, this.scalar % 12 + 1);
    }

    public final void addTo(int months) {
        Month month = this;
        month.scalar += months;
    }

    @NotNull
    public final Month add(int months) {
        return new Month((this.scalar + months) / 12, (this.scalar + months) % 12 + 1);
    }

    public final int subtract(@NotNull Month other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.scalar - other.scalar;
    }

    @Override
    public int compareTo(@NotNull Month other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int v1 = this.scalar;
        int v2 = other.scalar;
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    public int getYear() {
        return this.scalar / 12;
    }

    public int getMonth() {
        return this.scalar % 12 + 1;
    }

    @NotNull
    public Date getFirstDay() {
        return new Date(this.scalar / 12, this.scalar % 12 + 1, 1);
    }

    @NotNull
    public Date getLastDay() {
        return new Date((this.scalar + 1) / 12, (this.scalar + 1) % 12 + 1, 1).add(-1);
    }

    @Deprecated(message="")
    @NotNull
    public Date getDate() {
        return this.getFirstDay();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other == null ? true : other instanceof Month)) return false;
        int n = this.scalar;
        Month month = (Month)other;
        if (month == null) {
            return false;
        }
        if (n != month.scalar) return false;
        return true;
    }

    @Override
    @NotNull
    public String toString(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        int year = this.scalar / 12;
        int month = this.scalar % 12 + 1;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        $this$toString_u24lambda_u2d0.append(month / 10);
        $this$toString_u24lambda_u2d0.append(month % 10);
        $this$toString_u24lambda_u2d0.append('.');
        $this$toString_u24lambda_u2d0.append(year);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public java.sql.Date toSql() {
        int year = this.scalar / 12;
        int month = this.scalar % 12 + 1;
        return this.getDate().toSql();
    }

    public int hashCode() {
        return this.scalar;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/kopi/galite/visual/type/Month$Companion;", "", "()V", "DEFAULT", "Lorg/kopi/galite/visual/type/Month;", "getDEFAULT", "()Lorg/kopi/galite/visual/type/Month;", "now", "parse", "input", "", "format", "locale", "Ljava/util/Locale;", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Month now() {
            Calendar now = Calendar.getInstance();
            return new Month(now.get(1), now.get(2) + 1);
        }

        @NotNull
        public final Month parse(@NotNull String input, @NotNull String format2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            return this.parse(input, format2, locale);
        }

        @NotNull
        public final Month parse(@NotNull String input, @NotNull String format2, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            GregorianCalendar cal = new GregorianCalendar();
            try {
                cal.setTime(new SimpleDateFormat(format2, locale).parse(input));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException();
            }
            return new Month(cal.get(1), cal.get(2) + 1);
        }

        @NotNull
        public final Month getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

