/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.report;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.report.UReport;
import org.kopi.galite.visual.report.VDecimalColumn;
import org.kopi.galite.visual.report.VIntegerColumn;
import org.kopi.galite.visual.report.VReportColumn;
import org.kopi.galite.visual.report.VSeparatorColumn;
import org.kopi.galite.visual.ui.vaadin.report.ColumnStyleGenerator;
import org.kopi.galite.visual.ui.vaadin.report.DReport;
import org.kopi.galite.visual.ui.vaadin.report.ReportCellStyler;
import org.kopi.galite.visual.ui.vaadin.report.VTable;

@CssImport.Container(value={@CssImport(value="./styles/galite/report.css"), @CssImport(value="./styles/galite/report.css", themeFor="vaadin-grid")})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u00012\u00020\u0004:\u0001:B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010$\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u00102\u0006\u0010%\u001a\u00020\u00172\b\b\u0002\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0017H\u0016J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0017H\u0016J\u0006\u0010.\u001a\u00020\u0017J \u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0010\u00101\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0010J\u001a\u00102\u001a\u00020)2\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0010H\u0016J\u0010\u00103\u001a\u00020)2\u0006\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u00020)J\u0010\u00107\u001a\u00020)2\u0006\u00108\u001a\u00020\u0017H\u0002J\u0006\u00109\u001a\u00020)R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006;"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/report/DTable;", "Lcom/vaadin/flow/component/grid/Grid;", "Lorg/kopi/galite/visual/ui/vaadin/report/DReport$ReportModelItem;", "Lorg/kopi/galite/visual/ui/vaadin/report/DReport;", "Lorg/kopi/galite/visual/report/UReport$UTable;", "model", "Lorg/kopi/galite/visual/ui/vaadin/report/VTable;", "(Lorg/kopi/galite/visual/ui/vaadin/report/VTable;)V", "cellStyler", "Lorg/kopi/galite/visual/ui/vaadin/report/ReportCellStyler;", "getCellStyler", "()Lorg/kopi/galite/visual/ui/vaadin/report/ReportCellStyler;", "setCellStyler", "(Lorg/kopi/galite/visual/ui/vaadin/report/ReportCellStyler;)V", "columnToHeaderMap", "", "Lcom/vaadin/flow/component/grid/Grid$Column;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "getColumnToHeaderMap", "()Ljava/util/Map;", "getModel", "()Lorg/kopi/galite/visual/ui/vaadin/report/VTable;", "selectedColumn", "", "getSelectedColumn", "()I", "setSelectedColumn", "(I)V", "selectedRow", "getSelectedRow", "viewColumns", "", "getViewColumns", "()Ljava/util/List;", "setViewColumns", "(Ljava/util/List;)V", "addColumn", "key", "column", "Lorg/kopi/galite/visual/report/VReportColumn;", "buildColumns", "", "convertColumnIndexToModel", "viewColumnIndex", "convertColumnIndexToView", "modelColumnIndex", "getColumnCount", "getColumnNameComponent", "Lcom/vaadin/flow/component/Component;", "gridColumn", "removeColumn", "removeColumnByKey", "columnKey", "", "resetCachedInfos", "resetColumnSize", "pos", "resetWidth", "ColumnValueProvider", "galite-core"})
public final class DTable
extends Grid<DReport.ReportModelItem>
implements UReport.UTable {
    @NotNull
    private final VTable model;
    private int selectedColumn;
    @NotNull
    private List<Integer> viewColumns;
    @NotNull
    private final Map<Grid.Column<?>, VerticalLayout> columnToHeaderMap;
    public ReportCellStyler cellStyler;

    public DTable(@NotNull VTable model2) {
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        this.model = model2;
        this.selectedColumn = -1;
        boolean bl = false;
        this.viewColumns = new ArrayList();
        bl = false;
        this.columnToHeaderMap = new LinkedHashMap();
        this.setItems(this.model);
        this.buildColumns();
        GridVariant[] gridVariantArray = new GridVariant[]{GridVariant.LUMO_COMPACT, GridVariant.LUMO_COLUMN_BORDERS};
        this.addThemeVariants(gridVariantArray);
        this.getThemeNames().add((Object)"report");
        this.getClassNames().add((Object)"small");
        this.getClassNames().add((Object)"borderless");
        this.getClassNames().add((Object)"report");
        this.setWidthFull();
    }

    @NotNull
    public final VTable getModel() {
        return this.model;
    }

    public final int getSelectedRow() {
        int n;
        DReport.ReportModelItem reportModelItem = (DReport.ReportModelItem)this.asSingleSelect().getValue();
        return reportModelItem == null ? -1 : (n = reportModelItem.getRowIndex());
    }

    public final int getSelectedColumn() {
        return this.selectedColumn;
    }

    public final void setSelectedColumn(int n) {
        this.selectedColumn = n;
    }

    @NotNull
    public final List<Integer> getViewColumns() {
        return this.viewColumns;
    }

    public final void setViewColumns(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.viewColumns = list;
    }

    @NotNull
    public final Map<Grid.Column<?>, VerticalLayout> getColumnToHeaderMap() {
        return this.columnToHeaderMap;
    }

    @NotNull
    public final ReportCellStyler getCellStyler() {
        ReportCellStyler reportCellStyler = this.cellStyler;
        if (reportCellStyler != null) {
            return reportCellStyler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cellStyler");
        return null;
    }

    public final void setCellStyler(@NotNull ReportCellStyler reportCellStyler) {
        Intrinsics.checkNotNullParameter((Object)reportCellStyler, (String)"<set-?>");
        this.cellStyler = reportCellStyler;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildColumns() {
        VReportColumn[] $this$forEachIndexed$iv = this.model.getAccessibleColumns();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (VReportColumn item$iv : $this$forEachIndexed$iv) {
            void column2;
            int n = index$iv++;
            VReportColumn vReportColumn = item$iv;
            int index = n;
            boolean bl = false;
            void v1 = column2;
            Intrinsics.checkNotNull((Object)v1);
            Grid.Column<DReport.ReportModelItem> gridColumn = this.addColumn(index, (VReportColumn)v1);
            gridColumn.setHeader(this.getColumnNameComponent((VReportColumn)column2, gridColumn));
            gridColumn.setFlexGrow(0);
        }
    }

    @NotNull
    public final Component getColumnNameComponent(@NotNull VReportColumn column2, @NotNull Grid.Column<DReport.ReportModelItem> gridColumn) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter(gridColumn, (String)"gridColumn");
        VerticalLayout verticalLayout = new VerticalLayout[]{(Component)new Span(column2.getLabel())};
        verticalLayout = new VerticalLayout((Component[])verticalLayout);
        boolean bl = false;
        boolean bl2 = false;
        VerticalLayout it = verticalLayout;
        boolean bl3 = false;
        it.getElement().setProperty("title", column2.getHelp());
        Map<Grid.Column<?>, VerticalLayout> map = this.getColumnToHeaderMap();
        boolean bl4 = false;
        map.put(gridColumn, it);
        return (Component)verticalLayout;
    }

    @Override
    public int convertColumnIndexToModel(int viewColumnIndex) {
        return ((Number)this.viewColumns.get(viewColumnIndex)).intValue();
    }

    @Override
    public int convertColumnIndexToView(int modelColumnIndex) {
        return this.viewColumns.indexOf(modelColumnIndex);
    }

    @NotNull
    public final Grid.Column<DReport.ReportModelItem> addColumn(int key, @NotNull VReportColumn column2) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        ColumnValueProvider provider = new ColumnValueProvider(key, column2);
        this.viewColumns.add(key);
        Grid.Column column3 = this.addColumn(provider, new String[0]);
        boolean bl = false;
        boolean bl2 = false;
        Grid.Column it = column3;
        boolean bl3 = false;
        provider.setColumn((Grid.Column<DReport.ReportModelItem>)it);
        ((Grid.Column)it.setKey(String.valueOf(key)).setResizable(true)).setClassNameGenerator((SerializableFunction)new ColumnStyleGenerator(this.getModel().getModel$galite_core(), column2)).setSortable(false);
        Grid.Column column4 = column3;
        Intrinsics.checkNotNullExpressionValue((Object)column4, (String)"addColumn(provider).also\u2026.setSortable(false)\n    }");
        return column4;
    }

    public static /* synthetic */ Grid.Column addColumn$default(DTable dTable, int n, VReportColumn vReportColumn, int n2, Object object) {
        if ((n2 & 2) != 0) {
            VReportColumn vReportColumn2 = dTable.model.getAccessibleColumns()[n];
            Intrinsics.checkNotNull((Object)vReportColumn2);
            vReportColumn = vReportColumn2;
        }
        return dTable.addColumn(n, vReportColumn);
    }

    public void removeColumnByKey(@NotNull String columnKey) {
        Intrinsics.checkNotNullParameter((Object)columnKey, (String)"columnKey");
        String string = columnKey;
        boolean bl = false;
        this.viewColumns.remove((Object)Integer.parseInt(string));
        super.removeColumnByKey(columnKey);
    }

    public void removeColumn(@NotNull Grid.Column<DReport.ReportModelItem> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        String string = column2.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"column.key");
        boolean bl = false;
        this.viewColumns.remove((Object)Integer.parseInt(string));
        super.removeColumn(column2);
    }

    public final int getColumnCount() {
        return this.model.getColumnCount();
    }

    public final void resetWidth() {
        int n = 0;
        int n2 = this.model.getColumnCount();
        if (n < n2) {
            do {
                int i = n++;
                this.resetColumnSize(i);
            } while (n < n2);
        }
    }

    private final void resetColumnSize(int pos) {
        VReportColumn column2 = this.model.getModel$galite_core().getAccessibleColumn(this.convertColumnIndexToModel(pos));
        int width = 0;
        VReportColumn vReportColumn = column2;
        Intrinsics.checkNotNull((Object)vReportColumn);
        if (vReportColumn.isFolded() && !(column2 instanceof VSeparatorColumn)) {
            width = 1;
        } else if (column2 instanceof VDecimalColumn || column2 instanceof VIntegerColumn) {
            width = RangesKt.coerceAtLeast((int)column2.getLabel().length(), (int)column2.getWidth());
            width = RangesKt.coerceAtLeast((int)width, (int)this.model.getModel$galite_core().computeColumnWidth(this.convertColumnIndexToModel(pos)));
        } else {
            width = RangesKt.coerceAtLeast((int)column2.getLabel().length(), (int)column2.getWidth());
        }
        if (width != 0) {
            width = width * 9 + 2;
        }
        ((Grid.Column)this.getColumns().get(pos)).setWidth(width + 12 + "px");
    }

    public final void resetCachedInfos() {
        this.selectedColumn = -1;
        this.select(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u0012\u0012\b\u0012\u00060\u0002R\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0010\u001a\u00020\u00042\n\u0010\u0011\u001a\u00060\u0002R\u00020\u0003H\u0016R&\u0010\n\u001a\u000e\u0012\b\u0012\u00060\u0002R\u00020\u0003\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/report/DTable$ColumnValueProvider;", "Lcom/vaadin/flow/function/ValueProvider;", "Lorg/kopi/galite/visual/ui/vaadin/report/DReport$ReportModelItem;", "Lorg/kopi/galite/visual/ui/vaadin/report/DReport;", "", "columnIndex", "", "columnModel", "Lorg/kopi/galite/visual/report/VReportColumn;", "(Lorg/kopi/galite/visual/ui/vaadin/report/DTable;ILorg/kopi/galite/visual/report/VReportColumn;)V", "column", "Lcom/vaadin/flow/component/grid/Grid$Column;", "getColumn", "()Lcom/vaadin/flow/component/grid/Grid$Column;", "setColumn", "(Lcom/vaadin/flow/component/grid/Grid$Column;)V", "apply", "source", "galite-core"})
    public final class ColumnValueProvider
    implements ValueProvider<DReport.ReportModelItem, String> {
        private final int columnIndex;
        @NotNull
        private final VReportColumn columnModel;
        @Nullable
        private Grid.Column<DReport.ReportModelItem> column;

        public ColumnValueProvider(@NotNull int columnIndex, VReportColumn columnModel) {
            Intrinsics.checkNotNullParameter((Object)DTable.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)columnModel, (String)"columnModel");
            this.columnIndex = columnIndex;
            this.columnModel = columnModel;
        }

        @Nullable
        public final Grid.Column<DReport.ReportModelItem> getColumn() {
            return this.column;
        }

        public final void setColumn(@Nullable Grid.Column<DReport.ReportModelItem> column2) {
            this.column = column2;
        }

        @NotNull
        public String apply(@NotNull DReport.ReportModelItem source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Grid.Column<DReport.ReportModelItem> column2 = this.column;
            if (column2 != null) {
                column2.setTextAlign(this.columnModel.getAlign() == 4 ? ColumnTextAlign.END : ColumnTextAlign.START);
            }
            DTable.this.getCellStyler().updateStyles(source.getRowIndex(), this.columnIndex);
            return source.getValueAt(this.columnIndex);
        }
    }
}

