/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util.ipp;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.util.ipp.IPP;
import org.kopi.galite.visual.util.ipp.IPPAttribute;
import org.kopi.galite.visual.util.ipp.IPPHttpConnection;
import org.kopi.galite.visual.util.ipp.IPPValue;
import org.kopi.galite.visual.util.ipp.IntegerValue;
import org.kopi.galite.visual.util.ipp.StringValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0017H\u0004J\u0006\u0010\u0019\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kopi/galite/visual/util/ipp/IPPClient;", "", "hostname", "", "port", "", "printer", "user", "(Ljava/lang/String;SLjava/lang/String;Ljava/lang/String;)V", "getMediaTypes", "", "getPrinterAttributes", "Lorg/kopi/galite/visual/util/ipp/IPP;", "print", "", "file", "Ljava/io/InputStream;", "nbCopies", "", "attributes", "", "(Ljava/io/InputStream;I[Ljava/lang/String;)V", "mediaAttributes", "", "optionalAttributes", "printPrinterAttributes", "galite-core"})
public final class IPPClient {
    @NotNull
    private final String hostname;
    private final short port;
    @NotNull
    private final String printer;
    @NotNull
    private final String user;

    public IPPClient(@NotNull String hostname, short port, @NotNull String printer, @NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.hostname = hostname;
        this.port = port;
        this.printer = printer;
        this.user = user;
    }

    public final void print(@NotNull InputStream file, int nbCopies, @Nullable String[] attributes) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean bl = false;
        List mediaAttributes = new ArrayList();
        boolean bl2 = false;
        List optionalAttributes = new ArrayList();
        String[] stringArray = attributes;
        if (stringArray != null) {
            String[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            String[] stringArray2 = $this$forEach$iv;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray2[i];
                boolean bl3 = false;
                if (StringsKt.indexOf$default((CharSequence)it, (char)'=', (int)0, (boolean)false, (int)6, null) != -1) {
                    optionalAttributes.add(it);
                    continue;
                }
                mediaAttributes.add(it);
            }
        }
        this.print(file, nbCopies, mediaAttributes, optionalAttributes);
    }

    protected final void print(@NotNull InputStream file, int nbCopies, @Nullable List<String> mediaAttributes, @Nullable List<String> optionalAttributes) {
        Collection<String> collection;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IPPAttribute att = null;
        IPP req = new IPP();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int read = 0;
        req.setRequest(1, (short)2);
        att = new IPPAttribute(1, 71, "attributes-charset");
        att.addValue(new StringValue("utf-8"));
        req.addAttribute(att);
        att = new IPPAttribute(1, 72, "attributes-natural-language");
        att.addValue(new StringValue("en"));
        req.addAttribute(att);
        att = new IPPAttribute(1, 69, "printer-uri");
        att.addValue(new StringValue("ipp://" + this.hostname + ':' + this.port + "/printers/" + this.printer));
        req.addAttribute(att);
        att = new IPPAttribute(1, 66, "requesting-user-name");
        att.addValue(new StringValue(this.user));
        req.addAttribute(att);
        att = new IPPAttribute(2, 33, "copies");
        att.addValue(new IntegerValue(1));
        req.addAttribute(att);
        if (mediaAttributes != null) {
            collection = mediaAttributes;
            boolean bl = false;
            if (!collection.isEmpty()) {
                att = new IPPAttribute(2, 68, "media");
                Iterable $this$forEach$iv = mediaAttributes;
                boolean $i$f$forEach = false;
                for (Iterator element$iv : $this$forEach$iv) {
                    String it = (String)((Object)element$iv);
                    boolean bl2 = false;
                    att.addValue(new StringValue(it));
                }
                req.addAttribute(att);
            }
        }
        if ((collection = optionalAttributes) != null) {
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String attributeValue;
                String attributeName;
                String optionalAttribute;
                String it = (String)element$iv;
                boolean bl = false;
                String string = optionalAttribute = it;
                int n = 0;
                int n2 = StringsKt.indexOf$default((CharSequence)optionalAttribute, (String)"=", (int)0, (boolean)false, (int)6, null);
                int n3 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string3 = optionalAttribute;
                n2 = StringsKt.indexOf$default((CharSequence)optionalAttribute, (String)"=", (int)0, (boolean)false, (int)6, null) + 1;
                n3 = optionalAttribute.length();
                boolean bl3 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string4.substring(n2, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                att = new IPPAttribute(2, 66, attributeName);
                att.addValue(new StringValue(attributeValue));
                req.addAttribute(att);
            }
        }
        while (true) {
            int n = file.read();
            boolean $this$forEach$iv = false;
            boolean $i$f$forEach = false;
            int it = n;
            boolean bl = false;
            read = it;
            if (n == -1) break;
            baos.write(read);
        }
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        req.setData(byArray);
        int n = 0;
        if (n < nbCopies) {
            do {
                int i = n++;
                IPP resp = null;
                IPPHttpConnection httpConnection = new IPPHttpConnection(new URL("http://" + this.hostname + ':' + this.port + "/printers/" + this.printer));
                httpConnection.sendRequest(req);
                resp = httpConnection.receiveResponse();
                resp.simpleDump();
            } while (n < nbCopies);
        }
    }

    public final void printPrinterAttributes() {
        IPP resp = this.getPrinterAttributes();
        resp.dump();
    }

    @NotNull
    public final List<?> getMediaTypes() {
        boolean bl = false;
        List media = new ArrayList();
        IPP properties = this.getPrinterAttributes();
        Iterator<?> attributes = properties.getAttributes();
        while (attributes.hasNext()) {
            Object obj = attributes.next();
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.util.ipp.IPPAttribute");
            }
            IPPAttribute attribute = (IPPAttribute)obj;
            if (!Intrinsics.areEqual((Object)attribute.getName(), (Object)"media-supported")) continue;
            Iterator<?> values = attribute.getValues();
            while (values.hasNext()) {
                Object obj2 = values.next();
                if (obj2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.util.ipp.IPPValue");
                }
                IPPValue value = (IPPValue)obj2;
                if (!(value instanceof StringValue)) continue;
                media.add(((StringValue)value).getValue());
            }
        }
        return media;
    }

    private final IPP getPrinterAttributes() {
        IPP req = new IPP();
        IPPHttpConnection httpConnection = new IPPHttpConnection(new URL("http://" + this.hostname + ':' + this.port + "/printers/" + this.printer));
        req.setRequest(1, (short)11);
        IPPAttribute att = new IPPAttribute(1, 71, "attributes-charset");
        att.addValue(new StringValue("iso-8859-1"));
        req.addAttribute(att);
        att = new IPPAttribute(1, 72, "attributes-natural-language");
        att.addValue(new StringValue("en"));
        req.addAttribute(att);
        att = new IPPAttribute(1, 69, "printer-uri");
        att.addValue(new StringValue("ipp://" + this.hostname + ':' + this.port + "/printers/" + this.printer));
        req.addAttribute(att);
        att = new IPPAttribute(1, 66, "printer-name");
        att.addValue(new StringValue(this.printer));
        req.addAttribute(att);
        httpConnection.sendRequest(req);
        return httpConnection.receiveResponse();
    }
}

