/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;

public class KopiTabbedPaneUI
extends MetalTabbedPaneUI {
    private static final int TAB_X_SPACE = 10;
    private static Color areaColor;

    public static ComponentUI createUI(JComponent c) {
        return new KopiTabbedPaneUI();
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            }
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.lightHighlight);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x, y + 2, x, y + h - 3);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 1, y);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                break;
            }
            case 4: {
                g.drawLine(x, y, x + w - 3, y);
                g.setColor(this.shadow);
                g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                break;
            }
            case 3: {
                g.drawLine(x, y, x, y + h - 3);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                break;
            }
            default: {
                Color selectedColor = UIManager.getColor("TabbedPane.selected");
                g.setColor(selectedColor);
                if (this.isFirstTab(tabIndex)) {
                    Polygon p = new Polygon(new int[]{x, x + 20, x}, new int[]{y, y, y + h - 1}, 3);
                    g.setColor(areaColor);
                    g.fillPolygon(p);
                    g.setColor(this.lightHighlight);
                    g.drawLine(x, y + h, x + 20, y);
                    g.drawLine(x + 20, y, x + w - 1, y);
                } else {
                    Polygon p = new Polygon(new int[]{x + 10, x + 20, x + 10}, new int[]{y, y, y + h / 2 - 1}, 3);
                    g.setColor(areaColor);
                    g.fillPolygon(p);
                    if (isSelected) {
                        g.setColor(this.tabPane.getBackgroundAt(tabIndex - 1));
                        Polygon p1 = new Polygon(new int[]{x, x + 10 - 1, x + 10 - 1, x}, new int[]{y + 2, y + 2, y + h / 2 - 1, y + h - 1}, 4);
                        g.fillPolygon(p1);
                        g.setColor(this.lightHighlight);
                        g.drawLine(x, y + h, x + 20, y);
                        g.drawLine(x + 10, y, x + 10, y + h / 2);
                    } else {
                        g.setColor(tabIndex - 1 == this.tabPane.getSelectedIndex() ? selectedColor : this.tabPane.getBackgroundAt(tabIndex - 1));
                        Polygon p1 = new Polygon(new int[]{x, x + 10, x + 10, x}, new int[]{y + 2, y + 2, y + h, y + h}, 4);
                        g.fillPolygon(p1);
                        g.setColor(this.lightHighlight);
                        g.drawLine(x + 10, y + h / 2, x + 20, y);
                        g.drawLine(x + 10, y, x + 10, y + h);
                    }
                    g.setColor(this.lightHighlight);
                    g.drawLine(x, y, x + 10, y);
                    g.drawLine(x + 20, y, x + w - 1, y);
                }
                if (tabIndex != this.tabPane.getTabCount() - 1) break;
                g.setColor(this.lightHighlight);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
        }
    }

    protected boolean isFirstTab(int tabIndex) {
        if (this.runCount == 1) {
            return tabIndex == 0;
        }
        for (int i = 0; i < this.runCount; ++i) {
            if (tabIndex != this.tabRuns[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected int getTabRunIndent(int tabPlacement, int run2) {
        return 7 * (run2 + 1) + 20 * run2;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Rectangle clipRect = g.getClipBounds();
        g.setColor(areaColor);
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        View v;
        Icon icon = this.getIconForTab(tabIndex);
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        int width = tabInsets.left + tabInsets.right + 3;
        if (icon != null) {
            width += icon.getIconWidth() + this.textIconGap;
        }
        if ((v = this.getTextViewForTab(tabIndex)) != null) {
            width += (int)v.getPreferredSpan(0);
        } else {
            String title = this.tabPane.getTitleAt(tabIndex);
            width += SwingUtilities.computeStringWidth(metrics, title);
        }
        return width + 10;
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
        } else {
            int offset = 0;
            if (selectedIndex != this.tabPane.getTabCount() - 1) {
                offset = 10;
            }
            g.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 2 + offset) {
                g.drawLine(selRect.x + selRect.width + offset, y, x + w - 2, y);
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge + 10;
        iconRect.y += yNudge;
        textRect.x += xNudge + 10;
        textRect.y += yNudge;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        areaColor = UIManager.getColor("TabbedPaneUI.tabarea.background");
    }
}

