/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.kopi.galite.visual.visual.DPositionPanelListener;
import org.kopi.vkopi.lib.ui.swing.base.Utils;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;

public class DPositionPanel
extends JPanel {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private final DPositionPanelListener listener;
    private final JPanel record;
    private final JPanel recordLeft;
    private final JPanel recordRight;
    private final JButton info;
    private final JButton left;
    private final JButton right;
    private final JButton first;
    private final JButton last;
    private boolean recordVisible;
    private int current;
    private int total;
    private static final long serialVersionUID = 3047549694322579187L;

    public DPositionPanel(DPositionPanelListener listener) {
        this.listener = listener;
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this.record = new JPanel();
        this.record.setLayout(new BorderLayout());
        this.recordLeft = new JPanel();
        this.recordLeft.setLayout(new BorderLayout());
        this.recordRight = new JPanel();
        this.recordRight.setLayout(new BorderLayout());
        this.first = new JButton(Utils.getImage("arrowfirst.gif"));
        this.first.setFocusable(false);
        this.first.setBorder(new EtchedBorder());
        this.first.setMargin(EMPTY_INSETS);
        this.first.setOpaque(false);
        this.first.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPositionPanel.this.listener.gotoFirstPosition();
            }
        });
        this.recordLeft.add((Component)this.first, "West");
        this.left = new JButton(Utils.getImage("arrowleft.gif"));
        this.left.setFocusable(false);
        this.left.setBorder(new EtchedBorder());
        this.left.setMargin(EMPTY_INSETS);
        this.left.setOpaque(false);
        this.left.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPositionPanel.this.listener.gotoPrevPosition();
            }
        });
        this.recordLeft.add((Component)this.left, "East");
        this.record.add((Component)this.recordLeft, "West");
        this.info = new JButton();
        this.info.setFont(new Font(null, 0, 8));
        this.info.setText(null);
        this.info.setFocusable(false);
        this.info.setBorder(new EtchedBorder());
        this.info.setMargin(EMPTY_INSETS);
        this.info.setOpaque(false);
        this.info.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int userInput = DWindow.askPostition(DPositionPanel.this, DPositionPanel.this.current, DPositionPanel.this.total);
                if (userInput != DPositionPanel.this.current) {
                    DPositionPanel.this.listener.gotoPosition(userInput);
                }
            }
        });
        this.record.add((Component)this.info, "Center");
        this.right = new JButton(Utils.getImage("arrowright.gif"));
        this.right.setFocusable(false);
        this.right.setBorder(new EtchedBorder());
        this.right.setMargin(EMPTY_INSETS);
        this.right.setOpaque(false);
        this.right.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPositionPanel.this.listener.gotoNextPosition();
            }
        });
        this.recordRight.add((Component)this.right, "West");
        this.last = new JButton(Utils.getImage("arrowlast.gif"));
        this.last.setFocusable(false);
        this.last.setBorder(new EtchedBorder());
        this.last.setMargin(EMPTY_INSETS);
        this.last.setOpaque(false);
        this.last.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPositionPanel.this.listener.gotoLastPosition();
            }
        });
        this.recordRight.add((Component)this.last, "East");
        this.record.add((Component)this.recordRight, "East");
        this.recordVisible = false;
    }

    public void setPosition(int current, int total) {
        this.current = current;
        this.total = total;
        if (current == -1 || total == 0) {
            if (this.recordVisible) {
                this.remove(this.record);
                this.recordVisible = false;
            }
        } else {
            if (!this.recordVisible) {
                this.add((Component)this.record, "Center");
                this.recordVisible = true;
            }
            this.info.setText(" " + current + " / " + total + " ");
            this.left.setEnabled(current > 1);
            this.first.setEnabled(current > 1);
            this.right.setEnabled(current < total);
            this.last.setEnabled(current < total);
        }
        this.doLayout();
    }
}

