/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.chart;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.base.UComponent;
import org.kopi.galite.visual.chart.CConstants;
import org.kopi.galite.visual.chart.UChartType;
import org.kopi.galite.visual.chart.VChart;
import org.kopi.galite.visual.chart.VDataSeries;
import org.kopi.galite.visual.chart.VDimensionData;
import org.kopi.galite.visual.chart.VMeasureData;
import org.kopi.galite.visual.chart.VRow;
import org.kopi.galite.visual.visual.VModel;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 (2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001(B\u0017\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ%\u0010 \u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b!J\u0011\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0#\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020&H\u0016R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lorg/kopi/galite/visual/chart/VChartType;", "Ljava/io/Serializable;", "Lorg/kopi/galite/visual/chart/CConstants;", "Lorg/kopi/galite/visual/visual/VModel;", "ordinal", "", "name", "", "(ILjava/lang/String;)V", "dataSeries", "", "Lorg/kopi/galite/visual/chart/VDataSeries;", "getDataSeries$galite_core", "()Ljava/util/List;", "setDataSeries$galite_core", "(Ljava/util/List;)V", "display", "Lorg/kopi/galite/visual/chart/UChartType;", "getName", "()Ljava/lang/String;", "getOrdinal", "()I", "createDataSeries", "", "chart", "Lorg/kopi/galite/visual/chart/VChart;", "createDataSeries$galite_core", "createDimensionData", "Lorg/kopi/galite/visual/chart/VDimensionData;", "row", "Lorg/kopi/galite/visual/chart/VRow;", "createDimensionData$galite_core", "fillMeasures", "fillMeasures$galite_core", "getDataSeries", "", "()[Lorg/kopi/galite/visual/chart/VDataSeries;", "getDisplay", "Lorg/kopi/galite/visual/base/UComponent;", "setDisplay", "Companion", "galite-core"})
public class VChartType
implements Serializable,
CConstants,
VModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int ordinal;
    @NotNull
    private final String name;
    private UChartType display;
    @NotNull
    private List<VDataSeries> dataSeries;
    @NotNull
    private static final VChartType PIE = new VChartType(0, "Pie");
    @NotNull
    private static final VChartType COLUMN = new VChartType(1, "Column");
    @NotNull
    private static final VChartType BAR = new VChartType(2, "Bar");
    @NotNull
    private static final VChartType LINE = new VChartType(3, "Line");
    @NotNull
    private static final VChartType AREA = new VChartType(4, "Area");
    @NotNull
    private static final VChartType DEFAULT = COLUMN;

    protected VChartType(int ordinal, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ordinal = ordinal;
        this.name = name;
        this.dataSeries = new ArrayList();
    }

    public final int getOrdinal() {
        return this.ordinal;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public void setDisplay(@NotNull UComponent display) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        boolean bl = display instanceof UChartType;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "The display should be a chart type view";
            throw new AssertionError((Object)string);
        }
        this.display = (UChartType)display;
    }

    @Override
    @NotNull
    public UComponent getDisplay() {
        UChartType uChartType = this.display;
        if (uChartType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"display");
            uChartType = null;
        }
        return uChartType;
    }

    public final void createDataSeries$galite_core(@NotNull VChart chart) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        this.dataSeries.clear();
        VRow[] $this$forEach$iv = chart.getRows$galite_core();
        boolean $i$f$forEach = false;
        for (VRow element$iv : $this$forEach$iv) {
            VRow row = element$iv;
            boolean bl = false;
            VDataSeries data = new VDataSeries(this.createDimensionData$galite_core(chart, row));
            this.fillMeasures$galite_core(data, chart, row);
            this.getDataSeries$galite_core().add(data);
        }
    }

    @NotNull
    public final VDimensionData createDimensionData$galite_core(@NotNull VChart chart, @NotNull VRow row) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return new VDimensionData(chart.getDimension(0).getLabel(), (Comparable)((Object)chart.getDimension(0).format(row.getDimensionAt(0))));
    }

    public final void fillMeasures$galite_core(@NotNull VDataSeries dataSeries, @NotNull VChart chart, @NotNull VRow row) {
        Intrinsics.checkNotNullParameter((Object)dataSeries, (String)"dataSeries");
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        int n = 0;
        int n2 = row.getMeasuresCount();
        while (n < n2) {
            int i = n++;
            String string = chart.getMeasure(i).getLabel();
            Intrinsics.checkNotNull((Object)string);
            VMeasureData vMeasureData = new VMeasureData(string, chart.getMeasure(i).toNumber$galite_core(row.getMeasureAt(i)));
            dataSeries.getMeasures$galite_core().add(vMeasureData);
        }
    }

    @NotNull
    public final VDataSeries[] getDataSeries() {
        Collection $this$toTypedArray$iv = this.dataSeries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VDataSeries[] vDataSeriesArray = thisCollection$iv.toArray(new VDataSeries[0]);
        if (vDataSeriesArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return vDataSeriesArray;
    }

    @NotNull
    public final List<VDataSeries> getDataSeries$galite_core() {
        return this.dataSeries;
    }

    public final void setDataSeries$galite_core(@NotNull List<VDataSeries> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dataSeries = list;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/kopi/galite/visual/chart/VChartType$Companion;", "", "()V", "AREA", "Lorg/kopi/galite/visual/chart/VChartType;", "getAREA", "()Lorg/kopi/galite/visual/chart/VChartType;", "BAR", "getBAR", "COLUMN", "getCOLUMN", "DEFAULT", "getDEFAULT", "LINE", "getLINE", "PIE", "getPIE", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VChartType getPIE() {
            return PIE;
        }

        @NotNull
        public final VChartType getCOLUMN() {
            return COLUMN;
        }

        @NotNull
        public final VChartType getBAR() {
            return BAR;
        }

        @NotNull
        public final VChartType getLINE() {
            return LINE;
        }

        @NotNull
        public final VChartType getAREA() {
            return AREA;
        }

        @NotNull
        public final VChartType getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

