/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.chart;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.chart.VColumnFormat;
import org.kopi.galite.visual.chart.VDimension;
import org.kopi.galite.visual.type.DateKt;
import org.kopi.galite.visual.type.DecimalKt;
import org.kopi.galite.visual.type.TimeKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kopi/galite/visual/chart/VDecimalDimension;", "Lorg/kopi/galite/visual/chart/VDimension;", "ident", "", "format", "Lorg/kopi/galite/visual/chart/VColumnFormat;", "maxScale", "", "exactScale", "", "(Ljava/lang/String;Lorg/kopi/galite/visual/chart/VColumnFormat;IZ)V", "toString", "value", "", "galite-core"})
public final class VDecimalDimension
extends VDimension {
    private final int maxScale;
    private final boolean exactScale;

    public VDecimalDimension(@NotNull String ident, @Nullable VColumnFormat format2, int maxScale, boolean exactScale) {
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        super(ident, format2);
        this.maxScale = maxScale;
        this.exactScale = exactScale;
    }

    @Override
    @NotNull
    protected String toString(@Nullable Object value) {
        String string;
        if (value == null) {
            string = "";
        } else {
            String string2;
            Integer n = value instanceof Integer ? (Integer)value : null;
            String string3 = string2 = n == null ? null : n.toString();
            if (string2 == null) {
                if (value instanceof BigDecimal) {
                    if (((BigDecimal)value).scale() > this.maxScale || this.exactScale) {
                        BigDecimal bigDecimal = ((BigDecimal)value).setScale(this.maxScale);
                        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.setScale(maxScale)");
                        string = DecimalKt.format(bigDecimal);
                    } else {
                        string = DecimalKt.format((BigDecimal)value);
                    }
                } else {
                    string = value instanceof LocalDate ? DateKt.format((LocalDate)value) : (value instanceof LocalTime ? TimeKt.format((LocalTime)value) : value.toString());
                }
            } else {
                string = string2;
            }
        }
        return string;
    }
}

