/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.block;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.block.AbstractBlockLayout;
import org.kopi.galite.visual.ui.vaadin.block.AlignPanel;
import org.kopi.galite.visual.ui.vaadin.block.Block;
import org.kopi.galite.visual.ui.vaadin.block.BlockAlignment;
import org.kopi.galite.visual.ui.vaadin.block.ComponentConstraint;
import org.kopi.galite.visual.ui.vaadin.block.LayoutManager;
import org.kopi.galite.visual.ui.vaadin.form.DField;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0016JB\u0010\u0019\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\"\u0010!\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0004J\b\u0010#\u001a\u00020\u0016H\u0016J\u0018\u0010$\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0004J\u0018\u0010&\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0012H\u0004J\b\u0010)\u001a\u00020\u0016H\u0014J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0003H\u0016J\b\u0010,\u001a\u00020\u0016H\u0016J(\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001fH\u0016J(\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u0003H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/SimpleBlockLayout;", "Lorg/kopi/galite/visual/ui/vaadin/block/AbstractBlockLayout;", "col", "", "line", "block", "Lorg/kopi/galite/visual/ui/vaadin/block/Block;", "(IILorg/kopi/galite/visual/ui/vaadin/block/Block;)V", "align", "Lorg/kopi/galite/visual/ui/vaadin/block/BlockAlignment;", "getAlign", "()Lorg/kopi/galite/visual/ui/vaadin/block/BlockAlignment;", "setAlign", "(Lorg/kopi/galite/visual/ui/vaadin/block/BlockAlignment;)V", "getBlock", "()Lorg/kopi/galite/visual/ui/vaadin/block/Block;", "follows", "", "Lcom/vaadin/flow/component/Component;", "followsAligns", "Lorg/kopi/galite/visual/ui/vaadin/block/ComponentConstraint;", "add", "", "component", "constraints", "addComponent", "x", "y", "width", "height", "alignRight", "", "useAll", "addInfoComponentAt", "info", "clear", "getAllocatedHeight", "row", "getAllocatedWidth", "getComponentHeight", "comp", "initSize", "columns", "rows", "layout", "setBlockAlignment", "original", "targetBlockName", "", "targets", "", "isChart", "updateScroll", "pageSize", "maxValue", "enable", "value", "galite-core"})
public class SimpleBlockLayout
extends AbstractBlockLayout {
    @NotNull
    private final Block block;
    @Nullable
    private BlockAlignment align;
    @Nullable
    private List<Component> follows;
    @Nullable
    private List<ComponentConstraint> followsAligns;

    public SimpleBlockLayout(int col, int line, @NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)((Object)block), (String)"block");
        super(col, line);
        this.block = block;
        this.setClassName("simple");
        this.initSize();
    }

    @NotNull
    public Block getBlock() {
        return this.block;
    }

    @Nullable
    public final BlockAlignment getAlign() {
        return this.align;
    }

    public final void setAlign(@Nullable BlockAlignment blockAlignment) {
        this.align = blockAlignment;
    }

    @Override
    protected void initSize() {
        this.initSize(this.getCol(), this.getLine());
    }

    @Override
    public void initSize(int columns, int rows) {
        super.initSize(columns, rows);
        this.follows = new ArrayList();
        this.followsAligns = new ArrayList();
    }

    @Override
    public void addComponent(@Nullable Component component, int x, int y, int width, int height, boolean alignRight, boolean useAll) {
        ComponentConstraint constraints = new ComponentConstraint(x, y, width, height, alignRight, useAll);
        if (component != null) {
            this.add(component, constraints);
        }
    }

    @Override
    public void add(@Nullable Component component, @NotNull ComponentConstraint constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        if (this.align == null) {
            if (constraints.getWidth() < 0) {
                List<Component> list = this.follows;
                Intrinsics.checkNotNull(list);
                Component component2 = component;
                Intrinsics.checkNotNull((Object)component2);
                list.add(component2);
                List<ComponentConstraint> list2 = this.followsAligns;
                Intrinsics.checkNotNull(list2);
                list2.add(constraints);
            } else {
                ComponentConstraint[][] componentConstraintArray = this.getAligns();
                Intrinsics.checkNotNull((Object)componentConstraintArray);
                componentConstraintArray[constraints.getX()][constraints.getY()] = constraints;
                Component[][] componentArray = this.getComponents();
                Intrinsics.checkNotNull((Object)componentArray);
                componentArray[constraints.getX()][constraints.getY()] = component;
            }
        } else {
            if (component == null) {
                return;
            }
            BlockAlignment blockAlignment = this.align;
            Intrinsics.checkNotNull((Object)blockAlignment);
            ComponentConstraint newConstraint = new ComponentConstraint(blockAlignment.getTargetPos$galite_core(constraints.getX()), constraints.getY(), constraints.getWidth(), constraints.getHeight(), constraints.getAlignRight(), constraints.getUseAll());
            this.addAlignedComponent(component, newConstraint);
        }
    }

    @Override
    public void layout() {
        if (this.align != null) {
            return;
        }
        LayoutManager manager = new LayoutManager(this);
        int n = 0;
        Component[][] componentArray = this.getComponents();
        Intrinsics.checkNotNull((Object)componentArray);
        int n2 = componentArray[0].length;
        while (n < n2) {
            int y = n++;
            int n3 = 0;
            Component[][] componentArray2 = this.getComponents();
            Intrinsics.checkNotNull((Object)componentArray2);
            int n4 = ((Object[])componentArray2).length;
            while (n3 < n4) {
                int x = n3++;
                Component[][] componentArray3 = this.getComponents();
                Intrinsics.checkNotNull((Object)componentArray3);
                if (componentArray3[x][y] == null) continue;
                ComponentConstraint[][] componentConstraintArray = this.getAligns();
                Intrinsics.checkNotNull((Object)componentConstraintArray);
                if (componentConstraintArray[x][y] == null) continue;
                Component[][] componentArray4 = this.getComponents();
                Intrinsics.checkNotNull((Object)componentArray4);
                Component component = componentArray4[x][y];
                Intrinsics.checkNotNull((Object)component);
                ComponentConstraint[][] componentConstraintArray2 = this.getAligns();
                Intrinsics.checkNotNull((Object)componentConstraintArray2);
                ComponentConstraint componentConstraint = componentConstraintArray2[x][y];
                Intrinsics.checkNotNull((Object)componentConstraint);
                ComponentConstraint[][] componentConstraintArray3 = this.getAligns();
                Intrinsics.checkNotNull((Object)componentConstraintArray3);
                ComponentConstraint componentConstraint2 = componentConstraintArray3[x][y];
                Intrinsics.checkNotNull((Object)componentConstraint2);
                int n5 = RangesKt.coerceAtMost((int)componentConstraint2.getWidth(), (int)this.getAllocatedWidth(x, y));
                ComponentConstraint[][] componentConstraintArray4 = this.getAligns();
                Intrinsics.checkNotNull((Object)componentConstraintArray4);
                ComponentConstraint componentConstraint3 = componentConstraintArray4[x][y];
                Intrinsics.checkNotNull((Object)componentConstraint3);
                manager.setComponent(component, componentConstraint, n5, RangesKt.coerceAtMost((int)componentConstraint3.getHeight(), (int)this.getAllocatedHeight(x, y)));
                ComponentConstraint[][] componentConstraintArray5 = this.getAligns();
                Intrinsics.checkNotNull((Object)componentConstraintArray5);
                ComponentConstraint componentConstraint4 = componentConstraintArray5[x][y];
                Intrinsics.checkNotNull((Object)componentConstraint4);
                int n6 = componentConstraint4.getY();
                ComponentConstraint[][] componentConstraintArray6 = this.getAligns();
                Intrinsics.checkNotNull((Object)componentConstraintArray6);
                ComponentConstraint componentConstraint5 = componentConstraintArray6[x][y];
                Intrinsics.checkNotNull((Object)componentConstraint5);
                int n7 = componentConstraint5.getX();
                ComponentConstraint[][] componentConstraintArray7 = this.getAligns();
                Intrinsics.checkNotNull((Object)componentConstraintArray7);
                ComponentConstraint componentConstraint6 = componentConstraintArray7[x][y];
                Intrinsics.checkNotNull((Object)componentConstraint6);
                this.setAlignment(n6, n7, componentConstraint6.getAlignRight());
            }
        }
        manager.layout$galite_core();
        n = 0;
        List<Component> list = this.follows;
        Intrinsics.checkNotNull(list);
        n2 = list.size();
        while (n < n2) {
            int i = n++;
            List<ComponentConstraint> list2 = this.followsAligns;
            Intrinsics.checkNotNull(list2);
            ComponentConstraint align = list2.get(i);
            List<Component> list3 = this.follows;
            Intrinsics.checkNotNull(list3);
            Component comp = list3.get(i);
            this.addInfoComponentAt(comp, align.getX(), align.getY());
        }
    }

    protected final void addInfoComponentAt(@Nullable Component info, int x, int y) {
        Component[][] componentArray = this.getComponents();
        Intrinsics.checkNotNull((Object)componentArray);
        Component component = componentArray[x][y];
        Intrinsics.checkNotNull((Object)component);
        Iterator iterator = component.getChildren().iterator();
        if (iterator.hasNext()) {
            Component field = (Component)iterator.next();
            Component[] componentArray2 = new Component[]{field, info};
            HorizontalLayout content = new HorizontalLayout(componentArray2);
            content.setClassName("info-content");
            Component component2 = (Component)content;
            ComponentConstraint[][] componentConstraintArray = this.getAligns();
            Intrinsics.checkNotNull((Object)componentConstraintArray);
            ComponentConstraint componentConstraint = componentConstraintArray[x][y];
            Intrinsics.checkNotNull((Object)componentConstraint);
            int n = componentConstraint.getX();
            ComponentConstraint[][] componentConstraintArray2 = this.getAligns();
            Intrinsics.checkNotNull((Object)componentConstraintArray2);
            ComponentConstraint componentConstraint2 = componentConstraintArray2[x][y];
            Intrinsics.checkNotNull((Object)componentConstraint2);
            int n2 = componentConstraint2.getY();
            ComponentConstraint[][] componentConstraintArray3 = this.getAligns();
            Intrinsics.checkNotNull((Object)componentConstraintArray3);
            ComponentConstraint componentConstraint3 = componentConstraintArray3[x][y];
            Intrinsics.checkNotNull((Object)componentConstraint3);
            int n3 = RangesKt.coerceAtMost((int)componentConstraint3.getWidth(), (int)this.getAllocatedWidth(x, y));
            Component[][] componentArray3 = this.getComponents();
            Intrinsics.checkNotNull((Object)componentArray3);
            Component component3 = componentArray3[x][y];
            Intrinsics.checkNotNull((Object)component3);
            int n4 = this.getComponentHeight(component3);
            Component component4 = info;
            Intrinsics.checkNotNull((Object)component4);
            this.setComponent(component2, n, n2, n3, RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)n4, (int)this.getComponentHeight(component4)), (int)this.getAllocatedHeight(x, y)));
        }
    }

    protected final int getComponentHeight(@NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        return comp instanceof DField ? ((DField)comp).getVisibleHeight() : 1;
    }

    protected final int getAllocatedHeight(int col, int row) {
        int allocatedHeight = 1;
        int n = row + 1;
        Component[][] componentArray = this.getComponents();
        Intrinsics.checkNotNull((Object)componentArray);
        int n2 = componentArray[col].length;
        while (n < n2) {
            int y = n++;
            Component[][] componentArray2 = this.getComponents();
            Intrinsics.checkNotNull((Object)componentArray2);
            if (componentArray2[col][y] != null) break;
            int n3 = allocatedHeight;
            allocatedHeight = n3 + 1;
        }
        return allocatedHeight;
    }

    private final int getAllocatedWidth(int col, int row) {
        int allocatedWidth = 1;
        int n = col + 1;
        Component[][] componentArray = this.getComponents();
        Intrinsics.checkNotNull((Object)componentArray);
        int n2 = ((Object[])componentArray).length;
        while (n < n2) {
            int x = n++;
            Component[][] componentArray2 = this.getComponents();
            Intrinsics.checkNotNull((Object)componentArray2);
            if (componentArray2[x][row] != null) break;
            int n3 = allocatedWidth;
            allocatedWidth = n3 + 1;
        }
        return allocatedWidth;
    }

    @Override
    public void clear() {
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Override
    public void updateScroll(int pageSize, int maxValue, boolean enable, int value) {
    }

    public void setBlockAlignment(@NotNull Component original, @NotNull String targetBlockName, @NotNull int[] targets, boolean isChart) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)targetBlockName, (String)"targetBlockName");
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        BlockAlignment blockAlignment = this.align = new BlockAlignment();
        Intrinsics.checkNotNull((Object)blockAlignment);
        blockAlignment.setChart(isChart);
        BlockAlignment blockAlignment2 = this.align;
        Intrinsics.checkNotNull((Object)blockAlignment2);
        blockAlignment2.setTargets(targets);
        BlockAlignment blockAlignment3 = this.align;
        Intrinsics.checkNotNull((Object)blockAlignment3);
        blockAlignment3.setOri(original);
        this.setAlignPane(new AlignPanel(this.align, targetBlockName));
    }
}

