/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import com.flowingcode.vaadin.addons.ironicons.IronIcons;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.icon.IronIcon;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VMonthField;
import org.kopi.galite.visual.form.VStringField;
import org.kopi.galite.visual.form.VTimestampField;
import org.kopi.galite.visual.form.VWeekField;
import org.kopi.galite.visual.ui.vaadin.event.TextFieldListener;
import org.kopi.galite.visual.ui.vaadin.field.AbstractField;
import org.kopi.galite.visual.ui.vaadin.field.AllowAllValidator;
import org.kopi.galite.visual.ui.vaadin.field.DateValidator;
import org.kopi.galite.visual.ui.vaadin.field.DecimalValidator;
import org.kopi.galite.visual.ui.vaadin.field.EnumValidator;
import org.kopi.galite.visual.ui.vaadin.field.InputTextField;
import org.kopi.galite.visual.ui.vaadin.field.IntegerValidator;
import org.kopi.galite.visual.ui.vaadin.field.MonthValidator;
import org.kopi.galite.visual.ui.vaadin.field.NoeditValidator;
import org.kopi.galite.visual.ui.vaadin.field.StringValidator;
import org.kopi.galite.visual.ui.vaadin.field.TextField;
import org.kopi.galite.visual.ui.vaadin.field.TextFieldNavigationHandler;
import org.kopi.galite.visual.ui.vaadin.field.TextValidator;
import org.kopi.galite.visual.ui.vaadin.field.TimeValidator;
import org.kopi.galite.visual.ui.vaadin.field.TimestampValidator;
import org.kopi.galite.visual.ui.vaadin.field.VCodeField;
import org.kopi.galite.visual.ui.vaadin.field.VDateField;
import org.kopi.galite.visual.ui.vaadin.field.VDecimalField;
import org.kopi.galite.visual.ui.vaadin.field.VInputButtonField;
import org.kopi.galite.visual.ui.vaadin.field.VIntegerField;
import org.kopi.galite.visual.ui.vaadin.field.VPasswordField;
import org.kopi.galite.visual.ui.vaadin.field.VTextAreaField;
import org.kopi.galite.visual.ui.vaadin.field.VTimeField;
import org.kopi.galite.visual.ui.vaadin.field.VTimeStampField;
import org.kopi.galite.visual.ui.vaadin.field.WeekValidator;
import org.kopi.galite.visual.ui.vaadin.form.DTextField;
import org.kopi.galite.visual.ui.vaadin.form.KeyNavigator;
import org.kopi.galite.visual.ui.vaadin.window.Window;

@CssImport.Container(value={@CssImport(value="./styles/galite/textfield.css"), @CssImport(value="./styles/galite/textfield.css", themeFor="vaadin-text-field"), @CssImport(value="./styles/galite/textfield.css", themeFor="vaadin-text-area")})
@JsModule(value="./src/text-field.js")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0004\u008f\u0001\u0090\u0001B=\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010h\u001a\u00020\u001bH\u0002J\u0016\u0010i\u001a\u00020j2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020j0lH\u0016J\u0015\u0010m\u001a\u00020j2\u0006\u0010n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\boJ\f\u0010p\u001a\u0006\u0012\u0002\b\u000307H\u0002J\f\u0010q\u001a\u0006\u0012\u0002\b\u000307H\u0002J\b\u0010r\u001a\u00020jH\u0002J\r\u0010s\u001a\u00020jH\u0000\u00a2\u0006\u0002\btJ\r\u0010u\u001a\u00020jH\u0000\u00a2\u0006\u0002\bvJ\r\u0010w\u001a\u00020jH\u0000\u00a2\u0006\u0002\bxJ\r\u0010y\u001a\u00020jH\u0000\u00a2\u0006\u0002\bzJ\b\u0010{\u001a\u00020jH\u0016J\b\u0010|\u001a\u00020}H\u0016J\b\u0010~\u001a\u00020\u000bH\u0002J\n\u0010\u007f\u001a\u0004\u0018\u00010&H\u0016J\t\u0010\u0080\u0001\u001a\u00020\u0007H\u0002J\t\u0010\u0081\u0001\u001a\u00020\u0007H\u0016J\u0010\u0010\u0082\u0001\u001a\u00020j2\u0007\u0010\u0083\u0001\u001a\u00020\u0007J\u001d\u0010\u0084\u0001\u001a\u00020j2\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010&2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010&J\t\u0010\u0087\u0001\u001a\u00020jH\u0002J\u0014\u0010\u0088\u0001\u001a\u00020j2\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u0002H\u0014J\u0016\u0010\u008a\u0001\u001a\u00020j2\u000b\u0010\u008b\u0001\u001a\u0006\u0012\u0002\b\u000307H\u0002J\u0013\u0010d\u001a\u00020j2\u000b\u0010\u008c\u0001\u001a\u0006\u0012\u0002\b\u000307J\u0014\u0010\u008d\u0001\u001a\u00020j2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\"\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\"\"\u0004\b4\u00101R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\"R\u0015\u00106\u001a\u0006\u0012\u0002\b\u000307\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\u00078PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010\"R\u001a\u0010<\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0011R\u001a\u0010C\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0011\"\u0004\bE\u0010\u0015R\u001e\u0010F\u001a\u0004\u0018\u00010GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001e\u0010M\u001a\u0004\u0018\u00010GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bN\u0010I\"\u0004\bO\u0010KR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\"R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\"R\u0011\u0010T\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\"R\u0014\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0XX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010Z\u001a\u00020[X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001c\u0010`\u001a\u0004\u0018\u00010aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR\u0011\u0010f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010\u0011\u00a8\u0006\u0091\u0001"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/TextField;", "Lorg/kopi/galite/visual/ui/vaadin/field/AbstractField;", "", "Lcom/vaadin/flow/component/HasStyle;", "model", "Lorg/kopi/galite/visual/form/VField;", "noEcho", "", "scanner", "noEdit", "align", "", "hasAutofill", "fieldParent", "Lorg/kopi/galite/visual/ui/vaadin/form/DTextField;", "(Lorg/kopi/galite/visual/form/VField;ZZZIZLorg/kopi/galite/visual/ui/vaadin/form/DTextField;)V", "getAlign", "()I", "autocompleteLength", "getAutocompleteLength", "setAutocompleteLength", "(I)V", "autofill", "Lcom/vaadin/flow/component/icon/IronIcon;", "col", "getCol", "convertType", "Lorg/kopi/galite/visual/ui/vaadin/field/TextField$ConvertType;", "getConvertType", "()Lorg/kopi/galite/visual/ui/vaadin/field/TextField$ConvertType;", "setConvertType", "(Lorg/kopi/galite/visual/ui/vaadin/field/TextField$ConvertType;)V", "dynamicNewLine", "getDynamicNewLine", "()Z", "enabled", "enumerations", "", "", "getEnumerations", "()[Ljava/lang/String;", "setEnumerations", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "getFieldParent", "()Lorg/kopi/galite/visual/ui/vaadin/form/DTextField;", "fraction", "getFraction", "setFraction", "(Z)V", "hasAutocomplete", "getHasAutocomplete", "setHasAutocomplete", "getHasAutofill", "inputField", "Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "getInputField", "()Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "isNull", "isNull$galite_core", "lastCommunicatedValue", "getLastCommunicatedValue$galite_core", "()Ljava/lang/String;", "setLastCommunicatedValue$galite_core", "(Ljava/lang/String;)V", "maxLength", "getMaxLength", "maxScale", "getMaxScale", "setMaxScale", "maxval", "", "getMaxval", "()Ljava/lang/Double;", "setMaxval", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "minval", "getMinval", "setMinval", "getModel", "()Lorg/kopi/galite/visual/form/VField;", "getNoEcho", "getNoEdit", "rows", "getRows", "getScanner", "textFieldListeners", "", "Lorg/kopi/galite/visual/ui/vaadin/event/TextFieldListener;", "type", "Lorg/kopi/galite/visual/ui/vaadin/field/TextField$Type;", "getType", "()Lorg/kopi/galite/visual/ui/vaadin/field/TextField$Type;", "setType", "(Lorg/kopi/galite/visual/ui/vaadin/field/TextField$Type;)V", "validator", "Lorg/kopi/galite/visual/ui/vaadin/field/TextValidator;", "getValidator", "()Lorg/kopi/galite/visual/ui/vaadin/field/TextValidator;", "setValidator", "(Lorg/kopi/galite/visual/ui/vaadin/field/TextValidator;)V", "visibleRows", "getVisibleRows", "_getConvertType", "addFocusListener", "", "function", "Lkotlin/Function0;", "checkValue", "rec", "checkValue$galite_core", "createFieldComponent", "createTextField", "fireAutofill", "fireGotoNextBlock", "fireGotoNextBlock$galite_core", "fireNextEntry", "fireNextEntry$galite_core", "firePreviousEntry", "firePreviousEntry$galite_core", "firePrintForm", "firePrintForm$galite_core", "focus", "getContent", "Lcom/vaadin/flow/component/Component;", "getFieldSize", "getValue", "isNumeric", "isReadOnly", "setBlink", "blink", "setColor", "foreground", "background", "setFieldType", "setPresentationValue", "newPresentationValue", "setTextTransform", "text", "field", "setValue", "value", "ConvertType", "Type", "galite-core"})
public final class TextField
extends AbstractField<Object>
implements HasStyle {
    @NotNull
    private final VField model;
    private final boolean noEcho;
    private final boolean scanner;
    private final boolean noEdit;
    private final int align;
    private final boolean hasAutofill;
    @NotNull
    private final DTextField fieldParent;
    @NotNull
    private final InputTextField<?> inputField;
    private final int col;
    private final int rows;
    private final int visibleRows;
    private final boolean dynamicNewLine;
    private final boolean enabled;
    public Type type;
    @Nullable
    private Double minval;
    @Nullable
    private Double maxval;
    private int maxScale;
    private boolean fraction;
    @Nullable
    private String[] enumerations;
    private boolean hasAutocomplete;
    private int autocompleteLength;
    @NotNull
    private ConvertType convertType;
    @Nullable
    private TextValidator validator;
    @Nullable
    private IronIcon autofill;
    @NotNull
    private String lastCommunicatedValue;
    @NotNull
    private final List<TextFieldListener> textFieldListeners;

    public TextField(@NotNull VField model2, boolean noEcho, boolean scanner, boolean noEdit, int align, boolean hasAutofill, @NotNull DTextField fieldParent) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)fieldParent, (String)"fieldParent");
        this.model = model2;
        this.noEcho = noEcho;
        this.scanner = scanner;
        this.noEdit = noEdit;
        this.align = align;
        this.hasAutofill = hasAutofill;
        this.fieldParent = fieldParent;
        this.enabled = true;
        this.convertType = ConvertType.NONE;
        this.lastCommunicatedValue = "";
        this.textFieldListeners = new ArrayList();
        this.setClassName("k-textfield");
        this.col = this.model.getWidth();
        this.rows = this.model.getHeight();
        this.visibleRows = this.model.getHeight() == 1 ? 1 : ((VStringField)this.model).getVisibleHeight();
        this.dynamicNewLine = !this.scanner && (this.model.getTypeOptions() & 0x10000) > 0;
        this.autocompleteLength = this.model.getAutocompleteLength();
        this.hasAutocomplete = this.model.hasAutocomplete();
        this.setFieldType();
        this.inputField = this.createTextField();
        this.inputField.setEnabled(this.enabled);
        Object[] objectArray = new Component[]{(Component)this.inputField};
        this.add((Component[])objectArray);
        if (this.hasAutofill) {
            IronIcon ironIcon = this.autofill = (IronIcon)IronIcons.ARROW_DROP_DOWN.create();
            Intrinsics.checkNotNull((Object)ironIcon);
            ironIcon.getStyle().set("cursor", "pointer");
            IronIcon ironIcon2 = this.autofill;
            Intrinsics.checkNotNull((Object)ironIcon2);
            ironIcon2.addClickListener(new ComponentEventListener(){

                public final void onComponentEvent(ClickEvent<IronIcon> it) {
                    this.fireAutofill();
                }
            });
            this.inputField.setSuffixComponent((Component)this.autofill);
            IronIcon ironIcon3 = this.autofill;
            Intrinsics.checkNotNull((Object)ironIcon3);
            Element element = ironIcon3.getElement();
            objectArray = new Serializable[2];
            objectArray[0] = (Serializable)this.inputField.getElement();
            IronIcon ironIcon4 = this.autofill;
            Intrinsics.checkNotNull((Object)ironIcon4);
            objectArray[1] = (Serializable)ironIcon4.getElement();
            element.executeJs("addAutofillListeners($0, $1);", (Serializable[])objectArray);
        }
    }

    @NotNull
    public final VField getModel() {
        return this.model;
    }

    public final boolean getNoEcho() {
        return this.noEcho;
    }

    public final boolean getScanner() {
        return this.scanner;
    }

    public final boolean getNoEdit() {
        return this.noEdit;
    }

    public final int getAlign() {
        return this.align;
    }

    public final boolean getHasAutofill() {
        return this.hasAutofill;
    }

    @NotNull
    public final DTextField getFieldParent() {
        return this.fieldParent;
    }

    @NotNull
    public final InputTextField<?> getInputField() {
        return this.inputField;
    }

    public final int getCol() {
        return this.col;
    }

    public final int getRows() {
        return this.rows;
    }

    public final int getVisibleRows() {
        return this.visibleRows;
    }

    public final boolean getDynamicNewLine() {
        return this.dynamicNewLine;
    }

    @NotNull
    public final Type getType() {
        Type type2 = this.type;
        if (type2 != null) {
            return type2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        return null;
    }

    public final void setType(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"<set-?>");
        this.type = type2;
    }

    @Nullable
    public final Double getMinval() {
        return this.minval;
    }

    public final void setMinval(@Nullable Double d) {
        this.minval = d;
    }

    @Nullable
    public final Double getMaxval() {
        return this.maxval;
    }

    public final void setMaxval(@Nullable Double d) {
        this.maxval = d;
    }

    public final int getMaxScale() {
        return this.maxScale;
    }

    public final void setMaxScale(int n) {
        this.maxScale = n;
    }

    public final boolean getFraction() {
        return this.fraction;
    }

    public final void setFraction(boolean bl) {
        this.fraction = bl;
    }

    @Nullable
    public final String[] getEnumerations() {
        return this.enumerations;
    }

    public final void setEnumerations(@Nullable String[] stringArray) {
        this.enumerations = stringArray;
    }

    public final boolean getHasAutocomplete() {
        return this.hasAutocomplete;
    }

    public final void setHasAutocomplete(boolean bl) {
        this.hasAutocomplete = bl;
    }

    public final int getAutocompleteLength() {
        return this.autocompleteLength;
    }

    public final void setAutocompleteLength(int n) {
        this.autocompleteLength = n;
    }

    @NotNull
    public final ConvertType getConvertType() {
        return this.convertType;
    }

    public final void setConvertType(@NotNull ConvertType convertType) {
        Intrinsics.checkNotNullParameter((Object)((Object)convertType), (String)"<set-?>");
        this.convertType = convertType;
    }

    @Nullable
    public final TextValidator getValidator() {
        return this.validator;
    }

    public final void setValidator(@Nullable TextValidator textValidator) {
        this.validator = textValidator;
    }

    @NotNull
    public final String getLastCommunicatedValue$galite_core() {
        return this.lastCommunicatedValue;
    }

    public final void setLastCommunicatedValue$galite_core(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lastCommunicatedValue = string;
    }

    private final int getMaxLength() {
        return this.col * this.rows;
    }

    private final void setFieldType() {
        VField vField2 = this.model;
        if (vField2 instanceof VStringField) {
            this.setType(Type.STRING);
            this.convertType = this._getConvertType();
        } else if (vField2 instanceof org.kopi.galite.visual.form.VIntegerField) {
            this.setType(Type.INTEGER);
            ((org.kopi.galite.visual.form.VIntegerField)this.model).getMinValue();
            this.minval = ((org.kopi.galite.visual.form.VIntegerField)this.model).getMinValue();
            ((org.kopi.galite.visual.form.VIntegerField)this.model).getMaxValue();
            this.maxval = ((org.kopi.galite.visual.form.VIntegerField)this.model).getMaxValue();
        } else if (vField2 instanceof VMonthField) {
            this.setType(Type.MONTH);
        } else if (vField2 instanceof org.kopi.galite.visual.form.VDateField) {
            this.setType(Type.DATE);
        } else if (vField2 instanceof VWeekField) {
            this.setType(Type.WEEK);
        } else if (vField2 instanceof org.kopi.galite.visual.form.VTimeField) {
            this.setType(Type.TIME);
        } else if (vField2 instanceof org.kopi.galite.visual.form.VCodeField) {
            this.setType(Type.CODE);
            this.enumerations = ((org.kopi.galite.visual.form.VCodeField)this.model).getLabels();
        } else if (vField2 instanceof org.kopi.galite.visual.form.VDecimalField) {
            this.setType(Type.DECIMAL);
            if (((org.kopi.galite.visual.form.VDecimalField)this.model).getMinValue() != null) {
                this.minval = ((org.kopi.galite.visual.form.VDecimalField)this.model).getMinValue().doubleValue();
            }
            if (((org.kopi.galite.visual.form.VDecimalField)this.model).getMaxValue() != null) {
                this.maxval = ((org.kopi.galite.visual.form.VDecimalField)this.model).getMaxValue().doubleValue();
            }
            this.maxScale = ((org.kopi.galite.visual.form.VDecimalField)this.model).getMaxScale();
            this.fraction = ((org.kopi.galite.visual.form.VDecimalField)this.model).isFraction();
        } else if (vField2 instanceof VTimestampField) {
            this.setType(Type.TIMESTAMP);
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"unknown field model : ", (Object)this.model.getClass().getName()));
        }
    }

    private final ConvertType _getConvertType() {
        ConvertType convertType;
        switch (((VStringField)this.model).getTypeOptions() & 0xF00) {
            case 0: {
                convertType = ConvertType.NONE;
                break;
            }
            case 256: {
                convertType = ConvertType.UPPER;
                break;
            }
            case 512: {
                convertType = ConvertType.LOWER;
                break;
            }
            case 1024: {
                convertType = ConvertType.NAME;
                break;
            }
            default: {
                convertType = ConvertType.NONE;
            }
        }
        return convertType;
    }

    public final void setValidator(@NotNull InputTextField<?> field) {
        AllowAllValidator allowAllValidator;
        Intrinsics.checkNotNullParameter(field, (String)"field");
        Binder binder = new Binder(String.class);
        Binder.BindingBuilder bindingBuilder = binder.forField((HasValue)field);
        switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
            case 1: {
                allowAllValidator = new StringValidator(this.col, this.rows, !this.dynamicNewLine, this.convertType, this.getMaxLength());
                break;
            }
            case 2: {
                allowAllValidator = new IntegerValidator(this.minval, this.maxval, this.getMaxLength());
                break;
            }
            case 3: {
                allowAllValidator = new DecimalValidator(this.maxScale, this.fraction, this.col, this.minval, this.maxval, this.getMaxLength());
                break;
            }
            case 4: {
                allowAllValidator = new DateValidator(this.getMaxLength());
                break;
            }
            case 5: {
                allowAllValidator = new TimeValidator(this.getMaxLength());
                break;
            }
            case 6: {
                allowAllValidator = new MonthValidator(this.getMaxLength());
                break;
            }
            case 7: {
                allowAllValidator = new WeekValidator(this.getMaxLength());
                break;
            }
            case 8: {
                allowAllValidator = new TimestampValidator(this.getMaxLength());
                break;
            }
            case 9: {
                allowAllValidator = new EnumValidator(this.enumerations, this.getMaxLength());
                break;
            }
            default: {
                allowAllValidator = new AllowAllValidator(this.getMaxLength());
            }
        }
        AllowAllValidator validator = allowAllValidator;
        bindingBuilder.withValidator((Validator)validator).bind((ValueProvider)setValidator.1.INSTANCE, (Setter)setValidator.2.INSTANCE);
        this.validator = validator;
        field.setTextValidator(validator);
    }

    private final void setTextTransform(InputTextField<?> text) {
        switch (WhenMappings.$EnumSwitchMapping$1[this.convertType.ordinal()]) {
            case 1: {
                text.addClassName("transform-uppercase");
                break;
            }
            case 2: {
                text.addClassName("transform-lowercase");
                break;
            }
            case 3: {
                text.addClassName("transform-capitalize");
                break;
            }
            case 4: {
                text.addClassName("transform-none");
            }
        }
    }

    private final InputTextField<?> createTextField() {
        InputTextField<?> text = this.createFieldComponent();
        this.setValidator(text);
        this.setTextTransform(text);
        text.setAlign(this.align);
        if (this.noEdit) {
            text.setTextValidator(new NoeditValidator(this.getMaxLength()));
            text.setReadOnly(true);
        }
        return text;
    }

    private final InputTextField<?> createFieldComponent() {
        InputTextField inputTextField;
        int col = 0;
        col = this.col;
        int size = this.getFieldSize();
        if (this.noEcho && this.rows == 1) {
            inputTextField = new VPasswordField(col);
        } else if (this.rows > 1) {
            VTextAreaField vTextAreaField;
            if (this.scanner) {
                col = 40;
            }
            VTextAreaField it = vTextAreaField = new VTextAreaField();
            boolean bl = false;
            it.setRows(this.getRows(), this.getVisibleRows());
            it.setWidth(col * 10 + "px");
            it.setWordwrap(true);
            it.setFixedNewLine(!this.getDynamicNewLine());
            inputTextField = vTextAreaField;
        } else if (!this.fieldParent.getModel$galite_core().hasAction()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
                case 2: {
                    Double d = this.minval;
                    Intrinsics.checkNotNull((Object)d);
                    double d2 = d;
                    Double d3 = this.maxval;
                    Intrinsics.checkNotNull((Object)d3);
                    inputTextField = new VIntegerField(col, d2, d3);
                    break;
                }
                case 3: {
                    inputTextField = new VDecimalField(col, this.maxScale, this.minval, this.maxval, this.fraction);
                    break;
                }
                case 9: {
                    inputTextField = new VCodeField(this.enumerations);
                    break;
                }
                case 5: {
                    inputTextField = new VTimeField();
                    break;
                }
                case 8: {
                    inputTextField = new VTimeStampField();
                    break;
                }
                case 4: {
                    inputTextField = new VDateField();
                    break;
                }
                default: {
                    inputTextField = new InputTextField<com.vaadin.flow.component.AbstractField>((com.vaadin.flow.component.AbstractField)new com.vaadin.flow.component.textfield.TextField());
                    break;
                }
            }
        } else {
            inputTextField = new VInputButtonField(size);
        }
        InputTextField text = inputTextField;
        text.setSize(size);
        text.setMaxLength(this.getMaxLength());
        ((HasSize)text.getContent()).setWidth("" + size + "ch");
        text.getElement().getStyle().set("box-sizing", "unset");
        text.setHasAutocomplete(this.model.hasAutocomplete());
        TextFieldNavigationHandler.Companion.createNavigator(text, this.rows > 1);
        this.textFieldListeners.add(new KeyNavigator(this.model, text));
        return text;
    }

    private final int getFieldSize() {
        int n;
        int size = this.col;
        if (this.convertType == ConvertType.UPPER) {
            size += 2;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
            case 8: {
                n = 6;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 4: {
                n = 7;
                break;
            }
            default: {
                n = 3;
            }
        }
        size += n;
        if (this.hasAutofill) {
            ++size;
        }
        return RangesKt.coerceAtLeast((int)1, (int)size);
    }

    private final boolean isNumeric() {
        return this.getType() != Type.STRING && this.getType() != Type.CODE;
    }

    public final void setBlink(boolean blink) {
        if (blink) {
            this.getClassNames().add((Object)"text-field-blink");
        } else {
            this.getClassNames().remove((Object)"text-field-blink");
        }
    }

    public boolean isReadOnly() {
        return this.inputField.isReadOnly();
    }

    protected void setPresentationValue(@Nullable Object newPresentationValue) {
        this.inputField.setValue(String.valueOf(newPresentationValue));
    }

    @Override
    @Nullable
    public String getValue() {
        return this.inputField.getValue();
    }

    @Override
    public void setValue(@Nullable Object value) {
        this.inputField.setAnyValue(value);
    }

    public final void firePrintForm$galite_core() {
        for (TextFieldListener l : this.textFieldListeners) {
            l.printForm();
        }
    }

    public final void firePreviousEntry$galite_core() {
        for (TextFieldListener l : this.textFieldListeners) {
            l.previousEntry();
        }
    }

    public final void fireNextEntry$galite_core() {
        for (TextFieldListener l : this.textFieldListeners) {
            l.nextEntry();
        }
    }

    public final void fireGotoNextBlock$galite_core() {
        for (TextFieldListener l : this.textFieldListeners) {
            l.gotoNextBlock();
        }
    }

    private final void fireAutofill() {
        for (TextFieldListener l : this.textFieldListeners) {
            l.autofill();
        }
    }

    @Override
    public void focus() {
        Window window = this.inputField.getParentWindow();
        if (window != null) {
            window.setLasFocusedField(this);
        }
        this.inputField.focus();
    }

    @Override
    public void addFocusListener(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.inputField.addFocusListener(new ComponentEventListener(function){
            final /* synthetic */ Function0<Unit> $function;
            {
                this.$function = $function;
            }

            public final void onComponentEvent(FocusNotifier.FocusEvent<? extends InputTextField<? extends com.vaadin.flow.component.AbstractField<?, ? extends Object>>> it) {
                this.$function.invoke();
            }
        });
    }

    @Override
    @NotNull
    public Component getContent() {
        return (Component)this.inputField;
    }

    public final void setColor(@Nullable String foreground, @Nullable String background) {
        this.inputField.setColor(foreground, background);
    }

    @Override
    public boolean isNull$galite_core() {
        return this.inputField.isNull();
    }

    @Override
    public void checkValue$galite_core(int rec) {
        this.inputField.checkValue(rec);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/TextField$ConvertType;", "", "(Ljava/lang/String;I)V", "NONE", "UPPER", "LOWER", "NAME", "galite-core"})
    public static final class ConvertType
    extends Enum<ConvertType> {
        public static final /* enum */ ConvertType NONE = new ConvertType();
        public static final /* enum */ ConvertType UPPER = new ConvertType();
        public static final /* enum */ ConvertType LOWER = new ConvertType();
        public static final /* enum */ ConvertType NAME = new ConvertType();
        private static final /* synthetic */ ConvertType[] $VALUES;

        public static ConvertType[] values() {
            return (ConvertType[])$VALUES.clone();
        }

        public static ConvertType valueOf(String value) {
            return Enum.valueOf(ConvertType.class, value);
        }

        static {
            $VALUES = convertTypeArray = new ConvertType[]{ConvertType.NONE, ConvertType.UPPER, ConvertType.LOWER, ConvertType.NAME};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/TextField$Type;", "", "(Ljava/lang/String;I)V", "STRING", "INTEGER", "DECIMAL", "DATE", "TIME", "MONTH", "WEEK", "TIMESTAMP", "CODE", "galite-core"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type STRING = new Type();
        public static final /* enum */ Type INTEGER = new Type();
        public static final /* enum */ Type DECIMAL = new Type();
        public static final /* enum */ Type DATE = new Type();
        public static final /* enum */ Type TIME = new Type();
        public static final /* enum */ Type MONTH = new Type();
        public static final /* enum */ Type WEEK = new Type();
        public static final /* enum */ Type TIMESTAMP = new Type();
        public static final /* enum */ Type CODE = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.STRING, Type.INTEGER, Type.DECIMAL, Type.DATE, Type.TIME, Type.MONTH, Type.WEEK, Type.TIMESTAMP, Type.CODE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.STRING.ordinal()] = 1;
            nArray[Type.INTEGER.ordinal()] = 2;
            nArray[Type.DECIMAL.ordinal()] = 3;
            nArray[Type.DATE.ordinal()] = 4;
            nArray[Type.TIME.ordinal()] = 5;
            nArray[Type.MONTH.ordinal()] = 6;
            nArray[Type.WEEK.ordinal()] = 7;
            nArray[Type.TIMESTAMP.ordinal()] = 8;
            nArray[Type.CODE.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ConvertType.values().length];
            nArray[ConvertType.UPPER.ordinal()] = 1;
            nArray[ConvertType.LOWER.ordinal()] = 2;
            nArray[ConvertType.NAME.ordinal()] = 3;
            nArray[ConvertType.NONE.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

