/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.function.SerializablePredicate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.ui.vaadin.form.FilterField;
import org.kopi.galite.visual.ui.vaadin.form.GridBlockItem;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DGridBlockFilter;", "Lcom/vaadin/flow/function/SerializablePredicate;", "Lorg/kopi/galite/visual/ui/vaadin/form/GridBlockItem;", "filterFields", "", "Lorg/kopi/galite/visual/ui/vaadin/form/FilterField;", "ignoreCase", "", "onlyMatchPrefix", "(Ljava/util/List;ZZ)V", "equals", "obj", "", "formatObject", "", "o", "field", "Lorg/kopi/galite/visual/form/VField;", "item", "hashCode", "", "test", "galite-core"})
public final class DGridBlockFilter
implements SerializablePredicate<GridBlockItem> {
    @NotNull
    private final List<FilterField> filterFields;
    private final boolean ignoreCase;
    private final boolean onlyMatchPrefix;

    public DGridBlockFilter(@NotNull List<FilterField> filterFields2, boolean ignoreCase, boolean onlyMatchPrefix) {
        Intrinsics.checkNotNullParameter(filterFields2, (String)"filterFields");
        this.filterFields = filterFields2;
        this.ignoreCase = ignoreCase;
        this.onlyMatchPrefix = onlyMatchPrefix;
    }

    public boolean test(@NotNull GridBlockItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        for (FilterField field : this.filterFields) {
            String filterString;
            String string;
            String value;
            String string2;
            if (this.ignoreCase) {
                String string3 = String.valueOf(this.formatObject(item, field.getModel())).toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
                string2 = string3;
            } else {
                string2 = value = String.valueOf(this.formatObject(item, field.getModel()));
            }
            if (this.ignoreCase) {
                String string4 = field.getValue().toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase()");
                string = string4;
            } else {
                string = filterString = field.getValue();
            }
            if (!(this.onlyMatchPrefix ? !StringsKt.startsWith$default((String)value, (String)filterString, (boolean)false, (int)2, null) : !StringsKt.contains$default((CharSequence)value, (CharSequence)filterString, (boolean)false, (int)2, null))) continue;
            return false;
        }
        return true;
    }

    private final String formatObject(GridBlockItem item, VField field) {
        return this.formatObject(item.getValue(field), field);
    }

    private final String formatObject(Object o, VField field) {
        return field.toText(o);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        int n = 0;
        int n2 = this.filterFields.size();
        while (n < n2) {
            String otherFilterString;
            String string;
            String filterString;
            String string2;
            int i = n++;
            FilterField field = this.filterFields.get(i);
            if (this.ignoreCase) {
                String string3 = field.getValue().toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
                string2 = string3;
            } else {
                string2 = filterString = field.getValue();
            }
            if (!(obj instanceof DGridBlockFilter)) {
                return false;
            }
            Object o = obj;
            FilterField otherField = ((DGridBlockFilter)o).filterFields.get(i);
            if (this.ignoreCase) {
                String string4 = otherField.getValue().toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase()");
                string = string4;
            } else {
                string = otherFilterString = otherField.getValue();
            }
            if (!Intrinsics.areEqual((Object)otherFilterString, (Object)filterString)) {
                return false;
            }
            if (this.ignoreCase != ((DGridBlockFilter)o).ignoreCase) {
                return false;
            }
            if (this.onlyMatchPrefix == ((DGridBlockFilter)o).onlyMatchPrefix) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = ((Object)this.filterFields).hashCode();
        result = 31 * result + Boolean.hashCode(this.ignoreCase);
        result = 31 * result + Boolean.hashCode(this.onlyMatchPrefix);
        return result;
    }
}

