/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.login;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.dom.DomEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.base.LocalizedProperties;
import org.kopi.galite.visual.ui.vaadin.event.LoginWindowListener;
import org.kopi.galite.visual.ui.vaadin.login.VLoginBox;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJD\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0004J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0006\u0010\u001b\u001a\u00020\u000bJ\u0010\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0006\u0010\u001f\u001a\u00020\u000bJ\u0006\u0010 \u001a\u00020\u000bJ\u0012\u0010!\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0004J\u0010\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010$\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010&\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010'\u001a\u00020\u000b2\b\u0010(\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010)\u001a\u00020\u000bJ\u0006\u0010*\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/login/VLoginWindow;", "Lcom/vaadin/flow/component/html/Div;", "()V", "listeners", "", "Lorg/kopi/galite/visual/ui/vaadin/event/LoginWindowListener;", "loginBox", "Lorg/kopi/galite/visual/ui/vaadin/login/VLoginBox;", "progress", "Lcom/vaadin/flow/component/progressbar/ProgressBar;", "addLoginWindowListener", "", "l", "addSupportedLanguage", "language", "", "isocode", "doInit", "welcomeText", "informationText", "usernameLabel", "passwordLabel", "languageLabel", "loginText", "fireLogin", "username", "password", "focus", "handleSelectionChange", "event", "Lcom/vaadin/flow/dom/DomEvent;", "onClick", "removeError", "removeLoginWindowListener", "setError", "error", "setLocale", "locale", "setSelectedLanguage", "setSloganImage", "welcomeImage", "setWaitInfo", "unsetWaitInfo", "galite-core"})
public final class VLoginWindow
extends Div {
    @NotNull
    private final VLoginBox loginBox;
    @NotNull
    private final List<LoginWindowListener> listeners;
    @NotNull
    private final ProgressBar progress = new ProgressBar();

    public VLoginWindow() {
        this.setClassName("k-loginBoxShadow");
        this.listeners = new ArrayList();
        this.loginBox = new VLoginBox();
        this.progress.setClassName("login-progress-bar");
        this.progress.setIndeterminate(true);
        this.progress.setVisible(false);
        Component[] componentArray = new Component[]{(Component)this.loginBox};
        this.add(componentArray);
        componentArray = new Component[]{(Component)this.progress};
        this.add(componentArray);
        this.loginBox.addClickHandler((Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(){

            public final void invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.onClick();
            }
        }));
        this.loginBox.addChangeHandler((Function1<? super DomEvent, Unit>)((Function1)new Function1<DomEvent, Unit>((Object)this){

            public final void invoke(@Nullable DomEvent p0) {
                ((VLoginWindow)((Object)this.receiver)).handleSelectionChange(p0);
            }
        }));
        this.setWidth("400px");
    }

    protected final void doInit(@Nullable String welcomeText, @Nullable String informationText, @Nullable String usernameLabel, @Nullable String passwordLabel, @Nullable String languageLabel, @Nullable String loginText) {
        this.loginBox.setWelcomeText(welcomeText);
        this.loginBox.setInformationText(informationText);
        this.loginBox.setUsernameLabel(usernameLabel);
        this.loginBox.setPasswordLabel(passwordLabel);
        this.loginBox.setLanguageLabel(languageLabel);
        this.loginBox.setLoginText(loginText);
    }

    public final void setSloganImage(@Nullable String welcomeImage) {
        this.loginBox.setWelcomeImage(welcomeImage);
    }

    public final void addSupportedLanguage(@NotNull String language, @Nullable String isocode) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.loginBox.addLanguage(language, isocode);
    }

    public final void setError(@Nullable String error2) {
        this.loginBox.setError(error2);
    }

    public final void removeError() {
        this.loginBox.removeError();
    }

    public final void setSelectedLanguage(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.loginBox.setSelectedLanguage(language);
    }

    public final void addLoginWindowListener(@NotNull LoginWindowListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    protected final void removeLoginWindowListener(@Nullable LoginWindowListener l) {
        ((Collection)this.listeners).remove(l);
    }

    protected final void fireLogin(@NotNull String username, @NotNull String password, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        for (LoginWindowListener l : this.listeners) {
            l.onLogin(username, password, language);
        }
    }

    public final void onClick() {
        this.removeError();
        this.fireLogin(this.loginBox.getUsername(), this.loginBox.getPassword(), this.loginBox.getSelectedLanguage());
    }

    public final void handleSelectionChange(@Nullable DomEvent event) {
        this.removeError();
        this.setLocale(this.loginBox.getSelectedLanguage());
    }

    public final void setLocale(@Nullable String locale) {
        this.doInit(LocalizedProperties.INSTANCE.getString(locale, "welcomeText"), LocalizedProperties.INSTANCE.getString(locale, "informationText"), LocalizedProperties.INSTANCE.getString(locale, "usernameLabel"), LocalizedProperties.INSTANCE.getString(locale, "passwordLabel"), LocalizedProperties.INSTANCE.getString(locale, "languageLabel"), LocalizedProperties.INSTANCE.getString(locale, "loginText"));
    }

    public final void focus() {
        this.loginBox.focus();
    }

    public final void setWaitInfo() {
        this.loginBox.disableLoginButton();
        this.progress.setVisible(true);
    }

    public final void unsetWaitInfo() {
        this.loginBox.enableLoginButton();
        this.progress.setVisible(false);
    }
}

