/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.main;

import com.vaadin.componentfactory.EnhancedDialog;
import com.vaadin.componentfactory.theme.EnhancedDialogVariant;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.main.VWindowsMenuItem;

@CssImport.Container(value={@CssImport(value="./styles/galite/windows.css", themeFor="vcf-enhanced-dialog-overlay"), @CssImport(value="./styles/galite/windows.css")})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/main/VWindowsMenu;", "Lcom/vaadin/componentfactory/EnhancedDialog;", "Lcom/vaadin/flow/component/HasStyle;", "()V", "headerText", "Lcom/vaadin/flow/component/html/Label;", "items", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "windowsItemsMap", "", "Lcom/vaadin/flow/component/Component;", "Lorg/kopi/galite/visual/ui/vaadin/main/VWindowsMenuItem;", "addWindow", "window", "title", "", "getItemFor", "removeWindow", "", "setHeaderText", "text", "galite-core"})
public final class VWindowsMenu
extends EnhancedDialog
implements HasStyle {
    @NotNull
    private final VerticalLayout items = new VerticalLayout();
    @NotNull
    private final Map<Component, VWindowsMenuItem> windowsItemsMap = new LinkedHashMap();
    @NotNull
    private final Label headerText = new Label();

    public VWindowsMenu() {
        Icon switchWindowIcon = VaadinIcon.BROWSER.create();
        Icon closeIcon = VaadinIcon.CLOSE_CIRCLE.create();
        HorizontalLayout header = new HorizontalLayout();
        Component[] componentArray = new Component[]{(Component)this.headerText, (Component)switchWindowIcon};
        HorizontalLayout horizontalLayout = new HorizontalLayout(componentArray);
        componentArray = new EnhancedDialogVariant[]{EnhancedDialogVariant.SIZE_SMALL};
        this.setThemeVariants((EnhancedDialogVariant[])componentArray);
        this.getElement().getThemeList().add((Object)"k-windowsMenu");
        header.setClassName("window-items-title");
        closeIcon.setClassName("close-icon");
        componentArray = new HasElement[]{(HasElement)horizontalLayout};
        header.setFlexGrow(1.0, (HasElement[])componentArray);
        closeIcon.addClickListener(new ComponentEventListener(){

            public final void onComponentEvent(ClickEvent<Icon> it) {
                this.close();
            }
        });
        componentArray = new Component[]{(Component)horizontalLayout};
        header.add(componentArray);
        componentArray = new Component[]{(Component)closeIcon};
        header.add(componentArray);
        componentArray = new Component[]{(Component)header};
        this.setHeader(componentArray);
        componentArray = new Component[]{(Component)this.items};
        this.setContent(componentArray);
    }

    @NotNull
    public final VWindowsMenuItem addWindow(@NotNull Component window, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        VWindowsMenuItem item = new VWindowsMenuItem(title, window);
        this.items.setClassName("window-items-container");
        this.windowsItemsMap.put(window, item);
        Component[] componentArray = new Component[]{(Component)item};
        this.items.add(componentArray);
        return item;
    }

    public final void removeWindow(@NotNull Component window) {
        VWindowsMenuItem toRemove;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        VWindowsMenuItem vWindowsMenuItem = toRemove = this.windowsItemsMap.get(window);
        if (vWindowsMenuItem != null) {
            VWindowsMenuItem it = vWindowsMenuItem;
            boolean bl = false;
            Component[] componentArray = new Component[]{(Component)it};
            this.items.remove(componentArray);
        }
        this.windowsItemsMap.remove(window);
    }

    public final void setHeaderText(@Nullable String text) {
        this.headerText.setText(text);
    }

    @Nullable
    public final VWindowsMenuItem getItemFor(@Nullable Component window) {
        return this.windowsItemsMap.get(window);
    }
}

