/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.notif;

import com.vaadin.componentfactory.EnhancedDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.base.Utils;
import org.kopi.galite.visual.ui.vaadin.common.VSpan;
import org.kopi.galite.visual.ui.vaadin.main.MainWindow;
import org.kopi.galite.visual.ui.vaadin.notif.NotificationListener;
import org.kopi.galite.visual.ui.vaadin.window.Window;

@CssImport.Container(value={@CssImport(value="./styles/galite/notification.css"), @CssImport(value="./styles/galite/notification.css", themeFor="vcf-enhanced-dialog-overlay")})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\b'\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B+\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001cJ\u0006\u0010,\u001a\u00020*J\u0017\u0010-\u001a\u00020*2\b\u0010.\u001a\u0004\u0018\u00010$H\u0004\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020$H\u0004J\u000e\u00101\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001cJ\b\u0010\u000e\u001a\u00020*H&J\u0012\u00102\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u00010\u0004H\u0002J\u0006\u00104\u001a\u00020*R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0005\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0003\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00065"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/notif/AbstractNotification;", "Lcom/vaadin/componentfactory/EnhancedDialog;", "Lcom/vaadin/flow/component/Focusable;", "title", "", "message", "locale", "parent", "Lcom/vaadin/flow/component/Component;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/vaadin/flow/component/Component;)V", "buttons", "Lcom/vaadin/flow/component/html/Div;", "getButtons", "()Lcom/vaadin/flow/component/html/Div;", "setButtons", "(Lcom/vaadin/flow/component/html/Div;)V", "content", "Lcom/vaadin/flow/component/orderedlayout/HorizontalLayout;", "footer", "getFooter", "icon", "Lcom/vaadin/flow/component/icon/Icon;", "iconName", "Lcom/vaadin/flow/component/icon/VaadinIcon;", "getIconName", "()Lcom/vaadin/flow/component/icon/VaadinIcon;", "listeners", "", "Lorg/kopi/galite/visual/ui/vaadin/notif/NotificationListener;", "getLocale", "()Ljava/lang/String;", "Lorg/kopi/galite/visual/ui/vaadin/common/VSpan;", "getParent", "()Lcom/vaadin/flow/component/Component;", "Lcom/vaadin/flow/component/html/H3;", "yesIsDefault", "", "getYesIsDefault$galite_core", "()Z", "setYesIsDefault$galite_core", "(Z)V", "addNotificationListener", "", "l", "createContent", "fireOnClose", "action", "(Ljava/lang/Boolean;)V", "goBackToLastFocusedWindow", "removeNotificationListener", "setNotificationMessage", "text", "show", "galite-core"})
public abstract class AbstractNotification
extends EnhancedDialog
implements Focusable<AbstractNotification> {
    @NotNull
    private final String locale;
    @Nullable
    private final Component parent;
    @NotNull
    private List<NotificationListener> listeners;
    @NotNull
    private final Icon icon;
    @NotNull
    private final H3 title;
    @NotNull
    private HorizontalLayout content;
    @NotNull
    private VSpan message;
    @NotNull
    private Div buttons;
    private boolean yesIsDefault;
    @NotNull
    private final Div footer;

    public AbstractNotification(@Nullable String title, @Nullable String message, @NotNull String locale, @Nullable Component parent) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.locale = locale;
        this.parent = parent;
        this.listeners = new ArrayList();
        this.icon = new Icon(this.getIconName());
        this.title = new H3(title);
        this.content = new HorizontalLayout();
        this.message = new VSpan();
        this.buttons = new Div();
        this.footer = new Div();
        this.getElement().getClassList().add((Object)"notification");
        this.getElement().getThemeList().add((Object)"notification");
        this.getElement().setAttribute("hideFocus", true);
        this.getElement().getStyle().set("outline", "0px");
        this.setDraggable(true);
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        this.message.setClassName("k-notification-message");
        this.message.getStyle().set("white-space", "nowrap");
        this.buttons.setClassName("k-notification-buttons");
        this.title.setClassName("k-notification-title");
        this.content.setClassName("k-notification-content");
        this.content.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        Component[] componentArray = new Component[]{(Component)this.title};
        this.setHeader(componentArray);
        this.setNotificationMessage(message);
        this.icon.setSize("2.8em");
        this.icon.setClassName("k-notification-icon");
        componentArray = new Component[]{(Component)this.icon};
        this.content.add(componentArray);
        componentArray = new Component[]{(Component)this.message};
        this.content.add(componentArray);
        componentArray = new Component[]{(Component)this.content};
        this.setContent(componentArray);
        componentArray = new Component[]{(Component)this.buttons};
        this.footer.add(componentArray);
        this.setButtons();
        componentArray = new Component[]{(Component)this.footer};
        this.setFooter(componentArray);
    }

    @NotNull
    protected final String getLocale() {
        return this.locale;
    }

    @Nullable
    public final Component getParent() {
        return this.parent;
    }

    @NotNull
    protected final Div getButtons() {
        return this.buttons;
    }

    protected final void setButtons(@NotNull Div div) {
        Intrinsics.checkNotNullParameter((Object)div, (String)"<set-?>");
        this.buttons = div;
    }

    public final boolean getYesIsDefault$galite_core() {
        return this.yesIsDefault;
    }

    public final void setYesIsDefault$galite_core(boolean bl) {
        this.yesIsDefault = bl;
    }

    @NotNull
    public final Div getFooter() {
        return this.footer;
    }

    public final void show() {
        this.open();
    }

    public final void addNotificationListener(@NotNull NotificationListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    public final void removeNotificationListener(@NotNull NotificationListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    protected final void fireOnClose(@Nullable Boolean action2) {
        Object object;
        Component component = this.parent;
        if (component == null) {
            object = null;
        } else {
            MainWindow mainWindow = Utils.INSTANCE.findMainWindow(component);
            object = mainWindow == null ? null : mainWindow.getCurrentWindow();
        }
        Component component2 = object;
        Window lastActiveWindow = component2 instanceof Window ? (Window)component2 : null;
        this.close();
        for (NotificationListener l : this.listeners) {
            l.onClose(action2);
        }
        Window window = lastActiveWindow;
        if (window != null) {
            window.goBackToLastFocusedTextField();
        }
    }

    private final void setNotificationMessage(String text) {
        if (text != null) {
            CharSequence charSequence = text;
            Regex regex = new Regex("\n");
            String string = "<br>";
            charSequence = regex.replace(charSequence, string);
            regex = new Regex("<br><br>");
            string = "<br>";
            this.message.setHtml(regex.replace(charSequence, string));
        }
    }

    public final void createContent() {
        this.content.addComponentAsFirst((Component)this.icon);
        Component[] componentArray = new Component[]{(Component)this.message};
        this.content.add(componentArray);
        componentArray = new Component[]{(Component)this.content};
        super.setContent(componentArray);
    }

    protected final boolean goBackToLastFocusedWindow() {
        return true;
    }

    public abstract void setButtons();

    @NotNull
    protected abstract VaadinIcon getIconName();
}

