/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util;

import java.text.BreakIterator;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.util.base.Utils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/kopi/galite/visual/util/LineBreaker;", "Lorg/kopi/galite/visual/util/base/Utils;", "()V", "Companion", "galite-core"})
public final class LineBreaker
extends Utils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0007J%\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\f2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007J&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/kopi/galite/visual/util/LineBreaker$Companion;", "", "()V", "addBreakForWidth", "", "sourceText", "width", "", "modelToText", "source", "col", "splitForWidth", "", "(Ljava/lang/String;I)[Ljava/lang/String;", "textToModel", "lin", "fixed", "", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String textToModel(@NotNull String source, int col, int lin) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return this.textToModel(source, col, lin, false);
        }

        @NotNull
        public final String textToModel(@NotNull String source, int col, int lin, boolean fixed) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            StringBuilder $this$textToModel_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int length = source.length();
            int start = 0;
            int lines = 0;
            while (start < length && lines < lin) {
                int n;
                String string;
                int index = StringsKt.indexOf$default((CharSequence)source, (char)'\n', (int)start, (boolean)false, (int)4, null);
                if (index == -1) {
                    string = source.substring(start, length);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$textToModel_u24lambda_u2d0.append(string);
                    start = length;
                    continue;
                }
                string = source.substring(start, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$textToModel_u24lambda_u2d0.append(string);
                if (fixed) {
                    n = index - start;
                    while (n < col) {
                        int i = n++;
                        $this$textToModel_u24lambda_u2d0.append(' ');
                    }
                } else {
                    int i = (index - start) % col;
                    while (i != 0 && i < col) {
                        $this$textToModel_u24lambda_u2d0.append(' ');
                        int n2 = i;
                        i = n2 + 1;
                    }
                }
                start = index + 1;
                n = lines;
                lines = n + 1;
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final String modelToText(@Nullable String source, int col) {
            String string;
            if (source != null) {
                StringBuilder stringBuilder;
                StringBuilder $this$modelToText_u24lambda_u2d1 = stringBuilder = new StringBuilder();
                boolean bl = false;
                int length = source.length();
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)length)), (int)col);
                int n = intProgression.getFirst();
                int n2 = intProgression.getLast();
                int n3 = intProgression.getStep();
                if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                    int start;
                    do {
                        start = n;
                        n += n3;
                        String string2 = source;
                        int n4 = RangesKt.coerceAtMost((int)(start + col), (int)length);
                        String string3 = string2.substring(start, n4);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        String line = string3;
                        int last = -1;
                        for (int i = line.length() - 1; last == -1 && i >= 0; --i) {
                            if (CharsKt.isWhitespace((char)line.charAt(i))) continue;
                            last = i;
                        }
                        if (start != 0) {
                            $this$modelToText_u24lambda_u2d1.append('\n');
                        }
                        if (last == -1) continue;
                        string3 = line;
                        int n5 = 0;
                        int n6 = last + 1;
                        String string4 = string3.substring(n5, n6);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        $this$modelToText_u24lambda_u2d1.append(string4);
                    } while (start != n2);
                }
                String string5 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
                string = string5;
            } else {
                string = "";
            }
            return string;
        }

        @NotNull
        public final String addBreakForWidth(@Nullable String sourceText, int width) {
            StringBuilder stringBuilder;
            String string = sourceText;
            if (string == null) {
                string = "";
            }
            String source = string;
            BreakIterator boundary = BreakIterator.getLineInstance();
            boundary.setText(source);
            int start = 0;
            start = boundary.first();
            int length = 0;
            int n = source.length();
            StringBuilder $this$addBreakForWidth_u24lambda_u2d2 = stringBuilder = new StringBuilder(n);
            boolean bl = false;
            int end = boundary.next();
            while (end != -1) {
                if ((length += end - start) > width) {
                    length = end - start;
                    $this$addBreakForWidth_u24lambda_u2d2.append("\n");
                }
                String string2 = source;
                int n2 = start;
                String string3 = string2.substring(n2, end);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$addBreakForWidth_u24lambda_u2d2.append(string3);
                string2 = source;
                n2 = start;
                string3 = string2.substring(n2, end);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                if (StringsKt.endsWith$default((String)string3, (String)"\n", (boolean)false, (int)2, null)) {
                    length = 0;
                }
                start = end;
                end = boundary.next();
            }
            String string4 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
            return string4;
        }

        @NotNull
        public final String[] splitForWidth(@Nullable String source, int width) {
            CharSequence charSequence = this.addBreakForWidth(source, width);
            Regex regex = new Regex("\n");
            int n = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return stringArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

