/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util.lpr;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.util.lpr.LpdException;
import org.kopi.galite.visual.util.lpr.LpdOptions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 E2\u00020\u0001:\u0001EB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0006\u0010%\u001a\u00020#J,\u0010&\u001a\u000e\u0012\u0002\b\u00030'j\u0006\u0012\u0002\b\u0003`(2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\r2\b\u0010+\u001a\u0004\u0018\u00010\u0010J\u0006\u0010,\u001a\u00020#J#\u0010-\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00102\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010/\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010H\u0002J\u0018\u00104\u001a\u00020#2\u0006\u00102\u001a\u00020\u00102\u0006\u0010\t\u001a\u000205H\u0002J.\u00106\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00102\u0006\u00107\u001a\u00020\r2\u0006\u00103\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00108\u001a\u000205J0\u00106\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00102\u0006\u00107\u001a\u00020\r2\u0006\u00103\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\b\u00109\u001a\u0004\u0018\u00010:J\u000e\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020\rJ\u000e\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020\u0010J\u000e\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020AJ\u0006\u0010D\u001a\u00020#R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0004R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0007\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0014R(\u0010\u001f\u001a\u0004\u0018\u00010\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0012\"\u0004\b!\u0010\u0014\u00a8\u0006F"}, d2={"Lorg/kopi/galite/visual/util/lpr/LpdClient;", "", "options", "Lorg/kopi/galite/visual/util/lpr/LpdOptions;", "(Lorg/kopi/galite/visual/util/lpr/LpdOptions;)V", "connection", "Ljava/net/Socket;", "<set-?>", "Ljava/io/DataInputStream;", "inputStream", "getInputStream", "()Ljava/io/DataInputStream;", "isConnected", "", "()Z", "localHost", "", "getLocalHost", "()Ljava/lang/String;", "setLocalHost", "(Ljava/lang/String;)V", "getOptions", "()Lorg/kopi/galite/visual/util/lpr/LpdOptions;", "setOptions", "Ljava/io/DataOutputStream;", "outputStream", "getOutputStream", "()Ljava/io/DataOutputStream;", "printHost", "getPrintHost", "setPrintHost", "user", "getUser", "setUser", "checkAcknowledge", "", "errorMessage", "close", "getWaitingJob", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "queue", "longOutput", "userOrJobID", "open", "removeJob", "args", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "sendControl", "jobID", "control", "sendData", "Ljava/io/InputStream;", "sendPrinterJob", "controlFirst", "stream", "data", "", "setBindSourcePort", "flag", "setProxyHost", "proxyHost", "setRemotePort", "remotePort", "", "setTimeout", "timeout", "startWaitingJob", "Companion", "galite-core"})
public final class LpdClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LpdOptions options;
    @Nullable
    private Socket connection;
    @Nullable
    private DataInputStream inputStream;
    @Nullable
    private DataOutputStream outputStream;
    private static final int SOURCE_PORT_LOW = 721;
    private static final int SOURCE_PORT_HIGH = 731;
    private static final int REMOTE_PORT = 515;
    private static final int PROXY_PORT = 7290;

    public LpdClient(@NotNull LpdOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    @NotNull
    public final LpdOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull LpdOptions lpdOptions) {
        Intrinsics.checkNotNullParameter((Object)lpdOptions, (String)"<set-?>");
        this.options = lpdOptions;
    }

    @Nullable
    public final DataInputStream getInputStream() {
        return this.inputStream;
    }

    @Nullable
    public final DataOutputStream getOutputStream() {
        return this.outputStream;
    }

    public final void open() {
        if (Intrinsics.areEqual((Object)this.options.getLocalHost(), (Object)"localhost")) {
            try {
                String string = InetAddress.getLocalHost().getHostName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalHost().hostName");
                this.options.setLocalHost(string);
            }
            catch (UnknownHostException e) {
                System.err.println("can't resolve local host name");
                this.options.setLocalHost("localhost");
            }
        }
        if (this.options.getPrintHost() == null) {
            this.options.setPrintHost(this.options.getLocalHost());
        }
        if (this.options.getUser() == null) {
            this.options.setUser(System.getProperty("user.name"));
        }
        if (this.options.getRemotePort() == -1) {
            this.options.setRemotePort(this.options.getProxyHost() != null ? 7290 : 515);
        }
        InetAddress remoteHost = InetAddress.getByName(this.options.getProxyHost() != null ? this.options.getProxyHost() : this.options.getPrintHost());
        if (this.options.getBindSourcePort()) {
            int port = 721;
            while (this.connection == null && port <= 731) {
                block12: {
                    try {
                        this.connection = new Socket(remoteHost, this.options.getRemotePort(), InetAddress.getLocalHost(), port);
                        this.options.setSourcePort(port);
                    }
                    catch (IOException e) {
                        if (port != 731) break block12;
                        throw e;
                    }
                }
                int n = port;
                port = n + 1;
            }
        } else {
            Socket socket = this.connection = new Socket(this.options.getPrintHost(), this.options.getRemotePort());
            Intrinsics.checkNotNull((Object)socket);
            this.options.setSourcePort(socket.getLocalPort());
        }
        Socket socket = this.connection;
        Intrinsics.checkNotNull((Object)socket);
        socket.setSoTimeout(this.options.getTimeout());
        Socket socket2 = this.connection;
        Intrinsics.checkNotNull((Object)socket2);
        this.inputStream = new DataInputStream(socket2.getInputStream());
        Socket socket3 = this.connection;
        Intrinsics.checkNotNull((Object)socket3);
        this.outputStream = new DataOutputStream(socket3.getOutputStream());
        if (this.options.getProxyHost() != null) {
            DataOutputStream dataOutputStream = this.outputStream;
            Intrinsics.checkNotNull((Object)dataOutputStream);
            dataOutputStream.writeBytes(Intrinsics.stringPlus((String)this.options.getPrintHost(), (Object)"\n"));
        }
    }

    public final void close() {
        try {
            DataInputStream dataInputStream = this.inputStream;
            Intrinsics.checkNotNull((Object)dataInputStream);
            dataInputStream.close();
            DataOutputStream dataOutputStream = this.outputStream;
            Intrinsics.checkNotNull((Object)dataOutputStream);
            dataOutputStream.close();
            Socket socket = this.connection;
            Intrinsics.checkNotNull((Object)socket);
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println((Object)"Error while closing connection port");
            System.out.println((Object)e.getMessage());
        }
        this.connection = null;
    }

    public final boolean isConnected() {
        return this.connection != null;
    }

    @NotNull
    public final String getLocalHost() {
        return this.options.getLocalHost();
    }

    public final void setLocalHost(@NotNull String localHost) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        this.options.setLocalHost(localHost);
    }

    public final void setProxyHost(@NotNull String proxyHost) {
        Intrinsics.checkNotNullParameter((Object)proxyHost, (String)"proxyHost");
        this.options.setProxyHost(proxyHost);
    }

    @NotNull
    public final String getPrintHost() {
        return this.options.getPrintHost();
    }

    public final void setPrintHost(@NotNull String printHost) {
        Intrinsics.checkNotNullParameter((Object)printHost, (String)"printHost");
        this.options.setPrintHost(printHost);
    }

    public final void setRemotePort(int remotePort) {
        this.options.setRemotePort(remotePort);
    }

    public final void setBindSourcePort(boolean flag) {
        this.options.setBindSourcePort(flag);
    }

    @Nullable
    public final String getUser() {
        String string = this.options.getUser();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final void setUser(@Nullable String user) {
        this.options.setUser(user);
    }

    public final void setTimeout(int timeout) {
        this.options.setTimeout(timeout);
    }

    public final void startWaitingJob() {
        DataOutputStream out;
        DataOutputStream dataOutputStream = out = this.outputStream;
        Intrinsics.checkNotNull((Object)dataOutputStream);
        dataOutputStream.write(1);
        out.writeBytes("\n");
        out.flush();
    }

    @NotNull
    public final ArrayList<?> getWaitingJob(@NotNull String queue, boolean longOutput, @Nullable String userOrJobID) {
        DataOutputStream out;
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        DataOutputStream dataOutputStream = out = this.outputStream;
        Intrinsics.checkNotNull((Object)dataOutputStream);
        dataOutputStream.write(longOutput ? 4 : 3);
        out.writeBytes(queue);
        if (userOrJobID != null) {
            out.writeBytes(Intrinsics.stringPlus((String)" ", (Object)userOrJobID));
        }
        out.writeBytes("\n");
        DataInputStream inputStream = this.inputStream;
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inputStream));
        String line = null;
        ArrayList<String> state = new ArrayList<String>();
        while (true) {
            String string;
            String it = string = lnr.readLine();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            line = it;
            if (string == null || line.length() <= 1) break;
            state.add(line);
        }
        return state;
    }

    public final void removeJob(@NotNull String queue, @Nullable String[] args) {
        DataOutputStream out;
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        DataOutputStream dataOutputStream = out = this.outputStream;
        Intrinsics.checkNotNull((Object)dataOutputStream);
        dataOutputStream.write(5);
        out.writeBytes(queue + ' ' + this.getUser());
        if (args != null) {
            String[] $this$forEach$iv = args;
            boolean $i$f$forEach = false;
            for (String element$iv : $this$forEach$iv) {
                String it = element$iv;
                boolean bl = false;
                out.writeBytes(Intrinsics.stringPlus((String)" ", (Object)it));
            }
        }
        out.writeBytes("\n");
    }

    public final void sendPrinterJob(@NotNull String queue, boolean controlFirst, @NotNull String control, @NotNull String jobID, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        Intrinsics.checkNotNullParameter((Object)jobID, (String)"jobID");
        this.sendPrinterJob(queue, controlFirst, control, jobID, new ByteArrayInputStream(data));
    }

    public final void sendPrinterJob(@NotNull String queue, boolean controlFirst, @NotNull String control, @NotNull String jobID, @NotNull InputStream stream) {
        DataOutputStream out;
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        Intrinsics.checkNotNullParameter((Object)jobID, (String)"jobID");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        DataOutputStream dataOutputStream = out = this.outputStream;
        Intrinsics.checkNotNull((Object)dataOutputStream);
        dataOutputStream.write(2);
        out.writeBytes(StringsKt.trimIndent((String)String.valueOf(queue)));
        this.checkAcknowledge(Intrinsics.stringPlus((String)"Error while start printing on queue ", (Object)queue));
        if (controlFirst) {
            this.sendControl(jobID, control);
            this.sendData(jobID, stream);
        } else {
            this.sendData(jobID, stream);
            this.sendControl(jobID, control);
        }
    }

    private final void sendControl(String jobID, String control) {
        DataOutputStream out;
        DataOutputStream dataOutputStream = out = this.outputStream;
        Intrinsics.checkNotNull((Object)dataOutputStream);
        dataOutputStream.write(2);
        out.writeBytes(Intrinsics.stringPlus((String)"", (Object)control.length()));
        out.writeBytes(" ");
        out.writeBytes("cfA" + jobID + this.getPrintHost() + '\n');
        this.checkAcknowledge("Error while start sending control file");
        out.writeBytes(control);
        out.writeByte(0);
        this.checkAcknowledge("Error while sending control file");
    }

    private final void sendData(String jobID, InputStream inputStream) {
        DataOutputStream out;
        int size = inputStream.available();
        DataOutputStream dataOutputStream = out = this.outputStream;
        Intrinsics.checkNotNull((Object)dataOutputStream);
        dataOutputStream.write(3);
        out.writeBytes(String.valueOf(size));
        out.writeBytes(" ");
        out.writeBytes("dfA" + jobID + this.getPrintHost() + '\n');
        this.checkAcknowledge("Error while start sending data file");
        int n = 0;
        while (n < size) {
            int i = n++;
            out.write(inputStream.read());
        }
        out.writeByte(0);
        out.flush();
        inputStream.close();
        this.checkAcknowledge("Error while sending data file");
    }

    private final void checkAcknowledge(String errorMessage) {
        DataInputStream dataInputStream = this.inputStream;
        Intrinsics.checkNotNull((Object)dataInputStream);
        byte returnCode = dataInputStream.readByte();
        if (returnCode != 0) {
            throw new LpdException(returnCode, errorMessage);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kopi/galite/visual/util/lpr/LpdClient$Companion;", "", "()V", "PROXY_PORT", "", "REMOTE_PORT", "SOURCE_PORT_HIGH", "SOURCE_PORT_LOW", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

