/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.kopi.galite.visual.preview.PreviewListener;
import org.kopi.galite.visual.preview.VPreviewWindow;
import org.kopi.galite.visual.util.base.InconsistencyException;
import org.kopi.galite.visual.visual.Action;
import org.kopi.galite.visual.visual.ApplicationConfiguration;
import org.kopi.galite.visual.visual.DPositionPanelListener;
import org.kopi.galite.visual.visual.UserConfiguration;
import org.kopi.vkopi.lib.ui.swing.visual.DPositionPanel;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;
import org.kopi.vkopi.lib.ui.swing.visual.Utils;

public class DPreviewWindow
extends DWindow
implements DPositionPanelListener,
PreviewListener {
    private VPreviewWindow model;
    private JLabel label;
    private JScrollPane bodypane;
    private DPositionPanel blockInfo;
    private static final long serialVersionUID = -3057089222899270837L;

    public DPreviewWindow(VPreviewWindow model2) {
        super(model2);
        this.model = model2;
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -3945777720296639744L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DPreviewWindow.this.closeWindow();
            }
        }, null, KeyStroke.getKeyStroke(27, 0), 2);
        this.label = new JLabel();
        this.bodypane = new JScrollPane(this.label, 20, 30);
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)this.bodypane, "Center");
        this.label.setIconTextGap(0);
        this.label.setRequestFocusEnabled(true);
        this.blockInfo = new DPositionPanel(this);
        this.setStatePanel(this.blockInfo);
        model2.addPreviewListener(this);
        this.label.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                if (k.getKeyCode() == 33 && DPreviewWindow.this.model.getCurrentPage() > 1) {
                    DPreviewWindow.this.gotoPrevPosition();
                }
                if (k.getKeyCode() == 34 && DPreviewWindow.this.model.getCurrentPage() < DPreviewWindow.this.model.getNumberOfPages()) {
                    DPreviewWindow.this.gotoNextPosition();
                }
                if (k.getKeyCode() == 36 && DPreviewWindow.this.model.getCurrentPage() > 1) {
                    DPreviewWindow.this.gotoFirstPosition();
                }
                if (k.getKeyCode() == 35 && DPreviewWindow.this.model.getCurrentPage() < DPreviewWindow.this.model.getNumberOfPages()) {
                    DPreviewWindow.this.gotoLastPosition();
                }
            }
        });
    }

    public void init() {
    }

    @Override
    public void run() {
        this.setTitle(this.model.getTitle());
        this.label.setIcon(this.createIcon(1));
        JFrame frame = this.getFrame();
        frame.pack();
        Rectangle bounds = Utils.calculateBounds(frame, null, null);
        frame.setBounds(bounds);
        this.setPagePosition(this.model.getCurrentPage(), this.model.getNumberOfPages());
        WindowAdapter listener = new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent evt) {
                int oldState = evt.getOldState();
                int newState = evt.getNewState();
                if ((oldState & 6) == 0 && (newState & 6) != 0) {
                    DPreviewWindow.this.getFrame().invalidate();
                    DPreviewWindow.this.getFrame().validate();
                    UserConfiguration userConfig = ApplicationConfiguration.Companion.getConfiguration().getUserConfiguration();
                    DPreviewWindow.this.zoomFit(userConfig == null ? 1 : userConfig.getPreviewMode());
                }
            }
        };
        frame.addWindowStateListener(listener);
        frame.setVisible(true);
        this.label.requestFocusInWindow();
        UserConfiguration userConfig = ApplicationConfiguration.Companion.getConfiguration().getUserConfiguration();
        if (userConfig != null && userConfig.getPreviewScreen() == 1) {
            frame.setExtendedState(6);
        } else if (userConfig != null && userConfig.getPreviewMode() != 1) {
            this.zoomFit(userConfig.getPreviewMode());
        }
    }

    public void setPagePosition(int current, int count) {
        this.blockInfo.setPosition(current, count);
    }

    private void setIcon(int current) {
        ImageIcon img = (ImageIcon)this.label.getIcon();
        if (img != null) {
            img.getImage().flush();
        }
        ImageIcon imgNew = this.createIcon(current);
        this.label.setIcon(imgNew);
        if (img != null) {
            this.bodypane.invalidate();
            this.bodypane.validate();
            this.centerScrollbar(this.bodypane.getHorizontalScrollBar());
            this.centerScrollbar(this.bodypane.getVerticalScrollBar());
        }
    }

    private void centerScrollbar(JScrollBar bar) {
        BoundedRangeModel rangemodel = bar.getModel();
        rangemodel.setValue(Math.max((rangemodel.getMaximum() - rangemodel.getExtent()) / 2, 0));
    }

    @Override
    public void pageChanged(int current) {
        this.setIcon(current);
        this.setPagePosition(current, this.model.getNumberOfPages());
    }

    @Override
    public void zoomChanged() {
        this.setIcon(this.model.getCurrentPage());
    }

    @Override
    public void zoomFit(int type2) {
        float ratio;
        Dimension dim = this.bodypane.getSize();
        switch (type2) {
            case 1: {
                ratio = Math.min((float)dim.height / (float)this.model.getHeight(), (float)dim.width / (float)this.model.getWidth()) * 0.99f;
                break;
            }
            case 3: {
                ratio = (float)dim.height * 1.03f / (float)this.model.getHeight();
                break;
            }
            case 2: {
                ratio = (float)dim.width * 1.05f / (float)this.model.getWidth();
                break;
            }
            default: {
                throw new InconsistencyException("Unkown type of zoom");
            }
        }
        this.model.zoom(ratio);
    }

    @Override
    public void gotoNextPosition() {
        this.getModel().performAsyncAction(new Action("preview right"){

            @Override
            public void execute() {
                DPreviewWindow.this.getModel().executeVoidTrigger(3);
            }
        });
    }

    @Override
    public void gotoPrevPosition() {
        this.getModel().performAsyncAction(new Action("preview left"){

            @Override
            public void execute() {
                DPreviewWindow.this.getModel().executeVoidTrigger(2);
            }
        });
    }

    @Override
    public void gotoLastPosition() {
        this.getModel().performAsyncAction(new Action("preview last"){

            @Override
            public void execute() {
                DPreviewWindow.this.getModel().executeVoidTrigger(4);
            }
        });
    }

    @Override
    public void gotoFirstPosition() {
        this.getModel().performAsyncAction(new Action("preview first"){

            @Override
            public void execute() {
                DPreviewWindow.this.getModel().executeVoidTrigger(1);
            }
        });
    }

    @Override
    public void gotoPosition(final int posno) {
        this.getModel().performAsyncAction(new Action("preview position"){

            @Override
            public void execute() {
                ((VPreviewWindow)DPreviewWindow.this.getModel()).gotoPosition(posno);
            }
        });
    }

    private ImageIcon createIcon(int idx) {
        return new ImageIcon(this.model.getPreviewFileName(idx));
    }

    public static BufferedImage rotate(String file) throws IOException {
        int h;
        BufferedImage image = ImageIO.read(new File(file));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        int w = image.getWidth();
        int neww = h = image.getHeight();
        int newh = w;
        int transparency = image.getColorModel().getTransparency();
        BufferedImage result = gc.createCompatibleImage(neww, newh, transparency);
        Graphics2D g = result.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(1.5707963267948966, w / 2, h / 2);
        g.drawRenderedImage(image, null);
        return result;
    }
}

