/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.report;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.kopi.galite.visual.report.ColumnStyle;
import org.kopi.galite.visual.report.MReport;
import org.kopi.galite.visual.report.Parameters;
import org.kopi.galite.visual.report.Point;
import org.kopi.galite.visual.report.UReport;
import org.kopi.galite.visual.report.VDecimalColumn;
import org.kopi.galite.visual.report.VIntegerColumn;
import org.kopi.galite.visual.report.VReport;
import org.kopi.galite.visual.report.VReportColumn;
import org.kopi.galite.visual.report.VSeparatorColumn;
import org.kopi.galite.visual.visual.VException;
import org.kopi.galite.visual.visual.VlibProperties;
import org.kopi.vkopi.lib.ui.swing.report.CellRenderer;
import org.kopi.vkopi.lib.ui.swing.report.DTable;
import org.kopi.vkopi.lib.ui.swing.report.VTable;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;
import org.kopi.vkopi.lib.ui.swing.visual.Utils;

public class DReport
extends DWindow
implements UReport,
TableCellRenderer {
    private static CellRenderer foldedCell = new CellRenderer(-1);
    public static final Dimension interCellSpacing = new Dimension(1, 1);
    private final MReport model;
    private final VReport report;
    private DTable table;
    private Parameters parameters;
    private CellRenderer[][] cellRenderers;
    private TableColumn[] tablecolumns;
    private boolean columnMove;
    private int fromIndex;
    private int toIndex;
    private int tableWidth;
    private static final long serialVersionUID = -6833408762223390823L;

    public DReport(VReport report) {
        super(report);
        this.report = report;
        this.model = report.getModel();
        this.model.addReportListener(this);
    }

    @Override
    public void setColumnLabel(int column2, String label) {
        this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(column2)).setHeaderValue(label);
        this.table.getTableHeader().resizeAndRepaint();
    }

    @Override
    public void removeColumn(int position) {
        int i;
        int index = position;
        position = this.table.convertColumnIndexToModel(position);
        this.model.removeColumn(position);
        this.model.initializeAfterRemovingColumn(index);
        this.table.removeColumn(this.tablecolumns[position]);
        TableColumn[] newTableColumns = new TableColumn[this.model.getAccessibleColumnCount()];
        for (i = 0; i < position; ++i) {
            newTableColumns[i] = this.tablecolumns[i];
        }
        for (i = position; i < this.model.getAccessibleColumnCount(); ++i) {
            newTableColumns[i] = this.tablecolumns[i + 1];
            newTableColumns[i].setModelIndex(newTableColumns[i].getModelIndex() - 1);
        }
        this.tablecolumns = newTableColumns;
        int[] pos = new int[this.model.getAccessibleColumnCount()];
        for (int i2 = 0; i2 < this.model.getAccessibleColumnCount(); ++i2) {
            pos[i2] = this.model.getDisplayOrder(i2) > position ? this.model.getDisplayOrder(i2) - 1 : this.model.getDisplayOrder(i2);
        }
        this.report.columnMoved(pos);
    }

    @Override
    public void addColumn(int position) {
        int i;
        this.table.setAutoCreateColumnsFromModel(false);
        TableColumn column2 = new TableColumn(this.model.getColumnCount());
        String headerLabel = "col" + this.model.getColumnCount();
        column2.setHeaderValue(headerLabel);
        this.table.getColumnModel().addColumn(column2);
        this.model.addColumn(headerLabel, position);
        TableColumn[] newTableColumns = new TableColumn[this.model.getAccessibleColumnCount()];
        newTableColumns[this.model.getAccessibleColumnCount() - 1] = this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1);
        for (int i2 = 0; i2 < this.model.getAccessibleColumnCount() - 1; ++i2) {
            newTableColumns[i2] = this.tablecolumns[i2];
        }
        this.tablecolumns = newTableColumns;
        int[] pos = new int[this.model.getAccessibleColumnCount()];
        for (i = 0; i < position; ++i) {
            pos[i] = this.model.getDisplayOrder(i);
        }
        for (i = position + 1; i < this.model.getAccessibleColumnCount(); ++i) {
            pos[i] = this.model.getDisplayOrder(i - 1);
        }
        pos[position] = this.model.getDisplayOrder(this.model.getAccessibleColumnCount() - 1);
        this.report.columnMoved(pos);
    }

    @Override
    public void addColumn() {
        this.addColumn(this.table.getColumnCount());
    }

    @Override
    public UReport.UTable getTable() {
        return this.table;
    }

    @Override
    public void columnMoved(final int[] pos) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DReport.this.reorder(pos);
                DReport.this.model.columnMoved(pos);
                DReport.this.redisplay();
            }
        });
    }

    @Override
    public void contentChanged() {
        if (this.table != null) {
            ((VTable)this.table.getModel()).fireTableDataChanged();
        }
    }

    @Override
    public void build() {
        int i;
        this.parameters = new Parameters(Color.blue);
        this.table = new DTable(new VTable(this.model));
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        this.table.setIntercellSpacing(interCellSpacing);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.getTableHeader().setFont(this.parameters.getFont());
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.buildCellRenderers();
        FontMetrics fontmetrics = this.getFontMetrics(this.parameters.getFont());
        int nbLinesMax = 1;
        for (i = 0; i < this.model.getAccessibleColumnCount(); ++i) {
            VReportColumn column2 = this.model.getAccessibleColumn(i);
            if (column2.getHeight() <= nbLinesMax) continue;
            nbLinesMax = column2.getHeight();
        }
        this.table.setRowHeight(nbLinesMax * fontmetrics.getHeight());
        this.resetWidth();
        this.tablecolumns = new TableColumn[this.model.getAccessibleColumnCount()];
        for (i = 0; i < this.model.getAccessibleColumnCount(); ++i) {
            this.tablecolumns[i] = this.table.getColumnModel().getColumn(i);
        }
        this.addTableListeners();
        JScrollPane scrollpane = new JScrollPane(this.table);
        scrollpane.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        scrollpane.getViewport().setPreferredSize(this.table.getPreferredSize());
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add(scrollpane);
        super.build();
    }

    @Override
    public void resetWidth() {
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.tableWidth += this.resetColumnSize(i);
        }
        this.tableWidth += this.table.getIntercellSpacing().width * (this.table.getColumnCount() + 1);
    }

    @Override
    public void redisplay() {
        this.buildCellRenderers();
        this.table.repaint();
    }

    public int[] getDisplayOrder() {
        int[] displayOrder = new int[this.model.getColumnCount()];
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            displayOrder[i] = this.table.convertColumnIndexToModel(i);
        }
        return displayOrder;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public void reorder(int[] newOrder) {
        int i;
        for (i = 0; i < this.tablecolumns.length; ++i) {
            this.table.removeColumn(this.tablecolumns[i]);
        }
        for (i = 0; i < this.tablecolumns.length; ++i) {
            this.table.addColumn(this.tablecolumns[newOrder[i]]);
        }
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public void run(boolean visible) throws VException {
        this.report.initReport();
        this.report.setMenu();
        if (visible) {
            JFrame frame = this.getFrame();
            frame.pack();
            Rectangle bounds = Utils.calculateBounds(frame, null, null);
            bounds.height = Math.max(bounds.height, 500);
            frame.setBounds(bounds);
            frame.setVisible(true);
            this.setInfoTable();
            this.setFocusable(true);
            this.requestFocusInWindow();
        }
    }

    @Override
    public void run() throws VException {
        this.run(true);
    }

    @Override
    public int getSelectedColumn() {
        int sel = this.table.getSelectedColumn();
        return sel == -1 ? -1 : this.table.convertColumnIndexToModel(sel);
    }

    @Override
    public Point getSelectedCell() {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        return new Point(col, row);
    }

    public static int getState(String text) {
        if (text == null || text.length() == 0) {
            return 1;
        }
        if (text.startsWith("-")) {
            return 2;
        }
        if (text.startsWith("0")) {
            return 3;
        }
        return 0;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column2) {
        int col = table.convertColumnIndexToModel(column2);
        int level = this.model.getRow(row).getLevel();
        boolean folded = this.model.getAccessibleColumn(col).isFolded() && !(this.model.getAccessibleColumn(col) instanceof VSeparatorColumn);
        String text = this.model.getAccessibleColumn(col).format(value);
        CellRenderer cell = null;
        if (folded) {
            cell = foldedCell;
        } else if (this.cellRenderers[col].length == 1) {
            cell = this.cellRenderers[col][0];
        } else {
            int state = DReport.getState(text);
            for (int i = 0; i < this.cellRenderers[col].length; ++i) {
                if (this.cellRenderers[col][i].getState() == state) {
                    cell = this.cellRenderers[col][i];
                    continue;
                }
                if (cell != null || this.cellRenderers[col][i].getState() != 0) continue;
                cell = this.cellRenderers[col][i];
            }
            if (cell == null) {
                cell = this.cellRenderers[col][0];
            }
        }
        cell.set(text, isSelected, this.parameters.getBackground(level));
        this.setInfoTable();
        return cell;
    }

    private void buildCellRenderers() {
        this.cellRenderers = new CellRenderer[this.model.getAccessibleColumnCount()][];
        for (int i = 0; i < this.model.getAccessibleColumnCount(); ++i) {
            HeaderRenderer headerRenderer = new HeaderRenderer();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(this);
            tableColumn.setHeaderRenderer(headerRenderer);
            VReportColumn column2 = this.model.getAccessibleColumn(i);
            if (column2 instanceof VSeparatorColumn) {
                this.cellRenderers[i] = new CellRenderer[]{new CellRenderer(-2)};
                continue;
            }
            ColumnStyle[] styles = column2.getStyles();
            this.cellRenderers[i] = new CellRenderer[styles.length];
            for (int j = 0; j < styles.length; ++j) {
                ColumnStyle style = styles[j];
                this.cellRenderers[i][j] = new CellRenderer(style.getState(), column2.getAlign(), style.getBackground(), style.getForeground(), style.getFont());
            }
        }
    }

    private void addTableListeners() {
        final MReport currentModel = this.model;
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = DReport.this.table.rowAtPoint(e.getPoint());
                int mod = e.getModifiers();
                int column2 = DReport.this.table.columnAtPoint(e.getPoint());
                if ((mod & 8) == 0 && (mod & 4) == 0) {
                    if (e.getClickCount() == 2) {
                        if (currentModel.isRowLine(row)) {
                            try {
                                DReport.this.report.editLine();
                            }
                            catch (VException ef) {
                                ef.printStackTrace();
                            }
                        } else if (row >= 0) {
                            DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                            int index = DReport.this.table.convertColumnIndexToModel(column2);
                            if (currentModel.isRowFold(row, index)) {
                                currentModel.unfoldingRow(row, index);
                            } else {
                                currentModel.foldingRow(row, index);
                            }
                            DReport.this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                } else if ((mod & 0x10) == 0 && (mod & 4) == 0) {
                    DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                    int index = DReport.this.table.convertColumnIndexToModel(column2);
                    if (currentModel.isColumnFold(index)) {
                        currentModel.unfoldingColumn(index);
                    } else {
                        currentModel.foldingColumn(index);
                    }
                    DReport.this.setCursor(Cursor.getDefaultCursor());
                } else if ((mod & 0x10) == 0 && (mod & 8) == 0 && row >= 0) {
                    DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                    int index = DReport.this.table.convertColumnIndexToModel(column2);
                    if (currentModel.isRowFold(row, index)) {
                        currentModel.unfoldingRow(row, index);
                    } else {
                        currentModel.foldingRow(row, index);
                    }
                    DReport.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int mod = e.getModifiers();
                int row = DReport.this.table.rowAtPoint(e.getPoint());
                int column2 = DReport.this.table.columnAtPoint(e.getPoint());
                if ((mod & 8) == 0 && (mod & 4) == 0) {
                    if ((mod & 2) != 0 && (mod & 1) != 0) {
                        DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                        int index = DReport.this.table.convertColumnIndexToModel(column2);
                        currentModel.sortColumn(index);
                        DReport.this.setCursor(Cursor.getDefaultCursor());
                    } else if ((mod & 2) != 0) {
                        if (row >= 0) {
                            DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                            int index = DReport.this.table.convertColumnIndexToModel(column2);
                            if (currentModel.isRowFold(row, index)) {
                                currentModel.unfoldingRow(row, index);
                            } else {
                                currentModel.foldingRow(row, index);
                            }
                            DReport.this.setCursor(Cursor.getDefaultCursor());
                        }
                    } else if ((mod & 1) != 0) {
                        DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                        int index = DReport.this.table.convertColumnIndexToModel(column2);
                        if (currentModel.isColumnFold(index)) {
                            currentModel.unfoldingColumn(index);
                        } else {
                            currentModel.foldingColumn(index);
                        }
                        DReport.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int mod = e.getModifiers();
                final int column2 = DReport.this.table.columnAtPoint(e.getPoint());
                DReport.this.columnMove = false;
                DReport.this.fromIndex = column2;
                if ((mod & 8) == 0 && (mod & 4) == 0) {
                    if ((mod & 2) != 0) {
                        DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                        int index = DReport.this.table.convertColumnIndexToModel(column2);
                        if (currentModel.isColumnFold(index)) {
                            currentModel.unfoldingColumn(index);
                        } else {
                            currentModel.foldingColumn(index);
                        }
                        DReport.this.setCursor(Cursor.getDefaultCursor());
                    } else if ((mod & 1) != 0) {
                        DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                        currentModel.sortColumn(DReport.this.table.convertColumnIndexToModel(column2));
                        DReport.this.setCursor(Cursor.getDefaultCursor());
                    } else if (e.getClickCount() == 2) {
                        DReport.this.model.switchColumnFolding(DReport.this.table.convertColumnIndexToModel(column2));
                        DReport.this.resetWidth();
                    } else {
                        DReport.this.table.setColumnSelectionInterval(column2, column2);
                        if (DReport.this.getSelectedCell().getY() == -1) {
                            DReport.this.table.setRowSelectionInterval(0, 0);
                        }
                    }
                }
                if ((mod & 0x10) == 0 && (mod & 8) == 0) {
                    JPopupMenu labelPopupMenu = new JPopupMenu();
                    JMenuItem item = new JMenuItem(VlibProperties.getString("set_column_info"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                DReport.this.report.setColumnInfo();
                            }
                            catch (VException vException) {
                                // empty catch block
                            }
                            DReport.this.table.setRowSelectionAllowed(false);
                            DReport.this.table.setColumnSelectionAllowed(false);
                            DReport.this.table.setCellSelectionEnabled(true);
                            DReport.this.setCursor(Cursor.getDefaultCursor());
                        }
                    });
                    labelPopupMenu.add(item);
                    item = new JMenuItem(VlibProperties.getString("sort_ASC"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                            currentModel.sortColumn(DReport.this.table.convertColumnIndexToModel(column2), 1);
                            DReport.this.table.setRowSelectionAllowed(false);
                            DReport.this.table.setColumnSelectionAllowed(false);
                            DReport.this.table.setCellSelectionEnabled(true);
                            DReport.this.setCursor(Cursor.getDefaultCursor());
                        }
                    });
                    labelPopupMenu.add(item);
                    item = new JMenuItem(VlibProperties.getString("sort_DSC"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                            currentModel.sortColumn(DReport.this.table.convertColumnIndexToModel(column2), -1);
                            DReport.this.table.setRowSelectionAllowed(false);
                            DReport.this.table.setColumnSelectionAllowed(false);
                            DReport.this.table.setCellSelectionEnabled(true);
                            DReport.this.setCursor(Cursor.getDefaultCursor());
                        }
                    });
                    labelPopupMenu.add(item);
                    item = new JMenuItem(VlibProperties.getString("add_column"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                            DReport.this.addColumn(column2 + 1);
                            DReport.this.table.setRowSelectionAllowed(false);
                            DReport.this.table.setColumnSelectionAllowed(false);
                            DReport.this.table.setCellSelectionEnabled(true);
                            DReport.this.setCursor(Cursor.getDefaultCursor());
                        }
                    });
                    labelPopupMenu.add(item);
                    if (DReport.this.model.getAccessibleColumn(DReport.this.table.convertColumnIndexToModel(column2)).isAddedAtRuntime()) {
                        item = new JMenuItem(VlibProperties.getString("remove_column"));
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                                DReport.this.removeColumn(column2);
                                DReport.this.table.setRowSelectionAllowed(false);
                                DReport.this.table.setColumnSelectionAllowed(false);
                                DReport.this.table.setCellSelectionEnabled(true);
                                DReport.this.setCursor(Cursor.getDefaultCursor());
                            }
                        });
                        labelPopupMenu.add(item);
                    }
                    if (DReport.this.model.getAccessibleColumn(DReport.this.table.convertColumnIndexToModel(column2)).isAddedAtRuntime()) {
                        item = new JMenuItem(VlibProperties.getString("set_column_data"));
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                                try {
                                    DReport.this.report.setColumnData();
                                }
                                catch (VException vException) {
                                    // empty catch block
                                }
                                DReport.this.table.setRowSelectionAllowed(false);
                                DReport.this.table.setColumnSelectionAllowed(false);
                                DReport.this.table.setCellSelectionEnabled(true);
                                DReport.this.setCursor(Cursor.getDefaultCursor());
                            }
                        });
                        labelPopupMenu.add(item);
                    }
                    labelPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                        @Override
                        public void popupMenuCanceled(PopupMenuEvent e) {
                            DReport.this.table.setRowSelectionAllowed(false);
                            DReport.this.table.setColumnSelectionAllowed(false);
                            DReport.this.table.setCellSelectionEnabled(true);
                        }

                        @Override
                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        }

                        @Override
                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                            DReport.this.table.setColumnSelectionAllowed(true);
                            DReport.this.table.setRowSelectionAllowed(false);
                            DReport.this.table.setColumnSelectionInterval(column2, column2);
                        }
                    });
                    labelPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean columnOrderChanged = false;
                if (DReport.this.columnMove) {
                    int[] newColumnOrder = new int[DReport.this.model.getColumnCount()];
                    if (DReport.this.fromIndex != DReport.this.toIndex) {
                        int index = 0;
                        int hiddenColumnsCount = 0;
                        columnOrderChanged = true;
                        for (int i = 0; i < newColumnOrder.length; ++i) {
                            if (!DReport.this.model.getAccessibleColumn(i).isVisible()) {
                                ++hiddenColumnsCount;
                                newColumnOrder[i] = DReport.this.model.getDisplayOrder(index);
                                ++index;
                                continue;
                            }
                            if (i == DReport.this.toIndex + hiddenColumnsCount) {
                                newColumnOrder[i] = DReport.this.table.convertColumnIndexToModel(DReport.this.toIndex);
                                continue;
                            }
                            if (index == DReport.this.fromIndex + hiddenColumnsCount) {
                                ++index;
                            }
                            newColumnOrder[i] = DReport.this.model.getDisplayOrder(index);
                            ++index;
                        }
                    }
                    if (columnOrderChanged) {
                        DReport.this.setCursor(Cursor.getPredefinedCursor(3));
                        DReport.this.model.columnMoved(newColumnOrder);
                        DReport.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                DReport.this.columnMove = true;
                DReport.this.toIndex = e.getToIndex();
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DReport.this.report.setMenu();
            }
        });
    }

    private int resetColumnSize(int pos) {
        String help;
        int width;
        VReportColumn column2 = this.model.getAccessibleColumn(this.table.convertColumnIndexToModel(pos));
        if (column2.isFolded() && !(column2 instanceof VSeparatorColumn)) {
            width = 1;
            help = column2.getLabel();
        } else if (column2 instanceof VDecimalColumn || column2 instanceof VIntegerColumn) {
            width = Math.max(column2.getLabel().length(), column2.getWidth());
            width = Math.max(width, this.model.computeColumnWidth(this.table.convertColumnIndexToModel(pos)));
            help = column2.getHelp();
        } else {
            width = Math.max(column2.getLabel().length(), column2.getWidth());
            help = column2.getHelp();
        }
        if (width != 0) {
            width = width * this.getFontMetrics(this.parameters.getFont()).charWidth('W') + 4;
        }
        this.table.getColumnModel().getColumn(pos).setPreferredWidth(width);
        ((JComponent)((Object)this.table.getColumnModel().getColumn(pos).getHeaderRenderer())).setToolTipText(help);
        return width;
    }

    private void setInfoTable() {
        this.setStatisticsText("<html><font color=#736AFF>" + this.table.getRowCount() + "/" + this.model.getBaseRowCount() + "/" + this.model.getVisibleRowCount() + "</font>");
    }

    class HeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 565901305687203629L;

        public HeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column2) {
            JTableHeader header = table == null ? null : table.getTableHeader();
            if (header != null) {
                this.setEnabled(header.isEnabled());
                this.setComponentOrientation(header.getComponentOrientation());
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            } else {
                this.setEnabled(true);
                this.setComponentOrientation(ComponentOrientation.UNKNOWN);
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
                this.setBackground(UIManager.getColor("TableHeader.background"));
                this.setFont(UIManager.getFont("TableHeader.font"));
            }
            this.setValue(value);
            DReport.this.setInfoTable();
            return this;
        }
    }
}

