/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.kopi.galite.visual.visual.UActor;
import org.kopi.galite.visual.visual.VActor;
import org.kopi.vkopi.lib.ui.swing.base.JMenuButton;
import org.kopi.vkopi.lib.ui.swing.visual.Utils;

public class DActor
implements UActor {
    private JButton button;
    private Action action;
    private VActor model;

    public DActor(VActor model2) {
        this.model = model2;
        this.init();
    }

    @Override
    public boolean isEnabled() {
        return this.action.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.action.setEnabled(enabled);
    }

    @Override
    public boolean isVisible() {
        return this.button != null && this.button.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.button != null) {
            this.button.setVisible(visible);
        }
    }

    @Override
    public void setModel(VActor model2) {
        this.model = model2;
        this.init();
    }

    @Override
    public VActor getModel() {
        return this.model;
    }

    public JButton getButton() {
        return this.button;
    }

    public Action getAction() {
        return this.action;
    }

    private final ImageIcon loadImage(String iconName) {
        ImageIcon image = Utils.getImage(iconName + ".png");
        if (image == null || image == Utils.UKN_IMAGE) {
            image = Utils.getImage(iconName + ".gif");
        }
        return image;
    }

    private void init() {
        this.action = new DActorAction(this.model.getMenuItem(), this.model.getIconName() != null ? this.loadImage(this.model.getIconName()) : null);
        if (this.model.getAcceleratorKey() != 0) {
            this.action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(this.model.getAcceleratorKey(), this.model.getAcceleratorModifier()));
        }
        this.action.putValue("ShortDescription", this.model.getHelp());
        this.action.setEnabled(false);
        if (this.button == null) {
            this.button = new JMenuButton(this.action);
        }
    }

    private class DActorAction
    extends AbstractAction {
        private static final long serialVersionUID = -6510825866215273279L;

        DActorAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DActor.this.model.performAction();
        }
    }
}

