/*
 * Copyright (c) 2013-2022 kopiLeft Services SARL, Tunis TN
 * Copyright (c) 1990-2022 kopiRight Managed Solutions GmbH, Wien AT
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.kopi.galite.visual.ui.vaadin.base

/**
 * Styles constants.
 */
object Styles {
  //---------------------------------------------------
  // DATA MEMBERS
  //---------------------------------------------------
  const val MAIN_WINDOW =                     "k-main-window"
  const val MAIN_WINDOW_TAB_PANEL =           "k-main-window-tab"
  const val WELCOME_VIEW =                    "k-welcome-view"
  const val WINDOW =                          "k-window"
  const val WINDOW_ERROR =                    "k-window-error"
  const val WINDOW_TITLE =                    "k-window-title"
  const val WINDOW_TITLE_IMAGE =              "k-window-title-image"
  const val WINDOW_VIEW =                     "k-window-view"
  const val WINDOW_VIEW_ACTORS =              "k-window-view-actors"
  const val WINDOW_VIEW_CONTENT =             "k-window-view-content"
  const val WINDOW_VIEW_CONTENT_WRAPPER =     "k-window-view-content-wrapper"
  const val WINDOW_VIEW_FOOTER =              "k-window-view-footer"
  const val WINDOW_VIEW_FOOTER_INFO =         "k-window-view-footer-info"
  const val WINDOW_VIEW_FOOTER_STAT =         "k-window-view-footer-stat"
  const val ACTOR =                           "k-actor"
  const val ACTOR_ANCHOR =                    "k-actor-anchor"
  const val ACTOR_IMAGE =                     "k-actor-icon"
  const val ACTOR_LABEL =                     "k-actor-label"
  const val INPUT_BUTTON =                    "k-input-button"
  const val INPUT_BUTTON_PRIMARY =            "k-input-button-primary"
  const val LOGIN_WINDOW =                    "k-loginBoxShadow"
  const val LOGIN_BOX =                       "k-loginBox"
  const val LOGIN_BOX_IMAGE =                 "k-loginBox-image"
  const val LOGIN_BOX_PANE =                  "k-loginBox-pane"
  const val LOGIN_BOX_PANE_ERROR =            "k-loginBox-error"
  const val LOGIN_BOX_PANE_INFO =             "k-loginBox-info"
  const val FIELD =                           "k-field"
  const val TEXT_FIELD =                      "k-textfield"
  const val TEXT_INPUT =                      "k-textinput"
  const val TEXT_AREA_INPUT =                 "k-textareainput"
  const val LABEL =                           "k-label"
  const val LABEL_UNDEFINED_WIDTH =           "k-label-undef-w"
  const val BLOCK =                           "k-block"
  const val BLOCK_LAYOUT =                    "k-blocklayout"
  const val FORM =                            "k-form"
  const val FORM_PAGE =                       "k-form-page"
  const val FORM_PAGE_CONTENT =               "k-form-page-content"
  const val FORM_TAB_PANEL =                  "k-form-tab"
  const val LIST_DIALOG =                     "k-listdialog"
  const val LIST_DIALOG_CONTAINER =           "k-listdialog-container"
  const val LIST_DIALOG_CONTENT =             "k-listdialog-content"
  const val LIST_DIALOG_TABLE =               "k-listdialog-table"
  const val NOTIFICATION =                    "k-notification"
  const val NOTIFICATION_TITLE =              "k-notification-title"
  const val NOTIFICATION_IMAGE =              "k-notification-image"
  const val NOTIFICATION_MESSAGE =            "k-notification-message"
  const val NOTIFICATION_FILLER =             "k-notification-filler"
  const val NOTIFICATION_BUTTONS =            "k-notification-buttons"
  const val PROGRESS_DIALOG =                 "k-progress"
  const val PROGRESS_TITLE =                  "k-progress-title"
  const val PROGRESS_MESSAGE =                "k-progress-message"
  const val PROGRESS_BAR =                    "k-progress-bar"
  const val PROGRESS_BAR_CELL =               "k-progress-bar-cell"
  const val PROGRESS_BAR_BLANK =              "k-progress-bar-blank"
  const val PROGRESS_BAR_FULL =               "k-progress-bar-full"
  const val PIVOT_REPORT_WINDOW =             "k-pivot-report-window"
  const val REPORT_ROW_DIMENSIONS_TABLE =     "k-report-row-table"
  const val REPORT_COLUMN_DIMENSIONS_TABLE = "k-report-column-table"
  const val REPORT_DIMENSION_CELL =          "k-report-dimensions-cell"
  const val REPORT_MEASURES_TABLE = "k-report-measures-table"
  const val REPORT_MEASURE_CELL = "k-report-measure-cell"
  const val REPORT_DIMENSION_DRAG = "k-report-dimension-drag"
  const val REPORT_DIMENSION_DRAG_PANEL = "k-report-dimension-drag-panel"
  const val REPORT_DIMENSION_DROP = "k-report-dimension-drop"
  const val REPORT_DIMENSION_DROP_PANEL = "k-report-dimension-drop-panel"
  const val REPORT_MEASURES_CHECK_PANEL = "k-report-measures-check-panel"

  // alignment
  const val CENTER =  0
  const val TOP =     1
  const val LEFT =    2
  const val BOTTOM =  3
  const val RIGHT =   4

  // calendar pane styles
  const val DATE_CHOOSER =            "k-datechooser"
  const val CN_FOCUSED =              "focused"
  const val CN_TODAY =                "today"
  const val CN_SELECTED =             "selected"
  const val CN_OFFMONTH =             "offmonth"
  const val CN_OUTSIDE_RANGE =        "outside-range"
  const val WAIT_WINDOW =             "k-wait-window"
  const val WAIT_WINDOW_IMAGE =       "k-wait-window-image"
  const val WAIT_WINDOW_TEXT =        "k-wait-window-text"
  const val POPUP_WINDOW =            "k-popup-window"
  const val POPUP_WINDOW_CAPTION =    "k-popup-window-caption"
  const val POPUP_WINDOW_CONTENT =    "k-popup-window-content"

  // font awesome icon primary style
  const val FONT_AWESOME =            "fa"

  // actor field styles
  const val ACTOR_FIELD =             "k-actor-field"
  const val ACTOR_FIELD_BUTTON =      "k-actor-field-button"

  // boolean field styles
  const val BOOLEAN_FIELD =           "k-boolean-field"
  const val POSITION_PANEL =          "k-positionpanel"

  // Styles
  const val STYLE_Z_INDEX =           "zIndex"
  const val STYLE_CURSOR =            "cursor"

  // Cursor Styles
  const val CURSOR_ROW_RESIZE =       "row-resize"
  const val CURSOR_COL_RESIZE =       "col-resize"
  const val CURSOR_HELP =             "help"
  const val CURSOR_WAIT =             "wait"
  const val CURSOR_TEXT =             "text"
  const val CURSOR_W_RESIZE =         "w-resize"
  const val CURSOR_S_RESIZE =         "s-resize"
  const val CURSOR_SW_RESIZE =        "sw-resize"
  const val CURSOR_SE_RESIZE =        "se-resize"
  const val CURSOR_N_RESIZE =         "n-resize"
  const val CURSOR_NW_RESIZE =        "nw-resize"
  const val CURSOR_NE_RESIZE =        "ne-resize"
  const val CURSOR_E_RESIZE =         "e-resize"
  const val CURSOR_MOVE =             "move"
  const val CURSOR_POINTER =          "pointer"
  const val CURSOR_CROSSHAIR =        "crosshair"
  const val CURSOR_AUTO =             "auto"
  const val CURSOR_DEFAULT =          "default"
}
