/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.chart;

import com.lowagie.text.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.base.Utils;
import org.kopi.galite.visual.chart.CConstants;
import org.kopi.galite.visual.chart.ChartTypeFactory;
import org.kopi.galite.visual.chart.UChart;
import org.kopi.galite.visual.chart.UChartType;
import org.kopi.galite.visual.chart.VChartType;
import org.kopi.galite.visual.chart.VColumn;
import org.kopi.galite.visual.chart.VDimension;
import org.kopi.galite.visual.chart.VHelpGenerator;
import org.kopi.galite.visual.chart.VMeasure;
import org.kopi.galite.visual.chart.VNoChartRowException;
import org.kopi.galite.visual.chart.VPrintOptions;
import org.kopi.galite.visual.chart.VRow;
import org.kopi.galite.visual.dsl.common.Action;
import org.kopi.galite.visual.dsl.common.Trigger;
import org.kopi.galite.visual.l10n.ChartLocalizer;
import org.kopi.galite.visual.l10n.LocalizationManager;
import org.kopi.galite.visual.print.Printable;
import org.kopi.galite.visual.util.PPaperType;
import org.kopi.galite.visual.util.PrintJob;
import org.kopi.galite.visual.util.base.InconsistencyException;
import org.kopi.galite.visual.visual.ApplicationConfiguration;
import org.kopi.galite.visual.visual.ApplicationContext;
import org.kopi.galite.visual.visual.FileHandler;
import org.kopi.galite.visual.visual.MessageCode;
import org.kopi.galite.visual.visual.UIFactory;
import org.kopi.galite.visual.visual.UWindow;
import org.kopi.galite.visual.visual.VCommand;
import org.kopi.galite.visual.visual.VException;
import org.kopi.galite.visual.visual.VExecFailedException;
import org.kopi.galite.visual.visual.VHelpViewer;
import org.kopi.galite.visual.visual.VWindow;
import org.kopi.galite.visual.visual.VlibProperties;
import org.kopi.galite.visual.visual.WindowBuilder;
import org.kopi.galite.visual.visual.WindowController;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b&\u0018\u0000 \u0086\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0086\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010C\u001a\u00020DH&J/\u0010E\u001a\u00020D2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010F0\u00072\u000e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010F0\u0007H\u0000\u00a2\u0006\u0004\bG\u0010HJ\b\u0010I\u001a\u00020DH\u0004J\u001c\u0010J\u001a\u0004\u0018\u00010F2\u0006\u0010K\u001a\u00020L2\b\b\u0002\u0010M\u001a\u00020LH\u0004J\u0006\u0010N\u001a\u00020DJ\b\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020DH\u0016J\u001c\u0010R\u001a\u0004\u0018\u00010F2\u0006\u0010S\u001a\u00020F2\b\u0010T\u001a\u0004\u0018\u00010\bH\u0004J\u0010\u0010U\u001a\u00020\u00122\b\u0010T\u001a\u0004\u0018\u00010\bJ\u0010\u0010V\u001a\u00020L2\b\u0010T\u001a\u0004\u0018\u00010\bJ\u0012\u0010W\u001a\u0004\u0018\u00010F2\b\u0010T\u001a\u0004\u0018\u00010\bJ\u0012\u0010X\u001a\u00020D2\b\u0010T\u001a\u0004\u0018\u00010\bH\u0016J\u0016\u0010Y\u001a\u00020D2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020LJ\u0010\u0010Y\u001a\u00020D2\b\b\u0002\u0010\\\u001a\u00020LJ\b\u0010]\u001a\u0004\u0018\u00010+J\b\u0010^\u001a\u00020LH\u0014J\u0015\u0010_\u001a\b\u0012\u0004\u0012\u00020`0\u0007H\u0010\u00a2\u0006\u0004\ba\u0010bJ\u000e\u0010c\u001a\u00020$2\u0006\u0010d\u001a\u00020LJ\b\u0010e\u001a\u00020LH\u0016J\n\u0010f\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010g\u001a\u0002012\u0006\u0010d\u001a\u00020LJ\u0015\u0010h\u001a\b\u0012\u0004\u0012\u00020?0\u0007H\u0000\u00a2\u0006\u0004\bi\u0010jJ\b\u0010k\u001a\u00020LH\u0016J\u0006\u0010l\u001a\u00020\u0012J\u001f\u0010m\u001a\u00020\u00122\u0006\u0010K\u001a\u00020L2\b\b\u0002\u0010M\u001a\u00020LH\u0000\u00a2\u0006\u0002\bnJ\b\u0010o\u001a\u00020DH$J\u0006\u0010p\u001a\u00020DJ\u0010\u0010q\u001a\u00020D2\b\u0010r\u001a\u0004\u0018\u00010sJ\u0010\u0010q\u001a\u00020D2\u0006\u0010t\u001a\u00020uH\u0004J\u0006\u0010v\u001a\u00020DJ\u0016\u0010w\u001a\u00020D2\u0006\u0010x\u001a\u00020\u000f2\u0006\u0010y\u001a\u00020\u0012J\u001e\u0010w\u001a\u00020D2\u0006\u0010x\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020L2\u0006\u0010y\u001a\u00020\u0012J\u0006\u0010z\u001a\u00020DJ\u000e\u0010{\u001a\u00020D2\u0006\u0010|\u001a\u00020+J\u000e\u0010}\u001a\u00020D2\u0006\u0010~\u001a\u00020FJ\u0017\u0010}\u001a\u00020D2\u0006\u0010\u007f\u001a\u00020F2\u0007\u0010\u0080\u0001\u001a\u00020FJ\u001b\u0010}\u001a\u00020D2\r\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020F0\u0007\u00a2\u0006\u0003\u0010\u0082\u0001J\u000f\u0010\u0083\u0001\u001a\u00020D2\u0006\u0010\\\u001a\u00020\u0014J\u001f\u0010\u0083\u0001\u001a\u00020D2\u0006\u0010\\\u001a\u00020\u00142\u0006\u0010v\u001a\u00020\u0012H\u0000\u00a2\u0006\u0003\b\u0084\u0001J\u0007\u0010\u0085\u0001\u001a\u00020DR(\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0007X\u0084.\u00a2\u0006\u0010\n\u0002\u0010)\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0007X\u0084.\u00a2\u0006\u0010\n\u0002\u00106\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u00107\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001e\u0010>\u001a\u0012\u0012\u0004\u0012\u00020?0\u000ej\b\u0012\u0004\u0012\u00020?`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u00020+X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010-\"\u0004\bB\u0010/\u00a8\u0006\u0087\u0001"}, d2={"Lorg/kopi/galite/visual/chart/VChart;", "Lorg/kopi/galite/visual/visual/VWindow;", "Lorg/kopi/galite/visual/chart/CConstants;", "Lorg/kopi/galite/visual/print/Printable;", "()V", "VKT_Triggers", "", "", "Lorg/kopi/galite/visual/dsl/common/Trigger;", "getVKT_Triggers", "()Ljava/util/List;", "setVKT_Triggers", "(Ljava/util/List;)V", "activeCommands", "Ljava/util/ArrayList;", "Lorg/kopi/galite/visual/visual/VCommand;", "Lkotlin/collections/ArrayList;", "built", "", "<set-?>", "Lorg/kopi/galite/visual/chart/VChartType;", "chartType", "getChartType", "()Lorg/kopi/galite/visual/chart/VChartType;", "cmdAreaView", "cmdBarView", "cmdColumnView", "cmdLineView", "cmdPieView", "commands", "getCommands", "()[Lorg/kopi/galite/visual/visual/VCommand;", "setCommands", "([Lorg/kopi/galite/visual/visual/VCommand;)V", "[Lorg/kopi/galite/visual/visual/VCommand;", "dimensions", "Lorg/kopi/galite/visual/chart/VDimension;", "getDimensions", "()[Lorg/kopi/galite/visual/chart/VDimension;", "setDimensions", "([Lorg/kopi/galite/visual/chart/VDimension;)V", "[Lorg/kopi/galite/visual/chart/VDimension;", "help", "", "getHelp", "()Ljava/lang/String;", "setHelp", "(Ljava/lang/String;)V", "measures", "Lorg/kopi/galite/visual/chart/VMeasure;", "getMeasures", "()[Lorg/kopi/galite/visual/chart/VMeasure;", "setMeasures", "([Lorg/kopi/galite/visual/chart/VMeasure;)V", "[Lorg/kopi/galite/visual/chart/VMeasure;", "pageTitle", "printOptions", "Lorg/kopi/galite/visual/chart/VPrintOptions;", "getPrintOptions", "()Lorg/kopi/galite/visual/chart/VPrintOptions;", "setPrintOptions", "(Lorg/kopi/galite/visual/chart/VPrintOptions;)V", "rows", "Lorg/kopi/galite/visual/chart/VRow;", "source", "getSource", "setSource", "add", "", "addRow", "", "addRow$galite_core", "([Ljava/lang/Object;[Ljava/lang/Object;)V", "build", "callTrigger", "event", "", "index", "close", "createPrintJob", "Lorg/kopi/galite/visual/util/PrintJob;", "destroyModel", "execTrigger", "block", "trigger", "executeBooleanTrigger", "executeIntegerTrigger", "executeObjectTrigger", "executeVoidTrigger", "export", "file", "Ljava/io/File;", "type", "genHelp", "getColumnCount", "getColumns", "Lorg/kopi/galite/visual/chart/VColumn;", "getColumns$galite_core", "()[Lorg/kopi/galite/visual/chart/VColumn;", "getDimension", "column", "getDocumentType", "getFixedType", "getMeasure", "getRows", "getRows$galite_core", "()[Lorg/kopi/galite/visual/chart/VRow;", "getType", "hasFixedType", "hasTrigger", "hasTrigger$galite_core", "init", "initChart", "localize", "locale", "Ljava/util/Locale;", "manager", "Lorg/kopi/galite/visual/l10n/LocalizationManager;", "refresh", "setCommandEnabled", "command", "enable", "setMenu", "setPageTitle", "title", "setPageTitleParams", "param", "param1", "param2", "params", "([Ljava/lang/Object;)V", "setType", "setType$galite_core", "showHelp", "Companion", "galite-core"})
public abstract class VChart
extends VWindow
implements CConstants,
Printable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private VCommand cmdBarView;
    @Nullable
    private VCommand cmdColumnView;
    @Nullable
    private VCommand cmdLineView;
    @Nullable
    private VCommand cmdAreaView;
    @Nullable
    private VCommand cmdPieView;
    public String source;
    private boolean built;
    @NotNull
    private String pageTitle = "";
    @Nullable
    private String help;
    @Nullable
    private VChartType chartType;
    @NotNull
    private List<Trigger[]> VKT_Triggers;
    @Nullable
    private VCommand[] commands;
    @NotNull
    private final ArrayList<VCommand> activeCommands;
    @NotNull
    private VPrintOptions printOptions;
    protected VDimension[] dimensions;
    protected VMeasure[] measures;
    @NotNull
    private final ArrayList<VRow> rows;
    public static final int TYP_PDF = 1;
    public static final int TYP_PNG = 2;
    public static final int TYP_JPEG = 3;

    public VChart() {
        super(null, 1, null);
        Trigger[][] triggerArrayArray = new Trigger[][]{new Trigger[CConstants.Companion.getTRG_TYPES().length]};
        this.VKT_Triggers = CollectionsKt.mutableListOf((Object[])((Object[])triggerArrayArray));
        this.activeCommands = new ArrayList();
        this.printOptions = new VPrintOptions(0, null, 0, 0, 0, 0, 0, 0, 0, 0, 1023, null);
        this.rows = new ArrayList(500);
    }

    @Override
    @NotNull
    public String getSource() {
        String string = this.source;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"source");
        return null;
    }

    public void setSource(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.source = string;
    }

    @Nullable
    public final String getHelp() {
        return this.help;
    }

    public final void setHelp(@Nullable String string) {
        this.help = string;
    }

    @Nullable
    public final VChartType getChartType() {
        return this.chartType;
    }

    @NotNull
    protected final List<Trigger[]> getVKT_Triggers() {
        return this.VKT_Triggers;
    }

    protected final void setVKT_Triggers(@NotNull List<Trigger[]> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.VKT_Triggers = list;
    }

    @Nullable
    protected final VCommand[] getCommands() {
        return this.commands;
    }

    protected final void setCommands(@Nullable VCommand[] vCommandArray) {
        this.commands = vCommandArray;
    }

    @NotNull
    public final VPrintOptions getPrintOptions() {
        return this.printOptions;
    }

    public final void setPrintOptions(@NotNull VPrintOptions vPrintOptions) {
        Intrinsics.checkNotNullParameter((Object)vPrintOptions, (String)"<set-?>");
        this.printOptions = vPrintOptions;
    }

    @NotNull
    protected final VDimension[] getDimensions() {
        VDimension[] vDimensionArray = this.dimensions;
        if (vDimensionArray != null) {
            return vDimensionArray;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dimensions");
        return null;
    }

    protected final void setDimensions(@NotNull VDimension[] vDimensionArray) {
        Intrinsics.checkNotNullParameter((Object)vDimensionArray, (String)"<set-?>");
        this.dimensions = vDimensionArray;
    }

    @NotNull
    protected final VMeasure[] getMeasures() {
        VMeasure[] vMeasureArray = this.measures;
        if (vMeasureArray != null) {
            return vMeasureArray;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"measures");
        return null;
    }

    protected final void setMeasures(@NotNull VMeasure[] vMeasureArray) {
        Intrinsics.checkNotNullParameter((Object)vMeasureArray, (String)"<set-?>");
        this.measures = vMeasureArray;
    }

    public final void localize(@Nullable Locale locale) {
        LocalizationManager manager = null;
        manager = new LocalizationManager(locale, ApplicationContext.Companion.getDefaultLocale());
        super.localizeActors(manager);
        this.localize(manager);
        manager = null;
    }

    protected final void localize(@NotNull LocalizationManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!Intrinsics.areEqual((Object)ApplicationContext.Companion.getDefaultLocale(), (Object)this.getLocale())) {
            boolean bl;
            VColumn it;
            ChartLocalizer loc = manager.getChartLocalizer(this.getSource());
            this.setPageTitle(loc.getTitle());
            this.help = loc.getHelp();
            VColumn[] $this$forEach$iv = this.getDimensions();
            boolean $i$f$forEach = false;
            for (VDimension vDimension : $this$forEach$iv) {
                it = vDimension;
                bl = false;
                it.localize(loc);
            }
            $this$forEach$iv = this.getMeasures();
            $i$f$forEach = false;
            for (VColumn vColumn : $this$forEach$iv) {
                it = vColumn;
                bl = false;
                it.localize(loc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PrintJob createPrintJob() {
        void var1_1;
        try {
            PrintJob printJob = null;
            File file = Utils.Companion.getTempFile$default(Utils.Companion, "galite", "pdf", false, 4, null);
            PPaperType paper = PPaperType.Companion.getPaperTypeFromCode(this.printOptions.getPaperType());
            Rectangle page = Intrinsics.areEqual((Object)this.printOptions.getPaperLayout(), (Object)"Landscape") ? new Rectangle((float)paper.getHeight(), (float)paper.getWidth()) : new Rectangle((float)paper.getWidth(), (float)paper.getHeight());
            this.export(file, 1);
            printJob = new PrintJob(file, true, page);
            printJob.setDataType(1);
            printJob.setTitle(this.getTitle());
            printJob.setNumberOfPages(1);
            printJob.setDocumentType(this.getDocumentType());
        }
        catch (IOException e) {
            throw new VExecFailedException(e);
        }
        return var1_1;
    }

    public int getDocumentType() {
        return 0;
    }

    @Override
    public int getType() {
        return 50;
    }

    public final void setMenu() {
        if (!this.built) {
            return;
        }
        if (this.cmdBarView != null) {
            VCommand vCommand = this.cmdBarView;
            Intrinsics.checkNotNull((Object)vCommand);
            this.setCommandEnabled(vCommand, this.chartType != VChartType.Companion.getBAR());
        }
        if (this.cmdColumnView != null) {
            VCommand vCommand = this.cmdColumnView;
            Intrinsics.checkNotNull((Object)vCommand);
            this.setCommandEnabled(vCommand, this.chartType != VChartType.Companion.getCOLUMN());
        }
        if (this.cmdLineView != null) {
            VCommand vCommand = this.cmdLineView;
            Intrinsics.checkNotNull((Object)vCommand);
            this.setCommandEnabled(vCommand, this.chartType != VChartType.Companion.getLINE());
        }
        if (this.cmdAreaView != null) {
            VCommand vCommand = this.cmdAreaView;
            Intrinsics.checkNotNull((Object)vCommand);
            this.setCommandEnabled(vCommand, this.chartType != VChartType.Companion.getAREA());
        }
        if (this.cmdPieView != null) {
            VCommand vCommand = this.cmdPieView;
            Intrinsics.checkNotNull((Object)vCommand);
            this.setCommandEnabled(vCommand, this.chartType != VChartType.Companion.getPIE());
        }
    }

    public final void initChart() {
        this.build();
        VChart.callTrigger$default(this, 0, 0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    protected final void build() {
        block25: {
            if (this.rows.isEmpty()) {
                throw new VNoChartRowException(MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00015", null, false, 6, null));
            }
            UWindow uWindow = this.getDisplay();
            if (uWindow == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.chart.UChart");
            }
            ((UChart)uWindow).build();
            this.setType$galite_core(VChartType.Companion.getDEFAULT(), false);
            this.built = true;
            if (VChart.hasTrigger$galite_core$default(this, 3, 0, 2, null)) {
                VChart.callTrigger$default(this, 3, 0, 2, null);
            }
            if (this.hasFixedType()) {
                Object object = VChart.callTrigger$default(this, 2, 0, 2, null);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.chart.VChartType");
                }
                this.setType((VChartType)object);
            }
            this.activeCommands.clear();
            if (this.commands == null) break block25;
            VCommand[] $this$forEachIndexed$iv = this.commands;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            VCommand[] vCommandArray = $this$forEachIndexed$iv;
            int n = 0;
            int n2 = vCommandArray.length;
            while (n < n2) {
                void it;
                VCommand item$iv = vCommandArray[n];
                ++n;
                int n3 = index$iv;
                index$iv = n3 + 1;
                VCommand vCommand = item$iv;
                int i = n3;
                boolean bl = false;
                switch (it.getIdent()) {
                    case "BarView": {
                        this.cmdBarView = it;
                        break;
                    }
                    case "ColumnView": {
                        this.cmdColumnView = it;
                        break;
                    }
                    case "LineView": {
                        this.cmdLineView = it;
                        break;
                    }
                    case "AreaView": {
                        this.cmdAreaView = it;
                        break;
                    }
                    case "PieView": {
                        this.cmdPieView = it;
                        break;
                    }
                    default: {
                        this.setCommandEnabled((VCommand)it, this.getColumnCount() + i + 1, true);
                    }
                }
            }
        }
    }

    public final boolean hasFixedType() {
        return VChart.hasTrigger$galite_core$default(this, 2, 0, 2, null);
    }

    @Nullable
    public VChartType getFixedType() {
        return (VChartType)VChart.callTrigger$default(this, 2, 0, 2, null);
    }

    public final void refresh() {
        UWindow uWindow = this.getDisplay();
        if (uWindow == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.chart.UChart");
        }
        ((UChart)uWindow).refresh();
    }

    public final void close() {
        UWindow uWindow = this.getDisplay();
        Intrinsics.checkNotNull((Object)uWindow);
        uWindow.closeWindow();
    }

    public final void showHelp() {
        new VHelpViewer().showHelp(this.genHelp());
    }

    @Override
    public void destroyModel() {
        try {
            VChart.callTrigger$default(this, 1, 0, 2, null);
        }
        catch (VException v) {
            v.printStackTrace();
        }
        super.destroyModel();
    }

    public final void setType(@NotNull VChartType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.setType$galite_core(type2, true);
    }

    public final void export(int type2) {
        String string;
        switch (type2) {
            case 2: {
                string = ".png";
                break;
            }
            case 1: {
                string = ".pdf";
                break;
            }
            case 3: {
                string = ".jpeg";
                break;
            }
            default: {
                throw new InconsistencyException("Export type unknown");
            }
        }
        String ext = string;
        FileHandler fileHandler = FileHandler.Companion.getFileHandler();
        Intrinsics.checkNotNull((Object)fileHandler);
        UWindow uWindow = this.getDisplay();
        Intrinsics.checkNotNull((Object)uWindow);
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.Companion.getConfiguration();
        Intrinsics.checkNotNull((Object)applicationConfiguration);
        File file = fileHandler.chooseFile(uWindow, applicationConfiguration.getDefaultDirectory(), Intrinsics.stringPlus((String)"chart", (Object)ext));
        if (file != null) {
            try {
                this.export(file, type2);
            }
            catch (IOException e) {
                throw new VExecFailedException(e);
            }
        }
    }

    public static /* synthetic */ void export$default(VChart vChart, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: export");
        }
        if ((n2 & 1) != 0) {
            n = 2;
        }
        vChart.export(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void export(@NotNull File file, int type2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileOutputStream destination = new FileOutputStream(file);
        boolean exported = false;
        this.setWaitInfo(VlibProperties.getString("export-message"));
        try {
            boolean bl;
            switch (type2) {
                case 1: {
                    UWindow uWindow = this.getDisplay();
                    if (uWindow == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.chart.UChart");
                    }
                    UChartType uChartType = ((UChart)uWindow).getType();
                    Intrinsics.checkNotNull((Object)uChartType);
                    uChartType.exportToPDF(destination, this.printOptions);
                    bl = true;
                    break;
                }
                case 2: {
                    UWindow uWindow = this.getDisplay();
                    if (uWindow == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.chart.UChart");
                    }
                    UChartType uChartType = ((UChart)uWindow).getType();
                    Intrinsics.checkNotNull((Object)uChartType);
                    uChartType.exportToPNG(destination, this.printOptions.getImageWidth(), this.printOptions.getImageHeight());
                    bl = true;
                    break;
                }
                case 3: {
                    UWindow uWindow = this.getDisplay();
                    if (uWindow == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.chart.UChart");
                    }
                    UChartType uChartType = ((UChart)uWindow).getType();
                    Intrinsics.checkNotNull((Object)uChartType);
                    uChartType.exportToJPEG(destination, this.printOptions.getImageWidth(), this.printOptions.getImageHeight());
                    bl = true;
                    break;
                }
                default: {
                    throw new InconsistencyException("Export type unknown");
                }
            }
            exported = bl;
            VWindow.fireFileProduced$default(this, file, null, 2, null);
        }
        finally {
            destination.close();
            this.unsetWaitInfo();
        }
    }

    public final void setType$galite_core(@NotNull VChartType type2, boolean refresh) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (this.hasFixedType() && !Intrinsics.areEqual((Object)type2, (Object)this.getFixedType())) {
            return;
        }
        this.chartType = type2;
        type2.createDataSeries$galite_core(this);
        UWindow uWindow = this.getDisplay();
        if (uWindow == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.chart.UChart");
        }
        ((UChart)uWindow).setType(ChartTypeFactory.Companion.getChartTypeFactory().createTypeView(this.getTitle(), type2));
        if (refresh) {
            this.refresh();
            UWindow uWindow2 = this.getDisplay();
            if (uWindow2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.chart.UChart");
            }
            ((UChart)uWindow2).typeChanged();
        }
    }

    public final void addRow$galite_core(@NotNull Object[] dimensions, @NotNull Object[] measures) {
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter((Object)measures, (String)"measures");
        this.rows.add(new VRow(dimensions, measures));
    }

    protected int getColumnCount() {
        return this.getDimensions().length + this.getMeasures().length;
    }

    public final void setCommandEnabled(@NotNull VCommand command, int index, boolean enable) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        boolean enable2 = enable;
        if (enable2) {
            if (this.hasTrigger$galite_core(6, index)) {
                boolean active;
                boolean bl;
                try {
                    Object object = this.callTrigger(6, index);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)object;
                }
                catch (VException e) {
                    bl = true;
                }
                enable2 = active = bl;
            }
            command.setEnabled(enable2);
            this.activeCommands.add(command);
        } else {
            this.activeCommands.remove(command);
            command.setEnabled(false);
        }
    }

    public final void setCommandEnabled(@NotNull VCommand command, boolean enable) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        command.setEnabled(enable);
        if (enable) {
            this.activeCommands.add(command);
        } else {
            this.activeCommands.remove(command);
        }
    }

    @Override
    public void executeVoidTrigger(@Nullable Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 != null) {
            Action<?> action2 = trigger2.getAction();
            if (action2 != null) {
                Function0<?> function0 = action2.getMethod();
                if (function0 != null) {
                    function0.invoke();
                }
            }
        }
        super.executeVoidTrigger(trigger);
    }

    @Nullable
    public final Object executeObjectTrigger(@Nullable Trigger trigger) {
        Object object;
        Trigger trigger2 = trigger;
        if (trigger2 == null) {
            object = null;
        } else {
            Action<?> action2 = trigger2.getAction();
            object = action2 == null ? null : action2.getMethod();
        }
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Function0<kotlin.Any?>");
        }
        return ((Function0)TypeIntrinsics.beforeCheckcastToFunctionOfArity(object, (int)0)).invoke();
    }

    public final boolean executeBooleanTrigger(@Nullable Trigger trigger) {
        throw new InconsistencyException("SHOULD BE REDEFINED");
    }

    public final int executeIntegerTrigger(@Nullable Trigger trigger) {
        throw new InconsistencyException("SHOULD BE REDEFINED");
    }

    @Nullable
    protected final Object execTrigger(@NotNull Object block, @Nullable Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.executeVoidTrigger(trigger);
        return null;
    }

    @Nullable
    protected final Object callTrigger(int event, int index) {
        Object object;
        switch (CConstants.Companion.getTRG_TYPES()[event]) {
            case 0: {
                this.executeVoidTrigger(this.VKT_Triggers.get(index)[event]);
                object = null;
                break;
            }
            case 3: {
                object = this.executeObjectTrigger(this.VKT_Triggers.get(index)[event]);
                break;
            }
            default: {
                throw new InconsistencyException(Intrinsics.stringPlus((String)"BAD TYPE", (Object)CConstants.Companion.getTRG_TYPES()[event]));
            }
        }
        return object;
    }

    public static /* synthetic */ Object callTrigger$default(VChart vChart, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callTrigger");
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return vChart.callTrigger(n, n2);
    }

    public final boolean hasTrigger$galite_core(int event, int index) {
        return this.VKT_Triggers.get(index)[event] != null;
    }

    public static /* synthetic */ boolean hasTrigger$galite_core$default(VChart vChart, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hasTrigger");
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return vChart.hasTrigger$galite_core(n, n2);
    }

    @NotNull
    public final VMeasure getMeasure(int column2) {
        return this.getMeasures()[column2];
    }

    @NotNull
    public final VDimension getDimension(int column2) {
        return this.getDimensions()[column2];
    }

    public final void setPageTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.pageTitle = title;
        this.setTitle(title);
    }

    public final void setPageTitleParams(@NotNull Object param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Object[] objectArray = new Object[]{param};
        this.setPageTitleParams(objectArray);
    }

    public final void setPageTitleParams(@NotNull Object param1, @NotNull Object param2) {
        Intrinsics.checkNotNullParameter((Object)param1, (String)"param1");
        Intrinsics.checkNotNullParameter((Object)param2, (String)"param2");
        Object[] objectArray = new Object[]{param1, param2};
        this.setPageTitleParams(objectArray);
    }

    public final void setPageTitleParams(@NotNull Object[] params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = MessageFormat.format(this.pageTitle, Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(pageTitle, *params)");
        this.setPageTitle(string);
    }

    @NotNull
    public final VRow[] getRows$galite_core() {
        Collection $this$toTypedArray$iv = this.rows;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VRow[] vRowArray = thisCollection$iv.toArray(new VRow[0]);
        if (vRowArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return vRowArray;
    }

    @NotNull
    public VColumn[] getColumns$galite_core() {
        VColumn it;
        boolean bl;
        int i;
        int n;
        Object[] columns = new VColumn[this.getColumnCount()];
        VColumn[] $this$forEachIndexed$iv = this.getDimensions();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (VDimension vDimension : $this$forEachIndexed$iv) {
            n = index$iv;
            index$iv = n + 1;
            VDimension vDimension2 = vDimension;
            i = n;
            bl = false;
            columns[i] = it;
        }
        $this$forEachIndexed$iv = this.getMeasures();
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (VColumn vColumn : $this$forEachIndexed$iv) {
            n = index$iv;
            index$iv = n + 1;
            it = vColumn;
            i = n;
            bl = false;
            columns[i + this.getDimensions().length] = it;
        }
        return (VColumn[])ArraysKt.requireNoNulls((Object[])columns);
    }

    @Nullable
    public final String genHelp() {
        String string;
        StringBuffer surl = new StringBuffer();
        String fileName = new VHelpGenerator().helpOnChart(this.getTitle(), this.commands, this.getColumns$galite_core(), this.help);
        if (fileName == null) {
            string = null;
        } else {
            try {
                surl.append(new File(fileName).toURI().toURL().toString());
            }
            catch (MalformedURLException mue) {
                throw new InconsistencyException(mue);
            }
            string = surl.toString();
        }
        return string;
    }

    protected abstract void init();

    public abstract void add();

    static {
        WindowController.Companion.getWindowController().registerWindowBuilder(50, new WindowBuilder(){

            @NotNull
            public UWindow createWindow(@NotNull VWindow model2) {
                Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
                return (UChart)UIFactory.Companion.getUiFactory().createView(model2);
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/kopi/galite/visual/chart/VChart$Companion;", "", "()V", "TYP_JPEG", "", "TYP_PDF", "TYP_PNG", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

