/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.preview;

import java.io.File;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.event.EventListenerList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.base.Utils;
import org.kopi.galite.visual.l10n.LocalizationManager;
import org.kopi.galite.visual.preview.PreviewListener;
import org.kopi.galite.visual.util.PrintJob;
import org.kopi.galite.visual.visual.ApplicationContext;
import org.kopi.galite.visual.visual.UIFactory;
import org.kopi.galite.visual.visual.UWindow;
import org.kopi.galite.visual.visual.VActor;
import org.kopi.galite.visual.visual.VWindow;
import org.kopi.galite.visual.visual.VlibProperties;
import org.kopi.galite.visual.visual.WindowBuilder;
import org.kopi.galite.visual.visual.WindowController;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0016\u0018\u0000 52\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0006H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0006H\u0004J\b\u0010&\u001a\u00020\u001eH\u0004J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u0006H\u0004J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0006J\b\u0010*\u001a\u00020\u0004H\u0016J\b\u0010+\u001a\u00020\u0006H\u0016J\u000e\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0006J\u000e\u0010.\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010/\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u00100\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\b\u00101\u001a\u00020\u001eH\u0002J\u000e\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u000204R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0005\u001a\u0004\u0018\u00010\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\t\u00a8\u00066"}, d2={"Lorg/kopi/galite/visual/preview/VPreviewWindow;", "Lorg/kopi/galite/visual/visual/VWindow;", "()V", "command", "", "<set-?>", "", "currentPage", "getCurrentPage", "()I", "height", "getHeight", "imageFile", "locale", "Ljava/util/Locale;", "getLocale", "()Ljava/util/Locale;", "numberOfPages", "getNumberOfPages", "previewListener", "Ljavax/swing/event/EventListenerList;", "printFile", "Ljava/io/File;", "Lorg/kopi/galite/visual/util/PrintJob;", "printJob", "getPrintJob", "()Lorg/kopi/galite/visual/util/PrintJob;", "width", "getWidth", "addPreviewListener", "", "bl", "Lorg/kopi/galite/visual/preview/PreviewListener;", "createImagesFromPostscript", "executeVoidTrigger", "VKT_Type", "firePageChanged", "current", "fireZoomChanged", "fireZoomFit", "type", "getPreviewFileName", "getTitle", "getType", "gotoPosition", "posno", "localize", "preview", "removePreviewListener", "setMenu", "zoom", "ratio", "", "Companion", "galite-core"})
public class VPreviewWindow
extends VWindow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int currentPage;
    private int numberOfPages;
    @Nullable
    private String command;
    @Nullable
    private PrintJob printJob;
    @Nullable
    private File printFile;
    @Nullable
    private String imageFile;
    private int height;
    private int width;
    @NotNull
    private final EventListenerList previewListener;
    private static final float DEF_ZOOM_RATIO = 1.3f;
    @NotNull
    private static final String PREVIEW_LOCALIZATION_RESOURCE = "org/kopi/galite/visual/Preview";
    public static final int CMD_QUIT = 0;
    public static final int CMD_FIRST = 1;
    public static final int CMD_LEFT = 2;
    public static final int CMD_RIGHT = 3;
    public static final int CMD_LAST = 4;
    protected static final int CMD_ZOOM_FIT = 5;
    protected static final int CMD_ZOOM_FIT_W = 6;
    protected static final int CMD_ZOOM_FIT_H = 7;
    protected static final int CMD_ZOOM_PLUS = 8;
    protected static final int CMD_ZOOM_MINUS = 9;

    public VPreviewWindow() {
        super(null, 1, null);
        this.setTitle(VlibProperties.getString("Preview"));
        Object object = new VActor[]{new VActor("File", PREVIEW_LOCALIZATION_RESOURCE, "Close", PREVIEW_LOCALIZATION_RESOURCE, "quit", 27, 0, false, 128, null), new VActor("Action", PREVIEW_LOCALIZATION_RESOURCE, "PageFirst", PREVIEW_LOCALIZATION_RESOURCE, "pageFirst", 36, 0, false, 128, null), new VActor("Action", PREVIEW_LOCALIZATION_RESOURCE, "PageLeft", PREVIEW_LOCALIZATION_RESOURCE, "pageLeft", 33, 0, false, 128, null), new VActor("Action", PREVIEW_LOCALIZATION_RESOURCE, "PageRight", PREVIEW_LOCALIZATION_RESOURCE, "pageRight", 34, 0, false, 128, null), new VActor("Action", PREVIEW_LOCALIZATION_RESOURCE, "PageLast", PREVIEW_LOCALIZATION_RESOURCE, "pageLast", 35, 0, false, 128, null), new VActor("Action", PREVIEW_LOCALIZATION_RESOURCE, "PreviewFit", PREVIEW_LOCALIZATION_RESOURCE, "zoomoptimal", 116, 0, false, 128, null), new VActor("Action", PREVIEW_LOCALIZATION_RESOURCE, "PreviewFitWidth", PREVIEW_LOCALIZATION_RESOURCE, "zoomwidth", 119, 0, false, 128, null), new VActor("Action", PREVIEW_LOCALIZATION_RESOURCE, "PreviewFitHeight", PREVIEW_LOCALIZATION_RESOURCE, "zoomheight", 120, 0, false, 128, null), new VActor("Action", PREVIEW_LOCALIZATION_RESOURCE, "PreviewPlus", PREVIEW_LOCALIZATION_RESOURCE, "zoomplus", 117, 0, false, 128, null), new VActor("Action", PREVIEW_LOCALIZATION_RESOURCE, "PreviewMinus", PREVIEW_LOCALIZATION_RESOURCE, "zoomminus", 118, 0, false, 128, null)};
        this.addActors((VActor[])object);
        object = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefault()");
        this.localize((Locale)object);
        this.getActor(0).setNumber(0);
        this.getActor(1).setNumber(1);
        this.getActor(2).setNumber(2);
        this.getActor(3).setNumber(3);
        this.getActor(4).setNumber(4);
        this.getActor(5).setNumber(5);
        this.getActor(6).setNumber(6);
        this.getActor(7).setNumber(7);
        this.getActor(8).setNumber(8);
        this.getActor(9).setNumber(9);
        this.previewListener = new EventListenerList();
    }

    public final int getCurrentPage() {
        return this.currentPage;
    }

    public final int getNumberOfPages() {
        return this.numberOfPages;
    }

    @Nullable
    public final PrintJob getPrintJob() {
        return this.printJob;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        return ApplicationContext.Companion.getDefaultLocale();
    }

    @Override
    public int getType() {
        return 30;
    }

    public final void preview(@NotNull PrintJob printJob, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)printJob, (String)"printJob");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        File tempFile = Utils.Companion.getTempFile$default(Utils.Companion, "PREVIEW", "JPG", false, 4, null);
        this.printJob = printJob;
        this.numberOfPages = printJob.getNumberOfPages();
        this.printFile = printJob.getDataFile();
        String string = this.imageFile = tempFile.getPath();
        Intrinsics.checkNotNull((Object)string);
        String string2 = this.imageFile;
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string.substring(0, StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        this.imageFile = string3;
        this.height = printJob.getHeight();
        this.width = printJob.getWidth();
        this.command = command;
        this.createImagesFromPostscript();
        this.currentPage = 1;
        this.setActorEnabled(0, true);
        this.setActorEnabled(1, this.currentPage > 1);
        this.setActorEnabled(2, this.currentPage > 1);
        this.setActorEnabled(3, this.currentPage < this.numberOfPages);
        this.setActorEnabled(4, this.currentPage < this.numberOfPages);
        this.setActorEnabled(5, true);
        this.setActorEnabled(7, true);
        this.setActorEnabled(6, true);
        this.setActorEnabled(8, true);
        this.setActorEnabled(9, true);
        this.doNotModal();
    }

    private final void createImagesFromPostscript() {
        try {
            float f = 72.0f * (float)this.height;
            PrintJob printJob = this.printJob;
            Intrinsics.checkNotNull((Object)printJob);
            int resolution = (int)(f / (float)printJob.getHeight());
            Process p = Runtime.getRuntime().exec(this.command + " -q -sOutputFile=" + this.imageFile + "%d.JPG -sDEVICE=jpeg -r" + resolution + 'x' + resolution + " -g" + this.width + 'x' + this.height + " -dNOPAUSE " + this.printFile + " -c quit ");
            p.waitFor();
        }
        catch (Exception e) {
            this.fatalError(this, "VPreviewWindow.preview(File ...)", e);
        }
    }

    public final void zoom(float ratio) {
        float ratio2 = ratio;
        if ((float)RangesKt.coerceAtMost((int)this.height, (int)this.width) * ratio2 < 50.0f) {
            ratio2 = (float)50 / (float)RangesKt.coerceAtMost((int)this.height, (int)this.width);
        }
        if ((float)RangesKt.coerceAtLeast((int)this.height, (int)this.width) * ratio2 > 3000.0f) {
            ratio2 = (float)3000 / (float)RangesKt.coerceAtLeast((int)this.height, (int)this.width);
        }
        this.width = (int)((float)this.width * ratio2);
        this.height = (int)((float)this.height * ratio2);
        this.createImagesFromPostscript();
        this.fireZoomChanged();
    }

    @Override
    public void executeVoidTrigger(int VKT_Type) {
        switch (VKT_Type) {
            case 0: {
                UWindow uWindow = this.getDisplay();
                Intrinsics.checkNotNull((Object)uWindow);
                uWindow.closeWindow();
                break;
            }
            case 1: {
                this.setWaitInfo(VlibProperties.getString("WAIT"));
                this.currentPage = 1;
                this.firePageChanged(this.currentPage);
                this.unsetWaitInfo();
                break;
            }
            case 2: {
                this.setWaitInfo(VlibProperties.getString("WAIT"));
                --this.currentPage;
                this.firePageChanged(this.currentPage);
                this.unsetWaitInfo();
                break;
            }
            case 3: {
                this.setWaitInfo(VlibProperties.getString("WAIT"));
                ++this.currentPage;
                this.firePageChanged(this.currentPage);
                this.unsetWaitInfo();
                break;
            }
            case 4: {
                this.setWaitInfo(VlibProperties.getString("WAIT"));
                this.currentPage = this.numberOfPages;
                this.firePageChanged(this.currentPage);
                this.unsetWaitInfo();
                break;
            }
            case 8: {
                this.setWaitInfo(VlibProperties.getString("WAIT"));
                this.zoom(1.3f);
                this.unsetWaitInfo();
                break;
            }
            case 9: {
                this.setWaitInfo(VlibProperties.getString("WAIT"));
                this.zoom(0.7692308f);
                this.unsetWaitInfo();
                break;
            }
            case 5: {
                this.setWaitInfo(VlibProperties.getString("WAIT"));
                this.fireZoomFit(1);
                this.unsetWaitInfo();
                break;
            }
            case 7: {
                this.setWaitInfo(VlibProperties.getString("WAIT"));
                this.fireZoomFit(3);
                this.unsetWaitInfo();
                break;
            }
            case 6: {
                this.setWaitInfo(VlibProperties.getString("WAIT"));
                this.fireZoomFit(2);
                this.unsetWaitInfo();
            }
        }
        this.setMenu();
    }

    public final void gotoPosition(int posno) {
        this.setWaitInfo(VlibProperties.getString("WAIT"));
        this.currentPage = posno;
        this.firePageChanged(this.currentPage);
        this.unsetWaitInfo();
        this.setMenu();
    }

    public final void localize(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        LocalizationManager manager = null;
        manager = new LocalizationManager(locale, ApplicationContext.Companion.getDefaultLocale());
        super.localizeActors(manager);
        manager = null;
    }

    public final void addPreviewListener(@NotNull PreviewListener bl) {
        Intrinsics.checkNotNullParameter((Object)bl, (String)"bl");
        this.previewListener.add(PreviewListener.class, (EventListener)bl);
    }

    public final void removePreviewListener(@NotNull PreviewListener bl) {
        Intrinsics.checkNotNullParameter((Object)bl, (String)"bl");
        this.previewListener.remove(PreviewListener.class, (EventListener)bl);
    }

    protected final void firePageChanged(int current) {
        Object[] listeners = this.previewListener.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PreviewListener.class) continue;
            Object object = listeners[i + 1];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.preview.PreviewListener");
            }
            ((PreviewListener)object).pageChanged(current);
        }
    }

    protected final void fireZoomChanged() {
        Object[] listeners = this.previewListener.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PreviewListener.class) continue;
            Object object = listeners[i + 1];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.preview.PreviewListener");
            }
            ((PreviewListener)object).zoomChanged();
        }
    }

    protected final void fireZoomFit(int type2) {
        Object[] listeners = this.previewListener.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PreviewListener.class) continue;
            Object object = listeners[i + 1];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.preview.PreviewListener");
            }
            ((PreviewListener)object).zoomFit(type2);
        }
    }

    private final void setMenu() {
        this.setActorEnabled(1, this.currentPage > 1);
        this.setActorEnabled(2, this.currentPage > 1);
        this.setActorEnabled(3, this.currentPage < this.numberOfPages);
        this.setActorEnabled(4, this.currentPage < this.numberOfPages);
    }

    @NotNull
    public final String getPreviewFileName(int current) {
        return this.imageFile + current + ".JPG";
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = this.getWindowTitle();
        if (string == null) {
            string = "";
        }
        return string;
    }

    static {
        WindowController.Companion.getWindowController().registerWindowBuilder(30, new WindowBuilder(){

            @NotNull
            public UWindow createWindow(@NotNull VWindow model2) {
                Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
                return (UWindow)UIFactory.Companion.getUiFactory().createView(model2);
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kopi/galite/visual/preview/VPreviewWindow$Companion;", "", "()V", "CMD_FIRST", "", "CMD_LAST", "CMD_LEFT", "CMD_QUIT", "CMD_RIGHT", "CMD_ZOOM_FIT", "CMD_ZOOM_FIT_H", "CMD_ZOOM_FIT_W", "CMD_ZOOM_MINUS", "CMD_ZOOM_PLUS", "DEF_ZOOM_RATIO", "", "PREVIEW_LOCALIZATION_RESOURCE", "", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

